"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api description.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Unset, exclude_unset

from .models import (
    BasicError,
    ValidationError,
    SearchCodeGetResponse200,
    SearchUsersGetResponse200,
    SearchIssuesGetResponse200,
    SearchLabelsGetResponse200,
    SearchTopicsGetResponse200,
    SearchCommitsGetResponse200,
    SearchRepositoriesGetResponse200,
    EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class SearchClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def code(
        self,
        q: str,
        sort: Union[Unset, Literal["indexed"]] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchCodeGetResponse200]":
        url = "/search/code"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchCodeGetResponse200,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_code(
        self,
        q: str,
        sort: Union[Unset, Literal["indexed"]] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchCodeGetResponse200]":
        url = "/search/code"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchCodeGetResponse200,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def commits(
        self,
        q: str,
        sort: Union[Unset, Literal["author-date", "committer-date"]] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchCommitsGetResponse200]":
        url = "/search/commits"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchCommitsGetResponse200,
        )

    async def async_commits(
        self,
        q: str,
        sort: Union[Unset, Literal["author-date", "committer-date"]] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchCommitsGetResponse200]":
        url = "/search/commits"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchCommitsGetResponse200,
        )

    def issues_and_pull_requests(
        self,
        q: str,
        sort: Union[
            Unset,
            Literal[
                "comments",
                "reactions",
                "reactions-+1",
                "reactions--1",
                "reactions-smile",
                "reactions-thinking_face",
                "reactions-heart",
                "reactions-tada",
                "interactions",
                "created",
                "updated",
            ],
        ] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchIssuesGetResponse200]":
        url = "/search/issues"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchIssuesGetResponse200,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_issues_and_pull_requests(
        self,
        q: str,
        sort: Union[
            Unset,
            Literal[
                "comments",
                "reactions",
                "reactions-+1",
                "reactions--1",
                "reactions-smile",
                "reactions-thinking_face",
                "reactions-heart",
                "reactions-tada",
                "interactions",
                "created",
                "updated",
            ],
        ] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchIssuesGetResponse200]":
        url = "/search/issues"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchIssuesGetResponse200,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def labels(
        self,
        repository_id: int,
        q: str,
        sort: Union[Unset, Literal["created", "updated"]] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchLabelsGetResponse200]":
        url = "/search/labels"

        params = {
            "repository_id": repository_id,
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    async def async_labels(
        self,
        repository_id: int,
        q: str,
        sort: Union[Unset, Literal["created", "updated"]] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchLabelsGetResponse200]":
        url = "/search/labels"

        params = {
            "repository_id": repository_id,
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def repos(
        self,
        q: str,
        sort: Union[
            Unset, Literal["stars", "forks", "help-wanted-issues", "updated"]
        ] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchRepositoriesGetResponse200]":
        url = "/search/repositories"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchRepositoriesGetResponse200,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "422": ValidationError,
            },
        )

    async def async_repos(
        self,
        q: str,
        sort: Union[
            Unset, Literal["stars", "forks", "help-wanted-issues", "updated"]
        ] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchRepositoriesGetResponse200]":
        url = "/search/repositories"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchRepositoriesGetResponse200,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "422": ValidationError,
            },
        )

    def topics(
        self,
        q: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchTopicsGetResponse200]":
        url = "/search/topics"

        params = {
            "q": q,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchTopicsGetResponse200,
        )

    async def async_topics(
        self,
        q: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchTopicsGetResponse200]":
        url = "/search/topics"

        params = {
            "q": q,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchTopicsGetResponse200,
        )

    def users(
        self,
        q: str,
        sort: Union[Unset, Literal["followers", "repositories", "joined"]] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchUsersGetResponse200]":
        url = "/search/users"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchUsersGetResponse200,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "422": ValidationError,
            },
        )

    async def async_users(
        self,
        q: str,
        sort: Union[Unset, Literal["followers", "repositories", "joined"]] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[SearchUsersGetResponse200]":
        url = "/search/users"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=SearchUsersGetResponse200,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "422": ValidationError,
            },
        )
