# /*
#  * @Author: Guofeng He 
#  * @Date: 2022-05-14 08:52:33 
#  * @Last Modified by:   Guofeng He 
#  * @Last Modified time: 2022-05-14 08:52:33 
#  */

#coding=utf-8


'''
    tools 常用的工具
'''



import argparse
import logging
import os
import time

import yaml



class Tools(object):
    @staticmethod
    def getvalue(dict,item):
        if dict.get(item,"") == "":
            dict.update({item:input("please input your %s:"%item)})
        return dict.get(item)

    @staticmethod
    def input_items(org_dict:dict,items:list)->dict:
        '''
        
        输入相应的参数

        Args:
            org_dict (dict): the dictionary of items
            items (list): should check items list

        Returns:
            dict: updated dict
        
        
        '''
        for item in items:
            if not org_dict.get(item,None):
                org_dict[item]=input("please input your %s:"%item)
        return org_dict

    @staticmethod
    def get_config_from_args(options):
        config = {"brain_ip":options.brain_ip,"brain_port":int(options.brain_port),
                  "org_id":options.org_id,"node_id":options.node_id}
        return config
    @staticmethod
    def check_path(path):
        if os.path.exists(path):
            return True
        else:
            try:
                dir,filename = os.path.split(path)
                os.mkdir(dir)
                return True
            except:
                return False
    @staticmethod
    def is_private_addr(addr):
        ips = addr[0].split(".")
        if ips[0] in ["127","192","10","172","224"]:
            return True
        return False
    @staticmethod
    def waitting(status,flag,timeout=10):
        count = 0
        while count < timeout:
            if status[flag]:
                break
            time.sleep(0.5)
            count += 1
        return status[flag]
    @staticmethod    

    def has_id(data:dict,id_chain:list)->bool:
        '''
        check does  item in dictionary with given key chain lists ,

        Args:
            data (dict): source dictionary
            id_chain (list): id list, such as ["first_key","son_key","grandson_key" ...]

        Returns:
            bool: True = has id_chain key in data 
                  False = id_chain not in data
        '''
        return False if len(id_chain)==0 else id_chain[0] in data.keys() if len(id_chain) == 1 else Tools.has_id(data.get(id_chain[0],{}),id_chain[1:])

    @staticmethod    
    def valid(data:dict,key_list:list)->bool:
        '''
        check give keys in item_dict,and not empty

        Args:
            item_dict (dict): data should be dict 
            key_list (list): keys ,such as [”ke1","Key2",...]

        Returns:
            bool: True = valid if has key and value is not empty
                  False = not valid
        '''
        for key in key_list:
            if not data.get(key,None):
                return False
        return True

    @staticmethod    
    def get_by_id(dict:dict,id_chain:list):
        '''
        get item for dictionary with given key chain lists ,

        Args:
            dict (dict): source dictionary
            id_list (list): id list, such as ["first_key","son_key","grandson_key" ...]

        Returns:
            dict: the selected item
        '''
        return {} if len(id_chain)==0 else dict.get(id_chain[0],{}) if len(id_chain) <= 1 else Tools.get_by_id(dict.get(id_chain[0],{}),id_chain[1:]) 

    int2ip = lambda x: '.'.join([str(int(x / (256 ** i) % 256)) for i in range(3, -1, -1)])

    ip2int = lambda x: sum([256 ** j * int(i) for j, i in enumerate(x.split('.')[::-1])])

    @staticmethod
    def load_config(configfile):
        config = yaml.load(open(configfile,"r"),Loader=yaml.FullLoader)
        return  config
    @staticmethod
    def set_debug_log(level,logfilename):
        debug_format = "%(asctime)-15s %(levelname)s %(filename)s %(funcName)s %(lineno)d %(thread)d %(message)s"
        info_format = "%(asctime)-15s %(levelname)s %(message)s"
        Tools.check_path(logfilename)
        if level == logging.DEBUG:
            logging.basicConfig(level=logging.DEBUG,format=debug_format,filename=logfilename)
        if level == logging.INFO:
            logging.basicConfig(level=logging.INFO,format=info_format,filename=logfilename)
        return

    @staticmethod
    def parser_argument():
        parser = argparse.ArgumentParser(
            formatter_class=argparse.ArgumentDefaultsHelpFormatter )
        parser.add_argument('-d', '--debug', action='store_true',
                            default=True,
                            help='Enable debug logging' )
        parser.add_argument('--daemon', action='store_true',
                            default=False,
                            help='daemon mode' )
        parser.add_argument('-o','--org_id',
                            default="misas",
                            help='org id' )
        parser.add_argument('-n','--node_id',
                            default="",
                            help='node id' )
        parser.add_argument('-p', '--password',
                            default="",
                            help='password for node' )
        parser.add_argument('--vpn_user',
                            default="",
                            help='vpn user id' )
        parser.add_argument('--vpn_password',
                        default="",
                        help='password for vpn' )
        parser.add_argument('--tcp',action='store_true',
                            default=False,
                            help='tcp mode' )
        parser.add_argument('-f', '--config',
                            default="",
                            help='config file' )
        parser.add_argument('--server_port',
                            default=9000,
                            help='remote port' )
        parser.add_argument('--server_ip',
                            default="127.0.0.1",
                            help='remote ip' )
        parser.add_argument('--brain_ip',
                            default="14.29.201.19",
                            help='brain ip' )
        parser.add_argument('--brain_port',
                            default="54320",
                            help='brain port' )

        parser.add_argument('--version', action='version', version= "1.0")
        return parser


    # @staticmethod
    # def run_daemon(config:dict,status:dict,flag:str):
    #     '''
    #     run adminserver with config, until status[falg]=True

    #     Args:
    #         config (_type_): {admin_port:9001,admin_pass:password,allow_src:127.0.0.1,admin_process:None}}
    #         status (_type_): _description_
    #         flag (_type_): _description_
    #     '''
    #     adminserver = AdminServer(port=config.get("admin_port", 9000),
    #                                 prompt= config.get("prompt","Admin"),
    #                                 admin_pass =config["admin_pass"],
    #                                 admin_process=config["admin_process"])
    #     adminserver.start()

    #     while not status.get(flag,False):
    #         time.sleep(1)
    #         pass
    #     adminserver.quit()
    #     status[flag] = True
    #     return 

    @staticmethod
    def run_interactive(prompt,command_handle):
        command = "help"
        while not command == "quit yes":
            try:
                print(command_handle(command))
                print("\n%s>"%prompt,end="")
            except Exception as exp:
                logging.debug(exp.__str__())
            command=input()
        return False

