# AUTOGENERATED! DO NOT EDIT! File to edit: 50_cli.ipynb (unless otherwise specified).

__all__ = ['upload_dataset', 'download_dataset', 'add_standalone_manifest']

# Cell
from .core import *
from fastcore.script import *

# Cell
@call_parse
def upload_dataset(storage_name:Param('Section name in config',str),
                   dataset_name:Param('Dataset name',str),
                   config_name:Param('Path to config',str)='secrets/settings.ini',
                   dataset_version:Param('Dataset version',str)='patch'):
    "Create a new dataset archive and upload it to remote storage"
    r=new_storage_client(storage_name,config_name).upload_dataset(dataset_name,dataset_version)
    print('Dataset uploaded to',r)

# Cell
@call_parse
def download_dataset(storage_name:Param('Section name in config',str),
                     dataset_name:Param('Dataset name',str),
                     config_name:Param('Path to config',str)='secrets/settings.ini',
                     dataset_version:Param('Dataset version',str)='latest',
                     overwrite:Param('If True, delete the dataset and re-download',bool)=False):
    "Download a dataset archive from remote storage"
    l=new_storage_client(storage_name,config_name).download_dataset(dataset_name,dataset_version,overwrite)
    print('Dataset downloaded to',l)

# Cell
@call_parse
def add_standalone_manifest(storage_name:Param('Section name in config',str),
                            dataset_name:Param('Dataset name',str),
                            config_name:Param('Path to config',str)='secrets/settings.ini'):
    "Add stand-alone manifest files for datasets created with `storage-tools 0.0.3` and earlier"
    storage_client=new_storage_client(storage_name,config_name)
    existing_names=[f.name for f in storage_client.ls(name_starts_with=dataset_name)]
    for version in storage_client.ls_versions(dataset_name):
        mf=f'{dataset_name}.{version}.manifest.json'
        if mf not in existing_names:
            r=storage_client.download_dataset(dataset_name,version)
            try:
                print('Manifest uploaded to',storage_client._upload_manifest(r))
            except FileNotFoundError as e:
                print('Manifest not uploaded.',e)