# auto generated by update_py.py

import ctypes

from tlclient.linker.constant import FIST_ADDR_MAX_LIMIT, FIST_NAME_MAX_LIMIT, MASTER_ERR_MSG_MAX_LIMIT
from tlclient.linker.timer import Timer
from tlclient.trader.constant import MODULE_ERR_MSG_LENGTH


class GatewayConnectionStatus(ctypes.Structure):
    _fields_ = [
        ('fist_type', ctypes.c_short),
        ('fist_name', ctypes.c_char * FIST_NAME_MAX_LIMIT),
        ('gateway_name', ctypes.c_char * FIST_NAME_MAX_LIMIT),
        ('connected', ctypes.c_bool),
        ('err_id', ctypes.c_int),
        ('err_msg', ctypes.c_char * MODULE_ERR_MSG_LENGTH),
    ]

    def __str__(self):
        return '<gcs fist_type={} fist_name={} gateway_name={} con={} err_id={} err_msg={}>'.format(
            self.fist_type, self.fist_name, self.gateway_name, self.connected, self.err_id, self.err_msg
        )

    def to_influx(self):
        return {
            "measurement": "GatewayConnectionStatus",
            "tags": {
                "fist_type": self.fist_type,
                "fist_name": self.fist_name,
                "gateway_name": self.gateway_name
            },
            "time": Timer.datetime(),
            "fields": {
                "connected": self.connected,
                "err_id": self.err_id,
                "err_msg": self.err_msg
            }
        }

    def to_dict(self):
        return {
            'fist_type': self.fist_type,
            "fist_name": self.fist_name,
            'gateway_name': self.gateway_name,
            "connected": self.connected,
            'err_id': self.err_id,
            "err_msg": self.err_msg,
        }
