# auto generated by update_py.py

import threading
import time
from collections import deque

import tlclient.trader.message_common as message_common
import tlclient.trader.message_market as message_market
import tlclient.trader.message_trade as message_trade

from tlclient.linker.constant import NotificationType, HeartBeatStatus
from tlclient.linker.fist import Fist
from tlclient.linker.frame import Frame
from tlclient.linker.utility import bytify
from tlclient.linker.timer import Timer
from tlclient.trader.constant import MsgType


class Gateway(Fist):

    def __init__(self, acc_name, gateway_name, env_name, addr, fist_type):
        Fist.__init__(self, acc_name, fist_type, env_name)
        self.set_master_addr(addr)
        self.create_fist()
        self.router_name = None
        self.gateway_name = gateway_name
        # init heat beat
        self.heart_beat_msg.desc_name = bytify(self.gateway_name)
        # init mutex
        self.push_mutex = threading.Lock()
        self.use_seperate_queue = True
        self.push_q = deque()
        self.push_c = threading.Condition()

    def init(self, router_name, use_seperate_queue=True):
        self.reg_req(router_name)
        self.reg_sub(router_name)
        self.reg_push(router_name)
        self.router_name = router_name
        self.use_seperate_queue = use_seperate_queue

    def safe_push(self, obj, msg_type, req_id=0):
        self.push_mutex.acquire()
        if self.use_seperate_queue:
            self.push_c.acquire()
            f = Frame()
            f.set_msg_type(msg_type)
            f.set_req_id(req_id)
            f.set_err_id(0)
            f.set_nano(Timer.nano())
            f.set_source(self.get_source_id())
            f.set_data(obj)
            self.push_q.append(f)
            self.push_c.notify()
            self.push_c.release()
        else:
            self.push(self.router_name, obj, msg_type, req_id)
        self.push_mutex.release()

    def start(self):
        if self.use_seperate_queue:
            t = threading.Thread(target=self.consume_push)
            t.setDaemon(True)
            t.start()            
        Fist.start(self)
        self.start_heart_beat(self.router_name, 5)

    # --------- utilities for gateway ---------
    #
    def push_connection_status_change(self, connected, err_id=0, err_msg=''):
        # init conn_status
        conn_status = message_common.GatewayConnectionStatus()
        conn_status.fist_type = self.fist_type
        conn_status.fist_name = bytify(self.fist_name)
        conn_status.gateway_name = bytify(self.gateway_name)
        conn_status.connected = connected
        conn_status.err_id = err_id
        conn_status.err_msg = bytify(err_msg)
        self.safe_push(conn_status, MsgType.GTW_CONNECTION)
        # sync status to heartbeat
        self.set_hb_status(HeartBeatStatus.HEALTHY if connected else HeartBeatStatus.CONNECTION_ERROR)
        # notification logic
        title = self.fist_name
        content = self.fist_name + " connected"
        if not connected:
            content = self.fist_name + " disconnected"
        notificaton_type = NotificationType.SYSTEM
        self.notify(title, content, notificaton_type)
        self.logger.info('conn_status: ' + str(conn_status))

    def consume_push(self):
        self.logger.info('{} consume push started!'.format(self.fist_name))
        while not self.is_stopped():
            while len(self.push_q) == 0:
                self.push_c.acquire()
                self.push_c.wait()
                self.push_c.release()
            self.batch_push(self.router_name, self.push_q)