# auto generated by update_py.py

import json
import platform

from .utils import singleton

DEFAULT_CONFIG_PATH = '/shared/etc/config.json'
CURRENT_PLATFORM = platform.system()


class DbSettings(object):

    def __init__(self, db_json):
        assert 'host' in db_json, 'could not find host in db settings'
        assert 'port' in db_json, 'could not find port in db settings'
        assert 'username' in db_json, 'could not find username in db settings'
        assert 'password' in db_json, 'could not find password in db settings'
        assert 'db' in db_json, 'could not find db in db settings'

        self.host = db_json['host']
        self.port = db_json['port']
        self.username = db_json['username']
        self.password = db_json['password']
        self.db = db_json['db']

    def to_mysql_dict(self):
        return {
            'host': self.host,
            'port': self.port,
            'user': self.username,
            'password': self.password,
            'db': self.db,
        }

    def to_conn_str(self):
        return 'mysql+pymysql://{}:{}@{}:{}/{}'.format(
            self.username, self.password, self.host, self.port, self.db
        )

    def __str__(self):
        return '<Database: -h{} -P{} -u{} -p(hidden) {}>'.format(self.host, self.port, self.username, self.db)


class RedisSettings(object):

    def __init__(self, rd_json):
        assert 'host' in rd_json, 'could not find host in redis json'
        assert 'port' in rd_json, 'could not find port in redis json'
        assert 'db' in rd_json, 'could not find db in redis json'

        self.host = rd_json['host']
        self.port = rd_json['port']
        self.db = rd_json['db']


@singleton
class Configurator(object):

    def __init__(self, config_path=DEFAULT_CONFIG_PATH):
        self._config_path = config_path
        self._config = json.load(open(self._config_path))

    def get_db_settings(self, db_mode=None):
        assert 'database' in self._config, 'could not find database section in config'
        db_mode = db_mode or self._config['database'].get('mode', 'development')
        assert db_mode in self._config['database'], 'could not find "{}" in config section'.format(db_mode)
        db_section = self._config['database'][db_mode]
        settings = DbSettings(db_section)

        return settings

    def get_redis_settings(self):
        assert 'redis' in self._config, 'could not find redis section in config'
        settings = RedisSettings(self._config['redis'])

        return settings


def print_current_config():
    print(json.dumps(Configurator()._config, indent=2))


if __name__ == '__main__':
    print_current_config()
