# auto generated by update_py.py
import logging
import logging.config
import pytz
import datetime
import os

from .utility import get_log_default_path


class Logger:

    LogConfig = {
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'standard': {
                'format': '[%(asctime)s.%(msecs)03d] [%(name)s] [%(levelname)s] [%(filename)s:%(lineno)s] %(message)s',
                'datefmt': '%Y-%m-%d %H:%M:%S'
            }
        },
        'filters': {},
        'handlers': {
            'console': {
                'level': None,
                'class': 'logging.StreamHandler',
                'formatter': 'standard'
            },
            'file': {
                'level': None,
                'class': 'logging.handlers.TimedRotatingFileHandler',
                'filename': None,
                'formatter': 'standard',
                'encoding': 'utf-8',
                'when': 'MIDNIGHT',
                'interval': 1
            }
        },
        'loggers': {
            '': {
                'handlers': ['file', 'console'],
                'level': 'NOTSET',
                'propagate': True
            }
        }
    }

    @classmethod
    def _get_log_level_from_env(cls, env_name, default_level=logging.DEBUG):
        log_level = os.environ.get(env_name)
        if log_level:
            log_level = log_level.lower()

        if log_level == "off":
            return logging.CRITICAL
        elif log_level == "critical":
            return logging.CRITICAL
        elif log_level == "err":
            return logging.ERROR
        elif log_level == "warn":
            return logging.WARNING
        elif log_level == "info":
            return logging.INFO
        elif log_level == "debug":
            return logging.DEBUG
        elif log_level == "trace":
            return logging.NOTSET
        else:
            return default_level

    @classmethod
    def _get_log_path_from_env(cls):
        log_path = os.environ.get("FILE_LOG_PATH") or get_log_default_path()
        if not os.path.exists(log_path):
            os.makedirs(log_path)
        if not os.path.isdir(log_path):
            raise TypeError("The log path '{}' is not a directory.".format(log_path))
        return log_path

    @classmethod
    def rename_file_suffix(cls):
        root_logger = logging.getLogger()
        for hdlr in root_logger.handlers:
            if hdlr.name == 'file':
                hdlr.suffix = '%Y-%m-%d.log'

    @classmethod
    def get_logger(cls, name):
        curr_date = datetime.datetime.now(pytz.timezone('Asia/Shanghai')).strftime("%Y-%m-%d")
        cls.LogConfig['handlers']['file']['filename'] = os.path.join(cls._get_log_path_from_env(), '{}_{}.log'.format(name, curr_date))
        cls.LogConfig['handlers']['console']['level'] = cls._get_log_level_from_env('CONSOLE_LOG_LEVEL')
        cls.LogConfig['handlers']['file']['level'] = cls._get_log_level_from_env('FILE_LOG_LEVEL', logging.INFO)
        logging.config.dictConfig(cls.LogConfig)
        cls.rename_file_suffix()
        return logging.getLogger(name)

    @staticmethod
    def redirect_console_handler_to_DEVNULL():
        root_logger = logging.getLogger()
        for hdlr in root_logger.handlers:
            if hdlr.name == 'console':
                hdlr.setStream(open('/dev/null', 'w'))
