# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ncbi.datasets.api_client import ApiClient
from ncbi.datasets.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class VirusApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def sars2_protein_download(self, proteins, **kwargs):  # noqa: E501
        """Download SARS-CoV-2 protein and CDS datasets by protein name  # noqa: E501

        Download a SARS-CoV-2 protein datasets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sars2_protein_download(proteins, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] proteins: Which proteins to retrieve in the data package (required)
        :param bool refseq_only: If true, limit results to RefSeq genomes.
        :param bool annotated_only: If true, limit results to annotated genomes.
        :param datetime released_since: If set, limit results to viral genomes that have been released after a specified date and time. April 1, 2020 midnight UTC should be formatted as follows: 2020-04-01T00:00:00.000Z.
        :param str host: If set, limit results to genomes extracted from this host (Taxonomy ID or name) or its taxonomic descendants.
        :param str geo_location: Assemblies from this location (country and state, or continent).
        :param bool complete_only: only include complete genomes.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.
        :param str filename: Output file name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.sars2_protein_download_with_http_info(proteins, **kwargs)  # noqa: E501

    def sars2_protein_download_with_http_info(self, proteins, **kwargs):  # noqa: E501
        """Download SARS-CoV-2 protein and CDS datasets by protein name  # noqa: E501

        Download a SARS-CoV-2 protein datasets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sars2_protein_download_with_http_info(proteins, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] proteins: Which proteins to retrieve in the data package (required)
        :param bool refseq_only: If true, limit results to RefSeq genomes.
        :param bool annotated_only: If true, limit results to annotated genomes.
        :param datetime released_since: If set, limit results to viral genomes that have been released after a specified date and time. April 1, 2020 midnight UTC should be formatted as follows: 2020-04-01T00:00:00.000Z.
        :param str host: If set, limit results to genomes extracted from this host (Taxonomy ID or name) or its taxonomic descendants.
        :param str geo_location: Assemblies from this location (country and state, or continent).
        :param bool complete_only: only include complete genomes.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.
        :param str filename: Output file name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proteins',
            'refseq_only',
            'annotated_only',
            'released_since',
            'host',
            'geo_location',
            'complete_only',
            'include_annotation_type',
            'filename'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sars2_protein_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proteins' is set
        if self.api_client.client_side_validation and ('proteins' not in local_var_params or  # noqa: E501
                                                        local_var_params['proteins'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proteins` when calling `sars2_protein_download`")  # noqa: E501

        if self.api_client.client_side_validation and ('proteins' in local_var_params and  # noqa: E501
                                                        len(local_var_params['proteins']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `proteins` when calling `sars2_protein_download`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'proteins' in local_var_params:
            path_params['proteins'] = local_var_params['proteins']  # noqa: E501
            collection_formats['proteins'] = 'csv'  # noqa: E501

        query_params = []
        if 'refseq_only' in local_var_params and local_var_params['refseq_only'] is not None:  # noqa: E501
            query_params.append(('refseq_only', local_var_params['refseq_only']))  # noqa: E501
        if 'annotated_only' in local_var_params and local_var_params['annotated_only'] is not None:  # noqa: E501
            query_params.append(('annotated_only', local_var_params['annotated_only']))  # noqa: E501
        if 'released_since' in local_var_params and local_var_params['released_since'] is not None:  # noqa: E501
            query_params.append(('released_since', local_var_params['released_since']))  # noqa: E501
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501
        if 'geo_location' in local_var_params and local_var_params['geo_location'] is not None:  # noqa: E501
            query_params.append(('geo_location', local_var_params['geo_location']))  # noqa: E501
        if 'complete_only' in local_var_params and local_var_params['complete_only'] is not None:  # noqa: E501
            query_params.append(('complete_only', local_var_params['complete_only']))  # noqa: E501
        if 'include_annotation_type' in local_var_params and local_var_params['include_annotation_type'] is not None:  # noqa: E501
            query_params.append(('include_annotation_type', local_var_params['include_annotation_type']))  # noqa: E501
            collection_formats['include_annotation_type'] = 'multi'  # noqa: E501
        if 'filename' in local_var_params and local_var_params['filename'] is not None:  # noqa: E501
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/virus/taxon/sars2/protein/{proteins}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def sars2_protein_summary(self, proteins, **kwargs):  # noqa: E501
        """Summary of SARS-CoV-2 protein and CDS datasets by protein name  # noqa: E501

        Download a summary of available SARS-CoV-2 protein datasets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sars2_protein_summary(proteins, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] proteins: Which proteins to retrieve in the data package (required)
        :param bool refseq_only: If true, limit results to RefSeq genomes.
        :param bool annotated_only: If true, limit results to annotated genomes.
        :param datetime released_since: If set, limit results to viral genomes that have been released after a specified date and time. April 1, 2020 midnight UTC should be formatted as follows: 2020-04-01T00:00:00.000Z.
        :param str host: If set, limit results to genomes extracted from this host (Taxonomy ID or name) or its taxonomic descendants.
        :param str geo_location: Assemblies from this location (country and state, or continent).
        :param bool complete_only: only include complete genomes.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1DownloadSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.sars2_protein_summary_with_http_info(proteins, **kwargs)  # noqa: E501

    def sars2_protein_summary_with_http_info(self, proteins, **kwargs):  # noqa: E501
        """Summary of SARS-CoV-2 protein and CDS datasets by protein name  # noqa: E501

        Download a summary of available SARS-CoV-2 protein datasets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sars2_protein_summary_with_http_info(proteins, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] proteins: Which proteins to retrieve in the data package (required)
        :param bool refseq_only: If true, limit results to RefSeq genomes.
        :param bool annotated_only: If true, limit results to annotated genomes.
        :param datetime released_since: If set, limit results to viral genomes that have been released after a specified date and time. April 1, 2020 midnight UTC should be formatted as follows: 2020-04-01T00:00:00.000Z.
        :param str host: If set, limit results to genomes extracted from this host (Taxonomy ID or name) or its taxonomic descendants.
        :param str geo_location: Assemblies from this location (country and state, or continent).
        :param bool complete_only: only include complete genomes.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1DownloadSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proteins',
            'refseq_only',
            'annotated_only',
            'released_since',
            'host',
            'geo_location',
            'complete_only',
            'include_annotation_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sars2_protein_summary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proteins' is set
        if self.api_client.client_side_validation and ('proteins' not in local_var_params or  # noqa: E501
                                                        local_var_params['proteins'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proteins` when calling `sars2_protein_summary`")  # noqa: E501

        if self.api_client.client_side_validation and ('proteins' in local_var_params and  # noqa: E501
                                                        len(local_var_params['proteins']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `proteins` when calling `sars2_protein_summary`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'proteins' in local_var_params:
            path_params['proteins'] = local_var_params['proteins']  # noqa: E501
            collection_formats['proteins'] = 'csv'  # noqa: E501

        query_params = []
        if 'refseq_only' in local_var_params and local_var_params['refseq_only'] is not None:  # noqa: E501
            query_params.append(('refseq_only', local_var_params['refseq_only']))  # noqa: E501
        if 'annotated_only' in local_var_params and local_var_params['annotated_only'] is not None:  # noqa: E501
            query_params.append(('annotated_only', local_var_params['annotated_only']))  # noqa: E501
        if 'released_since' in local_var_params and local_var_params['released_since'] is not None:  # noqa: E501
            query_params.append(('released_since', local_var_params['released_since']))  # noqa: E501
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501
        if 'geo_location' in local_var_params and local_var_params['geo_location'] is not None:  # noqa: E501
            query_params.append(('geo_location', local_var_params['geo_location']))  # noqa: E501
        if 'complete_only' in local_var_params and local_var_params['complete_only'] is not None:  # noqa: E501
            query_params.append(('complete_only', local_var_params['complete_only']))  # noqa: E501
        if 'include_annotation_type' in local_var_params and local_var_params['include_annotation_type'] is not None:  # noqa: E501
            query_params.append(('include_annotation_type', local_var_params['include_annotation_type']))  # noqa: E501
            collection_formats['include_annotation_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/virus/taxon/sars2/protein/{proteins}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1DownloadSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def sars2_protein_table(self, proteins, **kwargs):  # noqa: E501
        """Get SARS-CoV-2 protein metadata in a tabular format.  # noqa: E501

        Get protein metadata in tabular format for SARS-CoV-2 genomes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sars2_protein_table(proteins, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] proteins: Which proteins to retrieve in the data package (required)
        :param bool refseq_only: If true, limit results to RefSeq genomes.
        :param bool annotated_only: If true, limit results to annotated genomes.
        :param datetime released_since: If set, limit results to viral genomes that have been released after a specified date and time. April 1, 2020 midnight UTC should be formatted as follows: 2020-04-01T00:00:00.000Z.
        :param str host: If set, limit results to genomes extracted from this host (Taxonomy ID or name) or its taxonomic descendants.
        :param str geo_location: Assemblies from this location (country and state, or continent).
        :param bool complete_only: only include complete genomes.
        :param list[str] table_fields: Specify which fields to include in the tabular report.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StreamResultOfV1alpha1TabularOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.sars2_protein_table_with_http_info(proteins, **kwargs)  # noqa: E501

    def sars2_protein_table_with_http_info(self, proteins, **kwargs):  # noqa: E501
        """Get SARS-CoV-2 protein metadata in a tabular format.  # noqa: E501

        Get protein metadata in tabular format for SARS-CoV-2 genomes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sars2_protein_table_with_http_info(proteins, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] proteins: Which proteins to retrieve in the data package (required)
        :param bool refseq_only: If true, limit results to RefSeq genomes.
        :param bool annotated_only: If true, limit results to annotated genomes.
        :param datetime released_since: If set, limit results to viral genomes that have been released after a specified date and time. April 1, 2020 midnight UTC should be formatted as follows: 2020-04-01T00:00:00.000Z.
        :param str host: If set, limit results to genomes extracted from this host (Taxonomy ID or name) or its taxonomic descendants.
        :param str geo_location: Assemblies from this location (country and state, or continent).
        :param bool complete_only: only include complete genomes.
        :param list[str] table_fields: Specify which fields to include in the tabular report.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StreamResultOfV1alpha1TabularOutput, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proteins',
            'refseq_only',
            'annotated_only',
            'released_since',
            'host',
            'geo_location',
            'complete_only',
            'table_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sars2_protein_table" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proteins' is set
        if self.api_client.client_side_validation and ('proteins' not in local_var_params or  # noqa: E501
                                                        local_var_params['proteins'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proteins` when calling `sars2_protein_table`")  # noqa: E501

        if self.api_client.client_side_validation and ('proteins' in local_var_params and  # noqa: E501
                                                        len(local_var_params['proteins']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `proteins` when calling `sars2_protein_table`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'proteins' in local_var_params:
            path_params['proteins'] = local_var_params['proteins']  # noqa: E501
            collection_formats['proteins'] = 'csv'  # noqa: E501

        query_params = []
        if 'refseq_only' in local_var_params and local_var_params['refseq_only'] is not None:  # noqa: E501
            query_params.append(('refseq_only', local_var_params['refseq_only']))  # noqa: E501
        if 'annotated_only' in local_var_params and local_var_params['annotated_only'] is not None:  # noqa: E501
            query_params.append(('annotated_only', local_var_params['annotated_only']))  # noqa: E501
        if 'released_since' in local_var_params and local_var_params['released_since'] is not None:  # noqa: E501
            query_params.append(('released_since', local_var_params['released_since']))  # noqa: E501
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501
        if 'geo_location' in local_var_params and local_var_params['geo_location'] is not None:  # noqa: E501
            query_params.append(('geo_location', local_var_params['geo_location']))  # noqa: E501
        if 'complete_only' in local_var_params and local_var_params['complete_only'] is not None:  # noqa: E501
            query_params.append(('complete_only', local_var_params['complete_only']))  # noqa: E501
        if 'table_fields' in local_var_params and local_var_params['table_fields'] is not None:  # noqa: E501
            query_params.append(('table_fields', local_var_params['table_fields']))  # noqa: E501
            collection_formats['table_fields'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/tsv'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/virus/taxon/sars2/protein/{proteins}/table', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StreamResultOfV1alpha1TabularOutput',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def virus_genome_download(self, taxon, **kwargs):  # noqa: E501
        """Download Coronavirus genome datasets by taxon  # noqa: E501

        Download a Coronavirus genome datasets by taxon  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.virus_genome_download(taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param bool refseq_only: If true, limit results to RefSeq genomes.
        :param bool annotated_only: If true, limit results to annotated genomes.
        :param datetime released_since: If set, limit results to viral genomes that have been released after a specified date and time. April 1, 2020 midnight UTC should be formatted as follows: 2020-04-01T00:00:00.000Z.
        :param str host: If set, limit results to genomes extracted from this host (Taxonomy ID or name) or its taxonomic descendants.
        :param str geo_location: Assemblies from this location (country and state, or continent).
        :param bool complete_only: only include complete genomes.
        :param bool exclude_sequence: Set to true to omit the genomic sequence.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.
        :param str filename: Output file name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.virus_genome_download_with_http_info(taxon, **kwargs)  # noqa: E501

    def virus_genome_download_with_http_info(self, taxon, **kwargs):  # noqa: E501
        """Download Coronavirus genome datasets by taxon  # noqa: E501

        Download a Coronavirus genome datasets by taxon  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.virus_genome_download_with_http_info(taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param bool refseq_only: If true, limit results to RefSeq genomes.
        :param bool annotated_only: If true, limit results to annotated genomes.
        :param datetime released_since: If set, limit results to viral genomes that have been released after a specified date and time. April 1, 2020 midnight UTC should be formatted as follows: 2020-04-01T00:00:00.000Z.
        :param str host: If set, limit results to genomes extracted from this host (Taxonomy ID or name) or its taxonomic descendants.
        :param str geo_location: Assemblies from this location (country and state, or continent).
        :param bool complete_only: only include complete genomes.
        :param bool exclude_sequence: Set to true to omit the genomic sequence.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.
        :param str filename: Output file name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'taxon',
            'refseq_only',
            'annotated_only',
            'released_since',
            'host',
            'geo_location',
            'complete_only',
            'exclude_sequence',
            'include_annotation_type',
            'filename'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method virus_genome_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'taxon' is set
        if self.api_client.client_side_validation and ('taxon' not in local_var_params or  # noqa: E501
                                                        local_var_params['taxon'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `taxon` when calling `virus_genome_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'taxon' in local_var_params:
            path_params['taxon'] = local_var_params['taxon']  # noqa: E501

        query_params = []
        if 'refseq_only' in local_var_params and local_var_params['refseq_only'] is not None:  # noqa: E501
            query_params.append(('refseq_only', local_var_params['refseq_only']))  # noqa: E501
        if 'annotated_only' in local_var_params and local_var_params['annotated_only'] is not None:  # noqa: E501
            query_params.append(('annotated_only', local_var_params['annotated_only']))  # noqa: E501
        if 'released_since' in local_var_params and local_var_params['released_since'] is not None:  # noqa: E501
            query_params.append(('released_since', local_var_params['released_since']))  # noqa: E501
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501
        if 'geo_location' in local_var_params and local_var_params['geo_location'] is not None:  # noqa: E501
            query_params.append(('geo_location', local_var_params['geo_location']))  # noqa: E501
        if 'complete_only' in local_var_params and local_var_params['complete_only'] is not None:  # noqa: E501
            query_params.append(('complete_only', local_var_params['complete_only']))  # noqa: E501
        if 'exclude_sequence' in local_var_params and local_var_params['exclude_sequence'] is not None:  # noqa: E501
            query_params.append(('exclude_sequence', local_var_params['exclude_sequence']))  # noqa: E501
        if 'include_annotation_type' in local_var_params and local_var_params['include_annotation_type'] is not None:  # noqa: E501
            query_params.append(('include_annotation_type', local_var_params['include_annotation_type']))  # noqa: E501
            collection_formats['include_annotation_type'] = 'multi'  # noqa: E501
        if 'filename' in local_var_params and local_var_params['filename'] is not None:  # noqa: E501
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/virus/taxon/{taxon}/genome/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def virus_genome_summary(self, taxon, **kwargs):  # noqa: E501
        """Get summary data for Coronaviridae genomes by taxon  # noqa: E501

        Get summary data and download by command line instructions for Coronaviridae genomes by taxon.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.virus_genome_summary(taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param bool refseq_only: If true, limit results to RefSeq genomes.
        :param bool annotated_only: If true, limit results to annotated genomes.
        :param datetime released_since: If set, limit results to viral genomes that have been released after a specified date and time. April 1, 2020 midnight UTC should be formatted as follows: 2020-04-01T00:00:00.000Z.
        :param str host: If set, limit results to genomes extracted from this host (Taxonomy ID or name) or its taxonomic descendants.
        :param str geo_location: Assemblies from this location (country and state, or continent).
        :param bool complete_only: only include complete genomes.
        :param bool exclude_sequence: Set to true to omit the genomic sequence.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1DownloadSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.virus_genome_summary_with_http_info(taxon, **kwargs)  # noqa: E501

    def virus_genome_summary_with_http_info(self, taxon, **kwargs):  # noqa: E501
        """Get summary data for Coronaviridae genomes by taxon  # noqa: E501

        Get summary data and download by command line instructions for Coronaviridae genomes by taxon.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.virus_genome_summary_with_http_info(taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param bool refseq_only: If true, limit results to RefSeq genomes.
        :param bool annotated_only: If true, limit results to annotated genomes.
        :param datetime released_since: If set, limit results to viral genomes that have been released after a specified date and time. April 1, 2020 midnight UTC should be formatted as follows: 2020-04-01T00:00:00.000Z.
        :param str host: If set, limit results to genomes extracted from this host (Taxonomy ID or name) or its taxonomic descendants.
        :param str geo_location: Assemblies from this location (country and state, or continent).
        :param bool complete_only: only include complete genomes.
        :param bool exclude_sequence: Set to true to omit the genomic sequence.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1DownloadSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'taxon',
            'refseq_only',
            'annotated_only',
            'released_since',
            'host',
            'geo_location',
            'complete_only',
            'exclude_sequence',
            'include_annotation_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method virus_genome_summary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'taxon' is set
        if self.api_client.client_side_validation and ('taxon' not in local_var_params or  # noqa: E501
                                                        local_var_params['taxon'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `taxon` when calling `virus_genome_summary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'taxon' in local_var_params:
            path_params['taxon'] = local_var_params['taxon']  # noqa: E501

        query_params = []
        if 'refseq_only' in local_var_params and local_var_params['refseq_only'] is not None:  # noqa: E501
            query_params.append(('refseq_only', local_var_params['refseq_only']))  # noqa: E501
        if 'annotated_only' in local_var_params and local_var_params['annotated_only'] is not None:  # noqa: E501
            query_params.append(('annotated_only', local_var_params['annotated_only']))  # noqa: E501
        if 'released_since' in local_var_params and local_var_params['released_since'] is not None:  # noqa: E501
            query_params.append(('released_since', local_var_params['released_since']))  # noqa: E501
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501
        if 'geo_location' in local_var_params and local_var_params['geo_location'] is not None:  # noqa: E501
            query_params.append(('geo_location', local_var_params['geo_location']))  # noqa: E501
        if 'complete_only' in local_var_params and local_var_params['complete_only'] is not None:  # noqa: E501
            query_params.append(('complete_only', local_var_params['complete_only']))  # noqa: E501
        if 'exclude_sequence' in local_var_params and local_var_params['exclude_sequence'] is not None:  # noqa: E501
            query_params.append(('exclude_sequence', local_var_params['exclude_sequence']))  # noqa: E501
        if 'include_annotation_type' in local_var_params and local_var_params['include_annotation_type'] is not None:  # noqa: E501
            query_params.append(('include_annotation_type', local_var_params['include_annotation_type']))  # noqa: E501
            collection_formats['include_annotation_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/virus/taxon/{taxon}/genome', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1DownloadSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def virus_genome_table(self, taxon, **kwargs):  # noqa: E501
        """Get viral genomic metadata in a tabular format.  # noqa: E501

        Get viral genomic metadata in tabular format for Coronaviridae genomes by taxon.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.virus_genome_table(taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param bool refseq_only: If true, limit results to RefSeq genomes.
        :param bool annotated_only: If true, limit results to annotated genomes.
        :param datetime released_since: If set, limit results to viral genomes that have been released after a specified date and time. April 1, 2020 midnight UTC should be formatted as follows: 2020-04-01T00:00:00.000Z.
        :param str host: If set, limit results to genomes extracted from this host (Taxonomy ID or name) or its taxonomic descendants.
        :param str geo_location: Assemblies from this location (country and state, or continent).
        :param bool complete_only: only include complete genomes.
        :param list[str] table_fields: Specify which fields to include in the tabular report.
        :param bool exclude_sequence: Set to true to omit the genomic sequence.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StreamResultOfV1alpha1TabularOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.virus_genome_table_with_http_info(taxon, **kwargs)  # noqa: E501

    def virus_genome_table_with_http_info(self, taxon, **kwargs):  # noqa: E501
        """Get viral genomic metadata in a tabular format.  # noqa: E501

        Get viral genomic metadata in tabular format for Coronaviridae genomes by taxon.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.virus_genome_table_with_http_info(taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param bool refseq_only: If true, limit results to RefSeq genomes.
        :param bool annotated_only: If true, limit results to annotated genomes.
        :param datetime released_since: If set, limit results to viral genomes that have been released after a specified date and time. April 1, 2020 midnight UTC should be formatted as follows: 2020-04-01T00:00:00.000Z.
        :param str host: If set, limit results to genomes extracted from this host (Taxonomy ID or name) or its taxonomic descendants.
        :param str geo_location: Assemblies from this location (country and state, or continent).
        :param bool complete_only: only include complete genomes.
        :param list[str] table_fields: Specify which fields to include in the tabular report.
        :param bool exclude_sequence: Set to true to omit the genomic sequence.
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StreamResultOfV1alpha1TabularOutput, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'taxon',
            'refseq_only',
            'annotated_only',
            'released_since',
            'host',
            'geo_location',
            'complete_only',
            'table_fields',
            'exclude_sequence',
            'include_annotation_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method virus_genome_table" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'taxon' is set
        if self.api_client.client_side_validation and ('taxon' not in local_var_params or  # noqa: E501
                                                        local_var_params['taxon'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `taxon` when calling `virus_genome_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'taxon' in local_var_params:
            path_params['taxon'] = local_var_params['taxon']  # noqa: E501

        query_params = []
        if 'refseq_only' in local_var_params and local_var_params['refseq_only'] is not None:  # noqa: E501
            query_params.append(('refseq_only', local_var_params['refseq_only']))  # noqa: E501
        if 'annotated_only' in local_var_params and local_var_params['annotated_only'] is not None:  # noqa: E501
            query_params.append(('annotated_only', local_var_params['annotated_only']))  # noqa: E501
        if 'released_since' in local_var_params and local_var_params['released_since'] is not None:  # noqa: E501
            query_params.append(('released_since', local_var_params['released_since']))  # noqa: E501
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501
        if 'geo_location' in local_var_params and local_var_params['geo_location'] is not None:  # noqa: E501
            query_params.append(('geo_location', local_var_params['geo_location']))  # noqa: E501
        if 'complete_only' in local_var_params and local_var_params['complete_only'] is not None:  # noqa: E501
            query_params.append(('complete_only', local_var_params['complete_only']))  # noqa: E501
        if 'table_fields' in local_var_params and local_var_params['table_fields'] is not None:  # noqa: E501
            query_params.append(('table_fields', local_var_params['table_fields']))  # noqa: E501
            collection_formats['table_fields'] = 'multi'  # noqa: E501
        if 'exclude_sequence' in local_var_params and local_var_params['exclude_sequence'] is not None:  # noqa: E501
            query_params.append(('exclude_sequence', local_var_params['exclude_sequence']))  # noqa: E501
        if 'include_annotation_type' in local_var_params and local_var_params['include_annotation_type'] is not None:  # noqa: E501
            query_params.append(('include_annotation_type', local_var_params['include_annotation_type']))  # noqa: E501
            collection_formats['include_annotation_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/tsv'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/virus/taxon/{taxon}/genome/table', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StreamResultOfV1alpha1TabularOutput',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
