# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ncbi.datasets.api_client import ApiClient
from ncbi.datasets.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class GeneApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def download_gene_package(self, gene_ids, **kwargs):  # noqa: E501
        """Get a gene dataset by gene ID  # noqa: E501

        Get a gene dataset including gene, transcript and protein fasta sequence, annotation and metadata by gene ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_gene_package(gene_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[int] gene_ids: (required)
        :param list[str] include_annotation_type:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param str filename: Output file name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_gene_package_with_http_info(gene_ids, **kwargs)  # noqa: E501

    def download_gene_package_with_http_info(self, gene_ids, **kwargs):  # noqa: E501
        """Get a gene dataset by gene ID  # noqa: E501

        Get a gene dataset including gene, transcript and protein fasta sequence, annotation and metadata by gene ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_gene_package_with_http_info(gene_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[int] gene_ids: (required)
        :param list[str] include_annotation_type:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param str filename: Output file name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'gene_ids',
            'include_annotation_type',
            'sort_schema_field',
            'sort_schema_direction',
            'filename'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_gene_package" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gene_ids' is set
        if self.api_client.client_side_validation and ('gene_ids' not in local_var_params or  # noqa: E501
                                                        local_var_params['gene_ids'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `gene_ids` when calling `download_gene_package`")  # noqa: E501

        if self.api_client.client_side_validation and ('gene_ids' in local_var_params and  # noqa: E501
                                                        len(local_var_params['gene_ids']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gene_ids` when calling `download_gene_package`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gene_ids' in local_var_params:
            path_params['gene_ids'] = local_var_params['gene_ids']  # noqa: E501
            collection_formats['gene_ids'] = 'csv'  # noqa: E501

        query_params = []
        if 'include_annotation_type' in local_var_params and local_var_params['include_annotation_type'] is not None:  # noqa: E501
            query_params.append(('include_annotation_type', local_var_params['include_annotation_type']))  # noqa: E501
            collection_formats['include_annotation_type'] = 'multi'  # noqa: E501
        if 'sort_schema_field' in local_var_params and local_var_params['sort_schema_field'] is not None:  # noqa: E501
            query_params.append(('sort_schema.field', local_var_params['sort_schema_field']))  # noqa: E501
        if 'sort_schema_direction' in local_var_params and local_var_params['sort_schema_direction'] is not None:  # noqa: E501
            query_params.append(('sort_schema.direction', local_var_params['sort_schema_direction']))  # noqa: E501
        if 'filename' in local_var_params and local_var_params['filename'] is not None:  # noqa: E501
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/id/{gene_ids}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_gene_package_post(self, body, **kwargs):  # noqa: E501
        """Get a gene dataset by POST  # noqa: E501

        Get a gene dataset including gene, transcript and protein fasta sequence, annotation and metadata by POST.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_gene_package_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1GeneDatasetRequest body: (required)
        :param str filename: Output file name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_gene_package_post_with_http_info(body, **kwargs)  # noqa: E501

    def download_gene_package_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get a gene dataset by POST  # noqa: E501

        Get a gene dataset including gene, transcript and protein fasta sequence, annotation and metadata by POST.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_gene_package_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1GeneDatasetRequest body: (required)
        :param str filename: Output file name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'body',
            'filename'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_gene_package_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `download_gene_package_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filename' in local_var_params and local_var_params['filename'] is not None:  # noqa: E501
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/download', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_download_summary_by_accession(self, accessions, **kwargs):  # noqa: E501
        """Get gene download summary by RefSeq Accession  # noqa: E501

        Get gene download summary by RefSeq Accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_download_summary_by_accession(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: RNA or Protein accessions. (required)
        :param str returned_content:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1DownloadSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_download_summary_by_accession_with_http_info(accessions, **kwargs)  # noqa: E501

    def gene_download_summary_by_accession_with_http_info(self, accessions, **kwargs):  # noqa: E501
        """Get gene download summary by RefSeq Accession  # noqa: E501

        Get gene download summary by RefSeq Accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_download_summary_by_accession_with_http_info(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: RNA or Protein accessions. (required)
        :param str returned_content:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1DownloadSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'accessions',
            'returned_content',
            'sort_schema_field',
            'sort_schema_direction'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_download_summary_by_accession" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'accessions' is set
        if self.api_client.client_side_validation and ('accessions' not in local_var_params or  # noqa: E501
                                                        local_var_params['accessions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accessions` when calling `gene_download_summary_by_accession`")  # noqa: E501

        if self.api_client.client_side_validation and ('accessions' in local_var_params and  # noqa: E501
                                                        len(local_var_params['accessions']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `accessions` when calling `gene_download_summary_by_accession`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'accessions' in local_var_params:
            path_params['accessions'] = local_var_params['accessions']  # noqa: E501
            collection_formats['accessions'] = 'csv'  # noqa: E501

        query_params = []
        if 'returned_content' in local_var_params and local_var_params['returned_content'] is not None:  # noqa: E501
            query_params.append(('returned_content', local_var_params['returned_content']))  # noqa: E501
        if 'sort_schema_field' in local_var_params and local_var_params['sort_schema_field'] is not None:  # noqa: E501
            query_params.append(('sort_schema.field', local_var_params['sort_schema_field']))  # noqa: E501
        if 'sort_schema_direction' in local_var_params and local_var_params['sort_schema_direction'] is not None:  # noqa: E501
            query_params.append(('sort_schema.direction', local_var_params['sort_schema_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/accession/{accessions}/download_summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1DownloadSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_download_summary_by_id(self, gene_ids, **kwargs):  # noqa: E501
        """Get gene download summary by GeneID  # noqa: E501

        Get a download summary by GeneID in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_download_summary_by_id(gene_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[int] gene_ids: (required)
        :param str returned_content:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1DownloadSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_download_summary_by_id_with_http_info(gene_ids, **kwargs)  # noqa: E501

    def gene_download_summary_by_id_with_http_info(self, gene_ids, **kwargs):  # noqa: E501
        """Get gene download summary by GeneID  # noqa: E501

        Get a download summary by GeneID in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_download_summary_by_id_with_http_info(gene_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[int] gene_ids: (required)
        :param str returned_content:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1DownloadSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'gene_ids',
            'returned_content',
            'sort_schema_field',
            'sort_schema_direction'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_download_summary_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gene_ids' is set
        if self.api_client.client_side_validation and ('gene_ids' not in local_var_params or  # noqa: E501
                                                        local_var_params['gene_ids'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `gene_ids` when calling `gene_download_summary_by_id`")  # noqa: E501

        if self.api_client.client_side_validation and ('gene_ids' in local_var_params and  # noqa: E501
                                                        len(local_var_params['gene_ids']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gene_ids` when calling `gene_download_summary_by_id`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gene_ids' in local_var_params:
            path_params['gene_ids'] = local_var_params['gene_ids']  # noqa: E501
            collection_formats['gene_ids'] = 'csv'  # noqa: E501

        query_params = []
        if 'returned_content' in local_var_params and local_var_params['returned_content'] is not None:  # noqa: E501
            query_params.append(('returned_content', local_var_params['returned_content']))  # noqa: E501
        if 'sort_schema_field' in local_var_params and local_var_params['sort_schema_field'] is not None:  # noqa: E501
            query_params.append(('sort_schema.field', local_var_params['sort_schema_field']))  # noqa: E501
        if 'sort_schema_direction' in local_var_params and local_var_params['sort_schema_direction'] is not None:  # noqa: E501
            query_params.append(('sort_schema.direction', local_var_params['sort_schema_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/id/{gene_ids}/download_summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1DownloadSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_download_summary_by_post(self, body, **kwargs):  # noqa: E501
        """Get gene download summary  # noqa: E501

        Get gene download summary in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_download_summary_by_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1GeneDatasetRequest body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1DownloadSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_download_summary_by_post_with_http_info(body, **kwargs)  # noqa: E501

    def gene_download_summary_by_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get gene download summary  # noqa: E501

        Get gene download summary in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_download_summary_by_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1GeneDatasetRequest body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1DownloadSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_download_summary_by_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `gene_download_summary_by_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/download_summary', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1DownloadSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_download_summary_by_tax_and_symbol(self, symbols, taxon, **kwargs):  # noqa: E501
        """Get gene download summary by gene symbol.  # noqa: E501

        Get gene download summary by gene symbol in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_download_summary_by_tax_and_symbol(symbols, taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] symbols: (required)
        :param str taxon: (required)
        :param str returned_content:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1DownloadSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_download_summary_by_tax_and_symbol_with_http_info(symbols, taxon, **kwargs)  # noqa: E501

    def gene_download_summary_by_tax_and_symbol_with_http_info(self, symbols, taxon, **kwargs):  # noqa: E501
        """Get gene download summary by gene symbol.  # noqa: E501

        Get gene download summary by gene symbol in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_download_summary_by_tax_and_symbol_with_http_info(symbols, taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] symbols: (required)
        :param str taxon: (required)
        :param str returned_content:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1DownloadSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbols',
            'taxon',
            'returned_content',
            'sort_schema_field',
            'sort_schema_direction'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_download_summary_by_tax_and_symbol" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbols' is set
        if self.api_client.client_side_validation and ('symbols' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbols'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbols` when calling `gene_download_summary_by_tax_and_symbol`")  # noqa: E501
        # verify the required parameter 'taxon' is set
        if self.api_client.client_side_validation and ('taxon' not in local_var_params or  # noqa: E501
                                                        local_var_params['taxon'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `taxon` when calling `gene_download_summary_by_tax_and_symbol`")  # noqa: E501

        if self.api_client.client_side_validation and ('symbols' in local_var_params and  # noqa: E501
                                                        len(local_var_params['symbols']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `symbols` when calling `gene_download_summary_by_tax_and_symbol`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'symbols' in local_var_params:
            path_params['symbols'] = local_var_params['symbols']  # noqa: E501
            collection_formats['symbols'] = 'csv'  # noqa: E501
        if 'taxon' in local_var_params:
            path_params['taxon'] = local_var_params['taxon']  # noqa: E501

        query_params = []
        if 'returned_content' in local_var_params and local_var_params['returned_content'] is not None:  # noqa: E501
            query_params.append(('returned_content', local_var_params['returned_content']))  # noqa: E501
        if 'sort_schema_field' in local_var_params and local_var_params['sort_schema_field'] is not None:  # noqa: E501
            query_params.append(('sort_schema.field', local_var_params['sort_schema_field']))  # noqa: E501
        if 'sort_schema_direction' in local_var_params and local_var_params['sort_schema_direction'] is not None:  # noqa: E501
            query_params.append(('sort_schema.direction', local_var_params['sort_schema_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/symbol/{symbols}/taxon/{taxon}/download_summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1DownloadSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_metadata_by_accession(self, accessions, **kwargs):  # noqa: E501
        """Get gene metadata by RefSeq Accession  # noqa: E501

        Get detailed gene metadata by RefSeq Accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_metadata_by_accession(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: RNA or Protein accessions. (required)
        :param str returned_content:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1GeneMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_metadata_by_accession_with_http_info(accessions, **kwargs)  # noqa: E501

    def gene_metadata_by_accession_with_http_info(self, accessions, **kwargs):  # noqa: E501
        """Get gene metadata by RefSeq Accession  # noqa: E501

        Get detailed gene metadata by RefSeq Accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_metadata_by_accession_with_http_info(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: RNA or Protein accessions. (required)
        :param str returned_content:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1GeneMetadata, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'accessions',
            'returned_content',
            'sort_schema_field',
            'sort_schema_direction'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_metadata_by_accession" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'accessions' is set
        if self.api_client.client_side_validation and ('accessions' not in local_var_params or  # noqa: E501
                                                        local_var_params['accessions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accessions` when calling `gene_metadata_by_accession`")  # noqa: E501

        if self.api_client.client_side_validation and ('accessions' in local_var_params and  # noqa: E501
                                                        len(local_var_params['accessions']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `accessions` when calling `gene_metadata_by_accession`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'accessions' in local_var_params:
            path_params['accessions'] = local_var_params['accessions']  # noqa: E501
            collection_formats['accessions'] = 'csv'  # noqa: E501

        query_params = []
        if 'returned_content' in local_var_params and local_var_params['returned_content'] is not None:  # noqa: E501
            query_params.append(('returned_content', local_var_params['returned_content']))  # noqa: E501
        if 'sort_schema_field' in local_var_params and local_var_params['sort_schema_field'] is not None:  # noqa: E501
            query_params.append(('sort_schema.field', local_var_params['sort_schema_field']))  # noqa: E501
        if 'sort_schema_direction' in local_var_params and local_var_params['sort_schema_direction'] is not None:  # noqa: E501
            query_params.append(('sort_schema.direction', local_var_params['sort_schema_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/accession/{accessions}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1GeneMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_metadata_by_id(self, gene_ids, **kwargs):  # noqa: E501
        """Get gene metadata by GeneID  # noqa: E501

        Get detailed gene metadata by GeneID in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_metadata_by_id(gene_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[int] gene_ids: (required)
        :param str returned_content:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1GeneMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_metadata_by_id_with_http_info(gene_ids, **kwargs)  # noqa: E501

    def gene_metadata_by_id_with_http_info(self, gene_ids, **kwargs):  # noqa: E501
        """Get gene metadata by GeneID  # noqa: E501

        Get detailed gene metadata by GeneID in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_metadata_by_id_with_http_info(gene_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[int] gene_ids: (required)
        :param str returned_content:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1GeneMetadata, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'gene_ids',
            'returned_content',
            'sort_schema_field',
            'sort_schema_direction'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_metadata_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gene_ids' is set
        if self.api_client.client_side_validation and ('gene_ids' not in local_var_params or  # noqa: E501
                                                        local_var_params['gene_ids'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `gene_ids` when calling `gene_metadata_by_id`")  # noqa: E501

        if self.api_client.client_side_validation and ('gene_ids' in local_var_params and  # noqa: E501
                                                        len(local_var_params['gene_ids']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gene_ids` when calling `gene_metadata_by_id`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gene_ids' in local_var_params:
            path_params['gene_ids'] = local_var_params['gene_ids']  # noqa: E501
            collection_formats['gene_ids'] = 'csv'  # noqa: E501

        query_params = []
        if 'returned_content' in local_var_params and local_var_params['returned_content'] is not None:  # noqa: E501
            query_params.append(('returned_content', local_var_params['returned_content']))  # noqa: E501
        if 'sort_schema_field' in local_var_params and local_var_params['sort_schema_field'] is not None:  # noqa: E501
            query_params.append(('sort_schema.field', local_var_params['sort_schema_field']))  # noqa: E501
        if 'sort_schema_direction' in local_var_params and local_var_params['sort_schema_direction'] is not None:  # noqa: E501
            query_params.append(('sort_schema.direction', local_var_params['sort_schema_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/id/{gene_ids}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1GeneMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_metadata_by_post(self, body, **kwargs):  # noqa: E501
        """Get gene metadata  # noqa: E501

        Get detailed gene metadata in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_metadata_by_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1GeneDatasetRequest body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1GeneMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_metadata_by_post_with_http_info(body, **kwargs)  # noqa: E501

    def gene_metadata_by_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get gene metadata  # noqa: E501

        Get detailed gene metadata in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_metadata_by_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1GeneDatasetRequest body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1GeneMetadata, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_metadata_by_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `gene_metadata_by_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1GeneMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_metadata_by_tax_and_symbol(self, symbols, taxon, **kwargs):  # noqa: E501
        """Get gene metadata by gene symbol.  # noqa: E501

        Get detailed gene metadata by gene symbol in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_metadata_by_tax_and_symbol(symbols, taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] symbols: (required)
        :param str taxon: (required)
        :param str returned_content:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1GeneMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_metadata_by_tax_and_symbol_with_http_info(symbols, taxon, **kwargs)  # noqa: E501

    def gene_metadata_by_tax_and_symbol_with_http_info(self, symbols, taxon, **kwargs):  # noqa: E501
        """Get gene metadata by gene symbol.  # noqa: E501

        Get detailed gene metadata by gene symbol in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_metadata_by_tax_and_symbol_with_http_info(symbols, taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] symbols: (required)
        :param str taxon: (required)
        :param str returned_content:
        :param str sort_schema_field:
        :param str sort_schema_direction:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1GeneMetadata, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbols',
            'taxon',
            'returned_content',
            'sort_schema_field',
            'sort_schema_direction'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_metadata_by_tax_and_symbol" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbols' is set
        if self.api_client.client_side_validation and ('symbols' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbols'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbols` when calling `gene_metadata_by_tax_and_symbol`")  # noqa: E501
        # verify the required parameter 'taxon' is set
        if self.api_client.client_side_validation and ('taxon' not in local_var_params or  # noqa: E501
                                                        local_var_params['taxon'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `taxon` when calling `gene_metadata_by_tax_and_symbol`")  # noqa: E501

        if self.api_client.client_side_validation and ('symbols' in local_var_params and  # noqa: E501
                                                        len(local_var_params['symbols']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `symbols` when calling `gene_metadata_by_tax_and_symbol`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'symbols' in local_var_params:
            path_params['symbols'] = local_var_params['symbols']  # noqa: E501
            collection_formats['symbols'] = 'csv'  # noqa: E501
        if 'taxon' in local_var_params:
            path_params['taxon'] = local_var_params['taxon']  # noqa: E501

        query_params = []
        if 'returned_content' in local_var_params and local_var_params['returned_content'] is not None:  # noqa: E501
            query_params.append(('returned_content', local_var_params['returned_content']))  # noqa: E501
        if 'sort_schema_field' in local_var_params and local_var_params['sort_schema_field'] is not None:  # noqa: E501
            query_params.append(('sort_schema.field', local_var_params['sort_schema_field']))  # noqa: E501
        if 'sort_schema_direction' in local_var_params and local_var_params['sort_schema_direction'] is not None:  # noqa: E501
            query_params.append(('sort_schema.direction', local_var_params['sort_schema_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/symbol/{symbols}/taxon/{taxon}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1GeneMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_tax_name_query(self, taxon_query, **kwargs):  # noqa: E501
        """Get a list of taxonomy names and IDs found in the gene dataset given a partial taxonomic name.  # noqa: E501

        This endpoint retrieves a list of taxonomy names and IDs found in the gene dataset given a partial taxonomic name of any rank.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_tax_name_query(taxon_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon_query: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1SciNameAndIds
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_tax_name_query_with_http_info(taxon_query, **kwargs)  # noqa: E501

    def gene_tax_name_query_with_http_info(self, taxon_query, **kwargs):  # noqa: E501
        """Get a list of taxonomy names and IDs found in the gene dataset given a partial taxonomic name.  # noqa: E501

        This endpoint retrieves a list of taxonomy names and IDs found in the gene dataset given a partial taxonomic name of any rank.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_tax_name_query_with_http_info(taxon_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon_query: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1SciNameAndIds, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'taxon_query'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_tax_name_query" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'taxon_query' is set
        if self.api_client.client_side_validation and ('taxon_query' not in local_var_params or  # noqa: E501
                                                        local_var_params['taxon_query'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `taxon_query` when calling `gene_tax_name_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'taxon_query' in local_var_params:
            path_params['taxon_query'] = local_var_params['taxon_query']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/taxon_suggest/{taxon_query}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1SciNameAndIds',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_tax_tree(self, taxon, **kwargs):  # noqa: E501
        """Retrieve tax tree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_tax_tree(taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1Organism
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_tax_tree_with_http_info(taxon, **kwargs)  # noqa: E501

    def gene_tax_tree_with_http_info(self, taxon, **kwargs):  # noqa: E501
        """Retrieve tax tree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_tax_tree_with_http_info(taxon, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1Organism, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'taxon'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_tax_tree" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'taxon' is set
        if self.api_client.client_side_validation and ('taxon' not in local_var_params or  # noqa: E501
                                                        local_var_params['taxon'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `taxon` when calling `gene_tax_tree`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'taxon' in local_var_params:
            path_params['taxon'] = local_var_params['taxon']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/taxon/{taxon}/tree', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Organism',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
