#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


                 #include "mpk_ffi.h"
                 

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // CVecReal()(float const *, size_t)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 20), // float const *
/*  2 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION, 137), // Config *()(FsConfig *, DbConfig *, JackConfig *)
/*  5 */ _CFFI_OP(_CFFI_OP_POINTER, 226), // FsConfig *
/*  6 */ _CFFI_OP(_CFFI_OP_POINTER, 225), // DbConfig *
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 227), // JackConfig *
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 137), // Config *()(char const *)
/* 10 */ _CFFI_OP(_CFFI_OP_POINTER, 236), // char const *
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // DbConfig *()(void)
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // FsConfig *()(char const *)
/* 15 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // JackConfig *()(void)
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 156), // LowlevelFeatures *()(float, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal)
/* 20 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13), // float
/* 21 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // CVecReal
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 23 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 24 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 25 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 26 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 27 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 28 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 29 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 30 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 31 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 32 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 34 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 35 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 36 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 37 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 38 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 39 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 40 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 41 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 43 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 44 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 45 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 46 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 47 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 48 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 50 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 51 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 52 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 53 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // Mdb *()(char const *)
/* 56 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION, 204), // MusicbrainzTags *()(char const *, char const *, char const *, char const *, char const *, char const *, char const *, char const *)
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 60 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 62 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 63 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 66 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION, 207), // RhythmFeatures *()(float, float, float, CVecReal, int16_t, float, float, int16_t, float, float, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal, CVecReal)
/* 69 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 70 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 71 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 72 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 73 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 19), // int16_t
/* 74 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 75 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 76 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 19),
/* 77 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 78 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 79 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 80 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 81 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 83 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 84 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION, 210), // SfxFeatures *()(float, float, float, float, CVecReal, CVecReal, CVecReal)
/* 87 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 88 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 89 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 90 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 92 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION, 213), // Spectograms *()(CVecReal, CVecReal, CVecReal)
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 97 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 98 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION, 216), // TonalFeatures *()(float, float, float, float, float, float, float, CVecReal, CVecReal, CVecReal, CVecReal, char const *, char const *, char const *, char const *, char const *)
/* 101 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 102 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 103 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 104 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 105 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 106 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 107 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 108 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 109 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 111 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 112 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 113 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 114 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 219), // TrackTags *()(char const *, char const *, char const *, char const *, int16_t)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 120 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 121 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 122 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 123 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 19),
/* 124 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION, 222), // char *()(FsConfig const *, char const *)
/* 126 */ _CFFI_OP(_CFFI_OP_POINTER, 226), // FsConfig const *
/* 127 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 128 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION, 237), // int()(DbConfig const *)
/* 130 */ _CFFI_OP(_CFFI_OP_POINTER, 225), // DbConfig const *
/* 131 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION, 170), // int64_t()(Mdb const *, char const *)
/* 133 */ _CFFI_OP(_CFFI_OP_POINTER, 229), // Mdb const *
/* 134 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Config *)
/* 137 */ _CFFI_OP(_CFFI_OP_POINTER, 224), // Config *
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Config const *)
/* 140 */ _CFFI_OP(_CFFI_OP_POINTER, 224), // Config const *
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Config const *, char const *)
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 140),
/* 144 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 145 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 146 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(DbConfig *)
/* 147 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(FsConfig *)
/* 150 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(JackConfig *)
/* 153 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(LowlevelFeatures *)
/* 156 */ _CFFI_OP(_CFFI_OP_POINTER, 228), // LowlevelFeatures *
/* 157 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 158 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Mdb *)
/* 159 */ _CFFI_OP(_CFFI_OP_POINTER, 229), // Mdb *
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Mdb const *)
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 133),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Mdb const *, char const *)
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 133),
/* 166 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Mdb const *, int64_t, LowlevelFeatures const *)
/* 169 */ _CFFI_OP(_CFFI_OP_NOOP, 133),
/* 170 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23), // int64_t
/* 171 */ _CFFI_OP(_CFFI_OP_POINTER, 228), // LowlevelFeatures const *
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 173 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Mdb const *, int64_t, MusicbrainzTags const *)
/* 174 */ _CFFI_OP(_CFFI_OP_NOOP, 133),
/* 175 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23),
/* 176 */ _CFFI_OP(_CFFI_OP_POINTER, 230), // MusicbrainzTags const *
/* 177 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 178 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Mdb const *, int64_t, RhythmFeatures const *)
/* 179 */ _CFFI_OP(_CFFI_OP_NOOP, 133),
/* 180 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23),
/* 181 */ _CFFI_OP(_CFFI_OP_POINTER, 231), // RhythmFeatures const *
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 183 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Mdb const *, int64_t, SfxFeatures const *)
/* 184 */ _CFFI_OP(_CFFI_OP_NOOP, 133),
/* 185 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23),
/* 186 */ _CFFI_OP(_CFFI_OP_POINTER, 232), // SfxFeatures const *
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Mdb const *, int64_t, Spectograms const *)
/* 189 */ _CFFI_OP(_CFFI_OP_NOOP, 133),
/* 190 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23),
/* 191 */ _CFFI_OP(_CFFI_OP_POINTER, 233), // Spectograms const *
/* 192 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Mdb const *, int64_t, TonalFeatures const *)
/* 194 */ _CFFI_OP(_CFFI_OP_NOOP, 133),
/* 195 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23),
/* 196 */ _CFFI_OP(_CFFI_OP_POINTER, 234), // TonalFeatures const *
/* 197 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 198 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Mdb const *, int64_t, TrackTags const *)
/* 199 */ _CFFI_OP(_CFFI_OP_NOOP, 133),
/* 200 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23),
/* 201 */ _CFFI_OP(_CFFI_OP_POINTER, 235), // TrackTags const *
/* 202 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 203 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(MusicbrainzTags *)
/* 204 */ _CFFI_OP(_CFFI_OP_POINTER, 230), // MusicbrainzTags *
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(RhythmFeatures *)
/* 207 */ _CFFI_OP(_CFFI_OP_POINTER, 231), // RhythmFeatures *
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(SfxFeatures *)
/* 210 */ _CFFI_OP(_CFFI_OP_POINTER, 232), // SfxFeatures *
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(Spectograms *)
/* 213 */ _CFFI_OP(_CFFI_OP_POINTER, 233), // Spectograms *
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(TonalFeatures *)
/* 216 */ _CFFI_OP(_CFFI_OP_POINTER, 234), // TonalFeatures *
/* 217 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 218 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(TrackTags *)
/* 219 */ _CFFI_OP(_CFFI_OP_POINTER, 235), // TrackTags *
/* 220 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 221 */ _CFFI_OP(_CFFI_OP_FUNCTION, 238), // void()(char *)
/* 222 */ _CFFI_OP(_CFFI_OP_POINTER, 236), // char *
/* 223 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 224 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // Config
/* 225 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // DbConfig
/* 226 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // FsConfig
/* 227 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // JackConfig
/* 228 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // LowlevelFeatures
/* 229 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // Mdb
/* 230 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // MusicbrainzTags
/* 231 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // RhythmFeatures
/* 232 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // SfxFeatures
/* 233 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // Spectograms
/* 234 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // TonalFeatures
/* 235 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // TrackTags
/* 236 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 237 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 238 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static void _cffi_d_mdb_exec_batch(Mdb const * x0, char const * x1)
{
  mdb_exec_batch(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_exec_batch(PyObject *self, PyObject *args)
{
  Mdb const * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "mdb_exec_batch", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(133), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Mdb const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(133), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_exec_batch(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_exec_batch _cffi_d_mdb_exec_batch
#endif

static void _cffi_d_mdb_free(Mdb * x0)
{
  mdb_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_free(PyObject *self, PyObject *arg0)
{
  Mdb * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Mdb *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_free _cffi_d_mdb_free
#endif

static void _cffi_d_mdb_init(Mdb const * x0)
{
  mdb_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_init(PyObject *self, PyObject *arg0)
{
  Mdb const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(133), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Mdb const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(133), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_init _cffi_d_mdb_init
#endif

static int64_t _cffi_d_mdb_insert_track(Mdb const * x0, char const * x1)
{
  return mdb_insert_track(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_insert_track(PyObject *self, PyObject *args)
{
  Mdb const * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "mdb_insert_track", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(133), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Mdb const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(133), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mdb_insert_track(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mdb_insert_track _cffi_d_mdb_insert_track
#endif

static void _cffi_d_mdb_insert_track_features_lowlevel(Mdb const * x0, int64_t x1, LowlevelFeatures const * x2)
{
  mdb_insert_track_features_lowlevel(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_insert_track_features_lowlevel(PyObject *self, PyObject *args)
{
  Mdb const * x0;
  int64_t x1;
  LowlevelFeatures const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mdb_insert_track_features_lowlevel", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(133), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Mdb const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(133), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int64_t);
  if (x1 == (int64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(171), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (LowlevelFeatures const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(171), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_insert_track_features_lowlevel(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_insert_track_features_lowlevel _cffi_d_mdb_insert_track_features_lowlevel
#endif

static void _cffi_d_mdb_insert_track_features_rhythm(Mdb const * x0, int64_t x1, RhythmFeatures const * x2)
{
  mdb_insert_track_features_rhythm(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_insert_track_features_rhythm(PyObject *self, PyObject *args)
{
  Mdb const * x0;
  int64_t x1;
  RhythmFeatures const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mdb_insert_track_features_rhythm", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(133), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Mdb const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(133), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int64_t);
  if (x1 == (int64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(181), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (RhythmFeatures const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(181), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_insert_track_features_rhythm(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_insert_track_features_rhythm _cffi_d_mdb_insert_track_features_rhythm
#endif

static void _cffi_d_mdb_insert_track_features_sfx(Mdb const * x0, int64_t x1, SfxFeatures const * x2)
{
  mdb_insert_track_features_sfx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_insert_track_features_sfx(PyObject *self, PyObject *args)
{
  Mdb const * x0;
  int64_t x1;
  SfxFeatures const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mdb_insert_track_features_sfx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(133), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Mdb const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(133), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int64_t);
  if (x1 == (int64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(186), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (SfxFeatures const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(186), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_insert_track_features_sfx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_insert_track_features_sfx _cffi_d_mdb_insert_track_features_sfx
#endif

static void _cffi_d_mdb_insert_track_features_tonal(Mdb const * x0, int64_t x1, TonalFeatures const * x2)
{
  mdb_insert_track_features_tonal(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_insert_track_features_tonal(PyObject *self, PyObject *args)
{
  Mdb const * x0;
  int64_t x1;
  TonalFeatures const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mdb_insert_track_features_tonal", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(133), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Mdb const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(133), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int64_t);
  if (x1 == (int64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(196), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TonalFeatures const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(196), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_insert_track_features_tonal(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_insert_track_features_tonal _cffi_d_mdb_insert_track_features_tonal
#endif

static void _cffi_d_mdb_insert_track_images(Mdb const * x0, int64_t x1, Spectograms const * x2)
{
  mdb_insert_track_images(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_insert_track_images(PyObject *self, PyObject *args)
{
  Mdb const * x0;
  int64_t x1;
  Spectograms const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mdb_insert_track_images", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(133), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Mdb const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(133), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int64_t);
  if (x1 == (int64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(191), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (Spectograms const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(191), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_insert_track_images(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_insert_track_images _cffi_d_mdb_insert_track_images
#endif

static void _cffi_d_mdb_insert_track_tags(Mdb const * x0, int64_t x1, TrackTags const * x2)
{
  mdb_insert_track_tags(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_insert_track_tags(PyObject *self, PyObject *args)
{
  Mdb const * x0;
  int64_t x1;
  TrackTags const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mdb_insert_track_tags", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(133), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Mdb const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(133), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int64_t);
  if (x1 == (int64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(201), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TrackTags const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(201), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_insert_track_tags(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_insert_track_tags _cffi_d_mdb_insert_track_tags
#endif

static void _cffi_d_mdb_insert_track_tags_musicbrainz(Mdb const * x0, int64_t x1, MusicbrainzTags const * x2)
{
  mdb_insert_track_tags_musicbrainz(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_insert_track_tags_musicbrainz(PyObject *self, PyObject *args)
{
  Mdb const * x0;
  int64_t x1;
  MusicbrainzTags const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mdb_insert_track_tags_musicbrainz", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(133), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Mdb const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(133), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int64_t);
  if (x1 == (int64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(176), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (MusicbrainzTags const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(176), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_insert_track_tags_musicbrainz(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_insert_track_tags_musicbrainz _cffi_d_mdb_insert_track_tags_musicbrainz
#endif

static void _cffi_d_mdb_lowlevel_features_free(LowlevelFeatures * x0)
{
  mdb_lowlevel_features_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_lowlevel_features_free(PyObject *self, PyObject *arg0)
{
  LowlevelFeatures * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(156), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (LowlevelFeatures *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(156), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_lowlevel_features_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_lowlevel_features_free _cffi_d_mdb_lowlevel_features_free
#endif

static LowlevelFeatures * _cffi_d_mdb_lowlevel_features_new(float x0, CVecReal x1, CVecReal x2, CVecReal x3, CVecReal x4, CVecReal x5, CVecReal x6, CVecReal x7, CVecReal x8, CVecReal x9, CVecReal x10, CVecReal x11, CVecReal x12, CVecReal x13, CVecReal x14, CVecReal x15, CVecReal x16, CVecReal x17, CVecReal x18, CVecReal x19, CVecReal x20, CVecReal x21, CVecReal x22, CVecReal x23, CVecReal x24, CVecReal x25, CVecReal x26, CVecReal x27, CVecReal x28, CVecReal x29, CVecReal x30, CVecReal x31, CVecReal x32, CVecReal x33)
{
  return mdb_lowlevel_features_new(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15, x16, x17, x18, x19, x20, x21, x22, x23, x24, x25, x26, x27, x28, x29, x30, x31, x32, x33);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_lowlevel_features_new(PyObject *self, PyObject *args)
{
  float x0;
  CVecReal x1;
  CVecReal x2;
  CVecReal x3;
  CVecReal x4;
  CVecReal x5;
  CVecReal x6;
  CVecReal x7;
  CVecReal x8;
  CVecReal x9;
  CVecReal x10;
  CVecReal x11;
  CVecReal x12;
  CVecReal x13;
  CVecReal x14;
  CVecReal x15;
  CVecReal x16;
  CVecReal x17;
  CVecReal x18;
  CVecReal x19;
  CVecReal x20;
  CVecReal x21;
  CVecReal x22;
  CVecReal x23;
  CVecReal x24;
  CVecReal x25;
  CVecReal x26;
  CVecReal x27;
  CVecReal x28;
  CVecReal x29;
  CVecReal x30;
  CVecReal x31;
  CVecReal x32;
  CVecReal x33;
  LowlevelFeatures * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;
  PyObject *arg11;
  PyObject *arg12;
  PyObject *arg13;
  PyObject *arg14;
  PyObject *arg15;
  PyObject *arg16;
  PyObject *arg17;
  PyObject *arg18;
  PyObject *arg19;
  PyObject *arg20;
  PyObject *arg21;
  PyObject *arg22;
  PyObject *arg23;
  PyObject *arg24;
  PyObject *arg25;
  PyObject *arg26;
  PyObject *arg27;
  PyObject *arg28;
  PyObject *arg29;
  PyObject *arg30;
  PyObject *arg31;
  PyObject *arg32;
  PyObject *arg33;

  if (!PyArg_UnpackTuple(args, "mdb_lowlevel_features_new", 34, 34, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10, &arg11, &arg12, &arg13, &arg14, &arg15, &arg16, &arg17, &arg18, &arg19, &arg20, &arg21, &arg22, &arg23, &arg24, &arg25, &arg26, &arg27, &arg28, &arg29, &arg30, &arg31, &arg32, &arg33))
    return NULL;

  x0 = (float)_cffi_to_c_float(arg0);
  if (x0 == (float)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(21), arg1) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(21), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(21), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(21), arg4) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(21), arg5) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x6, _cffi_type(21), arg6) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x7, _cffi_type(21), arg7) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x8, _cffi_type(21), arg8) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x9, _cffi_type(21), arg9) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x10, _cffi_type(21), arg10) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x11, _cffi_type(21), arg11) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x12, _cffi_type(21), arg12) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x13, _cffi_type(21), arg13) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x14, _cffi_type(21), arg14) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x15, _cffi_type(21), arg15) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x16, _cffi_type(21), arg16) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x17, _cffi_type(21), arg17) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x18, _cffi_type(21), arg18) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x19, _cffi_type(21), arg19) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x20, _cffi_type(21), arg20) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x21, _cffi_type(21), arg21) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x22, _cffi_type(21), arg22) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x23, _cffi_type(21), arg23) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x24, _cffi_type(21), arg24) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x25, _cffi_type(21), arg25) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x26, _cffi_type(21), arg26) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x27, _cffi_type(21), arg27) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x28, _cffi_type(21), arg28) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x29, _cffi_type(21), arg29) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x30, _cffi_type(21), arg30) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x31, _cffi_type(21), arg31) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x32, _cffi_type(21), arg32) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x33, _cffi_type(21), arg33) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mdb_lowlevel_features_new(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15, x16, x17, x18, x19, x20, x21, x22, x23, x24, x25, x26, x27, x28, x29, x30, x31, x32, x33); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(156));
  return pyresult;
}
#else
static LowlevelFeatures * _cffi_f_mdb_lowlevel_features_new(float x0, CVecReal *x1, CVecReal *x2, CVecReal *x3, CVecReal *x4, CVecReal *x5, CVecReal *x6, CVecReal *x7, CVecReal *x8, CVecReal *x9, CVecReal *x10, CVecReal *x11, CVecReal *x12, CVecReal *x13, CVecReal *x14, CVecReal *x15, CVecReal *x16, CVecReal *x17, CVecReal *x18, CVecReal *x19, CVecReal *x20, CVecReal *x21, CVecReal *x22, CVecReal *x23, CVecReal *x24, CVecReal *x25, CVecReal *x26, CVecReal *x27, CVecReal *x28, CVecReal *x29, CVecReal *x30, CVecReal *x31, CVecReal *x32, CVecReal *x33)
{
  LowlevelFeatures * result;
  { result = mdb_lowlevel_features_new(x0, *x1, *x2, *x3, *x4, *x5, *x6, *x7, *x8, *x9, *x10, *x11, *x12, *x13, *x14, *x15, *x16, *x17, *x18, *x19, *x20, *x21, *x22, *x23, *x24, *x25, *x26, *x27, *x28, *x29, *x30, *x31, *x32, *x33); }
  return result;
}
#endif

static void _cffi_d_mdb_musicbrainz_tags_free(MusicbrainzTags * x0)
{
  mdb_musicbrainz_tags_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_musicbrainz_tags_free(PyObject *self, PyObject *arg0)
{
  MusicbrainzTags * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(204), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (MusicbrainzTags *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(204), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_musicbrainz_tags_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_musicbrainz_tags_free _cffi_d_mdb_musicbrainz_tags_free
#endif

static MusicbrainzTags * _cffi_d_mdb_musicbrainz_tags_new(char const * x0, char const * x1, char const * x2, char const * x3, char const * x4, char const * x5, char const * x6, char const * x7)
{
  return mdb_musicbrainz_tags_new(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_musicbrainz_tags_new(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  char const * x4;
  char const * x5;
  char const * x6;
  char const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  MusicbrainzTags * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "mdb_musicbrainz_tags_new", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mdb_musicbrainz_tags_new(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(204));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mdb_musicbrainz_tags_new _cffi_d_mdb_musicbrainz_tags_new
#endif

static Mdb * _cffi_d_mdb_new(char const * x0)
{
  return mdb_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_new(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Mdb * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mdb_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mdb_new _cffi_d_mdb_new
#endif

static void _cffi_d_mdb_rhythm_features_free(RhythmFeatures * x0)
{
  mdb_rhythm_features_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_rhythm_features_free(PyObject *self, PyObject *arg0)
{
  RhythmFeatures * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (RhythmFeatures *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_rhythm_features_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_rhythm_features_free _cffi_d_mdb_rhythm_features_free
#endif

static RhythmFeatures * _cffi_d_mdb_rhythm_features_new(float x0, float x1, float x2, CVecReal x3, int16_t x4, float x5, float x6, int16_t x7, float x8, float x9, CVecReal x10, CVecReal x11, CVecReal x12, CVecReal x13, CVecReal x14, CVecReal x15)
{
  return mdb_rhythm_features_new(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_rhythm_features_new(PyObject *self, PyObject *args)
{
  float x0;
  float x1;
  float x2;
  CVecReal x3;
  int16_t x4;
  float x5;
  float x6;
  int16_t x7;
  float x8;
  float x9;
  CVecReal x10;
  CVecReal x11;
  CVecReal x12;
  CVecReal x13;
  CVecReal x14;
  CVecReal x15;
  RhythmFeatures * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;
  PyObject *arg11;
  PyObject *arg12;
  PyObject *arg13;
  PyObject *arg14;
  PyObject *arg15;

  if (!PyArg_UnpackTuple(args, "mdb_rhythm_features_new", 16, 16, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10, &arg11, &arg12, &arg13, &arg14, &arg15))
    return NULL;

  x0 = (float)_cffi_to_c_float(arg0);
  if (x0 == (float)-1 && PyErr_Occurred())
    return NULL;

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  x2 = (float)_cffi_to_c_float(arg2);
  if (x2 == (float)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(21), arg3) < 0)
    return NULL;

  x4 = _cffi_to_c_int(arg4, int16_t);
  if (x4 == (int16_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = (float)_cffi_to_c_float(arg5);
  if (x5 == (float)-1 && PyErr_Occurred())
    return NULL;

  x6 = (float)_cffi_to_c_float(arg6);
  if (x6 == (float)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, int16_t);
  if (x7 == (int16_t)-1 && PyErr_Occurred())
    return NULL;

  x8 = (float)_cffi_to_c_float(arg8);
  if (x8 == (float)-1 && PyErr_Occurred())
    return NULL;

  x9 = (float)_cffi_to_c_float(arg9);
  if (x9 == (float)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x10, _cffi_type(21), arg10) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x11, _cffi_type(21), arg11) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x12, _cffi_type(21), arg12) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x13, _cffi_type(21), arg13) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x14, _cffi_type(21), arg14) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x15, _cffi_type(21), arg15) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mdb_rhythm_features_new(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(207));
  return pyresult;
}
#else
static RhythmFeatures * _cffi_f_mdb_rhythm_features_new(float x0, float x1, float x2, CVecReal *x3, int16_t x4, float x5, float x6, int16_t x7, float x8, float x9, CVecReal *x10, CVecReal *x11, CVecReal *x12, CVecReal *x13, CVecReal *x14, CVecReal *x15)
{
  RhythmFeatures * result;
  { result = mdb_rhythm_features_new(x0, x1, x2, *x3, x4, x5, x6, x7, x8, x9, *x10, *x11, *x12, *x13, *x14, *x15); }
  return result;
}
#endif

static void _cffi_d_mdb_sfx_features_free(SfxFeatures * x0)
{
  mdb_sfx_features_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_sfx_features_free(PyObject *self, PyObject *arg0)
{
  SfxFeatures * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(210), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SfxFeatures *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(210), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_sfx_features_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_sfx_features_free _cffi_d_mdb_sfx_features_free
#endif

static SfxFeatures * _cffi_d_mdb_sfx_features_new(float x0, float x1, float x2, float x3, CVecReal x4, CVecReal x5, CVecReal x6)
{
  return mdb_sfx_features_new(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_sfx_features_new(PyObject *self, PyObject *args)
{
  float x0;
  float x1;
  float x2;
  float x3;
  CVecReal x4;
  CVecReal x5;
  CVecReal x6;
  SfxFeatures * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "mdb_sfx_features_new", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  x0 = (float)_cffi_to_c_float(arg0);
  if (x0 == (float)-1 && PyErr_Occurred())
    return NULL;

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  x2 = (float)_cffi_to_c_float(arg2);
  if (x2 == (float)-1 && PyErr_Occurred())
    return NULL;

  x3 = (float)_cffi_to_c_float(arg3);
  if (x3 == (float)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(21), arg4) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(21), arg5) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x6, _cffi_type(21), arg6) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mdb_sfx_features_new(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(210));
  return pyresult;
}
#else
static SfxFeatures * _cffi_f_mdb_sfx_features_new(float x0, float x1, float x2, float x3, CVecReal *x4, CVecReal *x5, CVecReal *x6)
{
  SfxFeatures * result;
  { result = mdb_sfx_features_new(x0, x1, x2, x3, *x4, *x5, *x6); }
  return result;
}
#endif

static void _cffi_d_mdb_spectograms_free(Spectograms * x0)
{
  mdb_spectograms_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_spectograms_free(PyObject *self, PyObject *arg0)
{
  Spectograms * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(213), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Spectograms *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(213), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_spectograms_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_spectograms_free _cffi_d_mdb_spectograms_free
#endif

static Spectograms * _cffi_d_mdb_spectograms_new(CVecReal x0, CVecReal x1, CVecReal x2)
{
  return mdb_spectograms_new(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_spectograms_new(PyObject *self, PyObject *args)
{
  CVecReal x0;
  CVecReal x1;
  CVecReal x2;
  Spectograms * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mdb_spectograms_new", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(21), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(21), arg1) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(21), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mdb_spectograms_new(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(213));
  return pyresult;
}
#else
static Spectograms * _cffi_f_mdb_spectograms_new(CVecReal *x0, CVecReal *x1, CVecReal *x2)
{
  Spectograms * result;
  { result = mdb_spectograms_new(*x0, *x1, *x2); }
  return result;
}
#endif

static void _cffi_d_mdb_tonal_features_free(TonalFeatures * x0)
{
  mdb_tonal_features_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_tonal_features_free(PyObject *self, PyObject *arg0)
{
  TonalFeatures * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(216), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (TonalFeatures *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(216), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_tonal_features_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_tonal_features_free _cffi_d_mdb_tonal_features_free
#endif

static TonalFeatures * _cffi_d_mdb_tonal_features_new(float x0, float x1, float x2, float x3, float x4, float x5, float x6, CVecReal x7, CVecReal x8, CVecReal x9, CVecReal x10, char const * x11, char const * x12, char const * x13, char const * x14, char const * x15)
{
  return mdb_tonal_features_new(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_tonal_features_new(PyObject *self, PyObject *args)
{
  float x0;
  float x1;
  float x2;
  float x3;
  float x4;
  float x5;
  float x6;
  CVecReal x7;
  CVecReal x8;
  CVecReal x9;
  CVecReal x10;
  char const * x11;
  char const * x12;
  char const * x13;
  char const * x14;
  char const * x15;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  TonalFeatures * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;
  PyObject *arg11;
  PyObject *arg12;
  PyObject *arg13;
  PyObject *arg14;
  PyObject *arg15;

  if (!PyArg_UnpackTuple(args, "mdb_tonal_features_new", 16, 16, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10, &arg11, &arg12, &arg13, &arg14, &arg15))
    return NULL;

  x0 = (float)_cffi_to_c_float(arg0);
  if (x0 == (float)-1 && PyErr_Occurred())
    return NULL;

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  x2 = (float)_cffi_to_c_float(arg2);
  if (x2 == (float)-1 && PyErr_Occurred())
    return NULL;

  x3 = (float)_cffi_to_c_float(arg3);
  if (x3 == (float)-1 && PyErr_Occurred())
    return NULL;

  x4 = (float)_cffi_to_c_float(arg4);
  if (x4 == (float)-1 && PyErr_Occurred())
    return NULL;

  x5 = (float)_cffi_to_c_float(arg5);
  if (x5 == (float)-1 && PyErr_Occurred())
    return NULL;

  x6 = (float)_cffi_to_c_float(arg6);
  if (x6 == (float)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x7, _cffi_type(21), arg7) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x8, _cffi_type(21), arg8) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x9, _cffi_type(21), arg9) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x10, _cffi_type(21), arg10) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg11, (char **)&x11);
  if (datasize != 0) {
    x11 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg11, (char **)&x11,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg12, (char **)&x12);
  if (datasize != 0) {
    x12 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg12, (char **)&x12,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg13, (char **)&x13);
  if (datasize != 0) {
    x13 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg13, (char **)&x13,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg14, (char **)&x14);
  if (datasize != 0) {
    x14 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg14, (char **)&x14,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg15, (char **)&x15);
  if (datasize != 0) {
    x15 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg15, (char **)&x15,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mdb_tonal_features_new(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(216));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static TonalFeatures * _cffi_f_mdb_tonal_features_new(float x0, float x1, float x2, float x3, float x4, float x5, float x6, CVecReal *x7, CVecReal *x8, CVecReal *x9, CVecReal *x10, char const * x11, char const * x12, char const * x13, char const * x14, char const * x15)
{
  TonalFeatures * result;
  { result = mdb_tonal_features_new(x0, x1, x2, x3, x4, x5, x6, *x7, *x8, *x9, *x10, x11, x12, x13, x14, x15); }
  return result;
}
#endif

static void _cffi_d_mdb_track_tags_free(TrackTags * x0)
{
  mdb_track_tags_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_track_tags_free(PyObject *self, PyObject *arg0)
{
  TrackTags * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(219), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (TrackTags *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(219), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mdb_track_tags_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mdb_track_tags_free _cffi_d_mdb_track_tags_free
#endif

static TrackTags * _cffi_d_mdb_track_tags_new(char const * x0, char const * x1, char const * x2, char const * x3, int16_t x4)
{
  return mdb_track_tags_new(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_track_tags_new(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  int16_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  TrackTags * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "mdb_track_tags_new", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int16_t);
  if (x4 == (int16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mdb_track_tags_new(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(219));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mdb_track_tags_new _cffi_d_mdb_track_tags_new
#endif

static CVecReal _cffi_d_mdb_vecreal_new(float const * x0, size_t x1)
{
  return mdb_vecreal_new(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mdb_vecreal_new(PyObject *self, PyObject *args)
{
  float const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  CVecReal result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "mdb_vecreal_new", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mdb_vecreal_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(21));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static void _cffi_f_mdb_vecreal_new(CVecReal *result, float const * x0, size_t x1)
{
  { *result = mdb_vecreal_new(x0, x1); }
}
#endif

static void _cffi_d_mpk_config_build(Config const * x0)
{
  mpk_config_build(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_config_build(PyObject *self, PyObject *arg0)
{
  Config const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(140), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Config const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(140), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mpk_config_build(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mpk_config_build _cffi_d_mpk_config_build
#endif

static void _cffi_d_mpk_config_free(Config * x0)
{
  mpk_config_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_config_free(PyObject *self, PyObject *arg0)
{
  Config * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Config *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mpk_config_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mpk_config_free _cffi_d_mpk_config_free
#endif

static Config * _cffi_d_mpk_config_load(char const * x0)
{
  return mpk_config_load(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_config_load(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Config * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mpk_config_load(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(137));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mpk_config_load _cffi_d_mpk_config_load
#endif

static Config * _cffi_d_mpk_config_new(FsConfig * x0, DbConfig * x1, JackConfig * x2)
{
  return mpk_config_new(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_config_new(PyObject *self, PyObject *args)
{
  FsConfig * x0;
  DbConfig * x1;
  JackConfig * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Config * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mpk_config_new", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (FsConfig *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (DbConfig *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (JackConfig *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mpk_config_new(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(137));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mpk_config_new _cffi_d_mpk_config_new
#endif

static void _cffi_d_mpk_config_write(Config const * x0, char const * x1)
{
  mpk_config_write(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_config_write(PyObject *self, PyObject *args)
{
  Config const * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "mpk_config_write", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(140), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Config const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(140), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mpk_config_write(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mpk_config_write _cffi_d_mpk_config_write
#endif

static int _cffi_d_mpk_db_config_flags(DbConfig const * x0)
{
  return mpk_db_config_flags(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_db_config_flags(PyObject *self, PyObject *arg0)
{
  DbConfig const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (DbConfig const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mpk_db_config_flags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mpk_db_config_flags _cffi_d_mpk_db_config_flags
#endif

static void _cffi_d_mpk_db_config_free(DbConfig * x0)
{
  mpk_db_config_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_db_config_free(PyObject *self, PyObject *arg0)
{
  DbConfig * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (DbConfig *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mpk_db_config_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mpk_db_config_free _cffi_d_mpk_db_config_free
#endif

static DbConfig * _cffi_d_mpk_db_config_new(void)
{
  return mpk_db_config_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_db_config_new(PyObject *self, PyObject *noarg)
{
  DbConfig * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mpk_db_config_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(6));
  return pyresult;
}
#else
#  define _cffi_f_mpk_db_config_new _cffi_d_mpk_db_config_new
#endif

static void _cffi_d_mpk_fs_config_free(FsConfig * x0)
{
  mpk_fs_config_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_fs_config_free(PyObject *self, PyObject *arg0)
{
  FsConfig * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (FsConfig *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mpk_fs_config_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mpk_fs_config_free _cffi_d_mpk_fs_config_free
#endif

static char * _cffi_d_mpk_fs_config_get_path(FsConfig const * x0, char const * x1)
{
  return mpk_fs_config_get_path(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_fs_config_get_path(PyObject *self, PyObject *args)
{
  FsConfig const * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "mpk_fs_config_get_path", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (FsConfig const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(126), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mpk_fs_config_get_path(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(222));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mpk_fs_config_get_path _cffi_d_mpk_fs_config_get_path
#endif

static FsConfig * _cffi_d_mpk_fs_config_new(char const * x0)
{
  return mpk_fs_config_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_fs_config_new(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  FsConfig * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mpk_fs_config_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(5));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mpk_fs_config_new _cffi_d_mpk_fs_config_new
#endif

static void _cffi_d_mpk_jack_config_free(JackConfig * x0)
{
  mpk_jack_config_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_jack_config_free(PyObject *self, PyObject *arg0)
{
  JackConfig * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (JackConfig *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mpk_jack_config_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mpk_jack_config_free _cffi_d_mpk_jack_config_free
#endif

static JackConfig * _cffi_d_mpk_jack_config_new(void)
{
  return mpk_jack_config_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_jack_config_new(PyObject *self, PyObject *noarg)
{
  JackConfig * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mpk_jack_config_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(7));
  return pyresult;
}
#else
#  define _cffi_f_mpk_jack_config_new _cffi_d_mpk_jack_config_new
#endif

static void _cffi_d_mpk_string_free(char * x0)
{
  mpk_string_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mpk_string_free(PyObject *self, PyObject *arg0)
{
  char * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(222), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(222), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mpk_string_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mpk_string_free _cffi_d_mpk_string_free
#endif

_CFFI_UNUSED_FN
static void _cffi_checkfld__CVecReal(CVecReal *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { float const * *tmp = &p->ptr; (void)tmp; }
  (void)((p->len) | 0);  /* check that 'CVecReal.len' is an integer */
}
struct _cffi_align__CVecReal { char x; CVecReal y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "mdb_exec_batch", (void *)_cffi_f_mdb_exec_batch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 164), (void *)_cffi_d_mdb_exec_batch },
  { "mdb_free", (void *)_cffi_f_mdb_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 158), (void *)_cffi_d_mdb_free },
  { "mdb_init", (void *)_cffi_f_mdb_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 161), (void *)_cffi_d_mdb_init },
  { "mdb_insert_track", (void *)_cffi_f_mdb_insert_track, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 132), (void *)_cffi_d_mdb_insert_track },
  { "mdb_insert_track_features_lowlevel", (void *)_cffi_f_mdb_insert_track_features_lowlevel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 168), (void *)_cffi_d_mdb_insert_track_features_lowlevel },
  { "mdb_insert_track_features_rhythm", (void *)_cffi_f_mdb_insert_track_features_rhythm, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 178), (void *)_cffi_d_mdb_insert_track_features_rhythm },
  { "mdb_insert_track_features_sfx", (void *)_cffi_f_mdb_insert_track_features_sfx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 183), (void *)_cffi_d_mdb_insert_track_features_sfx },
  { "mdb_insert_track_features_tonal", (void *)_cffi_f_mdb_insert_track_features_tonal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 193), (void *)_cffi_d_mdb_insert_track_features_tonal },
  { "mdb_insert_track_images", (void *)_cffi_f_mdb_insert_track_images, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 188), (void *)_cffi_d_mdb_insert_track_images },
  { "mdb_insert_track_tags", (void *)_cffi_f_mdb_insert_track_tags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 198), (void *)_cffi_d_mdb_insert_track_tags },
  { "mdb_insert_track_tags_musicbrainz", (void *)_cffi_f_mdb_insert_track_tags_musicbrainz, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 173), (void *)_cffi_d_mdb_insert_track_tags_musicbrainz },
  { "mdb_lowlevel_features_free", (void *)_cffi_f_mdb_lowlevel_features_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 155), (void *)_cffi_d_mdb_lowlevel_features_free },
  { "mdb_lowlevel_features_new", (void *)_cffi_f_mdb_lowlevel_features_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 19), (void *)_cffi_d_mdb_lowlevel_features_new },
  { "mdb_musicbrainz_tags_free", (void *)_cffi_f_mdb_musicbrainz_tags_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 203), (void *)_cffi_d_mdb_musicbrainz_tags_free },
  { "mdb_musicbrainz_tags_new", (void *)_cffi_f_mdb_musicbrainz_tags_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 58), (void *)_cffi_d_mdb_musicbrainz_tags_new },
  { "mdb_new", (void *)_cffi_f_mdb_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 55), (void *)_cffi_d_mdb_new },
  { "mdb_rhythm_features_free", (void *)_cffi_f_mdb_rhythm_features_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 206), (void *)_cffi_d_mdb_rhythm_features_free },
  { "mdb_rhythm_features_new", (void *)_cffi_f_mdb_rhythm_features_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 68), (void *)_cffi_d_mdb_rhythm_features_new },
  { "mdb_sfx_features_free", (void *)_cffi_f_mdb_sfx_features_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 209), (void *)_cffi_d_mdb_sfx_features_free },
  { "mdb_sfx_features_new", (void *)_cffi_f_mdb_sfx_features_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 86), (void *)_cffi_d_mdb_sfx_features_new },
  { "mdb_spectograms_free", (void *)_cffi_f_mdb_spectograms_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 212), (void *)_cffi_d_mdb_spectograms_free },
  { "mdb_spectograms_new", (void *)_cffi_f_mdb_spectograms_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 95), (void *)_cffi_d_mdb_spectograms_new },
  { "mdb_tonal_features_free", (void *)_cffi_f_mdb_tonal_features_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 215), (void *)_cffi_d_mdb_tonal_features_free },
  { "mdb_tonal_features_new", (void *)_cffi_f_mdb_tonal_features_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 100), (void *)_cffi_d_mdb_tonal_features_new },
  { "mdb_track_tags_free", (void *)_cffi_f_mdb_track_tags_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 218), (void *)_cffi_d_mdb_track_tags_free },
  { "mdb_track_tags_new", (void *)_cffi_f_mdb_track_tags_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_mdb_track_tags_new },
  { "mdb_vecreal_new", (void *)_cffi_f_mdb_vecreal_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_mdb_vecreal_new },
  { "mpk_config_build", (void *)_cffi_f_mpk_config_build, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 139), (void *)_cffi_d_mpk_config_build },
  { "mpk_config_free", (void *)_cffi_f_mpk_config_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 136), (void *)_cffi_d_mpk_config_free },
  { "mpk_config_load", (void *)_cffi_f_mpk_config_load, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 9), (void *)_cffi_d_mpk_config_load },
  { "mpk_config_new", (void *)_cffi_f_mpk_config_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 4), (void *)_cffi_d_mpk_config_new },
  { "mpk_config_write", (void *)_cffi_f_mpk_config_write, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 142), (void *)_cffi_d_mpk_config_write },
  { "mpk_db_config_flags", (void *)_cffi_f_mpk_db_config_flags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 129), (void *)_cffi_d_mpk_db_config_flags },
  { "mpk_db_config_free", (void *)_cffi_f_mpk_db_config_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 146), (void *)_cffi_d_mpk_db_config_free },
  { "mpk_db_config_new", (void *)_cffi_f_mpk_db_config_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 12), (void *)_cffi_d_mpk_db_config_new },
  { "mpk_fs_config_free", (void *)_cffi_f_mpk_fs_config_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_mpk_fs_config_free },
  { "mpk_fs_config_get_path", (void *)_cffi_f_mpk_fs_config_get_path, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 125), (void *)_cffi_d_mpk_fs_config_get_path },
  { "mpk_fs_config_new", (void *)_cffi_f_mpk_fs_config_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 14), (void *)_cffi_d_mpk_fs_config_new },
  { "mpk_jack_config_free", (void *)_cffi_f_mpk_jack_config_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 152), (void *)_cffi_d_mpk_jack_config_free },
  { "mpk_jack_config_new", (void *)_cffi_f_mpk_jack_config_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 17), (void *)_cffi_d_mpk_jack_config_new },
  { "mpk_string_free", (void *)_cffi_f_mpk_string_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 221), (void *)_cffi_d_mpk_string_free },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "ptr", offsetof(CVecReal, ptr),
           sizeof(((CVecReal *)0)->ptr),
           _CFFI_OP(_CFFI_OP_NOOP, 1) },
  { "len", offsetof(CVecReal, len),
           sizeof(((CVecReal *)0)->len),
           _CFFI_OP(_CFFI_OP_NOOP, 2) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "CVecReal", 21, _CFFI_F_CHECK_FIELDS,
    sizeof(CVecReal), offsetof(struct _cffi_align__CVecReal, y), 0, 2 },
  { "Config", 224, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "DbConfig", 225, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "FsConfig", 226, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "JackConfig", 227, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "LowlevelFeatures", 228, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "Mdb", 229, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "MusicbrainzTags", 230, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "RhythmFeatures", 231, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "SfxFeatures", 232, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "Spectograms", 233, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "TonalFeatures", 234, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "TrackTags", 235, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "CVecReal", 21 },
  { "Config", 224 },
  { "DbConfig", 225 },
  { "FsConfig", 226 },
  { "JackConfig", 227 },
  { "LowlevelFeatures", 228 },
  { "Mdb", 229 },
  { "MusicbrainzTags", 230 },
  { "RhythmFeatures", 231 },
  { "SfxFeatures", 232 },
  { "Spectograms", 233 },
  { "TonalFeatures", 234 },
  { "TrackTags", 235 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  NULL,  /* no enums */
  _cffi_typenames,
  41,  /* num_globals */
  13,  /* num_struct_unions */
  0,  /* num_enums */
  13,  /* num_typenames */
  NULL,  /* no includes */
  239,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__mpk(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__mpk(void) { return NULL; }
#  else
     init_mpk(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__mpk(void)
{
  return _cffi_init("_mpk", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_mpk(void)
{
  _cffi_init("_mpk", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
