# Generated by Django 2.2.13 on 2020-06-18 08:18

from django.db import migrations
from django.conf import settings


def rename_existed_playbook(apps, schema_editor):
    Task = apps.get_registered_model('main', 'Task')
    prj_path = settings.PROJECTS_DIR
    for task in Task.objects.filter(name__contains=prj_path, playbook__contains=prj_path):
        task.name = task.name.replace(f"{prj_path}/{task.project.id}/", "")
        task.playbook = task.playbook.replace(f"{prj_path}/{task.project.id}/", "")
        task.save()


class Migration(migrations.Migration):

    dependencies = [
        ('main', '0007_auto_20200615_0402'),
    ]

    operations = [
        migrations.RunPython(
            code=rename_existed_playbook,
            reverse_code=migrations.RunPython.noop
        ),
    ]
