# Generated by Django 3.2.16 on 2023-02-06 04:35

import uuid
from django.db import migrations, models
import django.db.models.deletion
import vstutils.models.fields


class Migration(migrations.Migration):

    dependencies = [
        ('main', '0001_v3'),
    ]

    operations = [
        migrations.CreateModel(
            name='ExecutionTemplate',
            fields=[
                ('id', models.BigAutoField(db_index=True, primary_key=True, serialize=False)),
                ('name', models.CharField(db_index=True, max_length=255)),
                ('plugin', models.CharField(db_index=True, max_length=128)),
                ('notes', models.TextField(default='')),
                ('project', vstutils.models.fields.FkModelField(on_delete=django.db.models.deletion.CASCADE, related_name='execution_templates', to='main.project')),
                ('old_template_id', models.BigIntegerField(null=True)),
            ],
            options={
                'default_related_name': 'execution_templates',
            },
        ),
        migrations.CreateModel(
            name='ExecutionTemplateOption',
            fields=[
                ('id', models.UUIDField(db_index=True, default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(db_index=True, max_length=255)),
                ('notes', models.TextField(default='')),
                ('arguments', models.JSONField(default=dict)),
                ('template', vstutils.models.fields.FkModelField(on_delete=django.db.models.deletion.CASCADE, related_name='options', to='main.executiontemplate')),
            ],
            options={
                'default_related_name': 'execution_template_options',
            },
        ),
        migrations.CreateModel(
            name='TemplatePeriodicTask',
            fields=[
                ('id', models.AutoField(db_index=True, primary_key=True, serialize=False)),
                ('name', models.CharField(db_index=True, max_length=255)),
                ('notes', models.TextField(default='')),
                ('type', models.CharField(max_length=10)),
                ('schedule', models.CharField(max_length=512)),
                ('enabled', models.BooleanField(default=False)),
                ('save_result', models.BooleanField(default=False)),
                ('template_option', vstutils.models.fields.FkModelField(on_delete=django.db.models.deletion.CASCADE, related_name='periodic_tasks', to='main.executiontemplateoption')),
            ],
            options={
                'default_related_name': 'execution_template_option_schedules',
            },
        ),
        migrations.AddField(
            model_name='template',
            name='new_template_id',
            field=models.BigIntegerField(null=True),
        ),
    ]
