# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-06-26 04:33
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
from django.contrib.auth.hashers import make_password
import django.utils.timezone
from ..models.base import (
    first_staff_user, ManyToManyFieldACL, ForeignKeyACL,
    ManyToManyFieldACLReverse
)
import uuid


def create_admin_user(apps, schema_editor):
    User = apps.get_registered_model('auth', 'User')
    admin = User(
        username='admin',
        email='admin@domain.com',
        password=make_password('admin'),
        is_superuser=True,
        is_staff=True
    )
    admin.save()


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('auth', '0008_alter_user_username_max_length'),
        ('auth', '0006_require_contenttypes_0002'),
    ]

    operations = [
        migrations.RunPython(
            code=create_admin_user,
            reverse_code=migrations.RunPython.noop
        ),
        migrations.CreateModel(
            name='ACLPermission',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('role', models.CharField(max_length=10)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('name', models.CharField(default=uuid.uuid1, max_length=512)),
                ('children', models.BooleanField(default=False)),
                ('acl',
                 models.ManyToManyField(blank=True, null=True, related_name='groups',
                                        to='main.ACLPermission')),
            ],
            options={
                'default_related_name': 'groups',
            },
        ),
        migrations.CreateModel(
            name='History',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('mode', models.CharField(max_length=256)),
                ('revision', models.CharField(blank=True, max_length=256, null=True)),
                ('kind', models.CharField(default='PLAYBOOK', max_length=50)),
                ('start_time', models.DateTimeField(default=django.utils.timezone.now)),
                ('stop_time', models.DateTimeField(blank=True, null=True)),
                ('raw_args', models.TextField(default='')),
                ('json_args', models.TextField(default='{}')),
                ('raw_inventory', models.TextField(default='')),
                ('status', models.CharField(max_length=50)),
                ('initiator', models.IntegerField(default=0)),
                ('initiator_type', models.CharField(default='project', max_length=50)),
                ('json_options', models.TextField(default='{}')),
                ('executor', models.ForeignKey(blank=True, default=None, null=True,
                                               on_delete=django.db.models.deletion.CASCADE,
                                               related_name='history',
                                               to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'default_related_name': 'history',
                'ordering': ['-start_time'],
            },
        ),
        migrations.CreateModel(
            name='HistoryLines',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('line', models.CharField(default='', max_length=2048)),
                ('line_number', models.IntegerField(default=0)),
                ('line_gnumber', models.IntegerField(default=0)),
                ('history',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                   related_name='raw_history_line',
                                   related_query_name='raw_history_line',
                                   to='main.History')),
            ],
            options={
                'default_related_name': 'raw_history_line',
                'ordering': ['-line_gnumber', '-line_number'],
            },
        ),
        migrations.CreateModel(
            name='Hook',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('name', models.CharField(default=uuid.uuid1, max_length=512)),
                ('type', models.CharField(max_length=32)),
                ('when', models.CharField(default=None, max_length=32, null=True)),
                ('enable', models.BooleanField(default=True)),
                ('recipients', models.CharField(max_length=4096)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Host',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('name', models.CharField(default=uuid.uuid1, max_length=512)),
                ('type', models.CharField(default='HOST', max_length=5)),
                ('acl',
                 models.ManyToManyField(blank=True, null=True, related_name='hosts',
                                        to='main.ACLPermission')),
                ('owner',
                 models.ForeignKey(default=first_staff_user,
                                   on_delete=django.db.models.deletion.CASCADE,
                                   related_name='polemarch_host_set',
                                   to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'default_related_name': 'hosts',
            },
        ),
        migrations.CreateModel(
            name='Inventory',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('name', models.CharField(default=uuid.uuid1, max_length=512)),
                ('acl', models.ManyToManyField(blank=True, null=True,
                                               related_name='inventories',
                                               to='main.ACLPermission')),
                ('groups', ManyToManyFieldACL(
                    related_name='inventories', to='main.Group')),
                ('hosts', ManyToManyFieldACL(
                    related_name='inventories', to='main.Host')),
                ('owner',
                 models.ForeignKey(default=first_staff_user,
                                   on_delete=django.db.models.deletion.CASCADE,
                                   related_name='polemarch_inventory_set',
                                   to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'default_related_name': 'inventories',
            },
        ),
        migrations.CreateModel(
            name='PeriodicTask',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('name', models.CharField(default=uuid.uuid1, max_length=512)),
                ('mode', models.CharField(max_length=256)),
                ('kind', models.CharField(default='PLAYBOOK', max_length=50)),
                ('inventory_file',
                 models.CharField(blank=True, max_length=2048, null=True)),
                ('schedule', models.CharField(max_length=4096)),
                ('type', models.CharField(max_length=10)),
                ('save_result', models.BooleanField(default=True)),
                ('enabled', models.BooleanField(default=True)),
                (
                    'template_opt',
                    models.CharField(blank=True, max_length=256, null=True)),
                ('_inventory', models.ForeignKey(blank=True, null=True,
                                                 on_delete=django.db.models.deletion.CASCADE,
                                                 related_name='periodic_tasks',
                                                 related_query_name='periodic_tasks',
                                                 to='main.Inventory')),
                ('acl', models.ManyToManyField(blank=True, null=True,
                                               related_name='periodic_tasks',
                                               to='main.ACLPermission')),
                ('owner',
                 models.ForeignKey(default=first_staff_user,
                                   on_delete=django.db.models.deletion.CASCADE,
                                   related_name='polemarch_periodictask_set',
                                   to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'default_related_name': 'periodic_tasks',
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('name', models.CharField(default=uuid.uuid1, max_length=512)),
                ('repository', models.CharField(max_length=2048)),
                ('status', models.CharField(default='NEW', max_length=32)),
                ('acl',
                 models.ManyToManyField(blank=True, null=True, related_name='projects',
                                        to='main.ACLPermission')),
                ('groups',
                 ManyToManyFieldACL(blank=True, null=True,
                                    related_name='projects',
                                    to='main.Group')),
                ('hosts',
                 ManyToManyFieldACL(blank=True, null=True,
                                    related_name='projects',
                                    to='main.Host')),
                ('inventories',
                 ManyToManyFieldACL(blank=True, null=True,
                                    related_name='projects',
                                    to='main.Inventory')),
                ('owner',
                 models.ForeignKey(default=first_staff_user,
                                   on_delete=django.db.models.deletion.CASCADE,
                                   related_name='polemarch_project_set',
                                   to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'default_related_name': 'projects',
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('name', models.CharField(default=uuid.uuid1, max_length=256)),
                ('playbook', models.CharField(max_length=256)),
                ('project',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                   related_name='tasks', related_query_name='tasks',
                                   to='main.Project')),
            ],
            options={
                'default_related_name': 'tasks',
            },
        ),
        migrations.CreateModel(
            name='Template',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('name', models.CharField(max_length=512)),
                ('kind', models.CharField(max_length=32)),
                ('template_data', models.TextField(default='{}')),
                ('options_data', models.TextField(default='{}')),
                ('inventory',
                 models.CharField(blank=True, default=None, max_length=128, null=True)),
                ('acl',
                 models.ManyToManyField(blank=True, null=True, to='main.ACLPermission')),
                ('owner',
                 models.ForeignKey(default=first_staff_user,
                                   on_delete=django.db.models.deletion.CASCADE,
                                   related_name='polemarch_template_set',
                                   to=settings.AUTH_USER_MODEL)),
                ('project',
                 ForeignKeyACL(blank=True, default=None,
                               null=True,
                               on_delete=django.db.models.deletion.SET_NULL,
                               to='main.Project')),
            ],
        ),
        migrations.CreateModel(
            name='UserGroup',
            fields=[
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('parent',
                 models.OneToOneField(on_delete=django.db.models.deletion.CASCADE,
                                      parent_link=True, primary_key=True,
                                      serialize=False, to='auth.Group')),
                ('acl',
                 models.ManyToManyField(blank=True, null=True, to='main.ACLPermission')),
                ('owner',
                 models.ForeignKey(default=first_staff_user,
                                   on_delete=django.db.models.deletion.CASCADE,
                                   related_name='polemarch_usergroup_set',
                                   to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
            bases=('auth.group', models.Model),
        ),
        migrations.CreateModel(
            name='UserSettings',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('settings', models.TextField(default='{}')),
                ('user',
                 models.OneToOneField(on_delete=django.db.models.deletion.CASCADE,
                                      related_name='settings',
                                      related_query_name='settings',
                                      to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Variable',
            fields=[
                ('id',
                 models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('object_id', models.PositiveIntegerField()),
                ('key', models.CharField(max_length=128)),
                ('value', models.CharField(max_length=2048, null=True)),
                ('content_type',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                   to='contenttypes.ContentType')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='periodictask',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    related_name='periodic_tasks',
                                    related_query_name='periodic_tasks',
                                    to='main.Project'),
        ),
        migrations.AddField(
            model_name='periodictask',
            name='template',
            field=models.ForeignKey(blank=True, null=True,
                                    on_delete=django.db.models.deletion.CASCADE,
                                    related_name='periodic_tasks',
                                    related_query_name='periodic_tasks',
                                    to='main.Template'),
        ),
        migrations.AddField(
            model_name='history',
            name='inventory',
            field=models.ForeignKey(blank=True, default=None, null=True,
                                    on_delete=django.db.models.deletion.CASCADE,
                                    related_name='history', related_query_name='history',
                                    to='main.Inventory'),
        ),
        migrations.AddField(
            model_name='history',
            name='project',
            field=models.ForeignKey(null=True,
                                    on_delete=django.db.models.deletion.CASCADE,
                                    related_name='history', related_query_name='history',
                                    to='main.Project'),
        ),
        migrations.AddField(
            model_name='group',
            name='hosts',
            field=ManyToManyFieldACL(related_name='groups',
                                     related_query_name='groups',
                                     to='main.Host'),
        ),
        migrations.AddField(
            model_name='group',
            name='owner',
            field=models.ForeignKey(default=first_staff_user,
                                    on_delete=django.db.models.deletion.CASCADE,
                                    related_name='polemarch_group_set',
                                    to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='group',
            name='parents',
            field=ManyToManyFieldACLReverse(blank=True,
                                            null=True,
                                            related_name='groups',
                                            related_query_name='childrens',
                                            to='main.Group'),
        ),
        migrations.AddField(
            model_name='aclpermission',
            name='uagroup',
            field=models.ForeignKey(blank=True, null=True,
                                    on_delete=django.db.models.deletion.CASCADE,
                                    to='main.UserGroup'),
        ),
        migrations.AddField(
            model_name='aclpermission',
            name='user',
            field=models.ForeignKey(blank=True, null=True,
                                    on_delete=django.db.models.deletion.CASCADE,
                                    to=settings.AUTH_USER_MODEL),
        ),
        # migrations.AlterIndexTogether(
        #     name='template',
        #     index_together=set([('id', 'name', 'kind', 'inventory', 'project')]),
        # ),
        # Fix bug with Django migrations
        # Please, remove indexes manually.
        # migrations.AlterIndexTogether(
        #     name='historylines',
        #     index_together=set(
        #         [('history', 'line_number'), ('history',), ('line_number',)]),
        # ),
        # migrations.AlterIndexTogether(
        #     name='history',
        #     index_together=set([('id', 'project', 'mode', 'status', 'inventory',
        #                          'start_time', 'stop_time', 'initiator',
        #                          'initiator_type')]),
        # ),
        migrations.AlterIndexTogether(
            name='group',
            index_together=set([('children', 'id'), ('children',)]),
        ),
    ]
