Библиотека hotconsole позволяет запускать ваши скрипты на Windows в двух режимах: при помощи горячих клавиш и консольных команд. Таким образом ваши скрипты становятся удобным инструментом для повседневного использования в одиночку или в команде - без всяких усилий с вашей стороны. 

Hotconsole автоматически выводит в консоль информацию о командах, обрабатывает аргументы, запрашивает необходимую информацию у пользователя, дает возможность конфигурации и обновления (для командной работы), а также предоставляет ряд полезных методов.

Горячие клавиши работают глобально, поверх всех окон, а при необходимости действий в консоли - происходит автоматическое переключение на консоль. Примеры можно посмотреть и запустить в папке examples.

## Установка
Библиотека требует python 3.10 или выше (если устанавливаете в первый раз, соглайтесь на добавление переменной в path). Проверяем версию python --version, делаем python -m ensurepip и устанавливаем библиотеку командой:

```
python -m pip install hotconsole
```

При запуске любого скрипта при помощи библиотеки - в папке со скриптом появляется батник для установки hotconsole.
Батник пригодится, чтобы не обновлять библиотеку вручную. А еще, чтобы ваши пользователи могли легко установить библиотеку, а также подтянуть все зависимости, которые вы добавите сами и выгрузите в файл requirements.txt.

## Запуск команд

Рассмотрим простой пример пользовательского main.py - с командой для остановки службы

```
from hotconsole.hotconsole import Command, Runner, Hotkey
from hotconsole.helpers import OSHelper

TurnService = Command("turn", "Отключить службу", labmda_: OSHelper.try_stop_service("SERVICE"))

def main():
    Runner().run([Hotkey("alt+t", TurnService, None)])
```

Что происходит при запуске main.py:
- Появится окошко со списком горячих клавиш
- При необходимости оно перезапускается из-под админа
- При нажатии alt+t останавливается служба SERVICE
- Также можно нажать alt+q, перейти в консольный режим, написать turn - и получить тот же результат
- У пользователя появится конфиг data.json в папке с main.py

## Опции

Когда у нас парочка скриптов - можно создавать команды и без опций. Тогда по нажатию горячей клавиши сразу будет выполняться нужное действие. 

С этим подходом возникают проблемы, когда скриптов становится много - и при этом они тематически тесно связаны. В результате приходится создавать однотипные команды и запоминать / просматривать в списке десятки горячих клавиш. 

Решение - создавать определенные команды с опциями. У пользователя будет автоматически уточняться номер опции и передаваться в вашу функцию в качестве аргумента. 

Например, при создании команды передаем опции ["Включить", "Выключить", "Перезапустить"]   
Тогда функция будет выглядеть так:

```
def turn_service(option_number):
    match option_number:
            case 1:
                OSHelper.try_stop_service("SERVICE")
            case 2:
                OSHelper.try_start_service("SERVICE")
            case 3:
                OSHelper.try_rerun_service("SERVICE")
```

А команда так:
```
TurnService = Command("turn", "Изменить состояние службы", turn_service, ["Включить", "Выключить", "Перезапустить"])
```

В результате:
- При нажатии alt+t в любом окне - происсходит переключение на окно консоли
- В консоли появляется список вариантов: 1. Выключить, 2. Включить, 3. Перезапустить
- При выборе варианта выполняется соответствующее действие
- Если в горячей клавише указать вместо None, например, 1 - служба сразу остановится без вопросов в консоли
- Если перейти в консольный режим по alt+q и написать, например, turn 3 - служба сразу перезапустится

Также можно передать в команду option_message - вопрос, который будет уточнять у пользователя номер опции. По умолчанию это фраза "Введите номер варианта"

## Возможности конфигурации

При первом запуске main.py - создается конфиг data.json с версией = 1. 

Конфиг полезен:
1) Для кэширования. Если в процессе выполнения команды нужно сохранить значение переменной, то можно в этот файл
2) Для кастомизации. Например, по умолчанию в конфиге есть поле console_mode. Пользователь может выставить его в True и перейти в консольный режим без горячих клавиш. 
3) Для обновления. Если версия конфига пользователя неактуальна (расходится с версией в файле main.py), в конфиг автоматически добавляются новые поля. Также можно вставить в процесс инициализации миграцию.

Создаем конфиг для передачи в Runner: 

```
config = Config (version=22, consoleMode=False, refuseStartup=False, isAnything = False)
```

Допустим, в 22 версии изменилось поле "isSomething" на "isAnything". Чтобы не потерять данные наших пользователей, можем сделать миграцию:

```
def migration_to_22():
    config = OSHelper.extract_whole_json(CONFIG_PATH)
    if "consoleModeIsDefault" in config.keys():
        config["isAnything"] = config["isSomething"]
        OSHelper.write_file(CONFIG_PATH, json.dumps(config, indent=4))
```

Также может возникнуть потребность перед запуском каждой команды выполнять определенные действия и актуализировать данные пользователя. Для этого при создании Runner в него можно передать метод для актуализации. 

## Hotstrings

Hotstring - это как горячая клавиша, но только для строк. 
Например, мы можем создать Hotstring("githot", "Гитхаб hotconsole", "https://github.com/Vecheren/hotconsole")
И передать массив таких объектов в метод run.

Работает это так: пишем githot, нажимаем пробел - вместо githot в нашем случае подставляется ссылка.

## Хелперы

В hotconsole.helpers также есть хелперы, которые могут пригодиться при написании команд.
Например: 
- DBHelper - для взаимодействия с БД SQLite.
- OSHelper - для взаимодействия с виндой.
- RequestsHelper - для создания запросов к внешнему API.
- InnGenerator - генератор ИНН

## Известные ограничения

Hotconsole работает только на Windows, на линуксе и маке не запустится.

Библиотека проверялась на python 3.10, 3.11 и 3.12. Версия ниже не подойдет из-за использования pattern-matching, который наконец-то завезли в питон.

Запуск нескольких приложений с hotconsole одновременно - работает успешно. Но если у вас возникнет такая потребность, надо будет следить, чтобы не пересекались горячие клавиши в разных приложениях (иначе будут срабатывать сразу обе).

Приложение будет автоматически перезапускаться из-под админа, если указать if __name__ == "__main__": OSHelper.rerun_as_admin()

Но если у вас включен UAC, он будет доставать вас вопросами, запустить ли приложение. Для удобства можно выключить его в разделе "Изменение параметров контроля учетных записей".
