# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['servo_webhooks']
install_requires = \
['servox>=0.7.0,<0.8.0']

entry_points = \
{'servo.connectors': ['servo-webhooks = servo_webhooks:WebhooksConnector']}

setup_kwargs = {
    'name': 'servo-webhooks',
    'version': '0.2.2',
    'description': 'A flexible webhooks connector for Opsani Servo assemblies',
    'long_description': '# servo-webhooks\n![Run Tests](https://github.com/opsani/servo-webhooks/workflows/Run%20Tests/badge.svg)\n[![license](https://img.shields.io/github/license/opsani/servo-webhooks.svg)](https://github.com/opsani/servo-webhooks/blob/master/LICENSE)\n[![PyPI](https://img.shields.io/pypi/v/servo-webhooks.svg)](https://pypi.org/project/servo-webhooks/)\n[![release](https://img.shields.io/github/release/opsani/servo-webhooks.svg)](https://github.com/opsani/servo-webhooks/releases/latest)\n[![GitHub release date](https://img.shields.io/github/release-date/opsani/servo-webhooks.svg)](https://github.com/opsani/servo-webhooks/releases)\n[![Dependabot Status](https://api.dependabot.com/badges/status?host=github&repo=opsani/servo-webhooks)](https://dependabot.com)\n\nAn Opsani [Servo](https://github.com/opsani/servox) connector that provides a flexible webhooks \nemitter based on [servo events](https://github.com/opsani/servox/#understanding-events).\n\nThe webhooks connector extends the eventing infrastruture provided by the servo to enable events \nto be dispatched via HTTP or HTTP/2 request callbacks. Requests are delivered asynchronously on a \nbest effort basis. Webhooks can be registered to execute *before* or *after* any event defined in \nthe servo assembly. Before event webhooks should be used with care as they can block execution of the\nevent pending delivery of the webhook or cancel the event entirely through the response (see below).\nSupport is provided for configurable automatic retry and timeout of webhook requests.\n\nWebhook requests are sent with the HTTP `POST` method and a JSON request body. The webhook request body \nis dynamically defined based on the parameters and return value of the event registered with the servo. \nThis mechanism generalizes the webhook connector to support arbitrary events defined by any connector \nwithin the servo assembly. The `Content-Type` header and request body JSON Schema can be obtained \nvia the `webhooks` CLI subcommand (see usage below).\n\n## Configuration\n\n```yaml\nwebhooks:\n  - name: my_measure_handler # Optional. Name of the webhook.    \n    description: Store measurement info into Elastic Search. # Optional: Textual description of the webhook\n    events:\n    - after:measure # Required. Format: `(before|after):[EVENT_NAME]`\n    url: https://example.com/webhooks # Required. Format: [URL]\n    secret: s3cr3t # Required. Secret value for computing webhook signatures\n    headers: # Optional, Dict[str, str]\n      - name: x-some-header\n        value: some value\n    backoff: # Optional. Setting to `false` disables retries.\n      max_tries: 3\n      max_time: 5m\n```\n\nA starting point configuration can be added to your servo assembly via: `servo generate --defaults webhooks`.\n\n## Example Webhook Requests\n\n# TODO: Insert headers and request body for a couple of events\n```console\n```\n\n## Installation\n\nservo-webhooks is distributed as an installable Python package via PyPi and can be added to a servo assembly via Poetry:\n\n```console\n❯ poetry add servo-webhooks\n```\n\nFor convenience, servo-webhooks is included in the default servox assembly [Docker images](https://hub.docker.com/repository/docker/opsani/servox).\n\n## Usage\n\n1. Listing webhooks: `servo webhooks list`\n1. Getting event content type and payload schema: `servo webhooks schema after:measure`\n1. Triggering an ad-hoc webhook: `servo webhooks trigger after:adjust ([NAME|URL])`\n\n### Implementing Webhook Responders\n\nTODO: Content type, etc. headers. Include connector version, other event metadata. Schema versioning.\n\n### Validating Webhook Signatures\n\nAll webhook requests are sent with a `X-Servo-Signature` header. This value of this header is a hex\nstring representation of an HMAC SHA1 digest computed over the body of the request using the value of \nthe `secret` key from the webhook configuration. The signature can be easily verified to validate the \nauthenticity and integrity of the webhook payload. HMAC computation is supported on all major platforms\nand in the standard library of most modern programming languages.\n\nAn example of computing an HMAC SHA1 digest from a webhook request in Python looks like this:\n\n```python\nsecret = "super secret authentication code"\nexpected_signature = request.headers["x-servo-signature"]\nbody = request.read()\nsignature = str(hmac.new(secret.encode(), body, hashlib.sha1).hexdigest())\nassert signature == expected_signature\n```\n\n\n### Cancelling an Event via a Webhook\n\nLet\'s say that you want to implement a webhook that implements authorization of adjustments based on criteria \nsuch as a schedule that only permits them during midnight and 3am. To implement this, the webhook responder will\nreturn a 200 (OK) status code and a response body modeling a `servo.errors.CancelEventError` object. The `servo-webhooks`\nconnector will deserialize the `CancelEventError` representation and raise a `CancelEventError` exception within the\nassembly, cancelling the event. To indicate that your response body is a representation of a `CancelEventError` error,\nset the `Content-Type` header to `application/vnd.opsani.servo.errors.CancelEventError+json` and return a JSON object \nthat includes a `reason` property describing why the event was cancelled:\nTODO: What\'s the best status code/response for cancellation?\nReturn a 200 (OK) response with `Content-Type` of :\n\n```\n> POST http://webhooks.example.com/servo-webhooks\n> Content-Type: application/vnd.opsani.servo.events.Event+json # TODO: Not the right content type\n> {\n>  ...\n> }\n\n< 200 (OK)\n< Content-Type: application/vnd.opsani.servo.errors.CancelEventError+json\n< {\n<  "reason": "Unable to authorize adjustment: Adjustments are only permitted between midnight and 3am."\n< }\n```\n\n### Configuring Backoff Retries & Timeouts\n\nTODO: Disabling backoff to avoid blocking on a before handler.\n\n## Technical Details\n\nWebhook requests are managed non-persistently in memory. Requests are made via an asynchronous [httpx](https://www.python-httpx.org/) \nclient built on top of [asyncio](https://asyncio.readthedocs.io/). Support for webhook request body JSON Schema is provided via the \ndeep integration of [Pydantic](https://pydantic-docs.helpmanual.io/) in servox. Backoff and retry supported is provided via the \n[backoff](https://pypi.org/project/backoff/) library.\n\n## Testing\n\nAutomated tests are implemented via [Pytest](https://docs.pytest.org/en/stable/): `pytest test_servo_webhooks.py`\n\n## License\n\nservo-webhooks is distributed under the terms of the Apache 2.0 Open Source license.\n\nA copy of the license is provided in the [LICENSE](LICENSE) file at the root of the repository.\n',
    'author': 'Blake Watters',
    'author_email': 'blake@opsani.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/opsani/servo-webhooks',
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
