# generated by datamodel-codegen:
#   filename:  fuzz_detection.yaml

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Field


class NPScoreFuzzDetectionType(Enum):
    fuzz = 'fuzz'
    detection = 'detection'


class NPScoreClassifierOutput(BaseModel):
    str_tokens: Optional[List[str]] = Field(None, description='List of strings')
    activations: Optional[List[float]] = Field(None, description='List of floats')
    distance: Optional[Union[float, int]] = Field(None, description='Quantile or neighbor distance')
    ground_truth: Optional[bool] = Field(None, description='Whether the example is activating or not')
    prediction: Optional[bool] = Field(False, description='Whether the model predicted the example activating or not')
    highlighted: Optional[bool] = Field(False, description='Whether the sample is highlighted')
    probability: Optional[float] = Field(0.0, description='The probability of the example activating')
    correct: Optional[bool] = Field(False, description='Whether the prediction is correct')


class NPActivation(BaseModel):
    tokens: List[str] = Field(..., description='List of tokens for this text', example=['The', 'cat', 'sat'])
    values: List[float] = Field(
        ..., description='Activation values corresponding to each token', example=[0.5, 0.8, 0.2]
    )


class NPScoreFuzzDetectionResponse(BaseModel):
    score: float = Field(..., description='The score from 0 to 1')
    breakdown: List[NPScoreClassifierOutput] = Field(
        ..., description='Detailed breakdown of the classification outputs'
    )


class NPScoreFuzzDetectionRequest(BaseModel):
    activations: List[NPActivation] = Field(..., description='List of activation records to analyze')
    explanation: str = Field(
        ..., description='The explanation to evaluate', example='This neuron activates on references to feline behavior'
    )
    openrouter_key: str = Field(..., description='API key for OpenRouter service', example='sk-or-v1-...')
    model: str = Field(..., description='Model identifier to use for scoring', example='openai/gpt-4o-mini')
    type: NPScoreFuzzDetectionType = Field(..., description='Type of scoring to perform - either fuzzing or detection')
    secret: str = Field(..., description='Authentication secret for the API', example='your-secret-key')
