# OpenFermion-FQE
The Fermionic Quantum Emulator (FQE) is a light weight fermionic circuit simulator.  
The emulator uses number and projected spin quantum numbers to reduce the cost of simulating state 
evolutions under fermionic generators. 

![Python package](https://github.com/quantumlib/OpenFermion-FQE/workflows/Python%20package/badge.svg?branch=master)

## Getting Started
Installing FQE can be done via `pip install fqe`.

For information about getting started, please see the
[OpenFermion-FQE Guide & Tutorials](https://quantumai.google/openfermion/fqe).

## How to contribute
We'd love to accept your contributions and patches to OpenFermion-FQE. 
There are a few small guidelines you need to follow. 
Contributions to OpenFermion-FQE must be accompanied by a Contributor License Agreement. 
You (or your employer) retain the copyright to your contribution, this simply gives us permission 
to use and redistribute your contributions as part of the project. 
Head over to https://cla.developers.google.com/ to see your current agreements on file or to sign a new one.

All submissions, including submissions by project members, require review. 
We use GitHub pull requests for this purpose. Consult GitHub Help for more information on using pull requests. 
Furthermore, please make sure your new code comes with extensive tests! We use automatic testing to 
make sure all pull requests pass tests and do not decrease overall test coverage by too much. 
Make sure you adhere to our style guide. Just have a look at our code for clues. 
We mostly follow PEP 8 and use the corresponding linter to check for it. 
Code should always come with documentation, which is generated automatically and can be found here.

We use Github issues for tracking requests and bugs. 
Please post questions to the Quantum Computing Stack Exchange with an 'openfermion-fqe' tag.

## Authors
__Google Quantum AI__:\
Nicholas C. Rubin, Ryan Babbush

__QSimulate__:\
Klaas Gunst, Alec White, Leon Freitag, Kyle Throssell, Toru Shiozaki

__Caltech__:\
Garnet Chan

The initial version of OpenFermion-FQE has been developed in collaboration between
[QSimulate](https://qsimulate.com/)
and [Google Quantum AI](https://quantumai.google/).
## How to cite
When using OpenFermion-FQE for research projects, please cite:

```
@misc{fqe_2021,
    author       = {Nicholas C. Rubin, Klaas Gunst, Alec White, Leon Freitag,
                    Kyle Throssell, Garnet Chan, Ryan Babbush, Toru Shiozaki},
    title        = {The Fermionic Quantum Emulator, version 0.2.0},
    month        = {July},
    year         = {2021},
    url          = {https://github.com/quantumlib/OpenFermion-FQE} 
    }
```

## Disclaimer
Copyright 2020-2021 Google LLC. This is not an official Google product.
