/* Copyright 2019 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#include <stdio.h>
#include "command_responder.h"
#include "driver/gpio.h"
#include "pins.h"
#include "string.h"

// The default implementation writes out the name of the recognized command
// to the error console. Real applications will want to take some custom
// action instead, and should implement their own versions of this function.
// void RespondToCommand(tflite::ErrorReporter* error_reporter,
//                       int32_t current_time, const char* found_command,
//                       uint8_t score, bool is_new_command) {
void RespondToCommand(int32_t current_time, const char* found_command,
                      uint8_t score, bool is_new_command) {
  if (is_new_command) {
    // TF_LITE_REPORT_ERROR(error_reporter, "Heard %s (%d) @%dms", found_command,
    //                      score, current_time);
    printf("Heard %s (%d) @%dms\n", found_command,
                         score, current_time);
    if (strcmp(found_command, "silence") == 0) {
      gpio_set_level(GPIO_LED_RED, 0);
      gpio_set_level(GPIO_LED_GREEN, 0);
      gpio_set_level(GPIO_LED_BLUE, 0);
    } else if (strcmp(found_command, "unknown") == 0) {
      gpio_set_level(GPIO_LED_RED, 0);
      gpio_set_level(GPIO_LED_GREEN, 0);
      gpio_set_level(GPIO_LED_BLUE, 1);
    } else if (strcmp(found_command, "up") == 0) {
      gpio_set_level(GPIO_LED_RED, 0);
      gpio_set_level(GPIO_LED_GREEN, 1);
      gpio_set_level(GPIO_LED_BLUE, 0);
    } else if (strcmp(found_command, "down") == 0) {
      gpio_set_level(GPIO_LED_RED, 1);
      gpio_set_level(GPIO_LED_GREEN, 0);
      gpio_set_level(GPIO_LED_BLUE, 0);
    }
  }
}
