# coding: utf-8

from __future__ import annotations

import re  # noqa: F401
from datetime import datetime  # noqa: F401
from typing import List, Optional  # noqa: F401

from fastapi_camelcase import CamelModel
from pydantic import AnyUrl, Field  # noqa: F401

from telus_bulk.models.tmf_645.check_service_qualification_item import (
    CheckServiceQualificationItem,
)
from telus_bulk.models.tmf_645.related_party import RelatedParty


class CheckServiceQualification(CamelModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    CheckServiceQualification - a model defined in OpenAPI

        id: The id of this CheckServiceQualification [Optional].
        href: The href of this CheckServiceQualification [Optional].
        check_service_qualification_date: The check_service_qualification_date of this CheckServiceQualification [Optional].
        description: The description of this CheckServiceQualification [Optional].
        effective_qualification_date: The effective_qualification_date of this CheckServiceQualification [Optional].
        estimated_response_date: The estimated_response_date of this CheckServiceQualification [Optional].
        expected_qualification_date: The expected_qualification_date of this CheckServiceQualification [Optional].
        expiration_date: The expiration_date of this CheckServiceQualification [Optional].
        external_id: The external_id of this CheckServiceQualification [Optional].
        instant_sync_qualification: The instant_sync_qualification of this CheckServiceQualification [Optional].
        provide_alternative: The provide_alternative of this CheckServiceQualification [Optional].
        provide_unavailability_reason: The provide_unavailability_reason of this CheckServiceQualification [Optional].
        qualification_result: The qualification_result of this CheckServiceQualification [Optional].
        related_party: The related_party of this CheckServiceQualification [Optional].
        service_qualification_item: The service_qualification_item of this CheckServiceQualification [Optional].
        state: The state of this CheckServiceQualification [Optional].
        base_type: The base_type of this CheckServiceQualification [Optional].
        schema_location: The schema_location of this CheckServiceQualification [Optional].
        type: The type of this CheckServiceQualification [Optional].
    """

    id: Optional[str] = None
    href: Optional[str] = None
    check_service_qualification_date: Optional[datetime] = None
    description: Optional[str] = None
    effective_qualification_date: Optional[datetime] = None
    estimated_response_date: Optional[datetime] = None
    expected_qualification_date: Optional[datetime] = None
    expiration_date: Optional[datetime] = None
    external_id: Optional[str] = None
    instant_sync_qualification: Optional[bool] = None
    provide_alternative: Optional[bool] = None
    provide_unavailability_reason: Optional[bool] = None
    qualification_result: Optional[str] = None
    related_party: Optional[List[RelatedParty]] = None
    service_qualification_item: Optional[List[CheckServiceQualificationItem]] = None
    state: Optional[str] = None
    base_type: Optional[str] = None
    schema_location: Optional[AnyUrl] = None
    type: Optional[str] = Field(default=None, alias="@type")


CheckServiceQualification.update_forward_refs()
