The Extended Selfish Gene
=========================

![License](https://img.shields.io/github/license/squillero/sgx)
![Status: Active](https://img.shields.io/badge/status-active-green.svg)
![Version: 0.2.dev](https://img.shields.io/badge/version-0.2.dev-yellowgreen.svg)
![Release](https://img.shields.io/github/v/release/squillero/sgx?include_prereleases)
![Language: Python3](https://img.shields.io/badge/language-python3-blue.svg)
[![Build Status](https://travis-ci.org/squillero/sgx.svg?branch=master)](https://travis-ci.org/squillero/sgx)

The *Selfish Gene Algorithm* is a population-less evolutionary optimizer loosely inspired by the dashing interpretation of the Darwinian theory popularized in the scientific blockbuster [*The Selfish Gene*](https://en.wikipedia.org/wiki/The_Selfish_Gene). It enables a user to efficiently find the list parameters, either discrete symbols or real numbers, that maximizes a given target function. [**[MORE]**](extras/HISTORY.md)

Since 1998, the *Selfish Gene* was [exploited](https://goo.gl/Baw9I8) by different researchers, and a few brand new approaches derived from it. For celebrating (almost) a quarter century mark, it has been  rewritten from scratch in Python 3, with improved usability and tons of new features. 

> #### :warning: SGX is currently in [pre-alpha](https://en.wikipedia.org/wiki/Software_release_life_cycle#Pre-alpha) and under active development

## Installation

SGX is available as a [PyPi package](https://pypi.org/project/sgx) and installing it is as simple as

```shell
$ pip install sgx
```

## Source code

This repo is only useful if one wants to hack the code.

* The default branch is always the more stable and the only one tested through [Travis CI](https://en.wikipedia.org/wiki/Travis_CI)
* The experimental branches `exp/*` contain code and comments that some programmers may find disturbing —  Viewers discretion advised
* Before trying to contribute read [this paper](http://doi.org/10.1007/978-3-662-43505-2_45) and [this style guide](https://github.com/squillero/style/blob/master/python.md)
* It may be wise to send Giovanni an email [[@](mailto:giovanni.squillero@polito.it)] before digging into the project

## Licence

**Copyright © 2021 [Giovanni Squillero](https://staff.polito.it/giovanni.squillero/)**  
The Extended Selfish Gene (SGX) is [free and open-source software](https://en.wikipedia.org/wiki/Free_and_open-source_software), and it is distributed under the [European Union Public Licence](https://choosealicense.com/licenses/eupl-1.2/).
