"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    ReposOwnerRepoIssuesPostBodyType,
    ReposOwnerRepoLabelsPostBodyType,
    ReposOwnerRepoMilestonesPostBodyType,
    ReposOwnerRepoLabelsNamePatchBodyType,
    ReposOwnerRepoIssuesIssueNumberPatchBodyType,
    ReposOwnerRepoIssuesIssueNumberLockPutBodyType,
    ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType,
    ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType,
    ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType,
    ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType,
    ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1Type,
    ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType,
    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType,
    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType,
    ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1Type,
    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItemsType,
    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItemsType,
)
from .models import (
    Issue,
    Label,
    Milestone,
    BasicError,
    IssueEvent,
    SimpleUser,
    IssueComment,
    ValidationError,
    LockedIssueEvent,
    LabeledIssueEvent,
    RenamedIssueEvent,
    AssignedIssueEvent,
    UnlabeledIssueEvent,
    MilestonedIssueEvent,
    TimelineCommentEvent,
    UnassignedIssueEvent,
    StateChangeIssueEvent,
    TimelineReviewedEvent,
    DemilestonedIssueEvent,
    TimelineCommittedEvent,
    AddedToProjectIssueEvent,
    ReviewDismissedIssueEvent,
    ReviewRequestedIssueEvent,
    TimelineAssignedIssueEvent,
    TimelineLineCommentedEvent,
    RemovedFromProjectIssueEvent,
    ReposOwnerRepoIssuesPostBody,
    ReposOwnerRepoLabelsPostBody,
    TimelineCommitCommentedEvent,
    TimelineCrossReferencedEvent,
    TimelineUnassignedIssueEvent,
    ConvertedNoteToIssueIssueEvent,
    MovedColumnInProjectIssueEvent,
    ReviewRequestRemovedIssueEvent,
    ReposOwnerRepoMilestonesPostBody,
    ReposOwnerRepoLabelsNamePatchBody,
    ReposOwnerRepoIssuesIssueNumberPatchBody,
    ReposOwnerRepoIssuesIssueNumberLockPutBody,
    ReposOwnerRepoIssuesCommentsCommentIdPatchBody,
    ReposOwnerRepoIssuesIssueNumberCommentsPostBody,
    ReposOwnerRepoIssuesIssueNumberAssigneesPostBody,
    ReposOwnerRepoMilestonesMilestoneNumberPatchBody,
    ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody,
    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0,
    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2,
    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0,
    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2,
    EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items,
    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class IssuesClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list(
        self,
        filter_: Union[
            Unset,
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"],
        ] = "assigned",
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        labels: Union[Unset, str] = UNSET,
        sort: Union[Unset, Literal["created", "updated", "comments"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        since: Union[Unset, datetime] = UNSET,
        collab: Union[Unset, bool] = UNSET,
        orgs: Union[Unset, bool] = UNSET,
        owned: Union[Unset, bool] = UNSET,
        pulls: Union[Unset, bool] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Issue]]":
        url = "/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "collab": collab,
            "orgs": orgs,
            "owned": owned,
            "pulls": pulls,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Issue],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_list(
        self,
        filter_: Union[
            Unset,
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"],
        ] = "assigned",
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        labels: Union[Unset, str] = UNSET,
        sort: Union[Unset, Literal["created", "updated", "comments"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        since: Union[Unset, datetime] = UNSET,
        collab: Union[Unset, bool] = UNSET,
        orgs: Union[Unset, bool] = UNSET,
        owned: Union[Unset, bool] = UNSET,
        pulls: Union[Unset, bool] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Issue]]":
        url = "/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "collab": collab,
            "orgs": orgs,
            "owned": owned,
            "pulls": pulls,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Issue],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_for_org(
        self,
        org: str,
        filter_: Union[
            Unset,
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"],
        ] = "assigned",
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        labels: Union[Unset, str] = UNSET,
        sort: Union[Unset, Literal["created", "updated", "comments"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Issue]]":
        url = f"/orgs/{org}/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Issue],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_org(
        self,
        org: str,
        filter_: Union[
            Unset,
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"],
        ] = "assigned",
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        labels: Union[Unset, str] = UNSET,
        sort: Union[Unset, Literal["created", "updated", "comments"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Issue]]":
        url = f"/orgs/{org}/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Issue],
            error_models={
                "404": BasicError,
            },
        )

    def list_assignees(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/assignees"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_assignees(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/assignees"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    def check_user_can_be_assigned(
        self,
        owner: str,
        repo: str,
        assignee: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/assignees/{assignee}"

        return self._github.request(
            "GET",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_check_user_can_be_assigned(
        self,
        owner: str,
        repo: str,
        assignee: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/assignees/{assignee}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def list_for_repo(
        self,
        owner: str,
        repo: str,
        milestone: Union[Unset, str] = UNSET,
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        assignee: Union[Unset, str] = UNSET,
        creator: Union[Unset, str] = UNSET,
        mentioned: Union[Unset, str] = UNSET,
        labels: Union[Unset, str] = UNSET,
        sort: Union[Unset, Literal["created", "updated", "comments"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Issue]]":
        url = f"/repos/{owner}/{repo}/issues"

        params = {
            "milestone": milestone,
            "state": state,
            "assignee": assignee,
            "creator": creator,
            "mentioned": mentioned,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Issue],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_list_for_repo(
        self,
        owner: str,
        repo: str,
        milestone: Union[Unset, str] = UNSET,
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        assignee: Union[Unset, str] = UNSET,
        creator: Union[Unset, str] = UNSET,
        mentioned: Union[Unset, str] = UNSET,
        labels: Union[Unset, str] = UNSET,
        sort: Union[Unset, Literal["created", "updated", "comments"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Issue]]":
        url = f"/repos/{owner}/{repo}/issues"

        params = {
            "milestone": milestone,
            "state": state,
            "assignee": assignee,
            "creator": creator,
            "mentioned": mentioned,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Issue],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    def create(
        self, owner: str, repo: str, *, data: ReposOwnerRepoIssuesPostBodyType
    ) -> "Response[Issue]":
        ...

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        title: Union[str, int],
        body: Union[Unset, str] = UNSET,
        assignee: Union[Unset, Union[str, None]] = UNSET,
        milestone: Union[Unset, Union[None, str, int, str, int]] = UNSET,
        labels: Union[
            Unset,
            List[Union[str, ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1Type]],
        ] = UNSET,
        assignees: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Issue]":
        ...

    def create(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoIssuesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Issue]":
        url = f"/repos/{owner}/{repo}/issues"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Issue,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    async def async_create(
        self, owner: str, repo: str, *, data: ReposOwnerRepoIssuesPostBodyType
    ) -> "Response[Issue]":
        ...

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        title: Union[str, int],
        body: Union[Unset, str] = UNSET,
        assignee: Union[Unset, Union[str, None]] = UNSET,
        milestone: Union[Unset, Union[None, str, int, str, int]] = UNSET,
        labels: Union[
            Unset,
            List[Union[str, ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1Type]],
        ] = UNSET,
        assignees: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Issue]":
        ...

    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoIssuesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Issue]":
        url = f"/repos/{owner}/{repo}/issues"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Issue,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "404": BasicError,
                "410": BasicError,
            },
        )

    def list_comments_for_repo(
        self,
        owner: str,
        repo: str,
        sort: Union[Unset, Literal["created", "updated"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[IssueComment]]":
        url = f"/repos/{owner}/{repo}/issues/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[IssueComment],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_list_comments_for_repo(
        self,
        owner: str,
        repo: str,
        sort: Union[Unset, Literal["created", "updated"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[IssueComment]]":
        url = f"/repos/{owner}/{repo}/issues/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[IssueComment],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response[IssueComment]":
        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        return self._github.request(
            "GET",
            url,
            response_model=IssueComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response[IssueComment]":
        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=IssueComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType,
    ) -> "Response[IssueComment]":
        ...

    @overload
    def update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Unset = UNSET,
        body: str,
    ) -> "Response[IssueComment]":
        ...

    def update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[IssueComment]":
        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesCommentsCommentIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=IssueComment,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType,
    ) -> "Response[IssueComment]":
        ...

    @overload
    async def async_update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Unset = UNSET,
        body: str,
    ) -> "Response[IssueComment]":
        ...

    async def async_update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[IssueComment]":
        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesCommentsCommentIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=IssueComment,
            error_models={
                "422": ValidationError,
            },
        )

    def list_events_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[IssueEvent]]":
        url = f"/repos/{owner}/{repo}/issues/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[IssueEvent],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_events_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[IssueEvent]]":
        url = f"/repos/{owner}/{repo}/issues/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[IssueEvent],
            error_models={
                "422": ValidationError,
            },
        )

    def get_event(
        self,
        owner: str,
        repo: str,
        event_id: int,
    ) -> "Response[IssueEvent]":
        url = f"/repos/{owner}/{repo}/issues/events/{event_id}"

        return self._github.request(
            "GET",
            url,
            response_model=IssueEvent,
            error_models={
                "404": BasicError,
                "410": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_event(
        self,
        owner: str,
        repo: str,
        event_id: int,
    ) -> "Response[IssueEvent]":
        url = f"/repos/{owner}/{repo}/issues/events/{event_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=IssueEvent,
            error_models={
                "404": BasicError,
                "410": BasicError,
                "403": BasicError,
            },
        )

    def get(
        self,
        owner: str,
        repo: str,
        issue_number: int,
    ) -> "Response[Issue]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}"

        return self._github.request(
            "GET",
            url,
            response_model=Issue,
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        issue_number: int,
    ) -> "Response[Issue]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Issue,
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[Unset, ReposOwnerRepoIssuesIssueNumberPatchBodyType] = UNSET,
    ) -> "Response[Issue]":
        ...

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        title: Union[Unset, Union[None, str, int, str, int]] = UNSET,
        body: Union[Unset, Union[str, None]] = UNSET,
        assignee: Union[Unset, Union[str, None]] = UNSET,
        state: Union[Unset, Literal["open", "closed"]] = UNSET,
        milestone: Union[Unset, Union[None, str, int, str, int]] = UNSET,
        labels: Union[
            Unset,
            List[
                Union[
                    str,
                    ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1Type,
                ]
            ],
        ] = UNSET,
        assignees: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Issue]":
        ...

    def update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[Unset, ReposOwnerRepoIssuesIssueNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Issue]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesIssueNumberPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Issue,
            error_models={
                "422": ValidationError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[Unset, ReposOwnerRepoIssuesIssueNumberPatchBodyType] = UNSET,
    ) -> "Response[Issue]":
        ...

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        title: Union[Unset, Union[None, str, int, str, int]] = UNSET,
        body: Union[Unset, Union[str, None]] = UNSET,
        assignee: Union[Unset, Union[str, None]] = UNSET,
        state: Union[Unset, Literal["open", "closed"]] = UNSET,
        milestone: Union[Unset, Union[None, str, int, str, int]] = UNSET,
        labels: Union[
            Unset,
            List[
                Union[
                    str,
                    ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1Type,
                ]
            ],
        ] = UNSET,
        assignees: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Issue]":
        ...

    async def async_update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[Unset, ReposOwnerRepoIssuesIssueNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Issue]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesIssueNumberPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Issue,
            error_models={
                "422": ValidationError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType
        ] = UNSET,
    ) -> "Response[Issue]":
        ...

    @overload
    def add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        assignees: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Issue]":
        ...

    def add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Issue]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesIssueNumberAssigneesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Issue,
        )

    @overload
    async def async_add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType
        ] = UNSET,
    ) -> "Response[Issue]":
        ...

    @overload
    async def async_add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        assignees: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Issue]":
        ...

    async def async_add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Issue]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesIssueNumberAssigneesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Issue,
        )

    @overload
    def remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType
        ] = UNSET,
    ) -> "Response[Issue]":
        ...

    @overload
    def remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        assignees: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Issue]":
        ...

    def remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Issue]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=Issue,
        )

    @overload
    async def async_remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType
        ] = UNSET,
    ) -> "Response[Issue]":
        ...

    @overload
    async def async_remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        assignees: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Issue]":
        ...

    async def async_remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Issue]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=Issue,
        )

    def list_comments(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[IssueComment]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/comments"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[IssueComment],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_list_comments(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[IssueComment]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/comments"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[IssueComment],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType,
    ) -> "Response[IssueComment]":
        ...

    @overload
    def create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        body: str,
    ) -> "Response[IssueComment]":
        ...

    def create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[Unset, ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[IssueComment]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/comments"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesIssueNumberCommentsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=IssueComment,
            error_models={
                "403": BasicError,
                "410": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType,
    ) -> "Response[IssueComment]":
        ...

    @overload
    async def async_create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        body: str,
    ) -> "Response[IssueComment]":
        ...

    async def async_create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[Unset, ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[IssueComment]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/comments"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesIssueNumberCommentsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=IssueComment,
            error_models={
                "403": BasicError,
                "410": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_events(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Union[LabeledIssueEvent, UnlabeledIssueEvent, AssignedIssueEvent, UnassignedIssueEvent, MilestonedIssueEvent, DemilestonedIssueEvent, RenamedIssueEvent, ReviewRequestedIssueEvent, ReviewRequestRemovedIssueEvent, ReviewDismissedIssueEvent, LockedIssueEvent, AddedToProjectIssueEvent, MovedColumnInProjectIssueEvent, RemovedFromProjectIssueEvent, ConvertedNoteToIssueIssueEvent]]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[
                Union[
                    LabeledIssueEvent,
                    UnlabeledIssueEvent,
                    AssignedIssueEvent,
                    UnassignedIssueEvent,
                    MilestonedIssueEvent,
                    DemilestonedIssueEvent,
                    RenamedIssueEvent,
                    ReviewRequestedIssueEvent,
                    ReviewRequestRemovedIssueEvent,
                    ReviewDismissedIssueEvent,
                    LockedIssueEvent,
                    AddedToProjectIssueEvent,
                    MovedColumnInProjectIssueEvent,
                    RemovedFromProjectIssueEvent,
                    ConvertedNoteToIssueIssueEvent,
                ]
            ],
            error_models={
                "410": BasicError,
            },
        )

    async def async_list_events(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Union[LabeledIssueEvent, UnlabeledIssueEvent, AssignedIssueEvent, UnassignedIssueEvent, MilestonedIssueEvent, DemilestonedIssueEvent, RenamedIssueEvent, ReviewRequestedIssueEvent, ReviewRequestRemovedIssueEvent, ReviewDismissedIssueEvent, LockedIssueEvent, AddedToProjectIssueEvent, MovedColumnInProjectIssueEvent, RemovedFromProjectIssueEvent, ConvertedNoteToIssueIssueEvent]]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[
                Union[
                    LabeledIssueEvent,
                    UnlabeledIssueEvent,
                    AssignedIssueEvent,
                    UnassignedIssueEvent,
                    MilestonedIssueEvent,
                    DemilestonedIssueEvent,
                    RenamedIssueEvent,
                    ReviewRequestedIssueEvent,
                    ReviewRequestRemovedIssueEvent,
                    ReviewDismissedIssueEvent,
                    LockedIssueEvent,
                    AddedToProjectIssueEvent,
                    MovedColumnInProjectIssueEvent,
                    RemovedFromProjectIssueEvent,
                    ConvertedNoteToIssueIssueEvent,
                ]
            ],
            error_models={
                "410": BasicError,
            },
        )

    def list_labels_on_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Label]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Label],
            error_models={
                "410": BasicError,
            },
        )

    async def async_list_labels_on_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Label]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Label],
            error_models={
                "410": BasicError,
            },
        )

    @overload
    def set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType],
                str,
            ],
        ] = UNSET,
    ) -> "Response[List[Label]]":
        ...

    @overload
    def set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        labels: Union[Unset, List[str]] = UNSET,
    ) -> "Response[List[Label]]":
        ...

    @overload
    def set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        labels: Union[
            Unset,
            List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItemsType],
        ] = UNSET,
    ) -> "Response[List[Label]]":
        ...

    def set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType],
                str,
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Label]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items],
                str,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[Label],
            error_models={
                "410": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType],
                str,
            ],
        ] = UNSET,
    ) -> "Response[List[Label]]":
        ...

    @overload
    async def async_set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        labels: Union[Unset, List[str]] = UNSET,
    ) -> "Response[List[Label]]":
        ...

    @overload
    async def async_set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        labels: Union[
            Unset,
            List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItemsType],
        ] = UNSET,
    ) -> "Response[List[Label]]":
        ...

    async def async_set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType],
                str,
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Label]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items],
                str,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[Label],
            error_models={
                "410": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType],
                str,
            ],
        ] = UNSET,
    ) -> "Response[List[Label]]":
        ...

    @overload
    def add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        labels: Union[Unset, List[str]] = UNSET,
    ) -> "Response[List[Label]]":
        ...

    @overload
    def add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        labels: Union[
            Unset,
            List[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItemsType
            ],
        ] = UNSET,
    ) -> "Response[List[Label]]":
        ...

    def add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType],
                str,
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Label]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items],
                str,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Label],
            error_models={
                "410": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType],
                str,
            ],
        ] = UNSET,
    ) -> "Response[List[Label]]":
        ...

    @overload
    async def async_add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        labels: Union[Unset, List[str]] = UNSET,
    ) -> "Response[List[Label]]":
        ...

    @overload
    async def async_add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        labels: Union[
            Unset,
            List[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItemsType
            ],
        ] = UNSET,
    ) -> "Response[List[Label]]":
        ...

    async def async_add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType],
                str,
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Label]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items],
                str,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Label],
            error_models={
                "410": BasicError,
                "422": ValidationError,
            },
        )

    def remove_all_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "410": BasicError,
            },
        )

    async def async_remove_all_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "410": BasicError,
            },
        )

    def remove_label(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        name: str,
    ) -> "Response[List[Label]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}"

        return self._github.request(
            "DELETE",
            url,
            response_model=List[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_remove_label(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        name: str,
    ) -> "Response[List[Label]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=List[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoIssuesIssueNumberLockPutBodyType, None]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    def lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        lock_reason: Union[
            Unset, Literal["off-topic", "too heated", "resolved", "spam"]
        ] = UNSET,
    ) -> "Response":
        ...

    def lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoIssuesIssueNumberLockPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/lock"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoIssuesIssueNumberLockPutBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "403": BasicError,
                "410": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoIssuesIssueNumberLockPutBodyType, None]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Unset = UNSET,
        lock_reason: Union[
            Unset, Literal["off-topic", "too heated", "resolved", "spam"]
        ] = UNSET,
    ) -> "Response":
        ...

    async def async_lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoIssuesIssueNumberLockPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/lock"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoIssuesIssueNumberLockPutBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "403": BasicError,
                "410": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def unlock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/lock"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_unlock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/lock"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_events_for_timeline(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Union[LabeledIssueEvent, UnlabeledIssueEvent, MilestonedIssueEvent, DemilestonedIssueEvent, RenamedIssueEvent, ReviewRequestedIssueEvent, ReviewRequestRemovedIssueEvent, ReviewDismissedIssueEvent, LockedIssueEvent, AddedToProjectIssueEvent, MovedColumnInProjectIssueEvent, RemovedFromProjectIssueEvent, ConvertedNoteToIssueIssueEvent, TimelineCommentEvent, TimelineCrossReferencedEvent, TimelineCommittedEvent, TimelineReviewedEvent, TimelineLineCommentedEvent, TimelineCommitCommentedEvent, TimelineAssignedIssueEvent, TimelineUnassignedIssueEvent, StateChangeIssueEvent]]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/timeline"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[
                Union[
                    LabeledIssueEvent,
                    UnlabeledIssueEvent,
                    MilestonedIssueEvent,
                    DemilestonedIssueEvent,
                    RenamedIssueEvent,
                    ReviewRequestedIssueEvent,
                    ReviewRequestRemovedIssueEvent,
                    ReviewDismissedIssueEvent,
                    LockedIssueEvent,
                    AddedToProjectIssueEvent,
                    MovedColumnInProjectIssueEvent,
                    RemovedFromProjectIssueEvent,
                    ConvertedNoteToIssueIssueEvent,
                    TimelineCommentEvent,
                    TimelineCrossReferencedEvent,
                    TimelineCommittedEvent,
                    TimelineReviewedEvent,
                    TimelineLineCommentedEvent,
                    TimelineCommitCommentedEvent,
                    TimelineAssignedIssueEvent,
                    TimelineUnassignedIssueEvent,
                    StateChangeIssueEvent,
                ]
            ],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_list_events_for_timeline(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Union[LabeledIssueEvent, UnlabeledIssueEvent, MilestonedIssueEvent, DemilestonedIssueEvent, RenamedIssueEvent, ReviewRequestedIssueEvent, ReviewRequestRemovedIssueEvent, ReviewDismissedIssueEvent, LockedIssueEvent, AddedToProjectIssueEvent, MovedColumnInProjectIssueEvent, RemovedFromProjectIssueEvent, ConvertedNoteToIssueIssueEvent, TimelineCommentEvent, TimelineCrossReferencedEvent, TimelineCommittedEvent, TimelineReviewedEvent, TimelineLineCommentedEvent, TimelineCommitCommentedEvent, TimelineAssignedIssueEvent, TimelineUnassignedIssueEvent, StateChangeIssueEvent]]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/timeline"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[
                Union[
                    LabeledIssueEvent,
                    UnlabeledIssueEvent,
                    MilestonedIssueEvent,
                    DemilestonedIssueEvent,
                    RenamedIssueEvent,
                    ReviewRequestedIssueEvent,
                    ReviewRequestRemovedIssueEvent,
                    ReviewDismissedIssueEvent,
                    LockedIssueEvent,
                    AddedToProjectIssueEvent,
                    MovedColumnInProjectIssueEvent,
                    RemovedFromProjectIssueEvent,
                    ConvertedNoteToIssueIssueEvent,
                    TimelineCommentEvent,
                    TimelineCrossReferencedEvent,
                    TimelineCommittedEvent,
                    TimelineReviewedEvent,
                    TimelineLineCommentedEvent,
                    TimelineCommitCommentedEvent,
                    TimelineAssignedIssueEvent,
                    TimelineUnassignedIssueEvent,
                    StateChangeIssueEvent,
                ]
            ],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    def list_labels_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Label]]":
        url = f"/repos/{owner}/{repo}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Label],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Label]]":
        url = f"/repos/{owner}/{repo}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Label],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_label(
        self, owner: str, repo: str, *, data: ReposOwnerRepoLabelsPostBodyType
    ) -> "Response[Label]":
        ...

    @overload
    def create_label(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        name: str,
        color: Union[Unset, str] = UNSET,
        description: Union[Unset, str] = UNSET,
    ) -> "Response[Label]":
        ...

    def create_label(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Label]":
        url = f"/repos/{owner}/{repo}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoLabelsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Label,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_label(
        self, owner: str, repo: str, *, data: ReposOwnerRepoLabelsPostBodyType
    ) -> "Response[Label]":
        ...

    @overload
    async def async_create_label(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        name: str,
        color: Union[Unset, str] = UNSET,
        description: Union[Unset, str] = UNSET,
    ) -> "Response[Label]":
        ...

    async def async_create_label(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Label]":
        url = f"/repos/{owner}/{repo}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoLabelsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Label,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_label(
        self,
        owner: str,
        repo: str,
        name: str,
    ) -> "Response[Label]":
        url = f"/repos/{owner}/{repo}/labels/{name}"

        return self._github.request(
            "GET",
            url,
            response_model=Label,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_label(
        self,
        owner: str,
        repo: str,
        name: str,
    ) -> "Response[Label]":
        url = f"/repos/{owner}/{repo}/labels/{name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Label,
            error_models={
                "404": BasicError,
            },
        )

    def delete_label(
        self,
        owner: str,
        repo: str,
        name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/labels/{name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_label(
        self,
        owner: str,
        repo: str,
        name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/labels/{name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: Union[Unset, ReposOwnerRepoLabelsNamePatchBodyType] = UNSET,
    ) -> "Response[Label]":
        ...

    @overload
    def update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: Unset = UNSET,
        new_name: Union[Unset, str] = UNSET,
        color: Union[Unset, str] = UNSET,
        description: Union[Unset, str] = UNSET,
    ) -> "Response[Label]":
        ...

    def update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: Union[Unset, ReposOwnerRepoLabelsNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Label]":
        url = f"/repos/{owner}/{repo}/labels/{name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoLabelsNamePatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Label,
        )

    @overload
    async def async_update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: Union[Unset, ReposOwnerRepoLabelsNamePatchBodyType] = UNSET,
    ) -> "Response[Label]":
        ...

    @overload
    async def async_update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: Unset = UNSET,
        new_name: Union[Unset, str] = UNSET,
        color: Union[Unset, str] = UNSET,
        description: Union[Unset, str] = UNSET,
    ) -> "Response[Label]":
        ...

    async def async_update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: Union[Unset, ReposOwnerRepoLabelsNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Label]":
        url = f"/repos/{owner}/{repo}/labels/{name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoLabelsNamePatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Label,
        )

    def list_milestones(
        self,
        owner: str,
        repo: str,
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        sort: Union[Unset, Literal["due_on", "completeness"]] = "due_on",
        direction: Union[Unset, Literal["asc", "desc"]] = "asc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Milestone]]":
        url = f"/repos/{owner}/{repo}/milestones"

        params = {
            "state": state,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Milestone],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_milestones(
        self,
        owner: str,
        repo: str,
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        sort: Union[Unset, Literal["due_on", "completeness"]] = "due_on",
        direction: Union[Unset, Literal["asc", "desc"]] = "asc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Milestone]]":
        url = f"/repos/{owner}/{repo}/milestones"

        params = {
            "state": state,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Milestone],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_milestone(
        self, owner: str, repo: str, *, data: ReposOwnerRepoMilestonesPostBodyType
    ) -> "Response[Milestone]":
        ...

    @overload
    def create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        title: str,
        state: Union[Unset, Literal["open", "closed"]] = "open",
        description: Union[Unset, str] = UNSET,
        due_on: Union[Unset, datetime] = UNSET,
    ) -> "Response[Milestone]":
        ...

    def create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoMilestonesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Milestone]":
        url = f"/repos/{owner}/{repo}/milestones"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoMilestonesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Milestone,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_milestone(
        self, owner: str, repo: str, *, data: ReposOwnerRepoMilestonesPostBodyType
    ) -> "Response[Milestone]":
        ...

    @overload
    async def async_create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        title: str,
        state: Union[Unset, Literal["open", "closed"]] = "open",
        description: Union[Unset, str] = UNSET,
        due_on: Union[Unset, datetime] = UNSET,
    ) -> "Response[Milestone]":
        ...

    async def async_create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoMilestonesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Milestone]":
        url = f"/repos/{owner}/{repo}/milestones"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoMilestonesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Milestone,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
    ) -> "Response[Milestone]":
        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        return self._github.request(
            "GET",
            url,
            response_model=Milestone,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
    ) -> "Response[Milestone]":
        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Milestone,
            error_models={
                "404": BasicError,
            },
        )

    def delete_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType
        ] = UNSET,
    ) -> "Response[Milestone]":
        ...

    @overload
    def update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        data: Unset = UNSET,
        title: Union[Unset, str] = UNSET,
        state: Union[Unset, Literal["open", "closed"]] = "open",
        description: Union[Unset, str] = UNSET,
        due_on: Union[Unset, datetime] = UNSET,
    ) -> "Response[Milestone]":
        ...

    def update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Milestone]":
        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoMilestonesMilestoneNumberPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Milestone,
        )

    @overload
    async def async_update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType
        ] = UNSET,
    ) -> "Response[Milestone]":
        ...

    @overload
    async def async_update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        data: Unset = UNSET,
        title: Union[Unset, str] = UNSET,
        state: Union[Unset, Literal["open", "closed"]] = "open",
        description: Union[Unset, str] = UNSET,
        due_on: Union[Unset, datetime] = UNSET,
    ) -> "Response[Milestone]":
        ...

    async def async_update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Milestone]":
        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoMilestonesMilestoneNumberPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Milestone,
        )

    def list_labels_for_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Label]]":
        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Label],
        )

    async def async_list_labels_for_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Label]]":
        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Label],
        )

    def list_for_authenticated_user(
        self,
        filter_: Union[
            Unset,
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"],
        ] = "assigned",
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        labels: Union[Unset, str] = UNSET,
        sort: Union[Unset, Literal["created", "updated", "comments"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Issue]]":
        url = "/user/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Issue],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        filter_: Union[
            Unset,
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"],
        ] = "assigned",
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        labels: Union[Unset, str] = UNSET,
        sort: Union[Unset, Literal["created", "updated", "comments"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Issue]]":
        url = "/user/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Issue],
            error_models={
                "404": BasicError,
            },
        )
