"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const stepfunctions = require("../lib");
describe('Parallel State', () => {
    test('State Machine With Parallel State', () => {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const parallel = new stepfunctions.Parallel(stack, 'Parallel State');
        parallel.branch(new stepfunctions.Pass(stack, 'Branch 1'));
        parallel.branch(new stepfunctions.Pass(stack, 'Branch 2'));
        // THEN
        expect(render(parallel)).toStrictEqual({
            StartAt: 'Parallel State',
            States: {
                'Parallel State': {
                    Type: 'Parallel',
                    End: true,
                    Branches: [
                        { StartAt: 'Branch 1', States: { 'Branch 1': { Type: 'Pass', End: true } } },
                        { StartAt: 'Branch 2', States: { 'Branch 2': { Type: 'Pass', End: true } } },
                    ],
                },
            },
        });
    });
});
function render(sm) {
    return new cdk.Stack().resolve(new stepfunctions.StateGraph(sm.startState, 'Test Graph').toGraphJson());
}
//# sourceMappingURL=data:application/json;base64,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