# /// script
# dependencies = ["llmling-agent"]
# ///

"""Example demonstrating team agent picking functionality."""

from __future__ import annotations

import asyncio

from llmling_agent import Agent, Team


async def main():
    # Parallel team members
    developer = Agent[None](
        name="developer",
        description="Implements new code features and changes",
        model="gpt-4o-mini",
        system_prompt="You write Python code and implement features.",
    )

    doc_writer = Agent[None](
        name="doc_writer",
        description="Writes and updates technical documentation",
        model="gpt-4o-mini",
        system_prompt="You specialize in writing technical documentation.",
    )

    lazy_bob = Agent[None](
        name="lazy_bob",
        description="Has no useful skills or contributions",
        model="gpt-4o-mini",
        system_prompt="You avoid work at all costs.",
    )

    team_lead = Agent[None](
        name="team_lead",
        model="gpt-4o-mini",
        system_prompt="You assign work to team members based on their skills.",
    )
    feature_team = Team([developer, doc_writer, lazy_bob], picker=team_lead)
    print("\n=== Parallel Team Example ===")
    task = "Implement a new sort_by_date() function and document it in the API guide."
    async for msg in feature_team.run_iter(task):
        print(f"{msg.name}: {msg.content}")


if __name__ == "__main__":
    asyncio.run(main())
