import abc
from logging import getLogger
from abc import ABC, abstractmethod
from kass_flow.interfaces import (
    KassBillingPaymentResults as KassBillingPaymentResults,
    KassCallbackPaymentDict as KassCallbackPaymentDict,
    KassPaymentResponseDict as KassPaymentResponseDict,
    KassRequestPaymentDict as KassRequestPaymentDict,
)
from typing import Any, Tuple

logger  # type: ignore

class KassBillingBase(ABC, metaclass=abc.ABCMeta):
    kass_token: str = ...
    kass_url: str = ...
    kass_request_timeout: int = ...
    def __init__(self, kass_token: str, kass_url: str) -> None: ...
    @property
    def token(self) -> str: ...
    def create_signature(self, data: KassCallbackPaymentDict) -> str: ...
    def is_signature_valid(self, res: KassCallbackPaymentDict) -> bool: ...
    @abstractmethod
    def create_payment_token(self, payload: KassRequestPaymentDict) -> str: ...
    def dispatch(
        self, payload: KassRequestPaymentDict
    ) -> Tuple[KassBillingPaymentResults, bool]: ...

class KassBilling(KassBillingBase):
    def create_payment_token(self, payload: KassRequestPaymentDict) -> str: ...
