import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Cloud9::EnvironmentEC2`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html
 */
export interface CfnEnvironmentEC2Props {
    /**
     * `AWS::Cloud9::EnvironmentEC2.InstanceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.AutomaticStopTimeMinutes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-automaticstoptimeminutes
     */
    readonly automaticStopTimeMinutes?: number;
    /**
     * `AWS::Cloud9::EnvironmentEC2.ConnectionType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-connectiontype
     */
    readonly connectionType?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-description
     */
    readonly description?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.ImageId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-imageid
     */
    readonly imageId?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-name
     */
    readonly name?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.OwnerArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-ownerarn
     */
    readonly ownerArn?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Repositories`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-repositories
     */
    readonly repositories?: Array<CfnEnvironmentEC2.RepositoryProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Cloud9::EnvironmentEC2.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-subnetid
     */
    readonly subnetId?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Cloud9::EnvironmentEC2`.
 *
 * @external
 * @cloudformationResource AWS::Cloud9::EnvironmentEC2
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html
 */
export declare class CfnEnvironmentEC2 extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cloud9::EnvironmentEC2";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEnvironmentEC2;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.InstanceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-instancetype
     */
    instanceType: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.AutomaticStopTimeMinutes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-automaticstoptimeminutes
     */
    automaticStopTimeMinutes: number | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.ConnectionType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-connectiontype
     */
    connectionType: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-description
     */
    description: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.ImageId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-imageid
     */
    imageId: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-name
     */
    name: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.OwnerArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-ownerarn
     */
    ownerArn: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Repositories`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-repositories
     */
    repositories: Array<CfnEnvironmentEC2.RepositoryProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-subnetid
     */
    subnetId: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Cloud9::EnvironmentEC2`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEnvironmentEC2Props);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Cloud9::EnvironmentEC2`.
 *
 * @external
 * @cloudformationResource AWS::Cloud9::EnvironmentEC2
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html
 */
export declare namespace CfnEnvironmentEC2 {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html
     */
    interface RepositoryProperty {
        /**
         * `CfnEnvironmentEC2.RepositoryProperty.PathComponent`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
         */
        readonly pathComponent: string;
        /**
         * `CfnEnvironmentEC2.RepositoryProperty.RepositoryUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
         */
        readonly repositoryUrl: string;
    }
}
