
import dash_core_components as dcc
import dash_html_components as html

from phi.viz.dash.player_controls import STEP_BUTTON, STEP_COMPLETE
from .dash_app import DashApp
from dash.dependencies import Input, Output


def build_log(dashapp):
    assert isinstance(dashapp, DashApp)

    layout = html.Div([
        html.Button('Refresh', id='log-refresh'),
        html.Div(id='log-dump', style={'background-color': '#F0F0F0'}, children=[
        ]),
        dcc.Interval(id='initialize-log', interval=200, max_intervals=1)
    ])

    @dashapp.dash.callback(Output('log-dump', 'children'), [STEP_COMPLETE, Input('initialize-log', 'n_intervals'), Input('log-refresh', 'n_clicks')])
    def refresh_log(*args):
        try:
            log_file = dashapp.app.log_file
            with open(log_file, 'r') as stream:
                log_text = stream.read()
            paragraphs = log_text.split('\n')
            return [html.P(paragraph) for paragraph in paragraphs]
        except BaseException as exc:
            return 'Could not load log file: %s' % exc

    return layout
