"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManualApprovalAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const iam = require("@aws-cdk/aws-iam");
const sns = require("@aws-cdk/aws-sns");
const subs = require("@aws-cdk/aws-sns-subscriptions");
const action_1 = require("./action");
/**
 * Manual approval action.
 *
 * @stability stable
 */
class ManualApprovalAction extends action_1.Action {
    /**
     * @stability stable
     */
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 0, maxOutputs: 0 },
        });
        this.props = props;
    }
    /**
     * @stability stable
     */
    get notificationTopic() {
        return this._notificationTopic;
    }
    /**
     * grant the provided principal the permissions to approve or reject this manual approval action.
     *
     * For more info see:
     * https://docs.aws.amazon.com/codepipeline/latest/userguide/approvals-iam-permissions.html
     *
     * @param grantable the grantable to attach the permissions to.
     * @stability stable
     */
    grantManualApproval(grantable) {
        if (!this.stage) {
            throw new Error('Cannot grant permissions before binding action to a stage');
        }
        grantable.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['codepipeline:ListPipelines'],
            resources: ['*'],
        }));
        grantable.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['codepipeline:GetPipeline', 'codepipeline:GetPipelineState', 'codepipeline:GetPipelineExecution'],
            resources: [this.stage.pipeline.pipelineArn],
        }));
        grantable.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['codepipeline:PutApprovalResult'],
            resources: [`${this.stage.pipeline.pipelineArn}/${this.stage.stageName}/${this.props.actionName}`],
        }));
    }
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     *
     * @stability stable
     */
    bound(scope, stage, options) {
        var _b;
        if (this.props.notificationTopic) {
            this._notificationTopic = this.props.notificationTopic;
        }
        else if ((this.props.notifyEmails || []).length > 0) {
            this._notificationTopic = new sns.Topic(scope, 'TopicResource');
        }
        if (this._notificationTopic) {
            this._notificationTopic.grantPublish(options.role);
            for (const notifyEmail of this.props.notifyEmails || []) {
                this._notificationTopic.addSubscription(new subs.EmailSubscription(notifyEmail));
            }
        }
        this.stage = stage;
        return {
            configuration: undefinedIfAllValuesAreEmpty({
                NotificationArn: (_b = this._notificationTopic) === null || _b === void 0 ? void 0 : _b.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            }),
        };
    }
}
exports.ManualApprovalAction = ManualApprovalAction;
_a = JSII_RTTI_SYMBOL_1;
ManualApprovalAction[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.ManualApprovalAction", version: "1.125.0" };
function undefinedIfAllValuesAreEmpty(object) {
    return Object.values(object).some(v => v !== undefined) ? object : undefined;
}
//# sourceMappingURL=data:application/json;base64,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