from setuptools import setup

setup(
    name='pytest-parametrized',
    version='1.3',
    description='Pytest plugin for parametrizing tests with default iterables.',
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    author='Aric Coady',
    author_email='aric.coady@gmail.com',
    url='https://github.com/coady/pytest-parametrized',
    license='Apache Software License',
    py_modules=['parametrized'],
    install_requires=['pytest'],
    python_requires='>=3.6',
    tests_require=['pytest-cov'],
    keywords='pytest parametrize fixture',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Framework :: Pytest',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: Apache Software License',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Topic :: Software Development :: Testing',
    ],
)
