from abc import ABC, abstractmethod
from typing import List, Any, Dict
from swarmauri_core.chains.IChain import IChain
from swarmauri_core.chains.IChainStep import IChainStep


class IChainFactory(ABC):
    """
    Interface for creating and managing execution chains within the system.
    """

    @abstractmethod
    def create_chain(self, steps: List[IChainStep] = None) -> IChain:
        pass

    @abstractmethod
    def get_chain(self) -> IChain:
        pass

    @abstractmethod
    def set_chain(self, chain: IChain):
        pass

    @abstractmethod
    def reset_chain(self):
        pass

    @abstractmethod
    def get_chain_steps(self) -> List[IChainStep]:
        pass

    @abstractmethod
    def set_chain_steps(self, steps: List[IChainStep]):
        pass

    @abstractmethod
    def add_chain_step(self, step: IChainStep):
        pass

    @abstractmethod
    def remove_chain_step(self, key: str):
        pass

    @abstractmethod
    def get_configs(self) -> Dict[str, Any]:
        pass

    @abstractmethod
    def set_configs(self, **configs):
        pass

    @abstractmethod
    def get_config(self, key: str) -> Any:
        pass

    @abstractmethod
    def set_config(self, key: str, value: Any):
        pass
