# Pycurtain

A community-maintained python package for wrapping a variety of REST API calls for a variety of different AI art models.  Think "curtain" like what is seen in an art gallery. This tool lets the developer close the curtains and only focus on implementing one code base for any supported AI art models.

![](pycurtain.png?raw=true)

# Install

```
pip install pycurtain
```

# AI MODELS SUPPORTED

Currently all supported AI Models require an API key generated from the REST API host. Pycurtain is a third-party (open-source / community driven) python wrapper SDK and is not associated with any of the AI Model providers.  Each API key can be generated by signing up from the AI Model hosting site. The current implementation requires each (in-use) API key to be set in the environment variables following the secrets\stuff.py format.  

No API Key or private information is stored by Pycurtain.

## Sources

* deep_ai <https://deepai.org/>
* stability_sdk <https://stability.ai/>

# Road Map

* provide prelimiary wrappers for these AI model sources
  * open-ai dalle2 <https://openai.com/>
  * craiyon <https://www.craiyon.com/>
  * replicate_ai <https://replicate.com/>
  * hugging_face <https://huggingface.co/>
  * ~stability_ai~
  * ~deep_ai~
* allow users to adjust common parameters between models
* provide utility features beyond the model wrapper
  * equirectangluar images (360 degree images)
  * simple inpainting mask creation
* beyond images... videos, text, audio.  All leveraging the available REST API accessible ML models of today.

# Developing Pycurtain

To install pycurtain, along with the tools you need to develop and run test, run the following in your virtual environment:

```
pip install -e .[dev]

```
