"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineStack = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const pipeline_1 = require("aws-prototyping-sdk/pipeline");
class PipelineStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.pipeline = new pipeline_1.PDKPipeline(this, 'ApplicationPipeline', {
            primarySynthDirectory: 'packages/infra/cdk.out',
            repositoryName: this.node.tryGetContext('repositoryName') || 'monorepo',
            publishAssetsInParallel: false,
            crossAccountKeys: true,
            synth: {},
            sonarCodeScannerConfig: this.node.tryGetContext('sonarqubeScannerConfig'),
        });
    }
}
exports.PipelineStack = PipelineStack;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlwZWxpbmUtc3RhY2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcGlwZWxpbmUtc3RhY2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsNkNBQWdEO0FBQ2hELDJEQUEyRDtBQUczRCxNQUFhLGFBQWMsU0FBUSxtQkFBSztJQUd0QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWlCO1FBQ3pELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXhCLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxzQkFBVyxDQUFDLElBQUksRUFBRSxxQkFBcUIsRUFBRTtZQUMzRCxxQkFBcUIsRUFBRSx3QkFBd0I7WUFDL0MsY0FBYyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLGdCQUFnQixDQUFDLElBQUksVUFBVTtZQUN2RSx1QkFBdUIsRUFBRSxLQUFLO1lBQzlCLGdCQUFnQixFQUFFLElBQUk7WUFDdEIsS0FBSyxFQUFFLEVBQUU7WUFDVCxzQkFBc0IsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyx3QkFBd0IsQ0FBQztTQUMxRSxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFmRCxzQ0FlQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0YWNrLCBTdGFja1Byb3BzIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgUERLUGlwZWxpbmUgfSBmcm9tICdhd3MtcHJvdG90eXBpbmctc2RrL3BpcGVsaW5lJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgY2xhc3MgUGlwZWxpbmVTdGFjayBleHRlbmRzIFN0YWNrIHtcbiAgcmVhZG9ubHkgcGlwZWxpbmU6IFBES1BpcGVsaW5lO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTdGFja1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG5cbiAgICB0aGlzLnBpcGVsaW5lID0gbmV3IFBES1BpcGVsaW5lKHRoaXMsICdBcHBsaWNhdGlvblBpcGVsaW5lJywge1xuICAgICAgcHJpbWFyeVN5bnRoRGlyZWN0b3J5OiAncGFja2FnZXMvaW5mcmEvY2RrLm91dCcsXG4gICAgICByZXBvc2l0b3J5TmFtZTogdGhpcy5ub2RlLnRyeUdldENvbnRleHQoJ3JlcG9zaXRvcnlOYW1lJykgfHwgJ21vbm9yZXBvJyxcbiAgICAgIHB1Ymxpc2hBc3NldHNJblBhcmFsbGVsOiBmYWxzZSxcbiAgICAgIGNyb3NzQWNjb3VudEtleXM6IHRydWUsXG4gICAgICBzeW50aDoge30sXG4gICAgICBzb25hckNvZGVTY2FubmVyQ29uZmlnOiB0aGlzLm5vZGUudHJ5R2V0Q29udGV4dCgnc29uYXJxdWJlU2Nhbm5lckNvbmZpZycpLFxuICAgIH0pO1xuICB9XG59Il19