/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pbf2.v0_6;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.v0_6.RunnableSourceManager;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.pbf2.v0_6.PbfReader;

public class PbfReaderFactory
extends TaskManagerFactory {
    private static final Logger LOG = Logger.getLogger(PbfReaderFactory.class.getName());
    private static final String ARG_FILE_NAME = "file";
    private static final String DEFAULT_FILE_NAME = "dump.osm.pbf";
    private static final String ARG_WORKERS = "workers";
    private static final int DEFAULT_WORKERS = 0;
    private static final String ARG_PROXY_HTTP = "proxy";
    private static final String ARG_HTTP_TIMEOUT = "httpTimeout";
    private static final String ARG_HTTP_READ_TIMEOUT = "httpReadTimeout";
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int DEFAULT_READ_TIMEOUT = 60000;
    private static final String FILE_POSTFIX = ".temp.pbf";

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        File file;
        int workers;
        block8: {
            String fileName = this.getStringArgument(taskConfig, ARG_FILE_NAME, this.getDefaultStringArgument(taskConfig, DEFAULT_FILE_NAME));
            workers = this.getIntegerArgument(taskConfig, ARG_WORKERS, 0);
            if (fileName.startsWith("http")) {
                String[] proxy = this.getStringArgument(taskConfig, ARG_PROXY_HTTP, "").split(":");
                String proxyHttp = proxy[0];
                int proxyPort = proxy.length > 1 ? Integer.valueOf(proxy[1]) : -1;
                int timeout = this.getIntegerArgument(taskConfig, ARG_HTTP_TIMEOUT, 60000);
                int readTimeout = this.getIntegerArgument(taskConfig, ARG_HTTP_READ_TIMEOUT, 60000);
                HttpURLConnection connection = null;
                try {
                    String fileLocation = FileUtils.getTempDirectoryPath() + File.separator + System.currentTimeMillis() + FILE_POSTFIX;
                    file = new File(fileLocation);
                    URL remoteFile = new URL(fileName);
                    connection = this.getURLConnection(remoteFile, proxyHttp, proxyPort, timeout, readTimeout);
                    int remoteFileLength = this.getRemoteFileSize(remoteFile, proxyHttp, proxyPort, timeout, readTimeout);
                    LOG.info(String.format("Downloading file %s...", fileName));
                    FileUtils.copyInputStreamToFile((InputStream)connection.getInputStream(), (File)file);
                    if ((long)remoteFileLength != file.length()) {
                        throw new RuntimeException(String.format("Remote file [%s] size [%d] is not equals to local file [%s] size [%d]", fileName, remoteFileLength, fileLocation, file.length()));
                    }
                    break block8;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
            file = new File(fileName);
        }
        PbfReader task = new PbfReader(file, workers);
        return new RunnableSourceManager(taskConfig.getId(), (RunnableSource)task, taskConfig.getPipeArgs());
    }

    private int getRemoteFileSize(URL url, String proxyString, int proxyPort, int timeout, int readTimeout) {
        HttpURLConnection connection = null;
        try {
            connection = this.getURLConnection(url, proxyString, proxyPort, timeout, readTimeout);
            connection.setRequestMethod("HEAD");
            connection.getInputStream();
            int n = connection.getContentLength();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private HttpURLConnection getURLConnection(URL url, String proxyString, int proxyPort, int timeout, int readTimeout) throws IOException {
        Proxy proxy = null;
        if (!Strings.isNullOrEmpty((String)proxyString)) {
            InetSocketAddress address = new InetSocketAddress(proxyString, proxyPort);
            proxy = new Proxy(Proxy.Type.HTTP, address);
        }
        HttpURLConnection connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(readTimeout);
        return connection;
    }
}

