/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.DatabaseCapabilityChecker;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityFeatureDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.WayMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.WayNodeMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.WayReader;

public class WayDao
extends EntityDao<Way> {
    private static final String SQL_UPDATE_WAY_BBOX = "UPDATE ways SET bbox = ( SELECT ST_Envelope(ST_Collect(geom)) FROM nodes JOIN way_nodes ON way_nodes.node_id = nodes.id WHERE way_nodes.way_id = ways.id ) WHERE ways.id = ?";
    private static final String SQL_UPDATE_WAY_LINESTRING = "UPDATE ways w SET linestring = ( SELECT ST_MakeLine(c.geom) AS way_line FROM ( SELECT n.geom AS geom FROM nodes n INNER JOIN way_nodes wn ON n.id = wn.node_id WHERE (wn.way_id = w.id) ORDER BY wn.sequence_id ) c ) WHERE w.id  = ?";
    private DatabaseCapabilityChecker capabilityChecker;
    private EntityFeatureDao<WayNode, DbOrderedFeature<WayNode>> wayNodeDao;
    private PreparedStatement updateWayBboxStatement;
    private PreparedStatement updateWayLinestringStatement;

    public WayDao(DatabaseContext dbCtx, ActionDao actionDao) {
        super(dbCtx, new WayMapper(), actionDao);
        this.capabilityChecker = new DatabaseCapabilityChecker(dbCtx);
        this.wayNodeDao = new EntityFeatureDao(dbCtx, new WayNodeMapper());
    }

    @Override
    protected void loadFeatures(long entityId, Way entity) {
        entity.getWayNodes().addAll(this.wayNodeDao.getAllRaw(entityId));
    }

    private void addWayNodeList(long entityId, List<WayNode> wayNodeList) {
        ArrayList<DbOrderedFeature> dbList = new ArrayList<DbOrderedFeature>(wayNodeList.size());
        for (int i = 0; i < wayNodeList.size(); ++i) {
            dbList.add(new DbOrderedFeature(entityId, (Storeable)wayNodeList.get(i), i));
        }
        this.wayNodeDao.addAll(dbList);
    }

    private void updateWayGeometries(long wayId) {
        int prmIndex;
        if (this.capabilityChecker.isWayBboxSupported()) {
            if (this.updateWayBboxStatement == null) {
                this.updateWayBboxStatement = this.prepareStatement(SQL_UPDATE_WAY_BBOX);
            }
            try {
                prmIndex = 1;
                this.updateWayBboxStatement.setLong(prmIndex++, wayId);
                this.updateWayBboxStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Update bbox failed for way " + wayId + ".");
            }
        }
        if (this.capabilityChecker.isWayLinestringSupported()) {
            if (this.updateWayLinestringStatement == null) {
                this.updateWayLinestringStatement = this.prepareStatement(SQL_UPDATE_WAY_LINESTRING);
            }
            try {
                prmIndex = 1;
                this.updateWayLinestringStatement.setLong(prmIndex++, wayId);
                this.updateWayLinestringStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Update linestring failed for way " + wayId + ".");
            }
        }
    }

    @Override
    public void addEntity(Way entity) {
        super.addEntity(entity);
        this.addWayNodeList(entity.getId(), entity.getWayNodes());
        this.updateWayGeometries(entity.getId());
    }

    @Override
    public void modifyEntity(Way entity) {
        super.modifyEntity(entity);
        long wayId = entity.getId();
        this.wayNodeDao.removeList(wayId);
        this.addWayNodeList(entity.getId(), entity.getWayNodes());
        this.updateWayGeometries(entity.getId());
    }

    @Override
    public void removeEntity(long entityId) {
        this.wayNodeDao.removeList(entityId);
        super.removeEntity(entityId);
    }

    @Override
    public ReleasableIterator<Way> iterate() {
        return new WayReader(this.getDatabaseContext());
    }
}

