/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.database.DatabaseLocker;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.common.SchemaVersionValidator;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionChangeWriter;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ChangeWriter;

public class PostgreSqlChangeWriter
implements ChangeSink {
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ChangeWriter changeWriter;
    private Map<ChangeAction, ActionChangeWriter> actionWriterMap;
    private DatabaseContext dbCtx;
    private SchemaVersionValidator schemaVersionValidator;
    private boolean initialized;
    private final Set<Long> appliedChangeSets;
    private long earliestTimestamp = 9999999999999L;
    private long latestTimestamp = 0L;
    private final Map<String, Integer> modifications;
    private final DatabaseLocker locker;

    public PostgreSqlChangeWriter(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, boolean keepInvalidWays, boolean logging) {
        this.dbCtx = new DatabaseContext(loginCredentials);
        this.changeWriter = new ChangeWriter(this.dbCtx, logging);
        this.actionWriterMap = new HashMap<ChangeAction, ActionChangeWriter>();
        this.actionWriterMap.put(ChangeAction.Create, new ActionChangeWriter(this.changeWriter, ChangeAction.Create, keepInvalidWays));
        this.actionWriterMap.put(ChangeAction.Modify, new ActionChangeWriter(this.changeWriter, ChangeAction.Modify, keepInvalidWays));
        this.actionWriterMap.put(ChangeAction.Delete, new ActionChangeWriter(this.changeWriter, ChangeAction.Delete, keepInvalidWays));
        this.schemaVersionValidator = new SchemaVersionValidator(this.dbCtx.getJdbcTemplate(), preferences);
        this.appliedChangeSets = new HashSet<Long>();
        this.modifications = new HashMap<String, Integer>();
        this.initialized = false;
        this.locker = new DatabaseLocker(this.dbCtx.getDataSource(), true);
    }

    private void initialize() {
        if (!this.initialized) {
            this.locker.lockDatabase(this.getClass().getSimpleName());
            this.dbCtx.beginTransaction();
            this.initialized = true;
        }
    }

    public void initialize(Map<String, Object> metaData) {
    }

    public void process(ChangeContainer change) {
        this.initialize();
        this.schemaVersionValidator.validateVersion(6);
        ChangeAction action = change.getAction();
        if (!this.actionWriterMap.containsKey(action)) {
            throw new OsmosisRuntimeException("The action " + action + " is unrecognized.");
        }
        Entity entity = change.getEntityContainer().getEntity();
        this.appliedChangeSets.add(entity.getChangesetId());
        this.earliestTimestamp = Math.min(this.earliestTimestamp, entity.getTimestamp().getTime());
        this.latestTimestamp = Math.max(this.latestTimestamp, entity.getTimestamp().getTime());
        String name = entity.getType().name() + "-" + action.name();
        int count = this.modifications.getOrDefault(name, 0) + 1;
        this.modifications.put(name, count);
        change.getEntityContainer().process((EntityProcessor)this.actionWriterMap.get(action));
    }

    public void complete() {
        this.initialize();
        this.changeWriter.complete();
        this.dbCtx.getJdbcTemplate().execute(String.format("INSERT INTO replication_changes (nodes_added, nodes_modified, nodes_deleted, ways_added, ways_modified, ways_deleted, relations_added, relations_modified, relations_deleted, changesets_applied, earliest_timestamp, latest_timestamp) VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, ARRAY[%s]::BIGINT[], '%s', '%s')", this.modifications.getOrDefault(EntityType.Node.name() + "-" + ChangeAction.Create, 0), this.modifications.getOrDefault(EntityType.Node.name() + "-" + ChangeAction.Modify, 0), this.modifications.getOrDefault(EntityType.Node.name() + "-" + ChangeAction.Delete, 0), this.modifications.getOrDefault(EntityType.Way.name() + "-" + ChangeAction.Create, 0), this.modifications.getOrDefault(EntityType.Way.name() + "-" + ChangeAction.Modify, 0), this.modifications.getOrDefault(EntityType.Way.name() + "-" + ChangeAction.Delete, 0), this.modifications.getOrDefault(EntityType.Relation.name() + "-" + ChangeAction.Create, 0), this.modifications.getOrDefault(EntityType.Relation.name() + "-" + ChangeAction.Modify, 0), this.modifications.getOrDefault(EntityType.Relation.name() + "-" + ChangeAction.Delete, 0), this.appliedChangeSets.stream().map(id -> id + "").collect(Collectors.joining(",")), FORMATTER.format(new Date(this.earliestTimestamp)), FORMATTER.format(new Date(this.latestTimestamp))));
        this.dbCtx.commitTransaction();
    }

    public void close() {
        this.locker.unlockDatabase();
        this.changeWriter.release();
        this.dbCtx.close();
    }
}

