/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.io.DataInputStream;
import org.openstreetmap.osmosis.core.store.ObjectReader;
import org.openstreetmap.osmosis.core.store.ObjectStreamIterator;
import org.openstreetmap.osmosis.core.store.Storeable;

public class SubObjectStreamIterator<T extends Storeable>
extends ObjectStreamIterator<T> {
    private long maxObjectCount;
    private long objectCount;

    public SubObjectStreamIterator(DataInputStream inStream, ObjectReader objectReader, long maxObjectCount) {
        super(inStream, objectReader);
        this.maxObjectCount = maxObjectCount;
        this.objectCount = 0L;
    }

    @Override
    public boolean hasNext() {
        if (this.objectCount >= this.maxObjectCount) {
            return false;
        }
        return super.hasNext();
    }

    @Override
    public T next() {
        Storeable result = (Storeable)super.next();
        ++this.objectCount;
        return (T)result;
    }
}

