/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.database;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DatabaseLocker
implements AutoCloseable {
    private static Logger logger = Logger.getLogger(DatabaseLocker.class.getSimpleName());
    private final DataSource source;
    private final boolean writeLock;
    private boolean enabled = true;
    private int lockedIdentifier = -1;

    public static void fullUnlockDatabase(DataSource source) {
        DatabaseLocker.unlockDatabase(-1, source);
    }

    private static void unlockDatabase(int identifier, DataSource source) {
        try (Connection connection = source.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT unlock_database(?)");){
            boolean unlocked;
            statement.setInt(1, identifier);
            ResultSet result = statement.executeQuery();
            if (result.next() && (unlocked = result.getBoolean(1))) {
                logger.info(String.format("Unlocked database using identifier %d.", identifier));
                return;
            }
            throw new RuntimeException("Failed to unlock the database");
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to unlock the database", e);
        }
    }

    public DatabaseLocker(DataSource source, boolean writeLock) {
        this.source = source;
        this.writeLock = writeLock;
        try (Connection connection = source.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeQuery("SELECT 'lock_database'::regproc, 'unlock_database'::regproc");
        }
        catch (Exception e) {
            logger.warning("Locking functions do not exist in database. Disabling locking.");
            this.enabled = false;
        }
    }

    public void lockDatabase(String process) {
        this.lockDatabase(process, "");
    }

    public void lockDatabase(String process, String description) {
        block17: {
            if (this.enabled) {
                String lockName = "read";
                if (this.writeLock) {
                    lockName = "write";
                }
                try (Connection connection = this.source.getConnection();
                     PreparedStatement statement = connection.prepareStatement("SELECT lock_database(?, ?, ?, ?)");){
                    statement.setString(1, process);
                    statement.setString(2, description);
                    statement.setString(3, InetAddress.getLocalHost().getHostName());
                    statement.setBoolean(4, this.writeLock);
                    ResultSet result = statement.executeQuery();
                    if (result.next()) {
                        this.lockedIdentifier = result.getInt(1);
                        logger.info(String.format("Obtained %s lock to database for process: %s from source: '%s', with lockedID: %d", lockName, process, description, this.lockedIdentifier));
                        break block17;
                    }
                    throw new RuntimeException("Failed to retrieve lock for the database.");
                }
                catch (UnknownHostException | SQLException e) {
                    throw new RuntimeException("Failed to lock the database.", e);
                }
            }
        }
    }

    public void unlockDatabase() {
        if (this.enabled && this.lockedIdentifier > 0) {
            DatabaseLocker.unlockDatabase(this.lockedIdentifier, this.source);
        }
    }

    public void fullUnlockDatabase() {
        if (this.enabled) {
            DatabaseLocker.fullUnlockDatabase(this.source);
        }
    }

    @Override
    public void close() throws Exception {
        this.unlockDatabase();
    }
}

