/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.openstreetmap.osmosis.apidb.v0_6.impl.MemberTypeParser;
import org.openstreetmap.osmosis.core.database.RowMapperListener;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.springframework.jdbc.core.RowCallbackHandler;

public class RelationMemberRowMapper
implements RowCallbackHandler {
    private RowMapperListener<RelationMember> listener;
    private MemberTypeParser memberTypeParser;

    public RelationMemberRowMapper(RowMapperListener<RelationMember> listener) {
        this.listener = listener;
        this.memberTypeParser = new MemberTypeParser();
    }

    public void processRow(ResultSet resultSet) throws SQLException {
        long memberId = resultSet.getLong("member_id");
        EntityType memberType = this.memberTypeParser.parse(resultSet.getString("member_type"));
        String memberRole = resultSet.getString("member_role");
        RelationMember relationMember = new RelationMember(memberId, memberType, memberRole);
        this.listener.process((Object)relationMember, resultSet);
    }
}

