/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6;

import java.util.Date;
import org.openstreetmap.osmosis.apidb.v0_6.ApidbChangeReader;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.database.DatabaseTaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.v0_6.RunnableChangeSourceManager;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableChangeSource;

public class ApidbChangeReaderFactory
extends DatabaseTaskManagerFactory {
    private static final String ARG_INTERVAL_BEGIN = "intervalBegin";
    private static final String ARG_INTERVAL_END = "intervalEnd";
    private static final String ARG_READ_FULL_HISTORY = "readFullHistory";
    private static final boolean DEFAULT_READ_FULL_HISTORY = false;

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        DatabaseLoginCredentials loginCredentials = this.getDatabaseLoginCredentials(taskConfig);
        DatabasePreferences preferences = this.getDatabasePreferences(taskConfig);
        Date intervalBegin = this.getDateArgument(taskConfig, ARG_INTERVAL_BEGIN, new Date(0L));
        Date intervalEnd = this.getDateArgument(taskConfig, ARG_INTERVAL_END, new Date());
        boolean fullHistory = this.getBooleanArgument(taskConfig, ARG_READ_FULL_HISTORY, false);
        return new RunnableChangeSourceManager(taskConfig.getId(), (RunnableChangeSource)new ApidbChangeReader(loginCredentials, preferences, intervalBegin, intervalEnd, fullHistory), taskConfig.getPipeArgs());
    }
}

