"""
    UniCourt Enterprise APIs

    <button><a href=\"/enterpriseapi/download/UniCourt-Enterprise-API-Spec.yaml\" >Download UniCourt Enterprise APIs Specification</a></button>   # noqa: E501

    The version of the OpenAPI document: 
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from unicourt.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from unicourt.exceptions import ApiAttributeError


def lazy_import():
    from unicourt.model.preview_document import PreviewDocument
    globals()['PreviewDocument'] = PreviewDocument


class CaseDocument(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('estimated_order_duration',): {
            'ESTIMATEUNAVAILABLE': "estimateUnavailable",
            'WITHINMINUTES': "withinMinutes",
            'WITHINHOURS': "withinHours",
            'WITHINDAYS': "withinDays",
            'WITHINWEEKS': "withinWeeks",
        },
        ('source_data_status',): {
            'None': None,
            'NO_LONGER_AVAILABLE_IN_COURT': "NO_LONGER_AVAILABLE_IN_COURT",
            'SOURCE_DEPRECATED': "SOURCE_DEPRECATED",
            'SEALED': "SEALED",
            'NULL': "null",
        },
    }

    validations = {
        ('object',): {
            'max_length': 12,
            'min_length': 12,
        },
        ('case_document_id',): {
            'max_length': 18,
            'min_length': 18,
        },
        ('name',): {
            'max_length': 255,
        },
        ('description',): {
            'max_length': 100000,
        },
        ('document_filed_date',): {
            'max_length': 25,
            'min_length': 25,
        },
        ('parent_document_id',): {
            'max_length': 18,
            'min_length': 18,
        },
        ('added_to_library_date',): {
            'max_length': 25,
            'min_length': 25,
        },
        ('estimated_order_duration',): {
            'max_length': 25,
            'min_length': 10,
        },
        ('download_api',): {
            'max_length': 255,
        },
        ('first_fetch_date',): {
            'max_length': 25,
            'min_length': 25,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = True

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'object': (str,),  # noqa: E501
            'case_document_id': (str,),  # noqa: E501
            'sort_order': (int, none_type,),  # noqa: E501
            'name': (str, none_type,),  # noqa: E501
            'description': (str, none_type,),  # noqa: E501
            'document_filed_date': (str, none_type,),  # noqa: E501
            'parent_document_id': (str, none_type,),  # noqa: E501
            'child_document_id_array': ([str, none_type],),  # noqa: E501
            'pages': (int, none_type,),  # noqa: E501
            'is_preview_available': (bool,),  # noqa: E501
            'preview_document': (PreviewDocument,),  # noqa: E501
            'price': (float, none_type,),  # noqa: E501
            'in_library': (bool,),  # noqa: E501
            'added_to_library_date': (str, none_type,),  # noqa: E501
            'estimated_order_duration': (str,),  # noqa: E501
            'download_api': (str, none_type,),  # noqa: E501
            'first_fetch_date': (str,),  # noqa: E501
            'source_data_status': (str, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'object': 'object',  # noqa: E501
        'case_document_id': 'caseDocumentId',  # noqa: E501
        'sort_order': 'sortOrder',  # noqa: E501
        'name': 'name',  # noqa: E501
        'description': 'description',  # noqa: E501
        'document_filed_date': 'documentFiledDate',  # noqa: E501
        'parent_document_id': 'parentDocumentId',  # noqa: E501
        'child_document_id_array': 'childDocumentIdArray',  # noqa: E501
        'pages': 'pages',  # noqa: E501
        'is_preview_available': 'isPreviewAvailable',  # noqa: E501
        'preview_document': 'previewDocument',  # noqa: E501
        'price': 'price',  # noqa: E501
        'in_library': 'inLibrary',  # noqa: E501
        'added_to_library_date': 'addedToLibraryDate',  # noqa: E501
        'estimated_order_duration': 'estimatedOrderDuration',  # noqa: E501
        'download_api': 'downloadAPI',  # noqa: E501
        'first_fetch_date': 'firstFetchDate',  # noqa: E501
        'source_data_status': 'sourceDataStatus',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, case_document_id, sort_order, name, description, document_filed_date, parent_document_id, child_document_id_array, pages, is_preview_available, preview_document, price, in_library, added_to_library_date, download_api, first_fetch_date, source_data_status, *args, **kwargs):  # noqa: E501
        """CaseDocument - a model defined in OpenAPI

        Args:
            case_document_id (str): UniCourt's Case Document ID.
            sort_order (int, none_type): Order of documents how it is being stored in UniCourt.
            name (str, none_type): Document name.
            description (str, none_type): Description of the document.
            document_filed_date (str, none_type): Document Date when it was filed. The document date will be either explicitly provided byt the court or if the document is associatated to a docket entry then the document date will be of docket entry date.
            parent_document_id (str, none_type): Document ID which is the parent document for the current document. This will be null if the current document is a parent document.
            child_document_id_array ([str, none_type]): List of child document ID's if exists or else it will be an empty lsit.
            pages (int, none_type): Total number of pages in the document.
            is_preview_available (bool): Determines if a preview is available for the case document.
            preview_document (PreviewDocument):
            price (float, none_type): Price of the document.
            in_library (bool): Determines if the document is present in the UniCourt Library or not.
            added_to_library_date (str, none_type): Date and time when the document was downloaded and added to the UniCourt Crowd Source Library.
            download_api (str, none_type): Link to either view the document if it is downloaded and already present in the UniCourt CrowdSourced Library.
            first_fetch_date (str): Is the date when the document was first fetched from the court site.
            source_data_status (str, none_type): The status of source data of document. If the value of sourceDataStatus is SOURCE_DEPRECATED then it means that the Document has been migrated from old court site to a new court site and the data being shown in the API response is from a old court site. If the sourceDataStatus is NO_LONGER_AVAILABLE_IN_COURT then it means that a particular case is invalid in the court site.

        Keyword Args:
            object (str): Name of the object. defaults to "CaseDocument"  # noqa: E501
            estimated_order_duration (str): Estimated duration of a Order.. defaults to "estimateUnavailable", must be one of ["estimateUnavailable", "withinMinutes", "withinHours", "withinDays", "withinWeeks", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        object = kwargs.get('object', "CaseDocument")
        estimated_order_duration = kwargs.get('estimated_order_duration', "estimateUnavailable")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.object = object
        self.case_document_id = case_document_id
        self.sort_order = sort_order
        self.name = name
        self.description = description
        self.document_filed_date = document_filed_date
        self.parent_document_id = parent_document_id
        self.child_document_id_array = child_document_id_array
        self.pages = pages
        self.is_preview_available = is_preview_available
        self.preview_document = preview_document
        self.price = price
        self.in_library = in_library
        self.added_to_library_date = added_to_library_date
        self.estimated_order_duration = estimated_order_duration
        self.download_api = download_api
        self.first_fetch_date = first_fetch_date
        self.source_data_status = source_data_status
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, case_document_id, sort_order, name, description, document_filed_date, parent_document_id, child_document_id_array, pages, is_preview_available, preview_document, price, in_library, added_to_library_date, download_api, first_fetch_date, source_data_status, *args, **kwargs):  # noqa: E501
        """CaseDocument - a model defined in OpenAPI

        Args:
            case_document_id (str): UniCourt's Case Document ID.
            sort_order (int, none_type): Order of documents how it is being stored in UniCourt.
            name (str, none_type): Document name.
            description (str, none_type): Description of the document.
            document_filed_date (str, none_type): Document Date when it was filed. The document date will be either explicitly provided byt the court or if the document is associatated to a docket entry then the document date will be of docket entry date.
            parent_document_id (str, none_type): Document ID which is the parent document for the current document. This will be null if the current document is a parent document.
            child_document_id_array ([str, none_type]): List of child document ID's if exists or else it will be an empty lsit.
            pages (int, none_type): Total number of pages in the document.
            is_preview_available (bool): Determines if a preview is available for the case document.
            preview_document (PreviewDocument):
            price (float, none_type): Price of the document.
            in_library (bool): Determines if the document is present in the UniCourt Library or not.
            added_to_library_date (str, none_type): Date and time when the document was downloaded and added to the UniCourt Crowd Source Library.
            download_api (str, none_type): Link to either view the document if it is downloaded and already present in the UniCourt CrowdSourced Library.
            first_fetch_date (str): Is the date when the document was first fetched from the court site.
            source_data_status (str, none_type): The status of source data of document. If the value of sourceDataStatus is SOURCE_DEPRECATED then it means that the Document has been migrated from old court site to a new court site and the data being shown in the API response is from a old court site. If the sourceDataStatus is NO_LONGER_AVAILABLE_IN_COURT then it means that a particular case is invalid in the court site.

        Keyword Args:
            object (str): Name of the object. defaults to "CaseDocument"  # noqa: E501
            estimated_order_duration (str): Estimated duration of a Order.. defaults to "estimateUnavailable", must be one of ["estimateUnavailable", "withinMinutes", "withinHours", "withinDays", "withinWeeks", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        object = kwargs.get('object', "CaseDocument")
        estimated_order_duration = kwargs.get('estimated_order_duration', "estimateUnavailable")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.object = object
        self.case_document_id = case_document_id
        self.sort_order = sort_order
        self.name = name
        self.description = description
        self.document_filed_date = document_filed_date
        self.parent_document_id = parent_document_id
        self.child_document_id_array = child_document_id_array
        self.pages = pages
        self.is_preview_available = is_preview_available
        self.preview_document = preview_document
        self.price = price
        self.in_library = in_library
        self.added_to_library_date = added_to_library_date
        self.estimated_order_duration = estimated_order_duration
        self.download_api = download_api
        self.first_fetch_date = first_fetch_date
        self.source_data_status = source_data_status
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
