"""
    UniCourt Enterprise APIs

    <button><a href=\"/enterpriseapi/download/UniCourt-Enterprise-API-Spec.yaml\" >Download UniCourt Enterprise APIs Specification</a></button>   # noqa: E501

    The version of the OpenAPI document: 
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from unicourt.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from unicourt.exceptions import ApiAttributeError


def lazy_import():
    from unicourt.model.attorneys import Attorneys
    from unicourt.model.case_cause_of_action import CaseCauseOfAction
    from unicourt.model.case_charge import CaseCharge
    from unicourt.model.case_documents import CaseDocuments
    from unicourt.model.case_stats import CaseStats
    from unicourt.model.case_status import CaseStatus
    from unicourt.model.case_type import CaseType
    from unicourt.model.court import Court
    from unicourt.model.court_location import CourtLocation
    from unicourt.model.docket_entries import DocketEntries
    from unicourt.model.hearings import Hearings
    from unicourt.model.judges import Judges
    from unicourt.model.parties import Parties
    from unicourt.model.related_cases import RelatedCases
    from unicourt.model.source_case_data import SourceCaseData
    globals()['Attorneys'] = Attorneys
    globals()['CaseCauseOfAction'] = CaseCauseOfAction
    globals()['CaseCharge'] = CaseCharge
    globals()['CaseDocuments'] = CaseDocuments
    globals()['CaseStats'] = CaseStats
    globals()['CaseStatus'] = CaseStatus
    globals()['CaseType'] = CaseType
    globals()['Court'] = Court
    globals()['CourtLocation'] = CourtLocation
    globals()['DocketEntries'] = DocketEntries
    globals()['Hearings'] = Hearings
    globals()['Judges'] = Judges
    globals()['Parties'] = Parties
    globals()['RelatedCases'] = RelatedCases
    globals()['SourceCaseData'] = SourceCaseData


class Case(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('source_data_status',): {
            'None': None,
            'NO_LONGER_AVAILABLE_IN_COURT': "NO_LONGER_AVAILABLE_IN_COURT",
            'SOURCE_DEPRECATED': "SOURCE_DEPRECATED",
            'NULL': "null",
        },
    }

    validations = {
        ('object',): {
            'max_length': 4,
            'min_length': 4,
        },
        ('case_id',): {
            'max_length': 18,
            'min_length': 18,
        },
        ('url',): {
            'max_length': 500,
        },
        ('case_number',): {
            'max_length': 50,
            'min_length': 3,
        },
        ('case_name',): {
            'max_length': 250,
        },
        ('filed_date',): {
            'max_length': 25,
            'min_length': 25,
        },
        ('court_service_status_id',): {
            'max_length': 18,
            'min_length': 18,
        },
        ('court_service_status_api',): {
            'max_length': 250,
        },
        ('first_fetch_date',): {
            'max_length': 25,
            'min_length': 25,
        },
        ('last_fetch_date',): {
            'max_length': 25,
            'min_length': 25,
        },
        ('last_fetch_date_with_updates',): {
            'max_length': 25,
            'min_length': 25,
        },
        ('participants_last_fetch_date',): {
            'max_length': 25,
            'min_length': 25,
        },
        ('export_api',): {
            'max_length': 255,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = True

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'object': (str,),  # noqa: E501
            'case_id': (str,),  # noqa: E501
            'url': (str, none_type,),  # noqa: E501
            'case_number': (str,),  # noqa: E501
            'case_name': (str, none_type,),  # noqa: E501
            'filed_date': (datetime,),  # noqa: E501
            'has_only_meta_info': (bool,),  # noqa: E501
            'court_service_status_id': (str, none_type,),  # noqa: E501
            'court_service_status_api': (str, none_type,),  # noqa: E501
            'court': (Court,),  # noqa: E501
            'court_location': (CourtLocation,),  # noqa: E501
            'case_type': (CaseType,),  # noqa: E501
            'charge_array': ([CaseCharge],),  # noqa: E501
            'case_status': (CaseStatus,),  # noqa: E501
            'cause_of_action_array': ([CaseCauseOfAction],),  # noqa: E501
            'first_fetch_date': (datetime,),  # noqa: E501
            'last_fetch_date': (datetime,),  # noqa: E501
            'last_fetch_date_with_updates': (datetime,),  # noqa: E501
            'participants_last_fetch_date': (datetime, none_type,),  # noqa: E501
            'source_data_status': (str, none_type,),  # noqa: E501
            'source_case_data': (SourceCaseData,),  # noqa: E501
            'has_documents_with_preview': (bool,),  # noqa: E501
            'export_api': (str,),  # noqa: E501
            'case_stats': (CaseStats,),  # noqa: E501
            'parties': (Parties,),  # noqa: E501
            'attorneys': (Attorneys,),  # noqa: E501
            'judges': (Judges,),  # noqa: E501
            'docket_entries': (DocketEntries,),  # noqa: E501
            'hearings': (Hearings,),  # noqa: E501
            'case_documents': (CaseDocuments,),  # noqa: E501
            'related_cases': (RelatedCases,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'object': 'object',  # noqa: E501
        'case_id': 'caseId',  # noqa: E501
        'url': 'url',  # noqa: E501
        'case_number': 'caseNumber',  # noqa: E501
        'case_name': 'caseName',  # noqa: E501
        'filed_date': 'filedDate',  # noqa: E501
        'has_only_meta_info': 'hasOnlyMetaInfo',  # noqa: E501
        'court_service_status_id': 'courtServiceStatusId',  # noqa: E501
        'court_service_status_api': 'courtServiceStatusAPI',  # noqa: E501
        'court': 'court',  # noqa: E501
        'court_location': 'courtLocation',  # noqa: E501
        'case_type': 'caseType',  # noqa: E501
        'charge_array': 'chargeArray',  # noqa: E501
        'case_status': 'caseStatus',  # noqa: E501
        'cause_of_action_array': 'causeOfActionArray',  # noqa: E501
        'first_fetch_date': 'firstFetchDate',  # noqa: E501
        'last_fetch_date': 'lastFetchDate',  # noqa: E501
        'last_fetch_date_with_updates': 'lastFetchDateWithUpdates',  # noqa: E501
        'participants_last_fetch_date': 'participantsLastFetchDate',  # noqa: E501
        'source_data_status': 'sourceDataStatus',  # noqa: E501
        'source_case_data': 'sourceCaseData',  # noqa: E501
        'has_documents_with_preview': 'hasDocumentsWithPreview',  # noqa: E501
        'export_api': 'exportAPI',  # noqa: E501
        'case_stats': 'caseStats',  # noqa: E501
        'parties': 'parties',  # noqa: E501
        'attorneys': 'attorneys',  # noqa: E501
        'judges': 'judges',  # noqa: E501
        'docket_entries': 'docketEntries',  # noqa: E501
        'hearings': 'hearings',  # noqa: E501
        'case_documents': 'caseDocuments',  # noqa: E501
        'related_cases': 'relatedCases',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, case_id, url, case_number, case_name, filed_date, has_only_meta_info, court_service_status_id, court_service_status_api, court, court_location, case_type, charge_array, case_status, cause_of_action_array, first_fetch_date, last_fetch_date, last_fetch_date_with_updates, participants_last_fetch_date, source_data_status, source_case_data, has_documents_with_preview, export_api, case_stats, parties, attorneys, judges, docket_entries, hearings, case_documents, related_cases, *args, **kwargs):  # noqa: E501
        """Case - a model defined in OpenAPI

        Args:
            case_id (str): Unique identifier of Case.
            url (str, none_type): URL to the case page in UniCourt Application.
            case_number (str): Case number as provided by Court.
            case_name (str, none_type): Case name as provided by Court.
            filed_date (datetime): Filing date for the case provided by the Court. Formatted as YYYY-MM-DDTHH:MM:SS+ZZ:zz
            has_only_meta_info (bool): This field determines if this case object has only meta information. If the value is true and if the full information is required you would need to call the updateCase API.
            court_service_status_id (str, none_type): Court Service Status ID of the requested case where we can use it to get the service status
            court_service_status_api (str, none_type): API to get the service statuses of the given case.
            court (Court):
            court_location (CourtLocation):
            case_type (CaseType):
            charge_array ([CaseCharge]): Array of charges that are added to this case.
            case_status (CaseStatus):
            cause_of_action_array ([CaseCauseOfAction]): Array of cause of Actions that are added to this case.
            first_fetch_date (datetime): The date and time when the case was first fetched from the Court. This date and time is in UTC. Formatted as YYYY-MM-DDTHH:MM:SS+ZZ:zz,.
            last_fetch_date (datetime): The date and time when the case was last fetched from the Court. This date and time is in UTC. Formatted as YYYY-MM-DDTHH:MM:SS+ZZ:zz, Note: It is not necessary that every time the case is fetched from Court we find changes in the case information. It could be that we already have the latest information from the Court and no changes exist.
            last_fetch_date_with_updates (datetime): The date and time when the case was last fetched from the Court where we found changes in the case information. This date and time is in UTC. Formatted as YYYY-MM-DDTHH:MM:SS+ZZ:zz,
            participants_last_fetch_date (datetime, none_type): The date and time when parties/attorneys were last updated from the Court. Formatted as YYYY-MM-DDTHH:MM:SS+ZZ:zz, Note: This is currently applicable for Federal PACER cases since we have an option to exclude parties and fetch only latest docket entries when updating cases to save PACER fees.
            source_data_status (str, none_type): The status of source data of case. If the value of sourceDataStatus is SOURCE_DEPRECATED then it means that the Case has been migrated from old court site to a new court site and the data being shown in the API response is from a old court site. If the sourceDataStatus is NO_LONGER_AVAILABLE_IN_COURT then it means that a particular case is invalid in the court site.
            source_case_data (SourceCaseData):
            has_documents_with_preview (bool): This field will be set to TRUE if atleast one document has a preview.
            export_api (str): When a case is beyond the threshold of entities we provide this link so that the user can request and get all the data of the case with one additional call. This data will be zipped and sent via a webhoook.
            case_stats (CaseStats):
            parties (Parties):
            attorneys (Attorneys):
            judges (Judges):
            docket_entries (DocketEntries):
            hearings (Hearings):
            case_documents (CaseDocuments):
            related_cases (RelatedCases):

        Keyword Args:
            object (str): Name of the object. defaults to "Case"  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        object = kwargs.get('object', "Case")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.object = object
        self.case_id = case_id
        self.url = url
        self.case_number = case_number
        self.case_name = case_name
        self.filed_date = filed_date
        self.has_only_meta_info = has_only_meta_info
        self.court_service_status_id = court_service_status_id
        self.court_service_status_api = court_service_status_api
        self.court = court
        self.court_location = court_location
        self.case_type = case_type
        self.charge_array = charge_array
        self.case_status = case_status
        self.cause_of_action_array = cause_of_action_array
        self.first_fetch_date = first_fetch_date
        self.last_fetch_date = last_fetch_date
        self.last_fetch_date_with_updates = last_fetch_date_with_updates
        self.participants_last_fetch_date = participants_last_fetch_date
        self.source_data_status = source_data_status
        self.source_case_data = source_case_data
        self.has_documents_with_preview = has_documents_with_preview
        self.export_api = export_api
        self.case_stats = case_stats
        self.parties = parties
        self.attorneys = attorneys
        self.judges = judges
        self.docket_entries = docket_entries
        self.hearings = hearings
        self.case_documents = case_documents
        self.related_cases = related_cases
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, case_id, url, case_number, case_name, filed_date, has_only_meta_info, court_service_status_id, court_service_status_api, court, court_location, case_type, charge_array, case_status, cause_of_action_array, first_fetch_date, last_fetch_date, last_fetch_date_with_updates, participants_last_fetch_date, source_data_status, source_case_data, has_documents_with_preview, export_api, case_stats, parties, attorneys, judges, docket_entries, hearings, case_documents, related_cases, *args, **kwargs):  # noqa: E501
        """Case - a model defined in OpenAPI

        Args:
            case_id (str): Unique identifier of Case.
            url (str, none_type): URL to the case page in UniCourt Application.
            case_number (str): Case number as provided by Court.
            case_name (str, none_type): Case name as provided by Court.
            filed_date (datetime): Filing date for the case provided by the Court. Formatted as YYYY-MM-DDTHH:MM:SS+ZZ:zz
            has_only_meta_info (bool): This field determines if this case object has only meta information. If the value is true and if the full information is required you would need to call the updateCase API.
            court_service_status_id (str, none_type): Court Service Status ID of the requested case where we can use it to get the service status
            court_service_status_api (str, none_type): API to get the service statuses of the given case.
            court (Court):
            court_location (CourtLocation):
            case_type (CaseType):
            charge_array ([CaseCharge]): Array of charges that are added to this case.
            case_status (CaseStatus):
            cause_of_action_array ([CaseCauseOfAction]): Array of cause of Actions that are added to this case.
            first_fetch_date (datetime): The date and time when the case was first fetched from the Court. This date and time is in UTC. Formatted as YYYY-MM-DDTHH:MM:SS+ZZ:zz,.
            last_fetch_date (datetime): The date and time when the case was last fetched from the Court. This date and time is in UTC. Formatted as YYYY-MM-DDTHH:MM:SS+ZZ:zz, Note: It is not necessary that every time the case is fetched from Court we find changes in the case information. It could be that we already have the latest information from the Court and no changes exist.
            last_fetch_date_with_updates (datetime): The date and time when the case was last fetched from the Court where we found changes in the case information. This date and time is in UTC. Formatted as YYYY-MM-DDTHH:MM:SS+ZZ:zz,
            participants_last_fetch_date (datetime, none_type): The date and time when parties/attorneys were last updated from the Court. Formatted as YYYY-MM-DDTHH:MM:SS+ZZ:zz, Note: This is currently applicable for Federal PACER cases since we have an option to exclude parties and fetch only latest docket entries when updating cases to save PACER fees.
            source_data_status (str, none_type): The status of source data of case. If the value of sourceDataStatus is SOURCE_DEPRECATED then it means that the Case has been migrated from old court site to a new court site and the data being shown in the API response is from a old court site. If the sourceDataStatus is NO_LONGER_AVAILABLE_IN_COURT then it means that a particular case is invalid in the court site.
            source_case_data (SourceCaseData):
            has_documents_with_preview (bool): This field will be set to TRUE if atleast one document has a preview.
            export_api (str): When a case is beyond the threshold of entities we provide this link so that the user can request and get all the data of the case with one additional call. This data will be zipped and sent via a webhoook.
            case_stats (CaseStats):
            parties (Parties):
            attorneys (Attorneys):
            judges (Judges):
            docket_entries (DocketEntries):
            hearings (Hearings):
            case_documents (CaseDocuments):
            related_cases (RelatedCases):

        Keyword Args:
            object (str): Name of the object. defaults to "Case"  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        object = kwargs.get('object', "Case")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.object = object
        self.case_id = case_id
        self.url = url
        self.case_number = case_number
        self.case_name = case_name
        self.filed_date = filed_date
        self.has_only_meta_info = has_only_meta_info
        self.court_service_status_id = court_service_status_id
        self.court_service_status_api = court_service_status_api
        self.court = court
        self.court_location = court_location
        self.case_type = case_type
        self.charge_array = charge_array
        self.case_status = case_status
        self.cause_of_action_array = cause_of_action_array
        self.first_fetch_date = first_fetch_date
        self.last_fetch_date = last_fetch_date
        self.last_fetch_date_with_updates = last_fetch_date_with_updates
        self.participants_last_fetch_date = participants_last_fetch_date
        self.source_data_status = source_data_status
        self.source_case_data = source_case_data
        self.has_documents_with_preview = has_documents_with_preview
        self.export_api = export_api
        self.case_stats = case_stats
        self.parties = parties
        self.attorneys = attorneys
        self.judges = judges
        self.docket_entries = docket_entries
        self.hearings = hearings
        self.case_documents = case_documents
        self.related_cases = related_cases
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
