"""
    UniCourt Enterprise APIs

    <button><a href=\"/enterpriseapi/download/UniCourt-Enterprise-API-Spec.yaml\" >Download UniCourt Enterprise APIs Specification</a></button>   # noqa: E501

    The version of the OpenAPI document: 
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from unicourt.api_client import ApiClient, Endpoint as _Endpoint
from unicourt.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from unicourt.model.exception import Exception
from unicourt.model.pacer_import_case import PACERImportCase
from unicourt.model.pcl_case import PCLCase
from unicourt.model.pcl_party import PCLParty


class PACERApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.all_courts_pacer_case_locator_case_search_endpoint = _Endpoint(
            settings={
                'response_type': (PCLCase,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacerCaseLocator/caseSearch/allCourts',
                'operation_id': 'all_courts_pacer_case_locator_case_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'pacer_case_id',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_type_array',
                    'court_region_id_array',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                    'page_number',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                ],
                'nullable': [
                    'case_number',
                    'case_title',
                    'case_year',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ],
                'enum': [
                    'case_status',
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('case_title',): {
                        'max_length': 255,
                    },
                    ('case_office',): {

                    },
                    ('case_sequence_number',): {

                    },
                    ('case_year',): {

                    },
                    ('case_filed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_filed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_parameter_query',): {
                        'max_length': 100,
                        'min_length': 5,
                    },
                    ('case_status',): {
                        'max_length': 100,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('case_status',): {
                        'None': None,
                        "OPEN": "open",
                        "CLOSED": "closed"
                    },
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str, none_type,),
                    'pacer_case_id':
                        (int,),
                    'case_title':
                        (str, none_type,),
                    'case_office':
                        (int,),
                    'case_sequence_number':
                        (int,),
                    'case_year':
                        (int, none_type,),
                    'case_type_array':
                        ([str, none_type],),
                    'court_region_id_array':
                        ([str, none_type],),
                    'case_filed_start_date':
                        (datetime, none_type,),
                    'case_filed_end_date':
                        (datetime, none_type,),
                    'case_terminated_start_date':
                        (datetime, none_type,),
                    'case_terminated_end_date':
                        (datetime, none_type,),
                    'sort_parameter_query':
                        (str, none_type,),
                    'case_status':
                        (str, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'pacer_case_id': 'pacerCaseId',
                    'case_title': 'caseTitle',
                    'case_office': 'caseOffice',
                    'case_sequence_number': 'caseSequenceNumber',
                    'case_year': 'caseYear',
                    'case_type_array': 'caseTypeArray',
                    'court_region_id_array': 'courtRegionIdArray',
                    'case_filed_start_date': 'caseFiledStartDate',
                    'case_filed_end_date': 'caseFiledEndDate',
                    'case_terminated_start_date': 'caseTerminatedStartDate',
                    'case_terminated_end_date': 'caseTerminatedEndDate',
                    'sort_parameter_query': 'sortParameterQuery',
                    'case_status': 'caseStatus',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'pacer_case_id': 'query',
                    'case_title': 'query',
                    'case_office': 'query',
                    'case_sequence_number': 'query',
                    'case_year': 'query',
                    'case_type_array': 'query',
                    'court_region_id_array': 'query',
                    'case_filed_start_date': 'query',
                    'case_filed_end_date': 'query',
                    'case_terminated_start_date': 'query',
                    'case_terminated_end_date': 'query',
                    'sort_parameter_query': 'query',
                    'case_status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                    'case_type_array': 'multi',
                    'court_region_id_array': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.all_courts_pacer_case_locator_party_search_endpoint = _Endpoint(
            settings={
                'response_type': (PCLParty,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacerCaseLocator/partySearch/allCourts',
                'operation_id': 'all_courts_pacer_case_locator_party_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'pacer_case_id',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'party_exact_name_match',
                    'party_role_array',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_type_array',
                    'court_region_id_array',
                    'case_year_from',
                    'case_year_to',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                    'page_number',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                ],
                'nullable': [
                    'case_number',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'case_title',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ],
                'enum': [
                    'case_status',
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_year_from',
                    'case_year_to',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('last_name',): {
                        'max_length': 50,
                    },
                    ('first_name',): {
                        'max_length': 100,
                    },
                    ('middle_name',): {
                        'max_length': 100,
                    },
                    ('generation',): {
                        'max_length': 5,
                    },
                    ('party_type',): {
                        'max_length': 50,
                    },
                    ('case_title',): {
                        'max_length': 255,
                    },
                    ('case_office',): {

                    },
                    ('case_sequence_number',): {

                    },
                    ('case_year',): {

                    },
                    ('case_year_from',): {

                    },
                    ('case_year_to',): {

                    },
                    ('case_filed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_filed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_parameter_query',): {
                        'max_length': 100,
                        'min_length': 5,
                    },
                    ('case_status',): {
                        'max_length': 100,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('case_status',): {
                        'None': None,
                        "OPEN": "open",
                        "CLOSED": "closed"
                    },
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str, none_type,),
                    'pacer_case_id':
                        (int,),
                    'last_name':
                        (str, none_type,),
                    'first_name':
                        (str, none_type,),
                    'middle_name':
                        (str, none_type,),
                    'generation':
                        (str, none_type,),
                    'party_type':
                        (str, none_type,),
                    'party_exact_name_match':
                        (bool,),
                    'party_role_array':
                        ([str, none_type],),
                    'case_title':
                        (str, none_type,),
                    'case_office':
                        (int,),
                    'case_sequence_number':
                        (int,),
                    'case_year':
                        (int,),
                    'case_type_array':
                        ([str, none_type],),
                    'court_region_id_array':
                        ([str, none_type],),
                    'case_year_from':
                        (int,),
                    'case_year_to':
                        (int,),
                    'case_filed_start_date':
                        (datetime, none_type,),
                    'case_filed_end_date':
                        (datetime, none_type,),
                    'case_terminated_start_date':
                        (datetime, none_type,),
                    'case_terminated_end_date':
                        (datetime, none_type,),
                    'sort_parameter_query':
                        (str, none_type,),
                    'case_status':
                        (str, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'pacer_case_id': 'pacerCaseId',
                    'last_name': 'lastName',
                    'first_name': 'firstName',
                    'middle_name': 'middleName',
                    'generation': 'generation',
                    'party_type': 'partyType',
                    'party_exact_name_match': 'partyExactNameMatch',
                    'party_role_array': 'partyRoleArray',
                    'case_title': 'caseTitle',
                    'case_office': 'caseOffice',
                    'case_sequence_number': 'caseSequenceNumber',
                    'case_year': 'caseYear',
                    'case_type_array': 'caseTypeArray',
                    'court_region_id_array': 'courtRegionIdArray',
                    'case_year_from': 'caseYearFrom',
                    'case_year_to': 'caseYearTo',
                    'case_filed_start_date': 'caseFiledStartDate',
                    'case_filed_end_date': 'caseFiledEndDate',
                    'case_terminated_start_date': 'caseTerminatedStartDate',
                    'case_terminated_end_date': 'caseTerminatedEndDate',
                    'sort_parameter_query': 'sortParameterQuery',
                    'case_status': 'caseStatus',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'pacer_case_id': 'query',
                    'last_name': 'query',
                    'first_name': 'query',
                    'middle_name': 'query',
                    'generation': 'query',
                    'party_type': 'query',
                    'party_exact_name_match': 'query',
                    'party_role_array': 'query',
                    'case_title': 'query',
                    'case_office': 'query',
                    'case_sequence_number': 'query',
                    'case_year': 'query',
                    'case_type_array': 'query',
                    'court_region_id_array': 'query',
                    'case_year_from': 'query',
                    'case_year_to': 'query',
                    'case_filed_start_date': 'query',
                    'case_filed_end_date': 'query',
                    'case_terminated_start_date': 'query',
                    'case_terminated_end_date': 'query',
                    'sort_parameter_query': 'query',
                    'case_status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                    'party_role_array': 'multi',
                    'case_type_array': 'multi',
                    'court_region_id_array': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.appeal_courts_pacer_case_locator_case_search_endpoint = _Endpoint(
            settings={
                'response_type': (PCLCase,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacerCaseLocator/caseSearch/appealCourts',
                'operation_id': 'appeal_courts_pacer_case_locator_case_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'pacer_case_id',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_type_array',
                    'nature_of_suits_array',
                    'court_region_id_array',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                    'page_number',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                ],
                'nullable': [
                    'case_number',
                    'case_title',
                    'case_office',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ],
                'enum': [
                    'case_status',
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('case_title',): {
                        'max_length': 255,
                    },
                    ('case_office',): {

                    },
                    ('case_sequence_number',): {

                    },
                    ('case_year',): {

                    },
                    ('case_filed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_filed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_parameter_query',): {
                        'max_length': 100,
                        'min_length': 5,
                    },
                    ('case_status',): {
                        'max_length': 100,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('case_status',): {
                        'None': None,
                        "OPEN": "open",
                        "CLOSED": "closed"
                    },
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str, none_type,),
                    'pacer_case_id':
                        (int,),
                    'case_title':
                        (str, none_type,),
                    'case_office':
                        (int, none_type,),
                    'case_sequence_number':
                        (int,),
                    'case_year':
                        (int,),
                    'case_type_array':
                        ([str, none_type],),
                    'nature_of_suits_array':
                        ([str, none_type],),
                    'court_region_id_array':
                        ([str, none_type],),
                    'case_filed_start_date':
                        (datetime, none_type,),
                    'case_filed_end_date':
                        (datetime, none_type,),
                    'case_terminated_start_date':
                        (datetime, none_type,),
                    'case_terminated_end_date':
                        (datetime, none_type,),
                    'sort_parameter_query':
                        (str, none_type,),
                    'case_status':
                        (str, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'pacer_case_id': 'pacerCaseId',
                    'case_title': 'caseTitle',
                    'case_office': 'caseOffice',
                    'case_sequence_number': 'caseSequenceNumber',
                    'case_year': 'caseYear',
                    'case_type_array': 'caseTypeArray',
                    'nature_of_suits_array': 'natureOfSuitsArray',
                    'court_region_id_array': 'courtRegionIdArray',
                    'case_filed_start_date': 'caseFiledStartDate',
                    'case_filed_end_date': 'caseFiledEndDate',
                    'case_terminated_start_date': 'caseTerminatedStartDate',
                    'case_terminated_end_date': 'caseTerminatedEndDate',
                    'sort_parameter_query': 'sortParameterQuery',
                    'case_status': 'caseStatus',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'pacer_case_id': 'query',
                    'case_title': 'query',
                    'case_office': 'query',
                    'case_sequence_number': 'query',
                    'case_year': 'query',
                    'case_type_array': 'query',
                    'nature_of_suits_array': 'query',
                    'court_region_id_array': 'query',
                    'case_filed_start_date': 'query',
                    'case_filed_end_date': 'query',
                    'case_terminated_start_date': 'query',
                    'case_terminated_end_date': 'query',
                    'sort_parameter_query': 'query',
                    'case_status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                    'case_type_array': 'multi',
                    'nature_of_suits_array': 'multi',
                    'court_region_id_array': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.appeal_courts_pacer_case_locator_party_search_endpoint = _Endpoint(
            settings={
                'response_type': (PCLParty,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacerCaseLocator/partySearch/appealCourts',
                'operation_id': 'appeal_courts_pacer_case_locator_party_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'pacer_case_id',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'party_exact_name_match',
                    'party_role_array',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_type_array',
                    'court_region_id_array',
                    'case_year_from',
                    'case_year_to',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                    'page_number',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                ],
                'nullable': [
                    'case_number',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'case_title',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ],
                'enum': [
                    'case_status',
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_year_from',
                    'case_year_to',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('last_name',): {
                        'max_length': 50,
                    },
                    ('first_name',): {
                        'max_length': 100,
                    },
                    ('middle_name',): {
                        'max_length': 100,
                    },
                    ('generation',): {
                        'max_length': 5,
                    },
                    ('party_type',): {
                        'max_length': 50,
                    },
                    ('case_title',): {
                        'max_length': 255,
                    },
                    ('case_office',): {

                    },
                    ('case_sequence_number',): {

                    },
                    ('case_year',): {

                    },
                    ('case_year_from',): {

                    },
                    ('case_year_to',): {

                    },
                    ('case_filed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_filed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_parameter_query',): {
                        'max_length': 100,
                        'min_length': 5,
                    },
                    ('case_status',): {
                        'max_length': 100,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('case_status',): {
                        'None': None,
                        "OPEN": "open",
                        "CLOSED": "closed"
                    },
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str, none_type,),
                    'pacer_case_id':
                        (int,),
                    'last_name':
                        (str, none_type,),
                    'first_name':
                        (str, none_type,),
                    'middle_name':
                        (str, none_type,),
                    'generation':
                        (str, none_type,),
                    'party_type':
                        (str, none_type,),
                    'party_exact_name_match':
                        (bool,),
                    'party_role_array':
                        ([str, none_type],),
                    'case_title':
                        (str, none_type,),
                    'case_office':
                        (int,),
                    'case_sequence_number':
                        (int,),
                    'case_year':
                        (int,),
                    'case_type_array':
                        ([str, none_type],),
                    'court_region_id_array':
                        ([str, none_type],),
                    'case_year_from':
                        (int,),
                    'case_year_to':
                        (int,),
                    'case_filed_start_date':
                        (datetime, none_type,),
                    'case_filed_end_date':
                        (datetime, none_type,),
                    'case_terminated_start_date':
                        (datetime, none_type,),
                    'case_terminated_end_date':
                        (datetime, none_type,),
                    'sort_parameter_query':
                        (str, none_type,),
                    'case_status':
                        (str, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'pacer_case_id': 'pacerCaseId',
                    'last_name': 'lastName',
                    'first_name': 'firstName',
                    'middle_name': 'middleName',
                    'generation': 'generation',
                    'party_type': 'partyType',
                    'party_exact_name_match': 'partyExactNameMatch',
                    'party_role_array': 'partyRoleArray',
                    'case_title': 'caseTitle',
                    'case_office': 'caseOffice',
                    'case_sequence_number': 'caseSequenceNumber',
                    'case_year': 'caseYear',
                    'case_type_array': 'caseTypeArray',
                    'court_region_id_array': 'courtRegionIdArray',
                    'case_year_from': 'caseYearFrom',
                    'case_year_to': 'caseYearTo',
                    'case_filed_start_date': 'caseFiledStartDate',
                    'case_filed_end_date': 'caseFiledEndDate',
                    'case_terminated_start_date': 'caseTerminatedStartDate',
                    'case_terminated_end_date': 'caseTerminatedEndDate',
                    'sort_parameter_query': 'sortParameterQuery',
                    'case_status': 'caseStatus',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'pacer_case_id': 'query',
                    'last_name': 'query',
                    'first_name': 'query',
                    'middle_name': 'query',
                    'generation': 'query',
                    'party_type': 'query',
                    'party_exact_name_match': 'query',
                    'party_role_array': 'query',
                    'case_title': 'query',
                    'case_office': 'query',
                    'case_sequence_number': 'query',
                    'case_year': 'query',
                    'case_type_array': 'query',
                    'court_region_id_array': 'query',
                    'case_year_from': 'query',
                    'case_year_to': 'query',
                    'case_filed_start_date': 'query',
                    'case_filed_end_date': 'query',
                    'case_terminated_start_date': 'query',
                    'case_terminated_end_date': 'query',
                    'sort_parameter_query': 'query',
                    'case_status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                    'party_role_array': 'multi',
                    'case_type_array': 'multi',
                    'court_region_id_array': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.bankruptcy_courts_pacer_case_locator_case_search_endpoint = _Endpoint(
            settings={
                'response_type': (PCLCase,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacerCaseLocator/caseSearch/bankruptcyCourts',
                'operation_id': 'bankruptcy_courts_pacer_case_locator_case_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'pacer_case_id',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_type_array',
                    'federal_bankruptcy_chapter_array',
                    'court_region_id_array',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'case_discharged_start_date',
                    'case_discharged_end_date',
                    'case_dismissed_start_date',
                    'case_dismissed_end_date',
                    'sort_parameter_query',
                    'case_status',
                    'page_number',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                ],
                'nullable': [
                    'case_number',
                    'case_title',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'case_discharged_start_date',
                    'case_discharged_end_date',
                    'case_dismissed_start_date',
                    'case_dismissed_end_date',
                    'sort_parameter_query',
                    'case_status',
                ],
                'enum': [
                    'case_status',
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'case_discharged_start_date',
                    'case_discharged_end_date',
                    'case_dismissed_start_date',
                    'case_dismissed_end_date',
                    'sort_parameter_query',
                    'case_status',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('case_title',): {
                        'max_length': 255,
                    },
                    ('case_office',): {

                    },
                    ('case_sequence_number',): {

                    },
                    ('case_year',): {

                    },
                    ('case_filed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_filed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_discharged_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_discharged_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_dismissed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_dismissed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_parameter_query',): {
                        'max_length': 100,
                        'min_length': 5,
                    },
                    ('case_status',): {
                        'max_length': 100,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('case_status',): {
                        'None': None,
                        "OPEN": "open",
                        "CLOSED": "closed"
                    },
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str, none_type,),
                    'pacer_case_id':
                        (int,),
                    'case_title':
                        (str, none_type,),
                    'case_office':
                        (int,),
                    'case_sequence_number':
                        (int,),
                    'case_year':
                        (int,),
                    'case_type_array':
                        ([str, none_type],),
                    'federal_bankruptcy_chapter_array':
                        ([str, none_type],),
                    'court_region_id_array':
                        ([str, none_type],),
                    'case_filed_start_date':
                        (datetime, none_type,),
                    'case_filed_end_date':
                        (datetime, none_type,),
                    'case_terminated_start_date':
                        (datetime, none_type,),
                    'case_terminated_end_date':
                        (datetime, none_type,),
                    'case_discharged_start_date':
                        (datetime, none_type,),
                    'case_discharged_end_date':
                        (datetime, none_type,),
                    'case_dismissed_start_date':
                        (datetime, none_type,),
                    'case_dismissed_end_date':
                        (datetime, none_type,),
                    'sort_parameter_query':
                        (str, none_type,),
                    'case_status':
                        (str, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'pacer_case_id': 'pacerCaseId',
                    'case_title': 'caseTitle',
                    'case_office': 'caseOffice',
                    'case_sequence_number': 'caseSequenceNumber',
                    'case_year': 'caseYear',
                    'case_type_array': 'caseTypeArray',
                    'federal_bankruptcy_chapter_array': 'federalBankruptcyChapterArray',
                    'court_region_id_array': 'courtRegionIdArray',
                    'case_filed_start_date': 'caseFiledStartDate',
                    'case_filed_end_date': 'caseFiledEndDate',
                    'case_terminated_start_date': 'caseTerminatedStartDate',
                    'case_terminated_end_date': 'caseTerminatedEndDate',
                    'case_discharged_start_date': 'caseDischargedStartDate',
                    'case_discharged_end_date': 'caseDischargedEndDate',
                    'case_dismissed_start_date': 'caseDismissedStartDate',
                    'case_dismissed_end_date': 'caseDismissedEndDate',
                    'sort_parameter_query': 'sortParameterQuery',
                    'case_status': 'caseStatus',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'pacer_case_id': 'query',
                    'case_title': 'query',
                    'case_office': 'query',
                    'case_sequence_number': 'query',
                    'case_year': 'query',
                    'case_type_array': 'query',
                    'federal_bankruptcy_chapter_array': 'query',
                    'court_region_id_array': 'query',
                    'case_filed_start_date': 'query',
                    'case_filed_end_date': 'query',
                    'case_terminated_start_date': 'query',
                    'case_terminated_end_date': 'query',
                    'case_discharged_start_date': 'query',
                    'case_discharged_end_date': 'query',
                    'case_dismissed_start_date': 'query',
                    'case_dismissed_end_date': 'query',
                    'sort_parameter_query': 'query',
                    'case_status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                    'case_type_array': 'multi',
                    'federal_bankruptcy_chapter_array': 'multi',
                    'court_region_id_array': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.bankruptcy_courts_pacer_case_locator_party_search_endpoint = _Endpoint(
            settings={
                'response_type': (PCLParty,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacerCaseLocator/partySearch/bankruptcyCourts',
                'operation_id': 'bankruptcy_courts_pacer_case_locator_party_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'pacer_case_id',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'party_exact_name_match',
                    'party_role_array',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_type_array',
                    'court_region_id_array',
                    'case_year_from',
                    'case_year_to',
                    'ssn_or_ein',
                    'four_digit_ssn',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'case_discharged_start_date',
                    'case_discharged_end_date',
                    'case_dismissed_start_date',
                    'case_dismissed_end_date',
                    'sort_parameter_query',
                    'case_status',
                    'page_number',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                ],
                'nullable': [
                    'case_number',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'case_title',
                    'ssn_or_ein',
                    'four_digit_ssn',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'case_discharged_start_date',
                    'case_discharged_end_date',
                    'case_dismissed_start_date',
                    'case_dismissed_end_date',
                    'sort_parameter_query',
                    'case_status',
                ],
                'enum': [
                    'case_status',
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_year_from',
                    'case_year_to',
                    'ssn_or_ein',
                    'four_digit_ssn',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'case_discharged_start_date',
                    'case_discharged_end_date',
                    'case_dismissed_start_date',
                    'case_dismissed_end_date',
                    'sort_parameter_query',
                    'case_status',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('last_name',): {
                        'max_length': 50,
                    },
                    ('first_name',): {
                        'max_length': 100,
                    },
                    ('middle_name',): {
                        'max_length': 100,
                    },
                    ('generation',): {
                        'max_length': 5,
                    },
                    ('party_type',): {
                        'max_length': 50,
                    },
                    ('case_title',): {
                        'max_length': 255,
                    },
                    ('case_office',): {

                    },
                    ('case_sequence_number',): {

                    },
                    ('case_year',): {

                    },
                    ('case_year_from',): {

                    },
                    ('case_year_to',): {

                    },
                    ('ssn_or_ein',): {
                        'max_length': 9,
                    },
                    ('four_digit_ssn',): {
                        'max_length': 4,
                    },
                    ('case_filed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_filed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_discharged_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_discharged_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_dismissed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_dismissed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_parameter_query',): {
                        'max_length': 100,
                        'min_length': 5,
                    },
                    ('case_status',): {
                        'max_length': 100,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('case_status',): {
                        'None': None,
                        "OPEN": "open",
                        "CLOSED": "closed"
                    },
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str, none_type,),
                    'pacer_case_id':
                        (int,),
                    'last_name':
                        (str, none_type,),
                    'first_name':
                        (str, none_type,),
                    'middle_name':
                        (str, none_type,),
                    'generation':
                        (str, none_type,),
                    'party_type':
                        (str, none_type,),
                    'party_exact_name_match':
                        (bool,),
                    'party_role_array':
                        ([str, none_type],),
                    'case_title':
                        (str, none_type,),
                    'case_office':
                        (int,),
                    'case_sequence_number':
                        (int,),
                    'case_year':
                        (int,),
                    'case_type_array':
                        ([str, none_type],),
                    'court_region_id_array':
                        ([str, none_type],),
                    'case_year_from':
                        (int,),
                    'case_year_to':
                        (int,),
                    'ssn_or_ein':
                        (str, none_type,),
                    'four_digit_ssn':
                        (str, none_type,),
                    'case_filed_start_date':
                        (datetime, none_type,),
                    'case_filed_end_date':
                        (datetime, none_type,),
                    'case_terminated_start_date':
                        (datetime, none_type,),
                    'case_terminated_end_date':
                        (datetime, none_type,),
                    'case_discharged_start_date':
                        (datetime, none_type,),
                    'case_discharged_end_date':
                        (datetime, none_type,),
                    'case_dismissed_start_date':
                        (datetime, none_type,),
                    'case_dismissed_end_date':
                        (datetime, none_type,),
                    'sort_parameter_query':
                        (str, none_type,),
                    'case_status':
                        (str, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'pacer_case_id': 'pacerCaseId',
                    'last_name': 'lastName',
                    'first_name': 'firstName',
                    'middle_name': 'middleName',
                    'generation': 'generation',
                    'party_type': 'partyType',
                    'party_exact_name_match': 'partyExactNameMatch',
                    'party_role_array': 'partyRoleArray',
                    'case_title': 'caseTitle',
                    'case_office': 'caseOffice',
                    'case_sequence_number': 'caseSequenceNumber',
                    'case_year': 'caseYear',
                    'case_type_array': 'caseTypeArray',
                    'court_region_id_array': 'courtRegionIdArray',
                    'case_year_from': 'caseYearFrom',
                    'case_year_to': 'caseYearTo',
                    'ssn_or_ein': 'ssnOrEin',
                    'four_digit_ssn': 'fourDigitSsn',
                    'case_filed_start_date': 'caseFiledStartDate',
                    'case_filed_end_date': 'caseFiledEndDate',
                    'case_terminated_start_date': 'caseTerminatedStartDate',
                    'case_terminated_end_date': 'caseTerminatedEndDate',
                    'case_discharged_start_date': 'caseDischargedStartDate',
                    'case_discharged_end_date': 'caseDischargedEndDate',
                    'case_dismissed_start_date': 'caseDismissedStartDate',
                    'case_dismissed_end_date': 'caseDismissedEndDate',
                    'sort_parameter_query': 'sortParameterQuery',
                    'case_status': 'caseStatus',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'pacer_case_id': 'query',
                    'last_name': 'query',
                    'first_name': 'query',
                    'middle_name': 'query',
                    'generation': 'query',
                    'party_type': 'query',
                    'party_exact_name_match': 'query',
                    'party_role_array': 'query',
                    'case_title': 'query',
                    'case_office': 'query',
                    'case_sequence_number': 'query',
                    'case_year': 'query',
                    'case_type_array': 'query',
                    'court_region_id_array': 'query',
                    'case_year_from': 'query',
                    'case_year_to': 'query',
                    'ssn_or_ein': 'query',
                    'four_digit_ssn': 'query',
                    'case_filed_start_date': 'query',
                    'case_filed_end_date': 'query',
                    'case_terminated_start_date': 'query',
                    'case_terminated_end_date': 'query',
                    'case_discharged_start_date': 'query',
                    'case_discharged_end_date': 'query',
                    'case_dismissed_start_date': 'query',
                    'case_dismissed_end_date': 'query',
                    'sort_parameter_query': 'query',
                    'case_status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                    'party_role_array': 'multi',
                    'case_type_array': 'multi',
                    'court_region_id_array': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.civil_courts_pacer_case_locator_case_search_endpoint = _Endpoint(
            settings={
                'response_type': (PCLCase,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacerCaseLocator/caseSearch/civilCourts',
                'operation_id': 'civil_courts_pacer_case_locator_case_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'pacer_case_id',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_type_array',
                    'nature_of_suits_array',
                    'court_region_id_array',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                    'page_number',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                ],
                'nullable': [
                    'case_number',
                    'case_title',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ],
                'enum': [
                    'case_status',
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('case_title',): {
                        'max_length': 255,
                    },
                    ('case_office',): {

                    },
                    ('case_sequence_number',): {

                    },
                    ('case_year',): {

                    },
                    ('case_filed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_filed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_parameter_query',): {
                        'max_length': 100,
                        'min_length': 5,
                    },
                    ('case_status',): {
                        'max_length': 100,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('case_status',): {
                        'None': None,
                        "OPEN": "open",
                        "CLOSED": "closed"
                    },
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str, none_type,),
                    'pacer_case_id':
                        (int,),
                    'case_title':
                        (str, none_type,),
                    'case_office':
                        (int,),
                    'case_sequence_number':
                        (int,),
                    'case_year':
                        (int,),
                    'case_type_array':
                        ([str, none_type],),
                    'nature_of_suits_array':
                        ([str, none_type],),
                    'court_region_id_array':
                        ([str, none_type],),
                    'case_filed_start_date':
                        (datetime, none_type,),
                    'case_filed_end_date':
                        (datetime, none_type,),
                    'case_terminated_start_date':
                        (datetime, none_type,),
                    'case_terminated_end_date':
                        (datetime, none_type,),
                    'sort_parameter_query':
                        (str, none_type,),
                    'case_status':
                        (str, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'pacer_case_id': 'pacerCaseId',
                    'case_title': 'caseTitle',
                    'case_office': 'caseOffice',
                    'case_sequence_number': 'caseSequenceNumber',
                    'case_year': 'caseYear',
                    'case_type_array': 'caseTypeArray',
                    'nature_of_suits_array': 'natureOfSuitsArray',
                    'court_region_id_array': 'courtRegionIdArray',
                    'case_filed_start_date': 'caseFiledStartDate',
                    'case_filed_end_date': 'caseFiledEndDate',
                    'case_terminated_start_date': 'caseTerminatedStartDate',
                    'case_terminated_end_date': 'caseTerminatedEndDate',
                    'sort_parameter_query': 'sortParameterQuery',
                    'case_status': 'caseStatus',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'pacer_case_id': 'query',
                    'case_title': 'query',
                    'case_office': 'query',
                    'case_sequence_number': 'query',
                    'case_year': 'query',
                    'case_type_array': 'query',
                    'nature_of_suits_array': 'query',
                    'court_region_id_array': 'query',
                    'case_filed_start_date': 'query',
                    'case_filed_end_date': 'query',
                    'case_terminated_start_date': 'query',
                    'case_terminated_end_date': 'query',
                    'sort_parameter_query': 'query',
                    'case_status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                    'case_type_array': 'multi',
                    'nature_of_suits_array': 'multi',
                    'court_region_id_array': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.civil_courts_pacer_case_locator_party_search_endpoint = _Endpoint(
            settings={
                'response_type': (PCLParty,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacerCaseLocator/partySearch/civilCourts',
                'operation_id': 'civil_courts_pacer_case_locator_party_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'pacer_case_id',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'party_exact_name_match',
                    'party_role_array',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_type_array',
                    'court_region_id_array',
                    'case_year_from',
                    'case_year_to',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                    'page_number',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                ],
                'nullable': [
                    'case_number',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'case_title',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ],
                'enum': [
                    'case_status',
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_year_from',
                    'case_year_to',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('last_name',): {
                        'max_length': 50,
                    },
                    ('first_name',): {
                        'max_length': 100,
                    },
                    ('middle_name',): {
                        'max_length': 100,
                    },
                    ('generation',): {
                        'max_length': 5,
                    },
                    ('party_type',): {
                        'max_length': 50,
                    },
                    ('case_title',): {
                        'max_length': 255,
                    },
                    ('case_office',): {

                    },
                    ('case_sequence_number',): {

                    },
                    ('case_year',): {

                    },
                    ('case_year_from',): {

                    },
                    ('case_year_to',): {

                    },
                    ('case_filed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_filed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_parameter_query',): {
                        'max_length': 100,
                        'min_length': 5,
                    },
                    ('case_status',): {
                        'max_length': 100,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('case_status',): {
                        'None': None,
                        "OPEN": "open",
                        "CLOSED": "closed"
                    },
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str, none_type,),
                    'pacer_case_id':
                        (int,),
                    'last_name':
                        (str, none_type,),
                    'first_name':
                        (str, none_type,),
                    'middle_name':
                        (str, none_type,),
                    'generation':
                        (str, none_type,),
                    'party_type':
                        (str, none_type,),
                    'party_exact_name_match':
                        (bool,),
                    'party_role_array':
                        ([str, none_type],),
                    'case_title':
                        (str, none_type,),
                    'case_office':
                        (int,),
                    'case_sequence_number':
                        (int,),
                    'case_year':
                        (int,),
                    'case_type_array':
                        ([str, none_type],),
                    'court_region_id_array':
                        ([str, none_type],),
                    'case_year_from':
                        (int,),
                    'case_year_to':
                        (int,),
                    'case_filed_start_date':
                        (datetime, none_type,),
                    'case_filed_end_date':
                        (datetime, none_type,),
                    'case_terminated_start_date':
                        (datetime, none_type,),
                    'case_terminated_end_date':
                        (datetime, none_type,),
                    'sort_parameter_query':
                        (str, none_type,),
                    'case_status':
                        (str, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'pacer_case_id': 'pacerCaseId',
                    'last_name': 'lastName',
                    'first_name': 'firstName',
                    'middle_name': 'middleName',
                    'generation': 'generation',
                    'party_type': 'partyType',
                    'party_exact_name_match': 'partyExactNameMatch',
                    'party_role_array': 'partyRoleArray',
                    'case_title': 'caseTitle',
                    'case_office': 'caseOffice',
                    'case_sequence_number': 'caseSequenceNumber',
                    'case_year': 'caseYear',
                    'case_type_array': 'caseTypeArray',
                    'court_region_id_array': 'courtRegionIdArray',
                    'case_year_from': 'caseYearFrom',
                    'case_year_to': 'caseYearTo',
                    'case_filed_start_date': 'caseFiledStartDate',
                    'case_filed_end_date': 'caseFiledEndDate',
                    'case_terminated_start_date': 'caseTerminatedStartDate',
                    'case_terminated_end_date': 'caseTerminatedEndDate',
                    'sort_parameter_query': 'sortParameterQuery',
                    'case_status': 'caseStatus',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'pacer_case_id': 'query',
                    'last_name': 'query',
                    'first_name': 'query',
                    'middle_name': 'query',
                    'generation': 'query',
                    'party_type': 'query',
                    'party_exact_name_match': 'query',
                    'party_role_array': 'query',
                    'case_title': 'query',
                    'case_office': 'query',
                    'case_sequence_number': 'query',
                    'case_year': 'query',
                    'case_type_array': 'query',
                    'court_region_id_array': 'query',
                    'case_year_from': 'query',
                    'case_year_to': 'query',
                    'case_filed_start_date': 'query',
                    'case_filed_end_date': 'query',
                    'case_terminated_start_date': 'query',
                    'case_terminated_end_date': 'query',
                    'sort_parameter_query': 'query',
                    'case_status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                    'party_role_array': 'multi',
                    'case_type_array': 'multi',
                    'court_region_id_array': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.criminal_courts_pacer_case_locator_case_search_endpoint = _Endpoint(
            settings={
                'response_type': (PCLCase,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacerCaseLocator/caseSearch/criminalCourts',
                'operation_id': 'criminal_courts_pacer_case_locator_case_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'pacer_case_id',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_type_array',
                    'court_region_id_array',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                    'page_number',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                ],
                'nullable': [
                    'case_number',
                    'case_title',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ],
                'enum': [
                    'case_status',
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('case_title',): {
                        'max_length': 255,
                    },
                    ('case_office',): {

                    },
                    ('case_sequence_number',): {

                    },
                    ('case_year',): {

                    },
                    ('case_filed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_filed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_parameter_query',): {
                        'max_length': 100,
                        'min_length': 5,
                    },
                    ('case_status',): {
                        'max_length': 100,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('case_status',): {
                        'None': None,
                        "OPEN": "open",
                        "CLOSED": "closed"
                    },
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str, none_type,),
                    'pacer_case_id':
                        (int,),
                    'case_title':
                        (str, none_type,),
                    'case_office':
                        (int,),
                    'case_sequence_number':
                        (int,),
                    'case_year':
                        (int,),
                    'case_type_array':
                        ([str, none_type],),
                    'court_region_id_array':
                        ([str, none_type],),
                    'case_filed_start_date':
                        (datetime, none_type,),
                    'case_filed_end_date':
                        (datetime, none_type,),
                    'case_terminated_start_date':
                        (datetime, none_type,),
                    'case_terminated_end_date':
                        (datetime, none_type,),
                    'sort_parameter_query':
                        (str, none_type,),
                    'case_status':
                        (str, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'pacer_case_id': 'pacerCaseId',
                    'case_title': 'caseTitle',
                    'case_office': 'caseOffice',
                    'case_sequence_number': 'caseSequenceNumber',
                    'case_year': 'caseYear',
                    'case_type_array': 'caseTypeArray',
                    'court_region_id_array': 'courtRegionIdArray',
                    'case_filed_start_date': 'caseFiledStartDate',
                    'case_filed_end_date': 'caseFiledEndDate',
                    'case_terminated_start_date': 'caseTerminatedStartDate',
                    'case_terminated_end_date': 'caseTerminatedEndDate',
                    'sort_parameter_query': 'sortParameterQuery',
                    'case_status': 'caseStatus',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'pacer_case_id': 'query',
                    'case_title': 'query',
                    'case_office': 'query',
                    'case_sequence_number': 'query',
                    'case_year': 'query',
                    'case_type_array': 'query',
                    'court_region_id_array': 'query',
                    'case_filed_start_date': 'query',
                    'case_filed_end_date': 'query',
                    'case_terminated_start_date': 'query',
                    'case_terminated_end_date': 'query',
                    'sort_parameter_query': 'query',
                    'case_status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                    'case_type_array': 'multi',
                    'court_region_id_array': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.criminal_courts_pacer_case_locator_party_search_endpoint = _Endpoint(
            settings={
                'response_type': (PCLParty,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacerCaseLocator/partySearch/criminalCourts',
                'operation_id': 'criminal_courts_pacer_case_locator_party_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'pacer_case_id',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'party_exact_name_match',
                    'party_role_array',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_type_array',
                    'court_region_id_array',
                    'case_year_from',
                    'case_year_to',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                    'page_number',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                ],
                'nullable': [
                    'case_number',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'case_title',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ],
                'enum': [
                    'case_status',
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_year_from',
                    'case_year_to',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('last_name',): {
                        'max_length': 50,
                    },
                    ('first_name',): {
                        'max_length': 100,
                    },
                    ('middle_name',): {
                        'max_length': 100,
                    },
                    ('generation',): {
                        'max_length': 5,
                    },
                    ('party_type',): {
                        'max_length': 50,
                    },
                    ('case_title',): {
                        'max_length': 255,
                    },
                    ('case_office',): {

                    },
                    ('case_sequence_number',): {

                    },
                    ('case_year',): {

                    },
                    ('case_year_from',): {

                    },
                    ('case_year_to',): {

                    },
                    ('case_filed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_filed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_parameter_query',): {
                        'max_length': 100,
                        'min_length': 5,
                    },
                    ('case_status',): {
                        'max_length': 100,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('case_status',): {
                        'None': None,
                        "OPEN": "open",
                        "CLOSED": "closed"
                    },
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str, none_type,),
                    'pacer_case_id':
                        (int,),
                    'last_name':
                        (str, none_type,),
                    'first_name':
                        (str, none_type,),
                    'middle_name':
                        (str, none_type,),
                    'generation':
                        (str, none_type,),
                    'party_type':
                        (str, none_type,),
                    'party_exact_name_match':
                        (bool,),
                    'party_role_array':
                        ([str, none_type],),
                    'case_title':
                        (str, none_type,),
                    'case_office':
                        (int,),
                    'case_sequence_number':
                        (int,),
                    'case_year':
                        (int,),
                    'case_type_array':
                        ([str, none_type],),
                    'court_region_id_array':
                        ([str, none_type],),
                    'case_year_from':
                        (int,),
                    'case_year_to':
                        (int,),
                    'case_filed_start_date':
                        (datetime, none_type,),
                    'case_filed_end_date':
                        (datetime, none_type,),
                    'case_terminated_start_date':
                        (datetime, none_type,),
                    'case_terminated_end_date':
                        (datetime, none_type,),
                    'sort_parameter_query':
                        (str, none_type,),
                    'case_status':
                        (str, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'pacer_case_id': 'pacerCaseId',
                    'last_name': 'lastName',
                    'first_name': 'firstName',
                    'middle_name': 'middleName',
                    'generation': 'generation',
                    'party_type': 'partyType',
                    'party_exact_name_match': 'partyExactNameMatch',
                    'party_role_array': 'partyRoleArray',
                    'case_title': 'caseTitle',
                    'case_office': 'caseOffice',
                    'case_sequence_number': 'caseSequenceNumber',
                    'case_year': 'caseYear',
                    'case_type_array': 'caseTypeArray',
                    'court_region_id_array': 'courtRegionIdArray',
                    'case_year_from': 'caseYearFrom',
                    'case_year_to': 'caseYearTo',
                    'case_filed_start_date': 'caseFiledStartDate',
                    'case_filed_end_date': 'caseFiledEndDate',
                    'case_terminated_start_date': 'caseTerminatedStartDate',
                    'case_terminated_end_date': 'caseTerminatedEndDate',
                    'sort_parameter_query': 'sortParameterQuery',
                    'case_status': 'caseStatus',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'pacer_case_id': 'query',
                    'last_name': 'query',
                    'first_name': 'query',
                    'middle_name': 'query',
                    'generation': 'query',
                    'party_type': 'query',
                    'party_exact_name_match': 'query',
                    'party_role_array': 'query',
                    'case_title': 'query',
                    'case_office': 'query',
                    'case_sequence_number': 'query',
                    'case_year': 'query',
                    'case_type_array': 'query',
                    'court_region_id_array': 'query',
                    'case_year_from': 'query',
                    'case_year_to': 'query',
                    'case_filed_start_date': 'query',
                    'case_filed_end_date': 'query',
                    'case_terminated_start_date': 'query',
                    'case_terminated_end_date': 'query',
                    'sort_parameter_query': 'query',
                    'case_status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                    'party_role_array': 'multi',
                    'case_type_array': 'multi',
                    'court_region_id_array': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.import_pacer_case_by_court_using_case_number_endpoint = _Endpoint(
            settings={
                'response_type': (PACERImportCase,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacer/importCaseByCourtUsingCaseNumber',
                'operation_id': 'import_pacer_case_by_court_using_case_number',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'court_id',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'court_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'court_id',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('court_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str,),
                    'court_id':
                        (str,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'court_id': 'courtId',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'court_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.multi_district_courts_pacer_case_locator_case_search_endpoint = _Endpoint(
            settings={
                'response_type': (PCLCase,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacerCaseLocator/caseSearch/multiDistrictCourts',
                'operation_id': 'multi_district_courts_pacer_case_locator_case_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'jpml_number',
                    'pacer_case_id',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_type_array',
                    'court_region_id_array',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                    'page_number',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                ],
                'nullable': [
                    'case_number',
                    'case_title',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ],
                'enum': [
                    'case_status',
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('case_title',): {
                        'max_length': 255,
                    },
                    ('case_office',): {

                    },
                    ('case_sequence_number',): {

                    },
                    ('case_year',): {

                    },
                    ('case_filed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_filed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_parameter_query',): {
                        'max_length': 100,
                        'min_length': 5,
                    },
                    ('case_status',): {
                        'max_length': 100,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('case_status',): {
                        'None': None,
                        "OPEN": "open",
                        "CLOSED": "closed"
                    },
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str, none_type,),
                    'jpml_number':
                        (int,),
                    'pacer_case_id':
                        (int,),
                    'case_title':
                        (str, none_type,),
                    'case_office':
                        (int,),
                    'case_sequence_number':
                        (int,),
                    'case_year':
                        (int,),
                    'case_type_array':
                        ([str, none_type],),
                    'court_region_id_array':
                        ([str, none_type],),
                    'case_filed_start_date':
                        (datetime, none_type,),
                    'case_filed_end_date':
                        (datetime, none_type,),
                    'case_terminated_start_date':
                        (datetime, none_type,),
                    'case_terminated_end_date':
                        (datetime, none_type,),
                    'sort_parameter_query':
                        (str, none_type,),
                    'case_status':
                        (str, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'jpml_number': 'jpmlNumber',
                    'pacer_case_id': 'pacerCaseId',
                    'case_title': 'caseTitle',
                    'case_office': 'caseOffice',
                    'case_sequence_number': 'caseSequenceNumber',
                    'case_year': 'caseYear',
                    'case_type_array': 'caseTypeArray',
                    'court_region_id_array': 'courtRegionIdArray',
                    'case_filed_start_date': 'caseFiledStartDate',
                    'case_filed_end_date': 'caseFiledEndDate',
                    'case_terminated_start_date': 'caseTerminatedStartDate',
                    'case_terminated_end_date': 'caseTerminatedEndDate',
                    'sort_parameter_query': 'sortParameterQuery',
                    'case_status': 'caseStatus',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'jpml_number': 'query',
                    'pacer_case_id': 'query',
                    'case_title': 'query',
                    'case_office': 'query',
                    'case_sequence_number': 'query',
                    'case_year': 'query',
                    'case_type_array': 'query',
                    'court_region_id_array': 'query',
                    'case_filed_start_date': 'query',
                    'case_filed_end_date': 'query',
                    'case_terminated_start_date': 'query',
                    'case_terminated_end_date': 'query',
                    'sort_parameter_query': 'query',
                    'case_status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                    'case_type_array': 'multi',
                    'court_region_id_array': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.multi_district_courts_pacer_case_locator_party_search_endpoint = _Endpoint(
            settings={
                'response_type': (PCLParty,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/pacerCaseLocator/partySearch/multiDistrictCourts',
                'operation_id': 'multi_district_courts_pacer_case_locator_party_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'jpml_number',
                    'pacer_case_id',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'party_exact_name_match',
                    'party_role_array',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_type_array',
                    'court_region_id_array',
                    'case_year_from',
                    'case_year_to',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                    'page_number',
                ],
                'required': [
                    'pacer_user_id',
                    'pacer_client_code',
                ],
                'nullable': [
                    'case_number',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'case_title',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ],
                'enum': [
                    'case_status',
                ],
                'validation': [
                    'pacer_user_id',
                    'pacer_client_code',
                    'case_number',
                    'last_name',
                    'first_name',
                    'middle_name',
                    'generation',
                    'party_type',
                    'case_title',
                    'case_office',
                    'case_sequence_number',
                    'case_year',
                    'case_year_from',
                    'case_year_to',
                    'case_filed_start_date',
                    'case_filed_end_date',
                    'case_terminated_start_date',
                    'case_terminated_end_date',
                    'sort_parameter_query',
                    'case_status',
                ]
            },
            root_map={
                'validations': {
                    ('pacer_user_id',): {
                        'max_length': 20,
                        'min_length': 6,
                    },
                    ('pacer_client_code',): {
                        'max_length': 32,
                        'min_length': 1,
                    },
                    ('case_number',): {
                        'max_length': 50,
                        'min_length': 3,
                    },
                    ('last_name',): {
                        'max_length': 50,
                    },
                    ('first_name',): {
                        'max_length': 100,
                    },
                    ('middle_name',): {
                        'max_length': 100,
                    },
                    ('generation',): {
                        'max_length': 5,
                    },
                    ('party_type',): {
                        'max_length': 50,
                    },
                    ('case_title',): {
                        'max_length': 255,
                    },
                    ('case_office',): {

                    },
                    ('case_sequence_number',): {

                    },
                    ('case_year',): {

                    },
                    ('case_year_from',): {

                    },
                    ('case_year_to',): {

                    },
                    ('case_filed_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_filed_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_start_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('case_terminated_end_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_parameter_query',): {
                        'max_length': 100,
                        'min_length': 5,
                    },
                    ('case_status',): {
                        'max_length': 100,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('case_status',): {
                        'None': None,
                        "OPEN": "open",
                        "CLOSED": "closed"
                    },
                },
                'openapi_types': {
                    'pacer_user_id':
                        (str,),
                    'pacer_client_code':
                        (str,),
                    'case_number':
                        (str, none_type,),
                    'jpml_number':
                        (int,),
                    'pacer_case_id':
                        (int,),
                    'last_name':
                        (str, none_type,),
                    'first_name':
                        (str, none_type,),
                    'middle_name':
                        (str, none_type,),
                    'generation':
                        (str, none_type,),
                    'party_type':
                        (str, none_type,),
                    'party_exact_name_match':
                        (bool,),
                    'party_role_array':
                        ([str, none_type],),
                    'case_title':
                        (str, none_type,),
                    'case_office':
                        (int,),
                    'case_sequence_number':
                        (int,),
                    'case_year':
                        (int,),
                    'case_type_array':
                        ([str, none_type],),
                    'court_region_id_array':
                        ([str, none_type],),
                    'case_year_from':
                        (int,),
                    'case_year_to':
                        (int,),
                    'case_filed_start_date':
                        (datetime, none_type,),
                    'case_filed_end_date':
                        (datetime, none_type,),
                    'case_terminated_start_date':
                        (datetime, none_type,),
                    'case_terminated_end_date':
                        (datetime, none_type,),
                    'sort_parameter_query':
                        (str, none_type,),
                    'case_status':
                        (str, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'pacer_user_id': 'pacerUserId',
                    'pacer_client_code': 'pacerClientCode',
                    'case_number': 'caseNumber',
                    'jpml_number': 'jpmlNumber',
                    'pacer_case_id': 'pacerCaseId',
                    'last_name': 'lastName',
                    'first_name': 'firstName',
                    'middle_name': 'middleName',
                    'generation': 'generation',
                    'party_type': 'partyType',
                    'party_exact_name_match': 'partyExactNameMatch',
                    'party_role_array': 'partyRoleArray',
                    'case_title': 'caseTitle',
                    'case_office': 'caseOffice',
                    'case_sequence_number': 'caseSequenceNumber',
                    'case_year': 'caseYear',
                    'case_type_array': 'caseTypeArray',
                    'court_region_id_array': 'courtRegionIdArray',
                    'case_year_from': 'caseYearFrom',
                    'case_year_to': 'caseYearTo',
                    'case_filed_start_date': 'caseFiledStartDate',
                    'case_filed_end_date': 'caseFiledEndDate',
                    'case_terminated_start_date': 'caseTerminatedStartDate',
                    'case_terminated_end_date': 'caseTerminatedEndDate',
                    'sort_parameter_query': 'sortParameterQuery',
                    'case_status': 'caseStatus',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'pacer_user_id': 'query',
                    'pacer_client_code': 'query',
                    'case_number': 'query',
                    'jpml_number': 'query',
                    'pacer_case_id': 'query',
                    'last_name': 'query',
                    'first_name': 'query',
                    'middle_name': 'query',
                    'generation': 'query',
                    'party_type': 'query',
                    'party_exact_name_match': 'query',
                    'party_role_array': 'query',
                    'case_title': 'query',
                    'case_office': 'query',
                    'case_sequence_number': 'query',
                    'case_year': 'query',
                    'case_type_array': 'query',
                    'court_region_id_array': 'query',
                    'case_year_from': 'query',
                    'case_year_to': 'query',
                    'case_filed_start_date': 'query',
                    'case_filed_end_date': 'query',
                    'case_terminated_start_date': 'query',
                    'case_terminated_end_date': 'query',
                    'sort_parameter_query': 'query',
                    'case_status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                    'party_role_array': 'multi',
                    'case_type_array': 'multi',
                    'court_region_id_array': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def all_courts_pacer_case_locator_case_search(
        self,
        pacer_user_id,
        pacer_client_code,
        **kwargs
    ):
        """PACER Case Locator Search API for All Courts.  # noqa: E501

        Search all courts within the PACER system for a particular case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.all_courts_pacer_case_locator_case_search(pacer_user_id, pacer_client_code, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The username of the PACER account under which the search is to be performed.
            pacer_client_code (str): The PACER client code under which the search is to be performed.

        Keyword Args:
            case_number (str, none_type): The case number of the target case. You may use the following case-number formats:    yy-nnnnn    yy-tp-nnnnn    yy tp nnnnn    yytpnnnnn    o:yy-nnnnn    o:yy-tp-nnnnn    o:yy tp nnnnn    o:yytpnnnnn   where:   yy  case year (may be 2 or 4 digits)   nnnnn  case number (up to 5 digits)   tp  case type (up to 2 characters)   o  office where the case was filed (1 digit).. [optional]
            pacer_case_id (int): The PACER-assigned identifier of the target case.. [optional]
            case_title (str, none_type): The title of the target case.    Examples:    A search for case title john doe v will result in all cases with the case title John Doe v.    A search for case title Acme, Inc. will result in all case titles starting with Acme, Inc.. [optional]
            case_office (int): The divisional office in which the case was filed.. [optional]
            case_sequence_number (int): The PACER-assigned sequence number of the target case. Ex 12345. [optional]
            case_year (int, none_type): The two- or four-digit year in which the target case was filed.. [optional]
            case_type_array ([str, none_type]): The PACER-assigned case type of the target case. Please see Appendix A for valid case-type values.    Scenario: When mulitple case types needs to be requested.    Imagine for a given case number 12-1234 I would like to search only with the case type civil(cv) and criminal(cr), My query in the request will look like the example mentioned below.    Example: caseTypeArray=cv&caseTypeArray=cr. [optional]
            court_region_id_array ([str, none_type]): The PACER-assigned court region in which the target case was filed. Please see Appendix B for valid court-region values.    Scenario: When mulitple court region ids needs to be requested.    Imagine for a given case number 12-1234 I would like to search in the court regions California Central (cac) and California Eastern (cae), My query in the request will look like the example mentioned below.    Example: courtRegionIdArray=cac&courtRegionIdArray=cae. [optional]
            case_filed_start_date (datetime, none_type): The date on which or after which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_filed_end_date (datetime, none_type): The date on which or before which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_start_date (datetime, none_type): The date on which or after which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_end_date (datetime, none_type): The date on which or before which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            sort_parameter_query (str, none_type): How search results from PACER are to be sorted. Please see Appendix C for valid sort-related settings.    Scenario: When mulitple sort paramters needs to be requested.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of courtId and caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtId,ASC&caseId,ASC. [optional] if omitted the server will use the default value of "sort=caseYear,DESC"
            case_status (str, none_type): Whether the target case is marked as 'open' or 'closed' within PACER.. [optional]
            page_number (int): The page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PCLCase
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        return self.all_courts_pacer_case_locator_case_search_endpoint.call_with_http_info(**kwargs)

    def all_courts_pacer_case_locator_party_search(
        self,
        pacer_user_id,
        pacer_client_code,
        **kwargs
    ):
        """PACER Case Locator Search API for All Courts.  # noqa: E501

        Search for the specified party across all PACER case filings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.all_courts_pacer_case_locator_party_search(pacer_user_id, pacer_client_code, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The username of the PACER account under which the search is to be performed.
            pacer_client_code (str): The PACER client code under which the search is to be performed.

        Keyword Args:
            case_number (str, none_type): The case number of the target case. You may use the following case-number formats:    yy-nnnnn    yy-tp-nnnnn    yy tp nnnnn    yytpnnnnn    o:yy-nnnnn    o:yy-tp-nnnnn    o:yy tp nnnnn    o:yytpnnnnn   where:   yy  case year (may be 2 or 4 digits)   nnnnn  case number (up to 5 digits)   tp  case type (up to 2 characters)   o  office where the case was filed (1 digit).. [optional]
            pacer_case_id (int): The PACER-assigned identifier of the target case.. [optional]
            last_name (str, none_type): The last name (for an individual) or the entity name (for a business entity) of the target party.. [optional]
            first_name (str, none_type): The first name of the target party.. [optional]
            middle_name (str, none_type): The middle name of the target party.. [optional]
            generation (str, none_type): The suffix (e.g., Jr., III) of the target party's name.. [optional]
            party_type (str, none_type): The court-assigned party type for a party involved in a case. Party type codes are created and assigned by individual courts, and as such, their meanings can vary from court to court.. [optional]
            party_exact_name_match (bool): Specify whether the search string must match the name of the target party exactly.. [optional]
            party_role_array ([str, none_type]): The court-assigned role for a party to a case. Party role codes are created and assigned by individual courts, and as such, their meanings can vary from court to court.. [optional]
            case_title (str, none_type): The title of the target case.    Examples:    A search for case title john doe v will result in all cases with the case title John Doe v.    A search for case title Acme, Inc. will result in all case titles starting with Acme, Inc.. [optional]
            case_office (int): The divisional office in which the case was filed.. [optional]
            case_sequence_number (int): The PACER-assigned sequence number of the target case.. [optional]
            case_year (int): The two- or four-digit year in which the target case was filed.. [optional]
            case_type_array ([str, none_type]): The PACER-assigned case type of the target case. Please see Appendix A for valid case-type values.    Scenario: When mulitple case types needs to be requested.    Imagine for a given case number 12-1234 I would like to search only with the case type civil(cv) and criminal(cr), My query in the request will look like the example mentioned below.    Example: caseTypeArray=cv&caseTypeArray=cr. [optional]
            court_region_id_array ([str, none_type]): The PACER-assigned court region in which the target case was filed. Please see Appendix B for valid court-region values.    Scenario: When mulitple court region ids needs to be requested.    Imagine for a given case number 12-1234 I would like to search in the court regions California Central (cac) and California Eastern (cae), My query in the request will look like the example mentioned below.    Example: courtRegionIdArray=cac&courtRegionIdArray=cae. [optional]
            case_year_from (int): Limit the results of the search to those cases from the year specified or later. [optional]
            case_year_to (int): Limit the results of the search to those cases from the year specified or earlier. [optional]
            case_filed_start_date (datetime, none_type): The date on which or after which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_filed_end_date (datetime, none_type): The date on which or before which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_start_date (datetime, none_type): The date on which or after which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_end_date (datetime, none_type): The date on which or before which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            sort_parameter_query (str, none_type): How search results from PACER are to be sorted. Please see Appendix C for valid sort-related settings.    Scenario 1: When mulitple sort paramters needs to be requested.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of courtId and caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtId,ASC&caseId,ASC    Scenario 2: When you want to sort the response using the case parameters in the party search.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of caseOffice and descending order of caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtCase.caseOffice,ASC&caseid,DESC. [optional] if omitted the server will use the default value of "sort=caseYear,DESC"
            case_status (str, none_type): Whether the target case is marked as 'open' or 'closed' within PACER.. [optional]
            page_number (int): The page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PCLParty
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        return self.all_courts_pacer_case_locator_party_search_endpoint.call_with_http_info(**kwargs)

    def appeal_courts_pacer_case_locator_case_search(
        self,
        pacer_user_id,
        pacer_client_code,
        **kwargs
    ):
        """PACER Case Locator Search API for All Courts.  # noqa: E501

        Search for PACER cases filed in U.S. Courts of Appeals.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.appeal_courts_pacer_case_locator_case_search(pacer_user_id, pacer_client_code, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The username of the PACER account under which the search is to be performed.
            pacer_client_code (str): The PACER client code under which the search is to be performed.

        Keyword Args:
            case_number (str, none_type): The case number of the target case. You may use the following case-number formats:    yy-nnnnn    where:   yy  case year (may be 2 or 4 digits)   nnnnn  case number (up to 5 digits).. [optional]
            pacer_case_id (int): The PACER-assigned identifier of the target case.. [optional]
            case_title (str, none_type): The title of the target case.    Examples:    A search for case title john doe v will result in all cases with the case title John Doe v.    A search for case title Acme, Inc. will result in all case titles starting with Acme, Inc.. [optional]
            case_office (int, none_type): The divisional office in which the case was filed.. [optional]
            case_sequence_number (int): The PACER-assigned sequence number of the target case. Ex 12345. [optional]
            case_year (int): The two- or four-digit year in which the target case was filed.. [optional]
            case_type_array ([str, none_type]): The PACER-assigned case type of the target case. Please see Appendix A for valid case-type values.    Scenario: When mulitple case types needs to be requested.    Imagine for a given case number 12-1234 I would like to search only with the case type civil(cv) and criminal(cr), My query in the request will look like the example mentioned below.    Example: caseTypeArray=cv&caseTypeArray=cr. [optional]
            nature_of_suits_array ([str, none_type]): The PACER-assigned nature of suit classification of the target case. Please see Appendix E for valid nature-of-suit classifications for cases in U.S. Courts of Appeals.    Scenario: When mulitple nature of suits needs to be requested.    Imagine for a given case number 12-1234 I would like to search with the nature of suit 1110 (Insurance) and 1150 (Overpayments & Enforc. of Judgments), My query in the request will look like the example mentioned below.    Example: natureOfSuitsArray=1110&natureOfSuitsArray=1150. [optional]
            court_region_id_array ([str, none_type]): The PACER-assigned court region in which the target case was filed. Please see Appendix B for valid court-region values.    Scenario: When mulitple court region ids needs to be requested.    Imagine for a given case number 12-1234 I would like to search in the court regions California Central (cac) and California Eastern (cae), My query in the request will look like the example mentioned below.    Example: courtRegionIdArray=cac&courtRegionIdArray=cae. [optional]
            case_filed_start_date (datetime, none_type): The date on which or after which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_filed_end_date (datetime, none_type): The date on which or before which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_start_date (datetime, none_type): The date on which or after which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_end_date (datetime, none_type): The date on which or before which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            sort_parameter_query (str, none_type): How search results from PACER are to be sorted. Please see Appendix C for valid sort-related settings.    Scenario: When mulitple sort paramters needs to be requested.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of courtId and caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtId,ASC&caseId,ASC. [optional] if omitted the server will use the default value of "sort=caseYear,DESC"
            case_status (str, none_type): Whether the target case is marked as 'open' or 'closed' within PACER.. [optional]
            page_number (int): The page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PCLCase
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        return self.appeal_courts_pacer_case_locator_case_search_endpoint.call_with_http_info(**kwargs)

    def appeal_courts_pacer_case_locator_party_search(
        self,
        pacer_user_id,
        pacer_client_code,
        **kwargs
    ):
        """PACER Case Locator Search API for All Courts.  # noqa: E501

        Search for the specified party across all PACER appeals cases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.appeal_courts_pacer_case_locator_party_search(pacer_user_id, pacer_client_code, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The username of the PACER account under which the search is to be performed.
            pacer_client_code (str): The PACER client code under which the search is to be performed.

        Keyword Args:
            case_number (str, none_type): The case number of the target case. You may use the following case-number formats:    yy-nnnnn    yy-tp-nnnnn    yy tp nnnnn    yytpnnnnn    o:yy-nnnnn    o:yy-tp-nnnnn    o:yy tp nnnnn    o:yytpnnnnn   where:   yy  case year (may be 2 or 4 digits)   nnnnn  case number (up to 5 digits)   tp  case type (up to 2 characters)   o  office where the case was filed (1 digit).. [optional]
            pacer_case_id (int): The PACER-assigned identifier of the target case.. [optional]
            last_name (str, none_type): The last name (for an individual) or the entity name (for a business entity) of the target party.. [optional]
            first_name (str, none_type): The first name of the target party.. [optional]
            middle_name (str, none_type): The middle name of the target party.. [optional]
            generation (str, none_type): The suffix (e.g., Jr., III) of the target party's name.. [optional]
            party_type (str, none_type): The court-assigned party type for a party involved in a case. Party type codes are created and assigned by individual courts, and as such, their meanings can vary from court to court.. [optional]
            party_exact_name_match (bool): Specify whether the search string must match the name of the target party exactly.. [optional]
            party_role_array ([str, none_type]): The court-assigned role for a party to a case. Party role codes are created and assigned by individual courts, and as such, their meanings can vary from court to court.. [optional]
            case_title (str, none_type): The title of the target case.    Examples:    A search for case title john doe v will result in all cases with the case title John Doe v.    A search for case title Acme, Inc. will result in all case titles starting with Acme, Inc.. [optional]
            case_office (int): The divisional office in which the case was filed.. [optional]
            case_sequence_number (int): The PACER-assigned sequence number of the target case. Ex 12345. [optional]
            case_year (int): The two- or four-digit year in which the target case was filed.. [optional]
            case_type_array ([str, none_type]): The PACER-assigned case type of the target case. Please see Appendix A for valid case-type values.    Scenario: When mulitple case types needs to be requested.    Imagine for a given case number 12-1234 I would like to search only with the case type civil(cv) and criminal(cr), My query in the request will look like the example mentioned below.    Example: caseTypeArray=cv&caseTypeArray=cr. [optional]
            court_region_id_array ([str, none_type]): The PACER-assigned court region in which the target case was filed. Please see Appendix B for valid court-region values.    Scenario: When mulitple court region ids needs to be requested.    Imagine for a given case number 12-1234 I would like to search in the court regions California Central (cac) and California Eastern (cae), My query in the request will look like the example mentioned below.    Example: courtRegionIdArray=cac&courtRegionIdArray=cae. [optional]
            case_year_from (int): Limit the results of the search to those cases from the year specified or later. [optional]
            case_year_to (int): Limit the results of the search to those cases from the year specified or earlier. [optional]
            case_filed_start_date (datetime, none_type): The date on which or after which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_filed_end_date (datetime, none_type): The date on which or before which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_start_date (datetime, none_type): The date on which or after which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_end_date (datetime, none_type): The date on which or before which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            sort_parameter_query (str, none_type): How search results from PACER are to be sorted. Please see Appendix C for valid sort-related settings.    Scenario 1: When mulitple sort paramters needs to be requested.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of courtId and caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtId,ASC&caseId,ASC    Scenario 2: When you want to sort the response using the case parameters in the party search.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of caseOffice and descending order of caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtCase.caseOffice,ASC&caseid,DESC. [optional] if omitted the server will use the default value of "sort=caseYear,DESC"
            case_status (str, none_type): Whether the target case is marked as 'open' or 'closed' within PACER.. [optional]
            page_number (int): The page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PCLParty
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        return self.appeal_courts_pacer_case_locator_party_search_endpoint.call_with_http_info(**kwargs)

    def bankruptcy_courts_pacer_case_locator_case_search(
        self,
        pacer_user_id,
        pacer_client_code,
        **kwargs
    ):
        """PACER Case Locator Search API for Bankruptcy Courts.  # noqa: E501

        Search for PACER cases filed in U.S. Bankruptcy Courts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.bankruptcy_courts_pacer_case_locator_case_search(pacer_user_id, pacer_client_code, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The username of the PACER account under which the search is to be performed.
            pacer_client_code (str): The PACER client code under which the search is to be performed.

        Keyword Args:
            case_number (str, none_type): The case number of the target case. You may use the following case-number formats:    yy-nnnnn    yy-tp-nnnnn    yy tp nnnnn    yytpnnnnn    o:yy-nnnnn    o:yy-tp-nnnnn    o:yy tp nnnnn    o:yytpnnnnn   where:   yy  case year (may be 2 or 4 digits)   nnnnn  case number (up to 5 digits)   tp  case type (up to 2 characters)   o  office where the case was filed (1 digit).. [optional]
            pacer_case_id (int): The PACER-assigned identifier of the target case.. [optional]
            case_title (str, none_type): The title of the target case.    Examples:    A search for case title john doe v will result in all cases with the case title John Doe v.    A search for case title Acme, Inc. will result in all case titles starting with Acme, Inc.. [optional]
            case_office (int): The divisional office in which the case was filed.. [optional]
            case_sequence_number (int): The PACER-assigned sequence number of the target case. Ex 12345. [optional]
            case_year (int): The two- or four-digit year in which the target case was filed.. [optional]
            case_type_array ([str, none_type]): The PACER-assigned case type of the target case. Please see Appendix A for valid case-type values.    Scenario: When mulitple case types needs to be requested.    Imagine for a given case number 12-1234 I would like to search only with the case type civil(cv) and criminal(cr), My query in the request will look like the example mentioned below.    Example: caseTypeArray=cv&caseTypeArray=cr. [optional]
            federal_bankruptcy_chapter_array ([str, none_type]): The chapter of the U.S. Bankruptcy Code under which the target case was filed. Please see Appendix D for a list of valid chapter numbers.    Scenario: When mulitple Federal Bankruptcy Chapters needs to be requested.    Imagine for a given case number 12-1234 I would like to search with the Federal Bankruptcy Chapters 7 (Chapter 7) and 11 (Chapter 11), My query in the request will look like the example mentioned below.    Example: federalBankruptcyChapterArray=7&federalBankruptcyChapterArray=11. [optional]
            court_region_id_array ([str, none_type]): The PACER-assigned court region in which the target case was filed. Please see Appendix B for valid court-region values.    Scenario: When mulitple court region ids needs to be requested.    Imagine for a given case number 12-1234 I would like to search in the court regions California Central (cac) and California Eastern (cae), My query in the request will look like the example mentioned below.    Example: courtRegionIdArray=cac&courtRegionIdArray=cae. [optional]
            case_filed_start_date (datetime, none_type): The date on which or after which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_filed_end_date (datetime, none_type): The date on which or before which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_start_date (datetime, none_type): The date on which or after which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_end_date (datetime, none_type): The date on which or before which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_discharged_start_date (datetime, none_type): The date on which or after which the target case was marked as discharged within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).    Note: This parameter is applicable since we only perform this search for Bankruptcy Court type.. [optional]
            case_discharged_end_date (datetime, none_type): The date on which or before which the target case was marked as discharged within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).    Note: This parameter is applicable since we only perform this search for Bankruptcy Court type.. [optional]
            case_dismissed_start_date (datetime, none_type): The date on which or after which the target case was marked as dismissed within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).    Note: This parameter is applicable since we only perform this search for Bankruptcy Court type.. [optional]
            case_dismissed_end_date (datetime, none_type): The date on which or before which the target case was marked as dismissed within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            sort_parameter_query (str, none_type): How search results from PACER are to be sorted. Please see Appendix C for valid sort-related settings.    Scenario: When mulitple sort paramters needs to be requested.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of courtId and caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtId,ASC&caseId,ASC. [optional] if omitted the server will use the default value of "sort=caseYear,DESC"
            case_status (str, none_type): Whether the target case is marked as 'open' or 'closed' within PACER.. [optional]
            page_number (int): The page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PCLCase
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        return self.bankruptcy_courts_pacer_case_locator_case_search_endpoint.call_with_http_info(**kwargs)

    def bankruptcy_courts_pacer_case_locator_party_search(
        self,
        pacer_user_id,
        pacer_client_code,
        **kwargs
    ):
        """PACER Case Locator Search API for All Courts.  # noqa: E501

        Search for the specified party in PACER bankruptcy filings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.bankruptcy_courts_pacer_case_locator_party_search(pacer_user_id, pacer_client_code, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The username of the PACER account under which the search is to be performed.
            pacer_client_code (str): The PACER client code under which the search is to be performed.

        Keyword Args:
            case_number (str, none_type): The case number of the target case. You may use the following case-number formats:    yy-nnnnn    yy-tp-nnnnn    yy tp nnnnn    yytpnnnnn    o:yy-nnnnn    o:yy-tp-nnnnn    o:yy tp nnnnn    o:yytpnnnnn   where:   yy  case year (may be 2 or 4 digits)   nnnnn  case number (up to 5 digits)   tp  case type (up to 2 characters)   o  office where the case was filed (1 digit).. [optional]
            pacer_case_id (int): The PACER-assigned identifier of the target case.. [optional]
            last_name (str, none_type): The last name (for an individual) or the entity name (for a business entity) of the target party.. [optional]
            first_name (str, none_type): The first name of the target party.. [optional]
            middle_name (str, none_type): The middle name of the target party.. [optional]
            generation (str, none_type): The suffix (e.g., Jr., III) of the target party's name.. [optional]
            party_type (str, none_type): The court-assigned party type for a party involved in a case. Party type codes are created and assigned by individual courts, and as such, their meanings can vary from court to court.. [optional]
            party_exact_name_match (bool): Specify whether the search string must match the name of the target party exactly.. [optional]
            party_role_array ([str, none_type]): The court-assigned role for a party to a case. Party role codes are created and assigned by individual courts, and as such, their meanings can vary from court to court.. [optional]
            case_title (str, none_type): The title of the target case.    Examples:    A search for case title john doe v will result in all cases with the case title John Doe v.    A search for case title Acme, Inc. will result in all case titles starting with Acme, Inc.. [optional]
            case_office (int): The divisional office in which the case was filed.. [optional]
            case_sequence_number (int): The PACER-assigned sequence number of the target case. Ex 12345. [optional]
            case_year (int): The two- or four-digit year in which the target case was filed.. [optional]
            case_type_array ([str, none_type]): The PACER-assigned case type of the target case. Please see Appendix A for valid case-type values.    Scenario: When mulitple case types needs to be requested.    Imagine for a given case number 12-1234 I would like to search only with the case type civil(cv) and criminal(cr), My query in the request will look like the example mentioned below.    Example: caseTypeArray=cv&caseTypeArray=cr. [optional]
            court_region_id_array ([str, none_type]): The PACER-assigned court region in which the target case was filed. Please see Appendix B for valid court-region values.    Scenario: When mulitple court region ids needs to be requested.    Imagine for a given case number 12-1234 I would like to search in the court regions California Central (cac) and California Eastern (cae), My query in the request will look like the example mentioned below.    Example: courtRegionIdArray=cac&courtRegionIdArray=cae. [optional]
            case_year_from (int): Limit the results of the search to those cases from the year specified or later. [optional]
            case_year_to (int): Limit the results of the search to those cases from the year specified or earlier. [optional]
            ssn_or_ein (str, none_type): The Social Security number or the federal Employer Identification Number of the target party. Either number can be entered with or without dashes.. [optional]
            four_digit_ssn (str, none_type): The last four digits of the Social Security number of the target party.   Note: When specified, a last name/entity name must also be specified.. [optional]
            case_filed_start_date (datetime, none_type): The date on which or after which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_filed_end_date (datetime, none_type): The date on which or before which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_start_date (datetime, none_type): The date on which or after which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_end_date (datetime, none_type): The date on which or before which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_discharged_start_date (datetime, none_type): The date on which or after which the target case was marked as discharged within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).    Note: This parameter is applicable since we only perform this search for Bankruptcy Court type.. [optional]
            case_discharged_end_date (datetime, none_type): The date on which or before which the target case was marked as discharged within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).    Note: This parameter is applicable since we only perform this search for Bankruptcy Court type.. [optional]
            case_dismissed_start_date (datetime, none_type): The date on which or after which the target case was marked as dismissed within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).    Note: This parameter is applicable since we only perform this search for Bankruptcy Court type.. [optional]
            case_dismissed_end_date (datetime, none_type): The date on which or before which the target case was marked as dismissed within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            sort_parameter_query (str, none_type): How search results from PACER are to be sorted. Please see Appendix C for valid sort-related settings.    Scenario 1: When mulitple sort paramters needs to be requested.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of courtId and caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtId,ASC&caseId,ASC    Scenario 2: When you want to sort the response using the case parameters in the party search.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of caseOffice and descending order of caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtCase.caseOffice,ASC&caseid,DESC. [optional] if omitted the server will use the default value of "sort=caseYear,DESC"
            case_status (str, none_type): Whether the target case is marked as 'open' or 'closed' within PACER.. [optional]
            page_number (int): The page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PCLParty
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        return self.bankruptcy_courts_pacer_case_locator_party_search_endpoint.call_with_http_info(**kwargs)

    def civil_courts_pacer_case_locator_case_search(
        self,
        pacer_user_id,
        pacer_client_code,
        **kwargs
    ):
        """PACER Case Locator Search API for All Courts.  # noqa: E501

        Search for civil cases filed in PACER.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.civil_courts_pacer_case_locator_case_search(pacer_user_id, pacer_client_code, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The username of the PACER account under which the search is to be performed.
            pacer_client_code (str): The PACER client code under which the search is to be performed.

        Keyword Args:
            case_number (str, none_type): The case number of the target case. You may use the following case-number formats:    yy-nnnnn    yy-tp-nnnnn    yy tp nnnnn    yytpnnnnn    o:yy-nnnnn    o:yy-tp-nnnnn    o:yy tp nnnnn    o:yytpnnnnn   where:   yy  case year (may be 2 or 4 digits)   nnnnn  case number (up to 5 digits)   tp  case type (up to 2 characters)   o  office where the case was filed (1 digit).. [optional]
            pacer_case_id (int): The PACER-assigned identifier of the target case.. [optional]
            case_title (str, none_type): The title of the target case.    Examples:    A search for case title john doe v will result in all cases with the case title John Doe v.    A search for case title Acme, Inc. will result in all case titles starting with Acme, Inc.. [optional]
            case_office (int): The divisional office in which the case was filed.. [optional]
            case_sequence_number (int): The PACER-assigned sequence number of the target case.. [optional]
            case_year (int): The two- or four-digit year in which the target case was filed.. [optional]
            case_type_array ([str, none_type]): The PACER-assigned case type of the target case. Please see Appendix A for valid case-type values.    Scenario: When mulitple case types needs to be requested.    Imagine for a given case number 12-1234 I would like to search only with the case type civil(cv) and criminal(cr), My query in the request will look like the example mentioned below.    Example: caseTypeArray=cv&caseTypeArray=cr. [optional]
            nature_of_suits_array ([str, none_type]): The PACER-assigned nature of suit classification of the target case. Please see Appendix E for valid nature-of-suit classifications for cases.    Scenario: When mulitple nature of suits needs to be requested.    Imagine for a given case number 12-1234 I would like to search with the nature of suit 110 (Insurance) and 140 (Negotiable Instrument), My query in the request will look like the example mentioned below.    Example: natureOfSuitsArray=110&natureOfSuitsArray=140. [optional]
            court_region_id_array ([str, none_type]): The PACER-assigned court region in which the target case was filed. Please see Appendix B for valid court-region values.    Scenario: When mulitple court region ids needs to be requested.    Imagine for a given case number 12-1234 I would like to search in the court regions California Central (cac) and California Eastern (cae), My query in the request will look like the example mentioned below.    Example: courtRegionIdArray=cac&courtRegionIdArray=cae. [optional]
            case_filed_start_date (datetime, none_type): The date on which or after which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_filed_end_date (datetime, none_type): The date on which or before which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_start_date (datetime, none_type): The date on which or after which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_end_date (datetime, none_type): The date on which or before which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            sort_parameter_query (str, none_type): How search results from PACER are to be sorted. Please see Appendix C for valid sort-related settings.    Scenario: When mulitple sort paramters needs to be requested.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of courtId and caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtId,ASC&caseId,ASC. [optional] if omitted the server will use the default value of "sort=caseYear,DESC"
            case_status (str, none_type): Whether the target case is marked as 'open' or 'closed' within PACER.. [optional]
            page_number (int): The page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PCLCase
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        return self.civil_courts_pacer_case_locator_case_search_endpoint.call_with_http_info(**kwargs)

    def civil_courts_pacer_case_locator_party_search(
        self,
        pacer_user_id,
        pacer_client_code,
        **kwargs
    ):
        """PACER Case Locator Search API for All Courts.  # noqa: E501

        Search for the specified party in civil cases filed in PACER.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.civil_courts_pacer_case_locator_party_search(pacer_user_id, pacer_client_code, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The username of the PACER account under which the search is to be performed.
            pacer_client_code (str): The PACER client code under which the search is to be performed.

        Keyword Args:
            case_number (str, none_type): The case number of the target case. You may use the following case-number formats:    yy-nnnnn    yy-tp-nnnnn    yy tp nnnnn    yytpnnnnn    o:yy-nnnnn    o:yy-tp-nnnnn    o:yy tp nnnnn    o:yytpnnnnn   where:   yy  case year (may be 2 or 4 digits)   nnnnn  case number (up to 5 digits)   tp  case type (up to 2 characters)   o  office where the case was filed (1 digit).. [optional]
            pacer_case_id (int): The PACER-assigned identifier of the target case.. [optional]
            last_name (str, none_type): The last name (for an individual) or the entity name (for a business entity) of the target party.. [optional]
            first_name (str, none_type): The first name of the target party.. [optional]
            middle_name (str, none_type): The middle name of the target party.. [optional]
            generation (str, none_type): The name suffix (e.g., III, MD).. [optional]
            party_type (str, none_type): The court-assigned party type for a party involved in a case. Party type codes are created and assigned by individual courts, and as such, their meanings can vary from court to court.. [optional]
            party_exact_name_match (bool): Specify whether the search string must match the name of the target party exactly.. [optional]
            party_role_array ([str, none_type]): The court-assigned role for a party to a case. Party role codes are created and assigned by individual courts, and as such, their meanings can vary from court to court.. [optional]
            case_title (str, none_type): The title of the target case.    Examples:    A search for case title john doe v will result in all cases with the case title John Doe v.    A search for case title Acme, Inc. will result in all case titles starting with Acme, Inc.. [optional]
            case_office (int): The divisional office in which the case was filed.. [optional]
            case_sequence_number (int): The PACER-assigned sequence number of the target case. Ex 12345. [optional]
            case_year (int): The two- or four-digit year in which the target case was filed.. [optional]
            case_type_array ([str, none_type]): The PACER-assigned case type of the target case. Please see Appendix A for valid case-type values.    Scenario: When mulitple case types needs to be requested.    Imagine for a given case number 12-1234 I would like to search only with the case type civil(cv) and criminal(cr), My query in the request will look like the example mentioned below.    Example: caseTypeArray=cv&caseTypeArray=cr. [optional]
            court_region_id_array ([str, none_type]): The PACER-assigned court region in which the target case was filed. Please see Appendix B for valid court-region values.    Scenario: When mulitple court region ids needs to be requested.    Imagine for a given case number 12-1234 I would like to search in the court regions California Central (cac) and California Eastern (cae), My query in the request will look like the example mentioned below.    Example: courtRegionIdArray=cac&courtRegionIdArray=cae. [optional]
            case_year_from (int): Limit the results of the search to those cases from the year specified or later. [optional]
            case_year_to (int): Limit the results of the search to those cases from the year specified or earlier. [optional]
            case_filed_start_date (datetime, none_type): The date on which or after which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_filed_end_date (datetime, none_type): The date on which or before which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_start_date (datetime, none_type): The date on which or after which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_end_date (datetime, none_type): The date on which or before which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            sort_parameter_query (str, none_type): How search results from PACER are to be sorted. Please see Appendix C for valid sort-related settings.    Scenario 1: When mulitple sort paramters needs to be requested.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of courtId and caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtId,ASC&caseId,ASC    Scenario 2: When you want to sort the response using the case parameters in the party search.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of caseOffice and descending order of caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtCase.caseOffice,ASC&caseid,DESC. [optional] if omitted the server will use the default value of "sort=caseYear,DESC"
            case_status (str, none_type): Whether the target case is marked as 'open' or 'closed' within PACER.. [optional]
            page_number (int): The page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PCLParty
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        return self.civil_courts_pacer_case_locator_party_search_endpoint.call_with_http_info(**kwargs)

    def criminal_courts_pacer_case_locator_case_search(
        self,
        pacer_user_id,
        pacer_client_code,
        **kwargs
    ):
        """PACER Case Locator Search API for All Courts.  # noqa: E501

        Search for criminal cases in PACER.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.criminal_courts_pacer_case_locator_case_search(pacer_user_id, pacer_client_code, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The username of the PACER account under which the search is to be performed.
            pacer_client_code (str): The PACER client code under which the search is to be performed.

        Keyword Args:
            case_number (str, none_type): The case number of the target case. You may use the following case-number formats:    yy-nnnnn    yy-tp-nnnnn    yy tp nnnnn    yytpnnnnn    o:yy-nnnnn    o:yy-tp-nnnnn    o:yy tp nnnnn    o:yytpnnnnn   where:   yy  case year (may be 2 or 4 digits)   nnnnn  case number (up to 5 digits)   tp  case type (up to 2 characters)   o  office where the case was filed (1 digit).. [optional]
            pacer_case_id (int): The PACER-assigned identifier of the target case.. [optional]
            case_title (str, none_type): The title of the target case.    Examples:    A search for case title john doe v will result in all cases with the case title John Doe v.    A search for case title Acme, Inc. will result in all case titles starting with Acme, Inc.. [optional]
            case_office (int): The divisional office in which the case was filed.. [optional]
            case_sequence_number (int): The PACER-assigned sequence number of the target case. Ex 12345. [optional]
            case_year (int): The two- or four-digit year in which the target case was filed.. [optional]
            case_type_array ([str, none_type]): The PACER-assigned case type of the target case. Please see Appendix A for valid case-type values.    Scenario: When mulitple case types needs to be requested.    Imagine for a given case number 12-1234 I would like to search only with the case type civil(cv) and criminal(cr), My query in the request will look like the example mentioned below.    Example: caseTypeArray=cv&caseTypeArray=cr. [optional]
            court_region_id_array ([str, none_type]): The PACER-assigned court region in which the target case was filed. Please see Appendix B for valid court-region values.    Scenario: When mulitple court region ids needs to be requested.    Imagine for a given case number 12-1234 I would like to search in the court regions California Central (cac) and California Eastern (cae), My query in the request will look like the example mentioned below.    Example: courtRegionIdArray=cac&courtRegionIdArray=cae. [optional]
            case_filed_start_date (datetime, none_type): The date on which or after which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_filed_end_date (datetime, none_type): The date on which or before which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_start_date (datetime, none_type): The date on which or after which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_end_date (datetime, none_type): The date on which or before which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            sort_parameter_query (str, none_type): How search results from PACER are to be sorted. Please see Appendix C for valid sort-related settings.    Scenario: When mulitple sort paramters needs to be requested.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of courtId and caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtId,ASC&caseId,ASC. [optional] if omitted the server will use the default value of "sort=caseYear,DESC"
            case_status (str, none_type): Whether the target case is marked as 'open' or 'closed' within PACER.. [optional]
            page_number (int): The page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PCLCase
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        return self.criminal_courts_pacer_case_locator_case_search_endpoint.call_with_http_info(**kwargs)

    def criminal_courts_pacer_case_locator_party_search(
        self,
        pacer_user_id,
        pacer_client_code,
        **kwargs
    ):
        """PACER Case Locator Search API for All Courts.  # noqa: E501

        Search for the specified party in PACER criminal cases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.criminal_courts_pacer_case_locator_party_search(pacer_user_id, pacer_client_code, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The username of the PACER account under which the search is to be performed.
            pacer_client_code (str): The PACER client code under which the search is to be performed.

        Keyword Args:
            case_number (str, none_type): The case number of the target case. You may use the following case-number formats:    yy-nnnnn    yy-tp-nnnnn    yy tp nnnnn    yytpnnnnn    o:yy-nnnnn    o:yy-tp-nnnnn    o:yy tp nnnnn    o:yytpnnnnn   where:   yy  case year (may be 2 or 4 digits)   nnnnn  case number (up to 5 digits)   tp  case type (up to 2 characters)   o  office where the case was filed (1 digit).. [optional]
            pacer_case_id (int): The PACER-assigned identifier of the target case.. [optional]
            last_name (str, none_type): The last name (for an individual) or the entity name (for a business entity) of the target party.. [optional]
            first_name (str, none_type): The first name of the target party.. [optional]
            middle_name (str, none_type): The middle name of the target party.. [optional]
            generation (str, none_type): The suffix (e.g., Jr., III) of the target party's name.. [optional]
            party_type (str, none_type): The court-assigned party type for a party involved in a case. Party type codes are created and assigned by individual courts, and as such, their meanings can vary from court to court.. [optional]
            party_exact_name_match (bool): Specify whether the search string must match the name of the target party exactly.. [optional]
            party_role_array ([str, none_type]): The court-assigned role for a party to a case. Party role codes are created and assigned by individual courts, and as such, their meanings can vary from court to court.. [optional]
            case_title (str, none_type): The title of the target case.    Examples:    A search for case title john doe v will result in all cases with the case title John Doe v.    A search for case title Acme, Inc. will result in all case titles starting with Acme, Inc.. [optional]
            case_office (int): The divisional office in which the case was filed.. [optional]
            case_sequence_number (int): The PACER-assigned sequence number of the target case. Ex 12345. [optional]
            case_year (int): The two- or four-digit year in which the target case was filed.. [optional]
            case_type_array ([str, none_type]): The PACER-assigned case type of the target case. Please see Appendix A for valid case-type values.    Scenario: When mulitple case types needs to be requested.    Imagine for a given case number 12-1234 I would like to search only with the case type civil(cv) and criminal(cr), My query in the request will look like the example mentioned below.    Example: caseTypeArray=cv&caseTypeArray=cr. [optional]
            court_region_id_array ([str, none_type]): The PACER-assigned court region in which the target case was filed. Please see Appendix B for valid court-region values.    Scenario: When mulitple court region ids needs to be requested.    Imagine for a given case number 12-1234 I would like to search in the court regions California Central (cac) and California Eastern (cae), My query in the request will look like the example mentioned below.    Example: courtRegionIdArray=cac&courtRegionIdArray=cae. [optional]
            case_year_from (int): Limit the results of the search to those cases from the year specified or later. [optional]
            case_year_to (int): Limit the results of the search to those cases from the year specified or earlier. [optional]
            case_filed_start_date (datetime, none_type): The date on which or after which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_filed_end_date (datetime, none_type): The date on which or before which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_start_date (datetime, none_type): The date on which or after which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_end_date (datetime, none_type): The date on which or before which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            sort_parameter_query (str, none_type): How search results from PACER are to be sorted. Please see Appendix C for valid sort-related settings.    Scenario 1: When mulitple sort paramters needs to be requested.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of courtId and caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtId,ASC&caseId,ASC    Scenario 2: When you want to sort the response using the case parameters in the party search.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of caseOffice and descending order of caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtCase.caseOffice,ASC&caseid,DESC. [optional] if omitted the server will use the default value of "sort=caseYear,DESC"
            case_status (str, none_type): Whether the target case is marked as 'open' or 'closed' within PACER.. [optional]
            page_number (int): The page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PCLParty
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        return self.criminal_courts_pacer_case_locator_party_search_endpoint.call_with_http_info(**kwargs)

    def import_pacer_case_by_court_using_case_number(
        self,
        pacer_user_id,
        pacer_client_code,
        case_number,
        court_id,
        **kwargs
    ):
        """Find PACER Case for a requested Case Number and Court.  # noqa: E501

        Import the specified case from PACER.    Workflow:     1.This API will return the Find Case results from the court site in a form of array of UniCourt Case Objects. These case objects will consists only Meta information of the case if not already present in the UniCourt Database.     2.To get the full updated case information one will have to request the caseUpdate API by passing the caseId.    Note:     1.Charges for Find Case in District, Bankruptcy and National Courts is free. Find case for Appeal Courts will be charged at minimum rate of $0.1. The fee charged by the court for find case can be found in the response of this API in the field courtFee.     2.The results of the search has less Meta information in case objects compared to the Meta information of cases found using the PCL search APIs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_pacer_case_by_court_using_case_number(pacer_user_id, pacer_client_code, case_number, court_id, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The PACER username of the PACER account under which the case should be imported.
            pacer_client_code (str): The PACER client code under which the case should be imported.
            case_number (str): The case number of the case to be imported.
            court_id (str): The courtId value of the court from which the case is to be imported.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PACERImportCase
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        kwargs['case_number'] = \
            case_number
        kwargs['court_id'] = \
            court_id
        return self.import_pacer_case_by_court_using_case_number_endpoint.call_with_http_info(**kwargs)

    def multi_district_courts_pacer_case_locator_case_search(
        self,
        pacer_user_id,
        pacer_client_code,
        **kwargs
    ):
        """PACER Case Locator Search API for All Courts.  # noqa: E501

        Search for multidistrict litigation in PACER.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.multi_district_courts_pacer_case_locator_case_search(pacer_user_id, pacer_client_code, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The username of the PACER account under which the search is to be performed.
            pacer_client_code (str): The PACER client code under which the search is to be performed.

        Keyword Args:
            case_number (str, none_type): The case number of the target case. You may use the following case-number formats:    yy-nnnnn    yy-tp-nnnnn    yy tp nnnnn    yytpnnnnn    o:yy-nnnnn    o:yy-tp-nnnnn    o:yy tp nnnnn    o:yytpnnnnn   where:   yy  case year (may be 2 or 4 digits)   nnnnn  case number (up to 5 digits)   tp  case type (up to 2 characters)   o  office where the case was filed (1 digit).. [optional]
            jpml_number (int): Master JPML Case Number.. [optional]
            pacer_case_id (int): The PACER-assigned identifier of the target case.. [optional]
            case_title (str, none_type): The title of the target case.    Examples:    A search for case title john doe v will result in all cases with the case title John Doe v.    A search for case title Acme, Inc. will result in all case titles starting with Acme, Inc.. [optional]
            case_office (int): The divisional office in which the case was filed.. [optional]
            case_sequence_number (int): The PACER-assigned sequence number of the target case. Ex 12345. [optional]
            case_year (int): The two- or four-digit year in which the target case was filed.. [optional]
            case_type_array ([str, none_type]): The PACER-assigned case type of the target case. Please see Appendix A for valid case-type values.    Scenario: When mulitple case types needs to be requested.    Imagine for a given case number 12-1234 I would like to search only with the case type civil(cv) and criminal(cr), My query in the request will look like the example mentioned below.    Example: caseTypeArray=cv&caseTypeArray=cr. [optional]
            court_region_id_array ([str, none_type]): The PACER-assigned court region in which the target case was filed. Please see Appendix B for valid court-region values.    Scenario: When mulitple court region ids needs to be requested.    Imagine for a given case number 12-1234 I would like to search in the court regions California Central (cac) and California Eastern (cae), My query in the request will look like the example mentioned below.    Example: courtRegionIdArray=cac&courtRegionIdArray=cae. [optional]
            case_filed_start_date (datetime, none_type): The date on which or after which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_filed_end_date (datetime, none_type): The date on which or before which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_start_date (datetime, none_type): The date on which or after which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_end_date (datetime, none_type): The date on which or before which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            sort_parameter_query (str, none_type): How search results from PACER are to be sorted. Please see Appendix C for valid sort-related settings.    Scenario: When mulitple sort paramters needs to be requested.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of courtId and caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtId,ASC&caseId,ASC. [optional] if omitted the server will use the default value of "sort=caseYear,DESC"
            case_status (str, none_type): Whether the target case is marked as 'open' or 'closed' within PACER.. [optional]
            page_number (int): The page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PCLCase
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        return self.multi_district_courts_pacer_case_locator_case_search_endpoint.call_with_http_info(**kwargs)

    def multi_district_courts_pacer_case_locator_party_search(
        self,
        pacer_user_id,
        pacer_client_code,
        **kwargs
    ):
        """PACER Case Locator Search API for All Courts.  # noqa: E501

        Search for the specified party in multidistrict litigation in PACER.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.multi_district_courts_pacer_case_locator_party_search(pacer_user_id, pacer_client_code, async_req=True)
        >>> result = thread.get()

        Args:
            pacer_user_id (str): The username of the PACER account under which the search is to be performed.
            pacer_client_code (str): The PACER client code under which the search is to be performed.

        Keyword Args:
            case_number (str, none_type): The case number of the target case. You may use the following case-number formats:    yy-nnnnn    yy-tp-nnnnn    yy tp nnnnn    yytpnnnnn    o:yy-nnnnn    o:yy-tp-nnnnn    o:yy tp nnnnn    o:yytpnnnnn   where:   yy  case year (may be 2 or 4 digits)   nnnnn  case number (up to 5 digits)   tp  case type (up to 2 characters)   o  office where the case was filed (1 digit).. [optional]
            jpml_number (int): Master JPML Case Number.. [optional]
            pacer_case_id (int): The PACER-assigned identifier of the target case.. [optional]
            last_name (str, none_type): The last name (for an individual) or the entity name (for a business entity) of the target party.. [optional]
            first_name (str, none_type): The first name of the target party.. [optional]
            middle_name (str, none_type): The middle name of the target party.. [optional]
            generation (str, none_type): The suffix (e.g., Jr., III) of the target party's name.. [optional]
            party_type (str, none_type): The court-assigned party type for a party involved in a case. Party type codes are created and assigned by individual courts, and as such, their meanings can vary from court to court.. [optional]
            party_exact_name_match (bool): Specify whether the search string must match the name of the target party exactly.. [optional]
            party_role_array ([str, none_type]): The court-assigned role for a party to a case. Party role codes are created and assigned by individual courts, and as such, their meanings can vary from court to court.. [optional]
            case_title (str, none_type): The title of the target case.    Examples:    A search for case title john doe v will result in all cases with the case title John Doe v.    A search for case title Acme, Inc. will result in all case titles starting with Acme, Inc.. [optional]
            case_office (int): The divisional office in which the case was filed.. [optional]
            case_sequence_number (int): The PACER-assigned sequence number of the target case. Ex 12345. [optional]
            case_year (int): The two- or four-digit year in which the target case was filed.. [optional]
            case_type_array ([str, none_type]): The PACER-assigned case type of the target case. Please see Appendix A for valid case-type values.    Scenario: When mulitple case types needs to be requested.    Imagine for a given case number 12-1234 I would like to search only with the case type civil(cv) and criminal(cr), My query in the request will look like the example mentioned below.    Example: caseTypeArray=cv&caseTypeArray=cr. [optional]
            court_region_id_array ([str, none_type]): The PACER-assigned court region in which the target case was filed. Please see Appendix B for valid court-region values.    Scenario: When mulitple court region ids needs to be requested.    Imagine for a given case number 12-1234 I would like to search in the court regions California Central (cac) and California Eastern (cae), My query in the request will look like the example mentioned below.    Example: courtRegionIdArray=cac&courtRegionIdArray=cae. [optional]
            case_year_from (int): Limit the results of the search to those cases from the year specified or later. [optional]
            case_year_to (int): Limit the results of the search to those cases from the year specified or earlier. [optional]
            case_filed_start_date (datetime, none_type): The date on which or after which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_filed_end_date (datetime, none_type): The date on which or before which the target case was filed. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_start_date (datetime, none_type): The date on which or after which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            case_terminated_end_date (datetime, none_type): The date on which or before which the target case was marked as terminated within PACER. The date format must be YYYY-MM-DDTHH:MM:SS+ZZ:zz, (e.g., 2017-12-20T12:54:24+00:00).. [optional]
            sort_parameter_query (str, none_type): How search results from PACER are to be sorted. Please see Appendix C for valid sort-related settings.    Scenario 1: When mulitple sort paramters needs to be requested.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of courtId and caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtId,ASC&caseId,ASC    Scenario 2: When you want to sort the response using the case parameters in the party search.    Imagine for a given case number 12-1234 I would like to sort the results in the Ascending order of caseOffice and descending order of caseId, My query in the request will look like the example mentioned below.    Example: sortParameterQuery=courtCase.caseOffice,ASC&caseid,DESC. [optional] if omitted the server will use the default value of "sort=caseYear,DESC"
            case_status (str, none_type): Whether the target case is marked as 'open' or 'closed' within PACER.. [optional]
            page_number (int): The page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PCLParty
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['pacer_user_id'] = \
            pacer_user_id
        kwargs['pacer_client_code'] = \
            pacer_client_code
        return self.multi_district_courts_pacer_case_locator_party_search_endpoint.call_with_http_info(**kwargs)

