"""
    UniCourt Enterprise APIs

    <button><a href=\"/enterpriseapi/download/UniCourt-Enterprise-API-Spec.yaml\" >Download UniCourt Enterprise APIs Specification</a></button>   # noqa: E501

    The version of the OpenAPI document: 
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from unicourt.api_client import ApiClient, Endpoint as _Endpoint
from unicourt.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from unicourt.model.area_of_law import AreaOfLaw
from unicourt.model.area_of_law_response import AreaOfLawResponse
from unicourt.model.attorney_representation_type import AttorneyRepresentationType
from unicourt.model.attorney_representation_type_response import AttorneyRepresentationTypeResponse
from unicourt.model.attorney_type import AttorneyType
from unicourt.model.attorney_type_response import AttorneyTypeResponse
from unicourt.model.case_class import CaseClass
from unicourt.model.case_class_response import CaseClassResponse
from unicourt.model.case_relationship_type import CaseRelationshipType
from unicourt.model.case_relationship_type_response import CaseRelationshipTypeResponse
from unicourt.model.case_status import CaseStatus
from unicourt.model.case_status_group import CaseStatusGroup
from unicourt.model.case_status_group_response import CaseStatusGroupResponse
from unicourt.model.case_status_response import CaseStatusResponse
from unicourt.model.case_type import CaseType
from unicourt.model.case_type_group import CaseTypeGroup
from unicourt.model.case_type_group_response import CaseTypeGroupResponse
from unicourt.model.case_type_response import CaseTypeResponse
from unicourt.model.cause_of_action import CauseOfAction
from unicourt.model.cause_of_action_additional_data import CauseOfActionAdditionalData
from unicourt.model.cause_of_action_additional_data_response import CauseOfActionAdditionalDataResponse
from unicourt.model.cause_of_action_group import CauseOfActionGroup
from unicourt.model.cause_of_action_group_response import CauseOfActionGroupResponse
from unicourt.model.cause_of_action_response import CauseOfActionResponse
from unicourt.model.charge import Charge
from unicourt.model.charge_additional_data import ChargeAdditionalData
from unicourt.model.charge_additional_data_response import ChargeAdditionalDataResponse
from unicourt.model.charge_degree import ChargeDegree
from unicourt.model.charge_degree_response import ChargeDegreeResponse
from unicourt.model.charge_group import ChargeGroup
from unicourt.model.charge_group_response import ChargeGroupResponse
from unicourt.model.charge_response import ChargeResponse
from unicourt.model.charge_severity import ChargeSeverity
from unicourt.model.charge_severity_response import ChargeSeverityResponse
from unicourt.model.court import Court
from unicourt.model.court_location import CourtLocation
from unicourt.model.court_location_response import CourtLocationResponse
from unicourt.model.court_response import CourtResponse
from unicourt.model.court_service_status import CourtServiceStatus
from unicourt.model.court_service_status_response import CourtServiceStatusResponse
from unicourt.model.court_system import CourtSystem
from unicourt.model.court_system_response import CourtSystemResponse
from unicourt.model.court_type import CourtType
from unicourt.model.court_type_response import CourtTypeResponse
from unicourt.model.exception import Exception
from unicourt.model.judge_type import JudgeType
from unicourt.model.judge_type_response import JudgeTypeResponse
from unicourt.model.jurisdiction_geo import JurisdictionGeo
from unicourt.model.jurisdiction_geo_response import JurisdictionGeoResponse
from unicourt.model.party_role import PartyRole
from unicourt.model.party_role_group import PartyRoleGroup
from unicourt.model.party_role_group_response import PartyRoleGroupResponse
from unicourt.model.party_role_response import PartyRoleResponse


class CourtStandardsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_appeal_courts_for_court_endpoint = _Endpoint(
            settings={
                'response_type': (CourtResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/court/{courtId}/appealCourts',
                'operation_id': 'get_appeal_courts_for_court',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'court_id',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [
                    'court_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'court_id',
                    'page_number',
                ]
            },
            root_map={
                'validations': {
                    ('court_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'court_id':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'court_id': 'courtId',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'court_id': 'path',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_area_of_law_endpoint = _Endpoint(
            settings={
                'response_type': (AreaOfLaw,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/areaOfLaw/{areaOfLawId}',
                'operation_id': 'get_area_of_law',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'area_of_law_id',
                ],
                'required': [
                    'area_of_law_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'area_of_law_id',
                ]
            },
            root_map={
                'validations': {
                    ('area_of_law_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'area_of_law_id':
                        (str,),
                },
                'attribute_map': {
                    'area_of_law_id': 'areaOfLawId',
                },
                'location_map': {
                    'area_of_law_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_areas_of_law_endpoint = _Endpoint(
            settings={
                'response_type': (AreaOfLawResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/areaOfLaw',
                'operation_id': 'get_areas_of_law',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_attorney_representation_type_endpoint = _Endpoint(
            settings={
                'response_type': (AttorneyRepresentationType,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/attorneyRepresentationType/{attorneyRepresentationTypeId}',
                'operation_id': 'get_attorney_representation_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'attorney_representation_type_id',
                ],
                'required': [
                    'attorney_representation_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'attorney_representation_type_id',
                ]
            },
            root_map={
                'validations': {
                    ('attorney_representation_type_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'attorney_representation_type_id':
                        (str,),
                },
                'attribute_map': {
                    'attorney_representation_type_id': 'attorneyRepresentationTypeId',
                },
                'location_map': {
                    'attorney_representation_type_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_attorney_representation_types_endpoint = _Endpoint(
            settings={
                'response_type': (AttorneyRepresentationTypeResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/attorneyRepresentationType',
                'operation_id': 'get_attorney_representation_types',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_attorney_type_endpoint = _Endpoint(
            settings={
                'response_type': (AttorneyType,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/attorneyType/{attorneyTypeId}',
                'operation_id': 'get_attorney_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'attorney_type_id',
                ],
                'required': [
                    'attorney_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'attorney_type_id',
                ]
            },
            root_map={
                'validations': {
                    ('attorney_type_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'attorney_type_id':
                        (str,),
                },
                'attribute_map': {
                    'attorney_type_id': 'attorneyTypeId',
                },
                'location_map': {
                    'attorney_type_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_attorney_types_endpoint = _Endpoint(
            settings={
                'response_type': (AttorneyTypeResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/attorneyType',
                'operation_id': 'get_attorney_types',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_class_endpoint = _Endpoint(
            settings={
                'response_type': (CaseClass,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/caseClass/{caseClassId}',
                'operation_id': 'get_case_class',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_class_id',
                ],
                'required': [
                    'case_class_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_class_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_class_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_class_id':
                        (str,),
                },
                'attribute_map': {
                    'case_class_id': 'caseClassId',
                },
                'location_map': {
                    'case_class_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_relationship_type_endpoint = _Endpoint(
            settings={
                'response_type': (CaseRelationshipType,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/caseRelationshipType/{caseRelationshipTypeId}',
                'operation_id': 'get_case_relationship_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_relationship_type_id',
                ],
                'required': [
                    'case_relationship_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_relationship_type_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_relationship_type_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_relationship_type_id':
                        (str,),
                },
                'attribute_map': {
                    'case_relationship_type_id': 'caseRelationshipTypeId',
                },
                'location_map': {
                    'case_relationship_type_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_relationship_types_endpoint = _Endpoint(
            settings={
                'response_type': (CaseRelationshipTypeResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/caseRelationshipType',
                'operation_id': 'get_case_relationship_types',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_status_endpoint = _Endpoint(
            settings={
                'response_type': (CaseStatus,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/caseStatus/{caseStatusId}',
                'operation_id': 'get_case_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_status_id',
                ],
                'required': [
                    'case_status_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_status_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_status_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_status_id':
                        (str,),
                },
                'attribute_map': {
                    'case_status_id': 'caseStatusId',
                },
                'location_map': {
                    'case_status_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_status_group_endpoint = _Endpoint(
            settings={
                'response_type': (CaseStatusGroup,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/caseStatusGroup/{caseStatusGroupId}',
                'operation_id': 'get_case_status_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_status_group_id',
                ],
                'required': [
                    'case_status_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_status_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_status_group_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_status_group_id':
                        (str,),
                },
                'attribute_map': {
                    'case_status_group_id': 'caseStatusGroupId',
                },
                'location_map': {
                    'case_status_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_status_groups_endpoint = _Endpoint(
            settings={
                'response_type': (CaseStatusGroupResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/caseStatusGroup',
                'operation_id': 'get_case_status_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_type_endpoint = _Endpoint(
            settings={
                'response_type': (CaseType,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/caseType/{caseTypeId}',
                'operation_id': 'get_case_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_type_id',
                ],
                'required': [
                    'case_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_type_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_type_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_type_id':
                        (str,),
                },
                'attribute_map': {
                    'case_type_id': 'caseTypeId',
                },
                'location_map': {
                    'case_type_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_type_group_endpoint = _Endpoint(
            settings={
                'response_type': (CaseTypeGroup,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/caseTypeGroup/{caseTypeGroupId}',
                'operation_id': 'get_case_type_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_type_group_id',
                ],
                'required': [
                    'case_type_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_type_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_type_group_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_type_group_id':
                        (str,),
                },
                'attribute_map': {
                    'case_type_group_id': 'caseTypeGroupId',
                },
                'location_map': {
                    'case_type_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_type_groups_endpoint = _Endpoint(
            settings={
                'response_type': (CaseTypeGroupResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/caseTypeGroup',
                'operation_id': 'get_case_type_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_types_endpoint = _Endpoint(
            settings={
                'response_type': (CaseTypeResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/caseType',
                'operation_id': 'get_case_types',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cases_class_endpoint = _Endpoint(
            settings={
                'response_type': (CaseClassResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/caseClass',
                'operation_id': 'get_cases_class',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cases_status_endpoint = _Endpoint(
            settings={
                'response_type': (CaseStatusResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/caseStatus',
                'operation_id': 'get_cases_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cause_of_action_endpoint = _Endpoint(
            settings={
                'response_type': (CauseOfAction,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/causeOfAction/{causeOfActionId}',
                'operation_id': 'get_cause_of_action',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cause_of_action_id',
                ],
                'required': [
                    'cause_of_action_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'cause_of_action_id',
                ]
            },
            root_map={
                'validations': {
                    ('cause_of_action_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cause_of_action_id':
                        (str,),
                },
                'attribute_map': {
                    'cause_of_action_id': 'causeOfActionId',
                },
                'location_map': {
                    'cause_of_action_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cause_of_action_additional_data_endpoint = _Endpoint(
            settings={
                'response_type': (CauseOfActionAdditionalData,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/causeOfActionAdditionalData/{causeOfActionAdditionalDataId}',
                'operation_id': 'get_cause_of_action_additional_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cause_of_action_additional_data_id',
                ],
                'required': [
                    'cause_of_action_additional_data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'cause_of_action_additional_data_id',
                ]
            },
            root_map={
                'validations': {
                    ('cause_of_action_additional_data_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cause_of_action_additional_data_id':
                        (str,),
                },
                'attribute_map': {
                    'cause_of_action_additional_data_id': 'causeOfActionAdditionalDataId',
                },
                'location_map': {
                    'cause_of_action_additional_data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cause_of_action_group_endpoint = _Endpoint(
            settings={
                'response_type': (CauseOfActionGroup,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/causeOfActionGroup/{causeOfActionGroupId}',
                'operation_id': 'get_cause_of_action_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cause_of_action_group_id',
                ],
                'required': [
                    'cause_of_action_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'cause_of_action_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('cause_of_action_group_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cause_of_action_group_id':
                        (str,),
                },
                'attribute_map': {
                    'cause_of_action_group_id': 'causeOfActionGroupId',
                },
                'location_map': {
                    'cause_of_action_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_causes_of_action_endpoint = _Endpoint(
            settings={
                'response_type': (CauseOfActionResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/causeOfAction',
                'operation_id': 'get_causes_of_action',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_causes_of_action_additional_data_endpoint = _Endpoint(
            settings={
                'response_type': (CauseOfActionAdditionalDataResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/causeOfActionAdditionalData',
                'operation_id': 'get_causes_of_action_additional_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_causes_of_action_group_endpoint = _Endpoint(
            settings={
                'response_type': (CauseOfActionGroupResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/causeOfActionGroup',
                'operation_id': 'get_causes_of_action_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_charge_endpoint = _Endpoint(
            settings={
                'response_type': (Charge,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/charge/{chargeId}',
                'operation_id': 'get_charge',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'charge_id',
                ],
                'required': [
                    'charge_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'charge_id',
                ]
            },
            root_map={
                'validations': {
                    ('charge_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'charge_id':
                        (str,),
                },
                'attribute_map': {
                    'charge_id': 'chargeId',
                },
                'location_map': {
                    'charge_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_charge_additional_data_endpoint = _Endpoint(
            settings={
                'response_type': (ChargeAdditionalData,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/chargeAdditionalData/{chargeAdditionalDataId}',
                'operation_id': 'get_charge_additional_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'charge_additional_data_id',
                ],
                'required': [
                    'charge_additional_data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'charge_additional_data_id',
                ]
            },
            root_map={
                'validations': {
                    ('charge_additional_data_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'charge_additional_data_id':
                        (str,),
                },
                'attribute_map': {
                    'charge_additional_data_id': 'chargeAdditionalDataId',
                },
                'location_map': {
                    'charge_additional_data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_charge_degree_endpoint = _Endpoint(
            settings={
                'response_type': (ChargeDegree,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/chargeDegree/{chargeDegreeId}',
                'operation_id': 'get_charge_degree',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'charge_degree_id',
                ],
                'required': [
                    'charge_degree_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'charge_degree_id',
                ]
            },
            root_map={
                'validations': {
                    ('charge_degree_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'charge_degree_id':
                        (str,),
                },
                'attribute_map': {
                    'charge_degree_id': 'chargeDegreeId',
                },
                'location_map': {
                    'charge_degree_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_charge_group_endpoint = _Endpoint(
            settings={
                'response_type': (ChargeGroup,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/chargeGroup/{chargeGroupId}',
                'operation_id': 'get_charge_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'charge_group_id',
                ],
                'required': [
                    'charge_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'charge_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('charge_group_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'charge_group_id':
                        (str,),
                },
                'attribute_map': {
                    'charge_group_id': 'chargeGroupId',
                },
                'location_map': {
                    'charge_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_charge_groups_endpoint = _Endpoint(
            settings={
                'response_type': (ChargeGroupResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/chargeGroup',
                'operation_id': 'get_charge_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_charge_severity_endpoint = _Endpoint(
            settings={
                'response_type': (ChargeSeverity,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/chargeSeverity/{chargeSeverityId}',
                'operation_id': 'get_charge_severity',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'charge_severity_id',
                ],
                'required': [
                    'charge_severity_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'charge_severity_id',
                ]
            },
            root_map={
                'validations': {
                    ('charge_severity_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'charge_severity_id':
                        (str,),
                },
                'attribute_map': {
                    'charge_severity_id': 'chargeSeverityId',
                },
                'location_map': {
                    'charge_severity_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_charges_endpoint = _Endpoint(
            settings={
                'response_type': (ChargeResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/charge',
                'operation_id': 'get_charges',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_charges_additional_data_endpoint = _Endpoint(
            settings={
                'response_type': (ChargeAdditionalDataResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/chargeAdditionalData',
                'operation_id': 'get_charges_additional_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_charges_degree_endpoint = _Endpoint(
            settings={
                'response_type': (ChargeDegreeResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/chargeDegree',
                'operation_id': 'get_charges_degree',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_charges_severity_endpoint = _Endpoint(
            settings={
                'response_type': (ChargeSeverityResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/chargeSeverity',
                'operation_id': 'get_charges_severity',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_court_endpoint = _Endpoint(
            settings={
                'response_type': (Court,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/court/{courtId}',
                'operation_id': 'get_court',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'court_id',
                ],
                'required': [
                    'court_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'court_id',
                ]
            },
            root_map={
                'validations': {
                    ('court_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'court_id':
                        (str,),
                },
                'attribute_map': {
                    'court_id': 'courtId',
                },
                'location_map': {
                    'court_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_court_location_endpoint = _Endpoint(
            settings={
                'response_type': (CourtLocation,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/courtLocation/{courtLocationId}',
                'operation_id': 'get_court_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'court_location_id',
                ],
                'required': [
                    'court_location_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'court_location_id',
                ]
            },
            root_map={
                'validations': {
                    ('court_location_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'court_location_id':
                        (str,),
                },
                'attribute_map': {
                    'court_location_id': 'courtLocationId',
                },
                'location_map': {
                    'court_location_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_court_locations_endpoint = _Endpoint(
            settings={
                'response_type': (CourtLocationResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/courtLocation',
                'operation_id': 'get_court_locations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_court_locations_for_court_endpoint = _Endpoint(
            settings={
                'response_type': (CourtLocationResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/court/{courtId}/courtLocations',
                'operation_id': 'get_court_locations_for_court',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'court_id',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [
                    'court_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'court_id',
                    'page_number',
                ]
            },
            root_map={
                'validations': {
                    ('court_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'court_id':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'court_id': 'courtId',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'court_id': 'path',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_court_service_status_endpoint = _Endpoint(
            settings={
                'response_type': (CourtServiceStatus,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/courtServiceStatus/{courtServiceStatusId}',
                'operation_id': 'get_court_service_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'court_service_status_id',
                ],
                'required': [
                    'court_service_status_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'court_service_status_id',
                ]
            },
            root_map={
                'validations': {
                    ('court_service_status_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'court_service_status_id':
                        (str,),
                },
                'attribute_map': {
                    'court_service_status_id': 'courtServiceStatusId',
                },
                'location_map': {
                    'court_service_status_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_court_system_endpoint = _Endpoint(
            settings={
                'response_type': (CourtSystem,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/courtSystem/{courtSystemId}',
                'operation_id': 'get_court_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'court_system_id',
                ],
                'required': [
                    'court_system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'court_system_id',
                ]
            },
            root_map={
                'validations': {
                    ('court_system_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'court_system_id':
                        (str,),
                },
                'attribute_map': {
                    'court_system_id': 'courtSystemId',
                },
                'location_map': {
                    'court_system_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_court_systems_endpoint = _Endpoint(
            settings={
                'response_type': (CourtSystemResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/courtSystem',
                'operation_id': 'get_court_systems',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_court_type_endpoint = _Endpoint(
            settings={
                'response_type': (CourtType,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/courtType/{courtTypeId}',
                'operation_id': 'get_court_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'court_type_id',
                ],
                'required': [
                    'court_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'court_type_id',
                ]
            },
            root_map={
                'validations': {
                    ('court_type_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'court_type_id':
                        (str,),
                },
                'attribute_map': {
                    'court_type_id': 'courtTypeId',
                },
                'location_map': {
                    'court_type_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_court_types_endpoint = _Endpoint(
            settings={
                'response_type': (CourtTypeResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/courtType',
                'operation_id': 'get_court_types',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_courts_endpoint = _Endpoint(
            settings={
                'response_type': (CourtResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/court',
                'operation_id': 'get_courts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_courts_for_court_location_endpoint = _Endpoint(
            settings={
                'response_type': (CourtResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/courtLocation/{courtLocationId}/courts',
                'operation_id': 'get_courts_for_court_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'court_location_id',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [
                    'court_location_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'court_location_id',
                    'page_number',
                ]
            },
            root_map={
                'validations': {
                    ('court_location_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'court_location_id':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'court_location_id': 'courtLocationId',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'court_location_id': 'path',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_courts_for_jurisdiction_geo_endpoint = _Endpoint(
            settings={
                'response_type': (CourtResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/jurisdictionGeo/{jurisdictionGeoId}/courts',
                'operation_id': 'get_courts_for_jurisdiction_geo',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'jurisdiction_geo_id',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [
                    'jurisdiction_geo_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'jurisdiction_geo_id',
                    'page_number',
                ]
            },
            root_map={
                'validations': {
                    ('jurisdiction_geo_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'jurisdiction_geo_id':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'jurisdiction_geo_id': 'jurisdictionGeoId',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'jurisdiction_geo_id': 'path',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_courts_service_status_endpoint = _Endpoint(
            settings={
                'response_type': (CourtServiceStatusResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/courtServiceStatus',
                'operation_id': 'get_courts_service_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_judge_type_endpoint = _Endpoint(
            settings={
                'response_type': (JudgeType,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/judgeType/{judgeTypeId}',
                'operation_id': 'get_judge_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'judge_type_id',
                ],
                'required': [
                    'judge_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'judge_type_id',
                ]
            },
            root_map={
                'validations': {
                    ('judge_type_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'judge_type_id':
                        (str,),
                },
                'attribute_map': {
                    'judge_type_id': 'judgeTypeId',
                },
                'location_map': {
                    'judge_type_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_judge_types_endpoint = _Endpoint(
            settings={
                'response_type': (JudgeTypeResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/judgeType',
                'operation_id': 'get_judge_types',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_jurisdiction_geo_endpoint = _Endpoint(
            settings={
                'response_type': (JurisdictionGeo,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/jurisdictionGeo/{jurisdictionGeoId}',
                'operation_id': 'get_jurisdiction_geo',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'jurisdiction_geo_id',
                ],
                'required': [
                    'jurisdiction_geo_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'jurisdiction_geo_id',
                ]
            },
            root_map={
                'validations': {
                    ('jurisdiction_geo_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'jurisdiction_geo_id':
                        (str,),
                },
                'attribute_map': {
                    'jurisdiction_geo_id': 'jurisdictionGeoId',
                },
                'location_map': {
                    'jurisdiction_geo_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_jurisdiction_geo_for_court_endpoint = _Endpoint(
            settings={
                'response_type': (JurisdictionGeoResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/court/{courtId}/jurisdictionGeo',
                'operation_id': 'get_jurisdiction_geo_for_court',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'court_id',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [
                    'court_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'court_id',
                    'page_number',
                ]
            },
            root_map={
                'validations': {
                    ('court_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "STATE": "state"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'court_id':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'court_id': 'courtId',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'court_id': 'path',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_jurisdictions_geo_endpoint = _Endpoint(
            settings={
                'response_type': (JurisdictionGeoResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/jurisdictionGeo',
                'operation_id': 'get_jurisdictions_geo',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "STATE": "state"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_party_role_endpoint = _Endpoint(
            settings={
                'response_type': (PartyRole,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/partyRole/{partyRoleId}',
                'operation_id': 'get_party_role',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'party_role_id',
                ],
                'required': [
                    'party_role_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'party_role_id',
                ]
            },
            root_map={
                'validations': {
                    ('party_role_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'party_role_id':
                        (str,),
                },
                'attribute_map': {
                    'party_role_id': 'partyRoleId',
                },
                'location_map': {
                    'party_role_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_party_role_group_endpoint = _Endpoint(
            settings={
                'response_type': (PartyRoleGroup,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/partyRoleGroup/{partyRoleGroupId}',
                'operation_id': 'get_party_role_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'party_role_group_id',
                ],
                'required': [
                    'party_role_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'party_role_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('party_role_group_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'party_role_group_id':
                        (str,),
                },
                'attribute_map': {
                    'party_role_group_id': 'partyRoleGroupId',
                },
                'location_map': {
                    'party_role_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_party_role_groups_endpoint = _Endpoint(
            settings={
                'response_type': (PartyRoleGroupResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/partyRoleGroup',
                'operation_id': 'get_party_role_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_party_roles_endpoint = _Endpoint(
            settings={
                'response_type': (PartyRoleResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/masterData/partyRole',
                'operation_id': 'get_party_roles',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                ],
                'validation': [
                    'q',
                    'page_number',
                    'sort',
                    'order',
                ]
            },
            root_map={
                'validations': {
                    ('q',): {
                        'max_length': 2000,
                        'min_length': 3,
                    },
                    ('page_number',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {
                        'max_length': 4,
                        'min_length': 4,
                    },
                    ('order',): {
                        'max_length': 4,
                        'min_length': 3,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "NAME": "name"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'q':
                        (str,),
                    'page_number':
                        (int,),
                    'sort':
                        (str,),
                    'order':
                        (str,),
                },
                'attribute_map': {
                    'q': 'q',
                    'page_number': 'pageNumber',
                    'sort': 'sort',
                    'order': 'order',
                },
                'location_map': {
                    'q': 'query',
                    'page_number': 'query',
                    'sort': 'query',
                    'order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_appeal_courts_for_court(
        self,
        court_id,
        **kwargs
    ):
        """Appeal Court Objects for given courtId.  # noqa: E501

        Retrieve the appeals courts associated with the specified court.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_appeal_courts_for_court(court_id, async_req=True)
        >>> result = thread.get()

        Args:
            court_id (str): The courtId value of the target court.

        Keyword Args:
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['court_id'] = \
            court_id
        return self.get_appeal_courts_for_court_endpoint.call_with_http_info(**kwargs)

    def get_area_of_law(
        self,
        area_of_law_id,
        **kwargs
    ):
        """AreaOfLaw Object for the given AreaOfLaw Id.  # noqa: E501

        Retrieve the specified area of law.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_area_of_law(area_of_law_id, async_req=True)
        >>> result = thread.get()

        Args:
            area_of_law_id (str): The areaOfLawId value of the desired area of law.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AreaOfLaw
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['area_of_law_id'] = \
            area_of_law_id
        return self.get_area_of_law_endpoint.call_with_http_info(**kwargs)

    def get_areas_of_law(
        self,
        **kwargs
    ):
        """AreaOfLaw Object.  # noqa: E501

        The keyword expression targeting the desired area of law.   ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> AreaOfLawQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_areas_of_law(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): Retrieve one or more areas of law using a keyword expression. Keyword expressions should be constructed according to the rules given above.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AreaOfLawResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_areas_of_law_endpoint.call_with_http_info(**kwargs)

    def get_attorney_representation_type(
        self,
        attorney_representation_type_id,
        **kwargs
    ):
        """Attorney Representation Type Object for the given attorneyRepresentationTypeId.  # noqa: E501

        Retrieve the specified attorney representation type.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attorney_representation_type(attorney_representation_type_id, async_req=True)
        >>> result = thread.get()

        Args:
            attorney_representation_type_id (str): The attorneyRepresentationTypeId value of the desired attorney representation type.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AttorneyRepresentationType
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['attorney_representation_type_id'] = \
            attorney_representation_type_id
        return self.get_attorney_representation_type_endpoint.call_with_http_info(**kwargs)

    def get_attorney_representation_types(
        self,
        **kwargs
    ):
        """Attorney Representation Type Object.  # noqa: E501

        Retrieve an attorney representation type using a keyword expression. Keyword expressions should be constructed according to the rules given above. ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below Schema section. Schema --> AttorneyRepresentationTypeQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attorney_representation_types(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the attorney representation type.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AttorneyRepresentationTypeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_attorney_representation_types_endpoint.call_with_http_info(**kwargs)

    def get_attorney_type(
        self,
        attorney_type_id,
        **kwargs
    ):
        """Attorney Type Object for given Attorney Type Id.  # noqa: E501

        Retrieve a specified attorney type object.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attorney_type(attorney_type_id, async_req=True)
        >>> result = thread.get()

        Args:
            attorney_type_id (str): The attorneyTypeId value of the desired attorney type.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AttorneyType
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['attorney_type_id'] = \
            attorney_type_id
        return self.get_attorney_type_endpoint.call_with_http_info(**kwargs)

    def get_attorney_types(
        self,
        **kwargs
    ):
        """Attorney Type Object.  # noqa: E501

        Retrieve an attorney type using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below Schema section. Schema --> AttorneyTypeQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attorney_types(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the attorney type.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AttorneyTypeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_attorney_types_endpoint.call_with_http_info(**kwargs)

    def get_case_class(
        self,
        case_class_id,
        **kwargs
    ):
        """Case Class Object for the given Case Class Id.  # noqa: E501

        Retrieve the specified case class.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_class(case_class_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_class_id (str): The caseClassId value of the desired case class.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_class_id'] = \
            case_class_id
        return self.get_case_class_endpoint.call_with_http_info(**kwargs)

    def get_case_relationship_type(
        self,
        case_relationship_type_id,
        **kwargs
    ):
        """Case Relationship Type Object for the given caseRelationshipTypeId.  # noqa: E501

        Retrieve the specified case relationship type.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_relationship_type(case_relationship_type_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_relationship_type_id (str): The caseRelationshipTypeId value of the desired case relationship type.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseRelationshipType
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_relationship_type_id'] = \
            case_relationship_type_id
        return self.get_case_relationship_type_endpoint.call_with_http_info(**kwargs)

    def get_case_relationship_types(
        self,
        **kwargs
    ):
        """Case Relationship Type Object.  # noqa: E501

        Retrieve an case relationship type using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CaseRelationshipTypeQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_relationship_types(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the case relationship type.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseRelationshipTypeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_case_relationship_types_endpoint.call_with_http_info(**kwargs)

    def get_case_status(
        self,
        case_status_id,
        **kwargs
    ):
        """Returns the caseStatus information for the given caseStatusId.  # noqa: E501

        Retrieve the specified case status.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_status(case_status_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_status_id (str): The caseStatusId value of the desired case status.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseStatus
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_status_id'] = \
            case_status_id
        return self.get_case_status_endpoint.call_with_http_info(**kwargs)

    def get_case_status_group(
        self,
        case_status_group_id,
        **kwargs
    ):
        """Returns the caseStatusGroup information for the given caseStatusGroupId.  # noqa: E501

        Retrieve the specified case status group.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_status_group(case_status_group_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_status_group_id (str): The caseStatusGroupId value of the desired case status group.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseStatusGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_status_group_id'] = \
            case_status_group_id
        return self.get_case_status_group_endpoint.call_with_http_info(**kwargs)

    def get_case_status_groups(
        self,
        **kwargs
    ):
        """Case Status Group Object.  # noqa: E501

        Retrieve a case status group using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CaseStatusGroupQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_status_groups(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired case status group.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseStatusGroupResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_case_status_groups_endpoint.call_with_http_info(**kwargs)

    def get_case_type(
        self,
        case_type_id,
        **kwargs
    ):
        """CaseType Object for given Case Type Id.  # noqa: E501

        Retrieve the specified case type.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_type(case_type_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_type_id (str): The caseTypeId value of the desired case type.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseType
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_type_id'] = \
            case_type_id
        return self.get_case_type_endpoint.call_with_http_info(**kwargs)

    def get_case_type_group(
        self,
        case_type_group_id,
        **kwargs
    ):
        """CaseType Group for the given CaseType Group Id.  # noqa: E501

        Retrieve the specified case type group.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_type_group(case_type_group_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_type_group_id (str): caseTypeGroupId

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseTypeGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_type_group_id'] = \
            case_type_group_id
        return self.get_case_type_group_endpoint.call_with_http_info(**kwargs)

    def get_case_type_groups(
        self,
        **kwargs
    ):
        """CaseTypeGroup Object.  # noqa: E501

        Retrieve one or more case type groups using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CaseTypeGroupQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_type_groups(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): Retrieve one or more case type groups using a keyword expression. Keyword expressions should be constructed according to the rules given above.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseTypeGroupResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_case_type_groups_endpoint.call_with_http_info(**kwargs)

    def get_case_types(
        self,
        **kwargs
    ):
        """Case Type Object.  # noqa: E501

        Retrieve one or more case types using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CaseTypeQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_types(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): Retrieve one or more case types using a keyword expression. Keyword expressions should be constructed according to the rules given above.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseTypeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_case_types_endpoint.call_with_http_info(**kwargs)

    def get_cases_class(
        self,
        **kwargs
    ):
        """Case Class Object.  # noqa: E501

        Retrieve one or more case classes using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CaseClassQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cases_class(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired case class.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseClassResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_cases_class_endpoint.call_with_http_info(**kwargs)

    def get_cases_status(
        self,
        **kwargs
    ):
        """Case Status Object.  # noqa: E501

        Retrieve a case status using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below Schema section. Schema --> CaseStatusQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cases_status(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired case status.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseStatusResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_cases_status_endpoint.call_with_http_info(**kwargs)

    def get_cause_of_action(
        self,
        cause_of_action_id,
        **kwargs
    ):
        """CauseOfAction Object for the given causeOfActionId.  # noqa: E501

        Retrieve the specified cause of action.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cause_of_action(cause_of_action_id, async_req=True)
        >>> result = thread.get()

        Args:
            cause_of_action_id (str): The causeOfActionId value of the desired cause of action.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CauseOfAction
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cause_of_action_id'] = \
            cause_of_action_id
        return self.get_cause_of_action_endpoint.call_with_http_info(**kwargs)

    def get_cause_of_action_additional_data(
        self,
        cause_of_action_additional_data_id,
        **kwargs
    ):
        """CauseOfActionAdditionalData Object for the given causeOfActionAdditionalDataId.  # noqa: E501

        Retrieve the specified cause of action additional data.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cause_of_action_additional_data(cause_of_action_additional_data_id, async_req=True)
        >>> result = thread.get()

        Args:
            cause_of_action_additional_data_id (str): The causeOfActionAdditionalDataId value of the desired cause of action additional data.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CauseOfActionAdditionalData
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cause_of_action_additional_data_id'] = \
            cause_of_action_additional_data_id
        return self.get_cause_of_action_additional_data_endpoint.call_with_http_info(**kwargs)

    def get_cause_of_action_group(
        self,
        cause_of_action_group_id,
        **kwargs
    ):
        """CauseOfActionGroup Object for the given causeOfActionGroupId.  # noqa: E501

        Retrieve the specified cause of action group.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cause_of_action_group(cause_of_action_group_id, async_req=True)
        >>> result = thread.get()

        Args:
            cause_of_action_group_id (str): causeOfActionGroupId

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CauseOfActionGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cause_of_action_group_id'] = \
            cause_of_action_group_id
        return self.get_cause_of_action_group_endpoint.call_with_http_info(**kwargs)

    def get_causes_of_action(
        self,
        **kwargs
    ):
        """CauseOfAction Object.  # noqa: E501

        Retrieve a cause of action using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CauseOfActionQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_causes_of_action(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired cause of action.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CauseOfActionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_causes_of_action_endpoint.call_with_http_info(**kwargs)

    def get_causes_of_action_additional_data(
        self,
        **kwargs
    ):
        """CauseOfActionAdditionaData Object.  # noqa: E501

        Retrieve a cause of action additional data using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CauseOfActionAdditionalDataQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_causes_of_action_additional_data(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired cause of action additional data.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CauseOfActionAdditionalDataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_causes_of_action_additional_data_endpoint.call_with_http_info(**kwargs)

    def get_causes_of_action_group(
        self,
        **kwargs
    ):
        """CauseOfActionGroup Object.  # noqa: E501

        Retrieve a cause of action group using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CauseOfActionGroupQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_causes_of_action_group(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired cause of action group.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CauseOfActionGroupResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_causes_of_action_group_endpoint.call_with_http_info(**kwargs)

    def get_charge(
        self,
        charge_id,
        **kwargs
    ):
        """Charge Object for the given chargeId.  # noqa: E501

        Retrieve the specified charge.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_charge(charge_id, async_req=True)
        >>> result = thread.get()

        Args:
            charge_id (str): The chargeId value of the desired charge.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Charge
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['charge_id'] = \
            charge_id
        return self.get_charge_endpoint.call_with_http_info(**kwargs)

    def get_charge_additional_data(
        self,
        charge_additional_data_id,
        **kwargs
    ):
        """Charge Additional Data Object for the given chargeAdditionalDataId.  # noqa: E501

        Retrieve the specified charge additional data.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_charge_additional_data(charge_additional_data_id, async_req=True)
        >>> result = thread.get()

        Args:
            charge_additional_data_id (str): The chargeAdditionalDataId value of the desired charge additional data.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ChargeAdditionalData
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['charge_additional_data_id'] = \
            charge_additional_data_id
        return self.get_charge_additional_data_endpoint.call_with_http_info(**kwargs)

    def get_charge_degree(
        self,
        charge_degree_id,
        **kwargs
    ):
        """ChargeDegree Object for the given chargeDegreeId.  # noqa: E501

        Retrieve the specified charge degree.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_charge_degree(charge_degree_id, async_req=True)
        >>> result = thread.get()

        Args:
            charge_degree_id (str): The chargeDegreeId value of the desired charge degree.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ChargeDegree
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['charge_degree_id'] = \
            charge_degree_id
        return self.get_charge_degree_endpoint.call_with_http_info(**kwargs)

    def get_charge_group(
        self,
        charge_group_id,
        **kwargs
    ):
        """Charge Group Object for the given chargeGroupId.  # noqa: E501

        Retrieve the specified charge group.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_charge_group(charge_group_id, async_req=True)
        >>> result = thread.get()

        Args:
            charge_group_id (str): The chargeGroupId value of the desired charge group.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ChargeGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['charge_group_id'] = \
            charge_group_id
        return self.get_charge_group_endpoint.call_with_http_info(**kwargs)

    def get_charge_groups(
        self,
        **kwargs
    ):
        """Charge Group Object.  # noqa: E501

        Retrieve one or more charge groups using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> ChargeGroupQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_charge_groups(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired charge group.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ChargeGroupResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_charge_groups_endpoint.call_with_http_info(**kwargs)

    def get_charge_severity(
        self,
        charge_severity_id,
        **kwargs
    ):
        """ChargeSeverity Object for the given chargeSeverityId.  # noqa: E501

        Retrieve the specified charge severity.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_charge_severity(charge_severity_id, async_req=True)
        >>> result = thread.get()

        Args:
            charge_severity_id (str): The chargeSeverityId value of the desired charge severity.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ChargeSeverity
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['charge_severity_id'] = \
            charge_severity_id
        return self.get_charge_severity_endpoint.call_with_http_info(**kwargs)

    def get_charges(
        self,
        **kwargs
    ):
        """Charge Object.  # noqa: E501

        Retrieve one or more charges using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> ChargeQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_charges(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired charge.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ChargeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_charges_endpoint.call_with_http_info(**kwargs)

    def get_charges_additional_data(
        self,
        **kwargs
    ):
        """Charge Additional Data Object.  # noqa: E501

        Retrieve additional information on a charge using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> ChargeAdditionalDataQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_charges_additional_data(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired charge additional data.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ChargeAdditionalDataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_charges_additional_data_endpoint.call_with_http_info(**kwargs)

    def get_charges_degree(
        self,
        **kwargs
    ):
        """ChargeDegree Object.  # noqa: E501

        Retrieve a charge degree using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> ChargeDegreeQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_charges_degree(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired charge degree.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ChargeDegreeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_charges_degree_endpoint.call_with_http_info(**kwargs)

    def get_charges_severity(
        self,
        **kwargs
    ):
        """ChargeSeverity Object.  # noqa: E501

        Retrieve a charge severity using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> ChargeSeverityQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_charges_severity(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired charge severity.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ChargeSeverityResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_charges_severity_endpoint.call_with_http_info(**kwargs)

    def get_court(
        self,
        court_id,
        **kwargs
    ):
        """Court Object for given courtId.  # noqa: E501

        Retrieve information about a specified court.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_court(court_id, async_req=True)
        >>> result = thread.get()

        Args:
            court_id (str): The courtId value of the target court.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Court
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['court_id'] = \
            court_id
        return self.get_court_endpoint.call_with_http_info(**kwargs)

    def get_court_location(
        self,
        court_location_id,
        **kwargs
    ):
        """Courthouse Object for given Court Location Id.  # noqa: E501

        Contains the Court Location Object.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_court_location(court_location_id, async_req=True)
        >>> result = thread.get()

        Args:
            court_location_id (str): courtLocationId

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtLocation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['court_location_id'] = \
            court_location_id
        return self.get_court_location_endpoint.call_with_http_info(**kwargs)

    def get_court_locations(
        self,
        **kwargs
    ):
        """Courthouse Object.  # noqa: E501

        Retrieve the specified court location or court locations.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CourtLocationQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_court_locations(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression that sets forth the criteria concerning the court location or court locations to target. Keyword expressions should be constructed according to the rules shown above.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtLocationResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_court_locations_endpoint.call_with_http_info(**kwargs)

    def get_court_locations_for_court(
        self,
        court_id,
        **kwargs
    ):
        """Associated Court Location for given courtId.  # noqa: E501

        Retrieve the court locations associated with the specified court.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_court_locations_for_court(court_id, async_req=True)
        >>> result = thread.get()

        Args:
            court_id (str): The courtId value of the target court.

        Keyword Args:
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtLocationResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['court_id'] = \
            court_id
        return self.get_court_locations_for_court_endpoint.call_with_http_info(**kwargs)

    def get_court_service_status(
        self,
        court_service_status_id,
        **kwargs
    ):
        """Court Service Status Object for the given courtServiceStatusId.  # noqa: E501

        Retrieve the court status of the specified court.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_court_service_status(court_service_status_id, async_req=True)
        >>> result = thread.get()

        Args:
            court_service_status_id (str): The courtServiceStatusId value of the desired court.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtServiceStatus
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['court_service_status_id'] = \
            court_service_status_id
        return self.get_court_service_status_endpoint.call_with_http_info(**kwargs)

    def get_court_system(
        self,
        court_system_id,
        **kwargs
    ):
        """Court System Object for given courtSystemId.  # noqa: E501

        Retrieve the specified court system.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_court_system(court_system_id, async_req=True)
        >>> result = thread.get()

        Args:
            court_system_id (str): The courtSystemId value of the court system to be retrieved.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtSystem
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['court_system_id'] = \
            court_system_id
        return self.get_court_system_endpoint.call_with_http_info(**kwargs)

    def get_court_systems(
        self,
        **kwargs
    ):
        """Court System Objects.  # noqa: E501

        Retrieve information about the specified court system or court systems.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------|         | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CourtSystemQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_court_systems(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression that sets forth the criteria concerning the court system or court systems. Keyword expressions should be constructed according to the rules shown above.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtSystemResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_court_systems_endpoint.call_with_http_info(**kwargs)

    def get_court_type(
        self,
        court_type_id,
        **kwargs
    ):
        """Court Type Object for given courtTypeId.  # noqa: E501

        Retrieve the information concerning the specific court type.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_court_type(court_type_id, async_req=True)
        >>> result = thread.get()

        Args:
            court_type_id (str): The courtTypeId value of the court type to be retrieved.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtType
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['court_type_id'] = \
            court_type_id
        return self.get_court_type_endpoint.call_with_http_info(**kwargs)

    def get_court_types(
        self,
        **kwargs
    ):
        """Court Type Objects.  # noqa: E501

        Retrieve court types recognized by UniCourt.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------|         | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CourtTypeQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_court_types(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression that sets forth the criteria concerning the court type or court types. Keyword expressions should be constructed according to the rules shown above.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtTypeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_court_types_endpoint.call_with_http_info(**kwargs)

    def get_courts(
        self,
        **kwargs
    ):
        """Court Objects.  # noqa: E501

        Retrieve information about a specified court or courts.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------|         | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CourtQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_courts(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression that sets forth the criteria concerning the court or courts to be retrieved. Keyword expressions should be constructed according to the rules shown above.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_courts_endpoint.call_with_http_info(**kwargs)

    def get_courts_for_court_location(
        self,
        court_location_id,
        **kwargs
    ):
        """Associated Court for given Court Location.  # noqa: E501

        Retrieve the courts associated with the specified court location.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_courts_for_court_location(court_location_id, async_req=True)
        >>> result = thread.get()

        Args:
            court_location_id (str): The courtLocationId value of the court location for which courts are to be retrieved.

        Keyword Args:
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['court_location_id'] = \
            court_location_id
        return self.get_courts_for_court_location_endpoint.call_with_http_info(**kwargs)

    def get_courts_for_jurisdiction_geo(
        self,
        jurisdiction_geo_id,
        **kwargs
    ):
        """Associated Court for given Jurisdiction Geo.  # noqa: E501

        Returns Associated Court for given Jurisdiction Geo.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_courts_for_jurisdiction_geo(jurisdiction_geo_id, async_req=True)
        >>> result = thread.get()

        Args:
            jurisdiction_geo_id (str): jurisdictionGeoId

        Keyword Args:
            page_number (int): Page number. - minimum: 1 - maximum: 100 . [optional]
            sort (str): Sort field.. [optional] if omitted the server will use the default value of "name"
            order (str): Sort order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['jurisdiction_geo_id'] = \
            jurisdiction_geo_id
        return self.get_courts_for_jurisdiction_geo_endpoint.call_with_http_info(**kwargs)

    def get_courts_service_status(
        self,
        **kwargs
    ):
        """Court Service Status Object.  # noqa: E501

        Retrieve the status of one or more courts using a keyword expression.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> CourtServiceStatusQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_courts_service_status(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired court. Keyword expressions should be constructed according to the rules given above.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CourtServiceStatusResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_courts_service_status_endpoint.call_with_http_info(**kwargs)

    def get_judge_type(
        self,
        judge_type_id,
        **kwargs
    ):
        """Judge Type Object for the given judgeTypeId.  # noqa: E501

        Retrieve the specified judge type.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_judge_type(judge_type_id, async_req=True)
        >>> result = thread.get()

        Args:
            judge_type_id (str): The judgeTypeId of the desired judge type.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JudgeType
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['judge_type_id'] = \
            judge_type_id
        return self.get_judge_type_endpoint.call_with_http_info(**kwargs)

    def get_judge_types(
        self,
        **kwargs
    ):
        """Judge Type Object.  # noqa: E501

        Retrieve a judge type using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> JudgeTypeQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_judge_types(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the judge type.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JudgeTypeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_judge_types_endpoint.call_with_http_info(**kwargs)

    def get_jurisdiction_geo(
        self,
        jurisdiction_geo_id,
        **kwargs
    ):
        """Jurisdiction Geo Object for given Jurisdiction Geo Id.  # noqa: E501

        Retrieve the specified jurisdiction geography.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_jurisdiction_geo(jurisdiction_geo_id, async_req=True)
        >>> result = thread.get()

        Args:
            jurisdiction_geo_id (str): The jurisdictionGeoId value of the desired jurisdiction geography.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JurisdictionGeo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['jurisdiction_geo_id'] = \
            jurisdiction_geo_id
        return self.get_jurisdiction_geo_endpoint.call_with_http_info(**kwargs)

    def get_jurisdiction_geo_for_court(
        self,
        court_id,
        **kwargs
    ):
        """Jurisdiction Geo Objects for given courtId.  # noqa: E501

        Retrieve the jurisdiction geography object for the specified court.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_jurisdiction_geo_for_court(court_id, async_req=True)
        >>> result = thread.get()

        Args:
            court_id (str): The courtId value of the target court.

        Keyword Args:
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "state"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JurisdictionGeoResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['court_id'] = \
            court_id
        return self.get_jurisdiction_geo_for_court_endpoint.call_with_http_info(**kwargs)

    def get_jurisdictions_geo(
        self,
        **kwargs
    ):
        """Jurisdiction Geo Object.  # noqa: E501

        Retrieve one or more jurisdiction geographies using a keyword expression.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> JurisdictionGeoQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_jurisdictions_geo(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired jurisdiction geography. Keyword expressions should be constructed according to the rules given above.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "state"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JurisdictionGeoResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_jurisdictions_geo_endpoint.call_with_http_info(**kwargs)

    def get_party_role(
        self,
        party_role_id,
        **kwargs
    ):
        """Party Role Object.  # noqa: E501

        Retrieve the specified party role.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_party_role(party_role_id, async_req=True)
        >>> result = thread.get()

        Args:
            party_role_id (str): The partyRoleId value of the desired party role.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PartyRole
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['party_role_id'] = \
            party_role_id
        return self.get_party_role_endpoint.call_with_http_info(**kwargs)

    def get_party_role_group(
        self,
        party_role_group_id,
        **kwargs
    ):
        """Party Role Group Object.  # noqa: E501

        Retrieve the specified party role group.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_party_role_group(party_role_group_id, async_req=True)
        >>> result = thread.get()

        Args:
            party_role_group_id (str): The partyRoleGroupId value of the desired party role group.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PartyRoleGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['party_role_group_id'] = \
            party_role_group_id
        return self.get_party_role_group_endpoint.call_with_http_info(**kwargs)

    def get_party_role_groups(
        self,
        **kwargs
    ):
        """Party Role Group Object.  # noqa: E501

        Retrieve a party role group using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> PartyRoleGroupQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_party_role_groups(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired party role group.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PartyRoleGroupResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_party_role_groups_endpoint.call_with_http_info(**kwargs)

    def get_party_roles(
        self,
        **kwargs
    ):
        """Party Role Object.  # noqa: E501

        Retrieve a party role using a keyword expression. Keyword expressions should be constructed according to the rules given above.  ## Logical Operators | Connector | Description  | Example | | ------| ------|------| | **AND** |Find data containing all connected terms.|**google AND facebook**| | **OR**  |Find data containing any connected term.| **order OR decision**| | **NOT** |Exclude data.| **google NOT apple**.| | **“[phrase]”** |Find an exact phrase.| **\"Google Inc”** | | **( … )** |Parenthesis may be used to group sets of terms of connectors.| **google (facebook OR apple)**.|  ### All Filter Query parameters supported for this API can be found in below schema section. Schema --> PartyRoleQueryObject   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_party_roles(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            q (str): The keyword expression targeting the desired party role.</a> . [optional]
            page_number (int): The page number of the results to be retrieved. - minimum: 1 - maximum: 100 . [optional]
            sort (str): The field according to which search results are to be sorted.. [optional] if omitted the server will use the default value of "name"
            order (str): Whether search results are to be shown in ascending or descending order.. [optional] if omitted the server will use the default value of "asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PartyRoleResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_party_roles_endpoint.call_with_http_info(**kwargs)

