"""
    UniCourt Enterprise APIs

    <button><a href=\"/enterpriseapi/download/UniCourt-Enterprise-API-Spec.yaml\" >Download UniCourt Enterprise APIs Specification</a></button>   # noqa: E501

    The version of the OpenAPI document: 
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from unicourt.api_client import ApiClient, Endpoint as _Endpoint
from unicourt.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from unicourt.model.case_document import CaseDocument
from unicourt.model.case_document_order_callback import CaseDocumentOrderCallback
from unicourt.model.case_document_order_callback_list_response import CaseDocumentOrderCallbackListResponse
from unicourt.model.case_document_order_request import CaseDocumentOrderRequest
from unicourt.model.case_documents import CaseDocuments
from unicourt.model.exception import Exception
from unicourt.model.get_case_document_download_by_id200_response import GetCaseDocumentDownloadById200Response


class CaseDocumentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_case_document_download_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (GetCaseDocumentDownloadById200Response,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/caseDocumentDownload/{caseDocumentId}',
                'operation_id': 'get_case_document_download_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_document_id',
                    'is_preview_document',
                ],
                'required': [
                    'case_document_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_document_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_document_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_document_id':
                        (str,),
                    'is_preview_document':
                        (bool,),
                },
                'attribute_map': {
                    'case_document_id': 'caseDocumentId',
                    'is_preview_document': 'isPreviewDocument',
                },
                'location_map': {
                    'case_document_id': 'path',
                    'is_preview_document': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_document_order_callback_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (CaseDocumentOrderCallback,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/caseDocumentOrder/callbacks/{caseDocumentOrderCallbackId}',
                'operation_id': 'get_case_document_order_callback_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_document_order_callback_id',
                ],
                'required': [
                    'case_document_order_callback_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_document_order_callback_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_document_order_callback_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_document_order_callback_id':
                        (str,),
                },
                'attribute_map': {
                    'case_document_order_callback_id': 'caseDocumentOrderCallbackId',
                },
                'location_map': {
                    'case_document_order_callback_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_document_order_callbacks_endpoint = _Endpoint(
            settings={
                'response_type': (CaseDocumentOrderCallbackListResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/caseDocumentOrder/callbacks',
                'operation_id': 'get_case_document_order_callbacks',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'date',
                    'status',
                    'page_number',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                    'date',
                    'status',
                    'page_number',
                ]
            },
            root_map={
                'validations': {
                    ('date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('status',): {
                        'max_length': 11,
                        'min_length': 7,
                    },
                    ('page_number',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('status',): {

                        "IN_PROGRESS": "IN_PROGRESS",
                        "COMPLETE": "COMPLETE",
                        "FAILURE": "FAILURE"
                    },
                },
                'openapi_types': {
                    'date':
                        (datetime,),
                    'status':
                        (str,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'date': 'date',
                    'status': 'status',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'date': 'query',
                    'status': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_documents_endpoint = _Endpoint(
            settings={
                'response_type': (CaseDocuments,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/case/{caseId}/documents',
                'operation_id': 'get_case_documents',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_id',
                    'in_library',
                    'after_first_fetch_date',
                    'library_date',
                    'first_fetch_date',
                    'sort_by',
                    'page_number',
                ],
                'required': [
                    'case_id',
                ],
                'nullable': [
                    'after_first_fetch_date',
                    'library_date',
                    'first_fetch_date',
                ],
                'enum': [
                    'sort_by',
                ],
                'validation': [
                    'case_id',
                    'after_first_fetch_date',
                    'library_date',
                    'first_fetch_date',
                    'sort_by',
                ]
            },
            root_map={
                'validations': {
                    ('case_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('after_first_fetch_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('library_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('first_fetch_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('sort_by',): {
                        'max_length': 20,
                        'min_length': 10,
                    },
                },
                'allowed_values': {
                    ('sort_by',): {

                        "LATEST_TO_OLDEST": "latest to oldest",
                        "OLDEST_TO_LATEST": "oldest to latest"
                    },
                },
                'openapi_types': {
                    'case_id':
                        (str,),
                    'in_library':
                        (bool,),
                    'after_first_fetch_date':
                        (datetime, none_type,),
                    'library_date':
                        (datetime, none_type,),
                    'first_fetch_date':
                        (datetime, none_type,),
                    'sort_by':
                        (str,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'case_id': 'caseId',
                    'in_library': 'inLibrary',
                    'after_first_fetch_date': 'afterFirstFetchDate',
                    'library_date': 'libraryDate',
                    'first_fetch_date': 'firstFetchDate',
                    'sort_by': 'sortBy',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'case_id': 'path',
                    'in_library': 'query',
                    'after_first_fetch_date': 'query',
                    'library_date': 'query',
                    'first_fetch_date': 'query',
                    'sort_by': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_document_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (CaseDocument,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/caseDocument/{caseDocumentId}',
                'operation_id': 'get_document_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_document_id',
                ],
                'required': [
                    'case_document_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_document_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_document_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_document_id':
                        (str,),
                },
                'attribute_map': {
                    'case_document_id': 'caseDocumentId',
                },
                'location_map': {
                    'case_document_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.order_case_document_endpoint = _Endpoint(
            settings={
                'response_type': (CaseDocumentOrderCallback,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/caseDocumentOrder',
                'operation_id': 'order_case_document',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_document_order_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_document_order_request':
                        (CaseDocumentOrderRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'case_document_order_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def get_case_document_download_by_id(
        self,
        case_document_id,
        **kwargs
    ):
        """Gets downloadable URL for a requested Document ID.  # noqa: E501

        Gets downloadable URL for a requested Document ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_document_download_by_id(case_document_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_document_id (str): Document ID which you want to download.

        Keyword Args:
            is_preview_document (bool): If the document you want to download is a preview of a document.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetCaseDocumentDownloadById200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_document_id'] = \
            case_document_id
        return self.get_case_document_download_by_id_endpoint.call_with_http_info(**kwargs)

    def get_case_document_order_callback_by_id(
        self,
        case_document_order_callback_id,
        **kwargs
    ):
        """Get Case Document Order Callback for a requested Case Document Order Callback Id.  # noqa: E501

        Get Case Document Order Callback for a requested Case Document Order Callback Id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_document_order_callback_by_id(case_document_order_callback_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_document_order_callback_id (str): Unique Id for the Case Document Order Callback.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseDocumentOrderCallback
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_document_order_callback_id'] = \
            case_document_order_callback_id
        return self.get_case_document_order_callback_by_id_endpoint.call_with_http_info(**kwargs)

    def get_case_document_order_callbacks(
        self,
        **kwargs
    ):
        """Get Case Document Order Callback list for a requested Date.  # noqa: E501

        Get Case Document Order Callback list for a requested Date.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_document_order_callbacks(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            date (datetime): Date for which fetch the Case Document Order Callback list. By default, the date will be set to current date.. [optional]
            status (str): Status of Document Order callbacks. Default status will fetch all callbacks.. [optional]
            page_number (int): Page to fetch the Case Document Order Callback list.<br>   - Minimum: 1 . [optional] if omitted the server will use the default value of 1
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseDocumentOrderCallbackListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_case_document_order_callbacks_endpoint.call_with_http_info(**kwargs)

    def get_case_documents(
        self,
        case_id,
        **kwargs
    ):
        """Gets Documents for a requested Case ID.  # noqa: E501

        Gets Documents for a requested Case ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_documents(case_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_id (str): Case ID for which you want the data for.

        Keyword Args:
            in_library (bool): Filter all the documents those are added to the UniCourt library.. [optional]
            after_first_fetch_date (datetime, none_type): Get all the documents which were added to the case on or after a specific date.. [optional]
            library_date (datetime, none_type): Sort all the documents based on the date when the document was added to the UniCourt Library.. [optional]
            first_fetch_date (datetime, none_type): Sort all the documents based on the date it was fetched from the source site.. [optional]
            sort_by (str): Sort documents with document order.. [optional]
            page_number (int): The page for which the result should be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseDocuments
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_id'] = \
            case_id
        return self.get_case_documents_endpoint.call_with_http_info(**kwargs)

    def get_document_by_id(
        self,
        case_document_id,
        **kwargs
    ):
        """Gets details for a requested Document ID.  # noqa: E501

        Gets details for a requested Document ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document_by_id(case_document_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_document_id (str): Specific Case Dcoument ID for which you want the data for.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_document_id'] = \
            case_document_id
        return self.get_document_by_id_endpoint.call_with_http_info(**kwargs)

    def order_case_document(
        self,
        **kwargs
    ):
        """Add Case Document Order for requested Document Ids.  # noqa: E501

        Add Case Document Order for requested Document Ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.order_case_document(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            case_document_order_request (CaseDocumentOrderRequest): If the Case Document Order is for Preview, then the value for ``isPreviewOnly`` should be ``true`` else ``false``. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CaseDocumentOrderCallback
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.order_case_document_endpoint.call_with_http_info(**kwargs)

