"""
    UniCourt Enterprise APIs

    <button><a href=\"/enterpriseapi/download/UniCourt-Enterprise-API-Spec.yaml\" >Download UniCourt Enterprise APIs Specification</a></button>   # noqa: E501

    The version of the OpenAPI document: 
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from unicourt.api_client import ApiClient, Endpoint as _Endpoint
from unicourt.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from unicourt.model.attorney import Attorney
from unicourt.model.attorneys import Attorneys
from unicourt.model.case import Case
from unicourt.model.docket_entries import DocketEntries
from unicourt.model.docket_entry_primary_documents import DocketEntryPrimaryDocuments
from unicourt.model.docket_entry_secondary_documents import DocketEntrySecondaryDocuments
from unicourt.model.exception import Exception
from unicourt.model.hearings import Hearings
from unicourt.model.judge import Judge
from unicourt.model.judges import Judges
from unicourt.model.parties import Parties
from unicourt.model.party import Party
from unicourt.model.party_attorney_associations import PartyAttorneyAssociations
from unicourt.model.related_cases import RelatedCases


class CaseDocketApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_attorney_associated_parties_endpoint = _Endpoint(
            settings={
                'response_type': (PartyAttorneyAssociations,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/attorney/{attorneyId}/associatedParties',
                'operation_id': 'get_attorney_associated_parties',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'attorney_id',
                    'page_number',
                ],
                'required': [
                    'attorney_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'attorney_id',
                ]
            },
            root_map={
                'validations': {
                    ('attorney_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'attorney_id':
                        (str,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'attorney_id': 'attorneyId',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'attorney_id': 'path',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_attorney_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (Attorney,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/attorney/{attorneyId}',
                'operation_id': 'get_attorney_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'attorney_id',
                ],
                'required': [
                    'attorney_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'attorney_id',
                ]
            },
            root_map={
                'validations': {
                    ('attorney_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'attorney_id':
                        (str,),
                },
                'attribute_map': {
                    'attorney_id': 'attorneyId',
                },
                'location_map': {
                    'attorney_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_endpoint = _Endpoint(
            settings={
                'response_type': (Case,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/case/{caseId}',
                'operation_id': 'get_case',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_id',
                ],
                'required': [
                    'case_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_id':
                        (str,),
                },
                'attribute_map': {
                    'case_id': 'caseId',
                },
                'location_map': {
                    'case_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_attorneys_endpoint = _Endpoint(
            settings={
                'response_type': (Attorneys,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/case/{caseId}/attorneys',
                'operation_id': 'get_case_attorneys',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_id',
                    'is_visible',
                    'page_number',
                ],
                'required': [
                    'case_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_id':
                        (str,),
                    'is_visible':
                        (bool,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'case_id': 'caseId',
                    'is_visible': 'isVisible',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'case_id': 'path',
                    'is_visible': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_docket_entries_endpoint = _Endpoint(
            settings={
                'response_type': (DocketEntries,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/case/{caseId}/docketEntries',
                'operation_id': 'get_case_docket_entries',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_id',
                    'docket_number',
                    'sort_by',
                    'page_number',
                ],
                'required': [
                    'case_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'sort_by',
                ],
                'validation': [
                    'case_id',
                    'sort_by',
                ]
            },
            root_map={
                'validations': {
                    ('case_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('sort_by',): {
                        'max_length': 20,
                        'min_length': 10,
                    },
                },
                'allowed_values': {
                    ('sort_by',): {

                        "LATEST_TO_OLDEST": "latest to oldest",
                        "OLDEST_TO_LATEST": "oldest to latest"
                    },
                },
                'openapi_types': {
                    'case_id':
                        (str,),
                    'docket_number':
                        (int,),
                    'sort_by':
                        (str,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'case_id': 'caseId',
                    'docket_number': 'docketNumber',
                    'sort_by': 'sortBy',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'case_id': 'path',
                    'docket_number': 'query',
                    'sort_by': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_hearings_endpoint = _Endpoint(
            settings={
                'response_type': (Hearings,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/case/{caseId}/hearings',
                'operation_id': 'get_case_hearings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_id',
                    'sort_by',
                    'page_number',
                ],
                'required': [
                    'case_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'sort_by',
                ],
                'validation': [
                    'case_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                    ('sort_by',): {

                        "LATEST_TO_OLDEST": "latest to oldest",
                        "OLDEST_TO_LATEST": "oldest to latest"
                    },
                },
                'openapi_types': {
                    'case_id':
                        (str,),
                    'sort_by':
                        (str,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'case_id': 'caseId',
                    'sort_by': 'sortBy',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'case_id': 'path',
                    'sort_by': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_judges_endpoint = _Endpoint(
            settings={
                'response_type': (Judges,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/case/{caseId}/judges',
                'operation_id': 'get_case_judges',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_id',
                    'is_visible',
                    'page_number',
                ],
                'required': [
                    'case_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_id':
                        (str,),
                    'is_visible':
                        (bool,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'case_id': 'caseId',
                    'is_visible': 'isVisible',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'case_id': 'path',
                    'is_visible': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_parties_endpoint = _Endpoint(
            settings={
                'response_type': (Parties,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/case/{caseId}/parties',
                'operation_id': 'get_case_parties',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_id',
                    'is_visible',
                    'page_number',
                    'party_role_id',
                    'party_role_group_id',
                    'attorney_representation_type_id',
                    'party_classification_type',
                ],
                'required': [
                    'case_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'party_classification_type',
                ],
                'validation': [
                    'case_id',
                    'party_role_id',
                    'party_role_group_id',
                    'attorney_representation_type_id',
                    'party_classification_type',
                ]
            },
            root_map={
                'validations': {
                    ('case_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('party_role_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('party_role_group_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('attorney_representation_type_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('party_classification_type',): {
                        'max_length': 10,
                        'min_length': 5,
                    },
                },
                'allowed_values': {
                    ('party_classification_type',): {

                        "INDIVIDUAL": "INDIVIDUAL",
                        "COMPANY": "COMPANY",
                        "OTHER": "OTHER"
                    },
                },
                'openapi_types': {
                    'case_id':
                        (str,),
                    'is_visible':
                        (bool,),
                    'page_number':
                        (int,),
                    'party_role_id':
                        (str,),
                    'party_role_group_id':
                        (str,),
                    'attorney_representation_type_id':
                        (str,),
                    'party_classification_type':
                        (str,),
                },
                'attribute_map': {
                    'case_id': 'caseId',
                    'is_visible': 'isVisible',
                    'page_number': 'pageNumber',
                    'party_role_id': 'partyRoleId',
                    'party_role_group_id': 'partyRoleGroupId',
                    'attorney_representation_type_id': 'attorneyRepresentationTypeId',
                    'party_classification_type': 'partyClassificationType',
                },
                'location_map': {
                    'case_id': 'path',
                    'is_visible': 'query',
                    'page_number': 'query',
                    'party_role_id': 'query',
                    'party_role_group_id': 'query',
                    'attorney_representation_type_id': 'query',
                    'party_classification_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_case_related_cases_endpoint = _Endpoint(
            settings={
                'response_type': (RelatedCases,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/case/{caseId}/relatedCases',
                'operation_id': 'get_case_related_cases',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_id',
                    'page_number',
                ],
                'required': [
                    'case_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'case_id',
                ]
            },
            root_map={
                'validations': {
                    ('case_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_id':
                        (str,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'case_id': 'caseId',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'case_id': 'path',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_judge_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (Judge,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/judge/{judgeId}',
                'operation_id': 'get_judge_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'judge_id',
                ],
                'required': [
                    'judge_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'judge_id',
                ]
            },
            root_map={
                'validations': {
                    ('judge_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'judge_id':
                        (str,),
                },
                'attribute_map': {
                    'judge_id': 'judgeId',
                },
                'location_map': {
                    'judge_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_party_associated_attorneys_endpoint = _Endpoint(
            settings={
                'response_type': (PartyAttorneyAssociations,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/party/{partyId}/associatedAttorneys',
                'operation_id': 'get_party_associated_attorneys',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'party_id',
                    'page_number',
                ],
                'required': [
                    'party_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'party_id',
                ]
            },
            root_map={
                'validations': {
                    ('party_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'party_id':
                        (str,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'party_id': 'partyId',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'party_id': 'path',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_party_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (Party,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/party/{partyId}',
                'operation_id': 'get_party_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'party_id',
                ],
                'required': [
                    'party_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'party_id',
                ]
            },
            root_map={
                'validations': {
                    ('party_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'party_id':
                        (str,),
                },
                'attribute_map': {
                    'party_id': 'partyId',
                },
                'location_map': {
                    'party_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_primary_documents_for_docket_entries_endpoint = _Endpoint(
            settings={
                'response_type': (DocketEntryPrimaryDocuments,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/case/{caseId}/docketEntries/primaryDocuments',
                'operation_id': 'get_primary_documents_for_docket_entries',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_id',
                    'docket_number',
                    'in_library',
                    'after_first_fetch_date',
                    'library_date',
                    'page_number',
                ],
                'required': [
                    'case_id',
                    'docket_number',
                ],
                'nullable': [
                    'after_first_fetch_date',
                    'library_date',
                ],
                'enum': [
                ],
                'validation': [
                    'case_id',
                    'after_first_fetch_date',
                    'library_date',
                ]
            },
            root_map={
                'validations': {
                    ('case_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('after_first_fetch_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('library_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_id':
                        (str,),
                    'docket_number':
                        (int,),
                    'in_library':
                        (bool,),
                    'after_first_fetch_date':
                        (datetime, none_type,),
                    'library_date':
                        (datetime, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'case_id': 'caseId',
                    'docket_number': 'docketNumber',
                    'in_library': 'inLibrary',
                    'after_first_fetch_date': 'afterFirstFetchDate',
                    'library_date': 'libraryDate',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'case_id': 'path',
                    'docket_number': 'query',
                    'in_library': 'query',
                    'after_first_fetch_date': 'query',
                    'library_date': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_secondary_documents_for_docket_entries_endpoint = _Endpoint(
            settings={
                'response_type': (DocketEntrySecondaryDocuments,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/case/{caseId}/docketEntries/secondaryDocuments',
                'operation_id': 'get_secondary_documents_for_docket_entries',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'case_id',
                    'docket_number',
                    'in_library',
                    'after_first_fetch_date',
                    'library_date',
                    'page_number',
                ],
                'required': [
                    'case_id',
                    'docket_number',
                ],
                'nullable': [
                    'after_first_fetch_date',
                    'library_date',
                ],
                'enum': [
                ],
                'validation': [
                    'case_id',
                    'after_first_fetch_date',
                    'library_date',
                ]
            },
            root_map={
                'validations': {
                    ('case_id',): {
                        'max_length': 18,
                        'min_length': 18,
                    },
                    ('after_first_fetch_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                    ('library_date',): {
                        'max_length': 25,
                        'min_length': 25,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'case_id':
                        (str,),
                    'docket_number':
                        (int,),
                    'in_library':
                        (bool,),
                    'after_first_fetch_date':
                        (datetime, none_type,),
                    'library_date':
                        (datetime, none_type,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'case_id': 'caseId',
                    'docket_number': 'docketNumber',
                    'in_library': 'inLibrary',
                    'after_first_fetch_date': 'afterFirstFetchDate',
                    'library_date': 'libraryDate',
                    'page_number': 'pageNumber',
                },
                'location_map': {
                    'case_id': 'path',
                    'docket_number': 'query',
                    'in_library': 'query',
                    'after_first_fetch_date': 'query',
                    'library_date': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_attorney_associated_parties(
        self,
        attorney_id,
        **kwargs
    ):
        """Gets Associated Party details for a requested Attorney ID.  # noqa: E501

        Retrieve the parties represented by the attorney with the specified attorneyId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attorney_associated_parties(attorney_id, async_req=True)
        >>> result = thread.get()

        Args:
            attorney_id (str): Retrieve the parties represented by the attorney with the specified attorneyId value.

        Keyword Args:
            page_number (int): Query parameter specifying the page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PartyAttorneyAssociations
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['attorney_id'] = \
            attorney_id
        return self.get_attorney_associated_parties_endpoint.call_with_http_info(**kwargs)

    def get_attorney_by_id(
        self,
        attorney_id,
        **kwargs
    ):
        """Gets details for a requested Attorney ID.  # noqa: E501

        Retrieve the attorney with the specified attorneyId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attorney_by_id(attorney_id, async_req=True)
        >>> result = thread.get()

        Args:
            attorney_id (str): Retrieve the attorney with the specified attorneyId value.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attorney
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['attorney_id'] = \
            attorney_id
        return self.get_attorney_by_id_endpoint.call_with_http_info(**kwargs)

    def get_case(
        self,
        case_id,
        **kwargs
    ):
        """Gets case information for a requested Case ID.  # noqa: E501

        Retrieve the case with the specified caseId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case(case_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_id (str): Retrieve the case with the specified caseId value.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Case
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_id'] = \
            case_id
        return self.get_case_endpoint.call_with_http_info(**kwargs)

    def get_case_attorneys(
        self,
        case_id,
        **kwargs
    ):
        """Gets Attorneys for a requested Case ID.  # noqa: E501

        Retrieve the attorneys in the case with the specified caseId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_attorneys(case_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_id (str): Retrieve the case with the specified caseId value.

        Keyword Args:
            is_visible (bool): Retrieve attorneys in the case with the specified caseId value whose isVisible flag is set to the specified value.. [optional]
            page_number (int): Query parameter specifying the page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attorneys
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_id'] = \
            case_id
        return self.get_case_attorneys_endpoint.call_with_http_info(**kwargs)

    def get_case_docket_entries(
        self,
        case_id,
        **kwargs
    ):
        """Gets Docket Entries for a requested Case ID.  # noqa: E501

        Retrieve the docket entries in the case with the specified caseId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_docket_entries(case_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_id (str): Retrieve the case with the specified caseId value.

        Keyword Args:
            docket_number (int): Retrieve the docket entry witih the specified docket number in the case with the specified caseId value.. [optional]
            sort_by (str): Sort the retrieved docket entries in ascending order or descending order of date.. [optional]
            page_number (int): Query parameter specifying the page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DocketEntries
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_id'] = \
            case_id
        return self.get_case_docket_entries_endpoint.call_with_http_info(**kwargs)

    def get_case_hearings(
        self,
        case_id,
        **kwargs
    ):
        """Gets Hearings for a requested Case ID.  # noqa: E501

        Gets Hearings for a requested Case ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_hearings(case_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_id (str): Retrieve the case with the specified caseId value.

        Keyword Args:
            sort_by (str): Specify the sort order of hearings in the case with the specified caseId.. [optional]
            page_number (int): Query parameter specifying the page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Hearings
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_id'] = \
            case_id
        return self.get_case_hearings_endpoint.call_with_http_info(**kwargs)

    def get_case_judges(
        self,
        case_id,
        **kwargs
    ):
        """Gets Judges for a requested Case ID.  # noqa: E501

        Retrieve the judges involved in the specified case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_judges(case_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_id (str): Retrieve the case with the specified caseId value.

        Keyword Args:
            is_visible (bool): Retrieve attorneys judges in the case with the specified caseId value whose isVisible flag is set to the specified value.. [optional]
            page_number (int): Query parameter specifying the page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Judges
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_id'] = \
            case_id
        return self.get_case_judges_endpoint.call_with_http_info(**kwargs)

    def get_case_parties(
        self,
        case_id,
        **kwargs
    ):
        """Gets Parties for a requested Case ID.  # noqa: E501

        Retrieve the parties involved in the case with the specified caseId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_parties(case_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_id (str): Retrieve the case with the specified caseId value.

        Keyword Args:
            is_visible (bool): Retrieve parties in the case with the specified caseId value whose isVisible flag is set to the specified value.. [optional]
            page_number (int): Query parameter specifying the page number of the search results to be retrieved.. [optional]
            party_role_id (str): Retrieve all parties with the specified partyRoleId value in the case with the specified caseId value.. [optional]
            party_role_group_id (str): Retrieve all parties with the specified partyRoleGroupId value in the case with the specified caseId value.. [optional]
            attorney_representation_type_id (str): Retrieve all parties with the specified attorneyRepresentationTypeId value in the case with the specified caseId value.. [optional]
            party_classification_type (str): Retrieve all parties with the specified partyClassificationType value in the case with the specified caseId value.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Parties
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_id'] = \
            case_id
        return self.get_case_parties_endpoint.call_with_http_info(**kwargs)

    def get_case_related_cases(
        self,
        case_id,
        **kwargs
    ):
        """Gets Related Cases for a requested Case ID.  # noqa: E501

        Retrieve cases that UniCourt has identified as related to the case with the specified caseId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_case_related_cases(case_id, async_req=True)
        >>> result = thread.get()

        Args:
            case_id (str): Retrieve the case with the specified caseId value.

        Keyword Args:
            page_number (int): Query parameter specifying the page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RelatedCases
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_id'] = \
            case_id
        return self.get_case_related_cases_endpoint.call_with_http_info(**kwargs)

    def get_judge_by_id(
        self,
        judge_id,
        **kwargs
    ):
        """Gets details for a requested Judge ID.  # noqa: E501

        Retrieve the judge with the specified judgeId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_judge_by_id(judge_id, async_req=True)
        >>> result = thread.get()

        Args:
            judge_id (str): Retrieve the judge with the specified judgeId value.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Judge
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['judge_id'] = \
            judge_id
        return self.get_judge_by_id_endpoint.call_with_http_info(**kwargs)

    def get_party_associated_attorneys(
        self,
        party_id,
        **kwargs
    ):
        """Gets Associated Attorney details for a requested Party ID.  # noqa: E501

        Retrieve the attorneys in the case with the specified partyId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_party_associated_attorneys(party_id, async_req=True)
        >>> result = thread.get()

        Args:
            party_id (str): Retrieve the party with the specified partyId value.

        Keyword Args:
            page_number (int): Query parameter specifying the page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PartyAttorneyAssociations
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['party_id'] = \
            party_id
        return self.get_party_associated_attorneys_endpoint.call_with_http_info(**kwargs)

    def get_party_by_id(
        self,
        party_id,
        **kwargs
    ):
        """Gets details for a requested Party ID.  # noqa: E501

        Retrieve the party with the specified partyId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_party_by_id(party_id, async_req=True)
        >>> result = thread.get()

        Args:
            party_id (str): Retrieve the party with the specified partyId value.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Party
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['party_id'] = \
            party_id
        return self.get_party_by_id_endpoint.call_with_http_info(**kwargs)

    def get_primary_documents_for_docket_entries(
        self,
        case_id,
        docket_number,
        **kwargs
    ):
        """Gets Primary Documents of Docket Entries.  # noqa: E501

        Retrieve the primary documents in the case with the specified caseId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_primary_documents_for_docket_entries(case_id, docket_number, async_req=True)
        >>> result = thread.get()

        Args:
            case_id (str): Retrieve the case with the specified caseId value.
            docket_number (int): Retrieve the primary documents associated with the specified docket number in the case with the specified caseId value.

        Keyword Args:
            in_library (bool): Retrieve the primary documents in the with the specified inLibrary flag in the case with the specified caseId value.. [optional]
            after_first_fetch_date (datetime, none_type): Retrieve all primary documents in the case with the specified caseId value that were first fetched by UniCourt on the specified date or within the specified date.. [optional]
            library_date (datetime, none_type): Retrieve all primary documents in the case with the specified caseId value that were added to the Crowdsourced Library on the specified date or within the specified date.. [optional]
            page_number (int): Query parameter specifying the page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DocketEntryPrimaryDocuments
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_id'] = \
            case_id
        kwargs['docket_number'] = \
            docket_number
        return self.get_primary_documents_for_docket_entries_endpoint.call_with_http_info(**kwargs)

    def get_secondary_documents_for_docket_entries(
        self,
        case_id,
        docket_number,
        **kwargs
    ):
        """Gets Secondary Documents of Docket Entries.  # noqa: E501

        Retrieve the secondary documents in the case with the specified caseId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_secondary_documents_for_docket_entries(case_id, docket_number, async_req=True)
        >>> result = thread.get()

        Args:
            case_id (str): Retrieve the case with the specified caseId value.
            docket_number (int): Retrieve the secondary documents associated with the specified docket number in the case with the specified caseId value.

        Keyword Args:
            in_library (bool): Retrieve the secondary documents in the with the specified inLibrary flag in the case with the specified caseId value.. [optional]
            after_first_fetch_date (datetime, none_type): Retrieve all secondary documents in the case with the specified caseId value that were first fetched by UniCourt on the specified date or within the specified date.. [optional]
            library_date (datetime, none_type): Retrieve all secondary documents in the case with the specified caseId value that were added to the Crowdsourced Library on the specified date or within the specified date.. [optional]
            page_number (int): Query parameter specifying the page number of the search results to be retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DocketEntrySecondaryDocuments
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['case_id'] = \
            case_id
        kwargs['docket_number'] = \
            docket_number
        return self.get_secondary_documents_for_docket_entries_endpoint.call_with_http_info(**kwargs)

