"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionFilter = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A subscription filter for an attribute.
 */
class SubscriptionFilter {
    /**
     *
     * @param conditions conditions that specify the message attributes that should be included, excluded, matched, etc.
     */
    constructor(conditions = []) {
        this.conditions = conditions;
    }
    /**
     * Returns a subscription filter for a string attribute.
     */
    static stringFilter(stringConditions) {
        var _b, _c;
        jsiiDeprecationWarnings._aws_cdk_aws_sns_StringConditions(stringConditions);
        const conditions = new Array();
        if (stringConditions.whitelist && stringConditions.allowlist) {
            throw new Error('`whitelist` is deprecated; please use `allowlist` instead');
        }
        if (stringConditions.blacklist && stringConditions.denylist) {
            throw new Error('`blacklist` is deprecated; please use `denylist` instead');
        }
        const allowlist = (_b = stringConditions.allowlist) !== null && _b !== void 0 ? _b : stringConditions.whitelist;
        const denylist = (_c = stringConditions.denylist) !== null && _c !== void 0 ? _c : stringConditions.blacklist;
        if (allowlist) {
            conditions.push(...allowlist);
        }
        if (denylist) {
            conditions.push({ 'anything-but': denylist });
        }
        if (stringConditions.matchPrefixes) {
            conditions.push(...stringConditions.matchPrefixes.map(p => ({ prefix: p })));
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for a numeric attribute.
     */
    static numericFilter(numericConditions) {
        var _b;
        jsiiDeprecationWarnings._aws_cdk_aws_sns_NumericConditions(numericConditions);
        const conditions = new Array();
        if (numericConditions.whitelist && numericConditions.allowlist) {
            throw new Error('`whitelist` is deprecated; please use `allowlist` instead');
        }
        const allowlist = (_b = numericConditions.allowlist) !== null && _b !== void 0 ? _b : numericConditions.whitelist;
        if (allowlist) {
            conditions.push(...allowlist.map(v => ({ numeric: ['=', v] })));
        }
        if (numericConditions.greaterThan !== undefined) {
            conditions.push({ numeric: ['>', numericConditions.greaterThan] });
        }
        if (numericConditions.greaterThanOrEqualTo !== undefined) {
            conditions.push({ numeric: ['>=', numericConditions.greaterThanOrEqualTo] });
        }
        if (numericConditions.lessThan !== undefined) {
            conditions.push({ numeric: ['<', numericConditions.lessThan] });
        }
        if (numericConditions.lessThanOrEqualTo !== undefined) {
            conditions.push({ numeric: ['<=', numericConditions.lessThanOrEqualTo] });
        }
        if (numericConditions.between) {
            conditions.push({ numeric: ['>=', numericConditions.between.start, '<=', numericConditions.between.stop] });
        }
        if (numericConditions.betweenStrict) {
            conditions.push({ numeric: ['>', numericConditions.betweenStrict.start, '<', numericConditions.betweenStrict.stop] });
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for attribute key matching.
     */
    static existsFilter() {
        return new SubscriptionFilter([{ exists: true }]);
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
_a = JSII_RTTI_SYMBOL_1;
SubscriptionFilter[_a] = { fqn: "@aws-cdk/aws-sns.SubscriptionFilter", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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