"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicPolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const sns_generated_1 = require("./sns.generated");
/**
 * The policy for an SNS Topic
 *
 * Policies define the operations that are allowed on this resource.
 *
 * You almost never need to define this construct directly.
 *
 * All AWS resources that support resource policies have a method called
 * `addToResourcePolicy()`, which will automatically create a new resource
 * policy if one doesn't exist yet, otherwise it will add to the existing
 * policy.
 *
 * Prefer to use `addToResourcePolicy()` instead.
 */
class TopicPolicy extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new aws_iam_1.PolicyDocument({
            // statements must be unique, so we use the statement index.
            // potantially SIDs can change as a result of order change, but this should
            // not have an impact on the policy evaluation.
            // https://docs.aws.amazon.com/sns/latest/dg/AccessPolicyLanguage_SpecialInfo.html
            assignSids: true,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_sns_TopicPolicyProps(props);
        this.document = (_b = props.policyDocument) !== null && _b !== void 0 ? _b : this.document;
        new sns_generated_1.CfnTopicPolicy(this, 'Resource', {
            policyDocument: this.document,
            topics: props.topics.map(t => t.topicArn),
        });
    }
}
exports.TopicPolicy = TopicPolicy;
_a = JSII_RTTI_SYMBOL_1;
TopicPolicy[_a] = { fqn: "@aws-cdk/aws-sns.TopicPolicy", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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