# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['file_collection_hash']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['file-collection-hash = '
                     'file_collection_hash.__main__:run']}

setup_kwargs = {
    'name': 'file-collection-hash',
    'version': '1.0.0',
    'description': 'Stable, fast hash of collection of content of files and directories, optionally including permissions, dates, etc.',
    'long_description': "file-collection-hash: Generate stable hash of a directory or \n=================================================\n\n[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)\n[![Latest release](https://img.shields.io/github/v/release/sammck/file-collection-hash.svg?style=flat-square&color=b44e88)](https://github.com/sammck/pulumi-crypto/releases)\n\nA Python commandline tool and callable function that can efficiently compute a repeatable hash\nstring for the content of a directory or a collection of files.\n\n\n\nTable of contents\n-----------------\n\n* [Introduction](#introduction)\n* [Details](#pulumi-passphrase-encryption-details)\n* [Installation](#installation)\n* [Usage](#usage)\n  * [Command line](#command-line)\n  * [API](api)\n* [Known issues and limitations](#known-issues-and-limitations)\n* [Getting help](#getting-help)\n* [Contributing](#contributing)\n* [License](#license)\n* [Authors and history](#authors-and-history)\n\n\nIntroduction\n------------\n\nPython package `file-collection-hash` provides a command-line tool as well as a runtime function to efficiently\ngenerate a stable content hash for a directory or collection of files. In general, a directory created\nwith `rsync -a old_dir/ new_dir/` will produce the same hash. The hash includes the data of\nall files, so it is reliable regardless of file timestamps, etc.\n\nFiles within a directory are processed in alhabetically sorted order, so that hashes remain stable across directory\nreconstruction.\n\nRelative pathnames are included in the path, so that if a file is renamed, the hash will change.\n\nBy default, file modify timestamps, file owner/UID, and file group/GID are ignored for the purposes of hashing, so that\ndirectories cloned onto different systems will hash the same even if a different user owns the directory\nor UID/GID mappings are different. Options are provided to enabled includion of these properties in the hash.\n\nBy default, file permission/mode bits (e.g., Read, Write, Execute) are included in the hash; this allows applications\nto recognize chmod operations as significant and requiring update.\n\nIn general, the default options produce a hash that changes under similar conditions to when `git status` would\nshow a change.\n\nThe hashing function can be any filter command that takes a byte stream as input and produces a whitespace-free\ntextual hash as output. Any output from the first whitespace on is stripped.\n\n`file-collection-hash` delegates all of the heavy lifting to two very optimized native external commands, piped together:\n1. `tar` is used to render all included files and directories into a repeatable byte stream. Command options\n   on `tar` are used to sort the input files and to hide variations in owner, group, modify timestamps,\n   and permission bits as required. The output of `tar` is piped directly into the hashing filter.\n2. The hashing filter command (by default `sha256sum`) has its stdin piped directly from the `tar` output.\n\nThis package was originally developed as part of a solution to update `.tar.gz` files, triggering dependent\nactions, only when there is a material change in the content being bundled, ignoring differences in timestamp\nand file owner/group settings.\n\nInstallation\n------------\n\n### Prerequisites\n\n**Python**: Python 3.7+ is required. See your OS documentation for instructions.\n\n### From PyPi\n\nThe current released version of `file-collection-hash` can be installed with \n\n```bash\npip3 install pulumi-crypto\n```\n\n### From GitHub\n\n[Poetry](https://python-poetry.org/docs/master/#installing-with-the-official-installer) is required; it can be installed with:\n\n```bash\ncurl -sSL https://install.python-poetry.org | python3 -\n```\n\nClone the repository and install pulumi-crypto into a private virtualenv with:\n\n```bash\ncd <parent-folder>\ngit clone https://github.com/sammck/file-collection-hash.git\ncd file-collection-hash\npoetry install\n```\n\nYou can then launch a bash shell with the virtualenv activated using:\n\n```bash\npoetry shell\n```\n\nUsage\n=====\n\nCommand Line\n------------\n\nExample usage:\n\n```bash\n$ file-collection-hash --exclude=.git --exclude=.venv\na25f091c7de730931480a97243a15cfce7cd0fe07eee925749e5dc37a573237e\n$ file-collection-hash -C scripts\nf039c1016394986afb86436e58a3708fcd375789f95f178c7c340e29f01cf637\n$ file-collection-hash -C scripts --no-ignore-owner --no-ignore-group\nbb6d86071992c01336eaaa05cf2fdb64896b339f4fcf048cda45fa2c12aa7db6\n$ cd scripts\n$ file-collection-hash\nf039c1016394986afb86436e58a3708fcd375789f95f178c7c340e29f01cf637\n```\n\nAPI\n---\n\n```python\n#!/usr/bin/env python3\n\nimport os\nfrom file_collection_hash import file_collection_hash\n\nprint(file_collection_hash(exclude=['.git', '.venv']))\nprint(file_collection_hash('scripts'))\nprint(file_collection_hash('scripts', ignore_owner=False, ignore_group=False))\nos.chdir('scripts')\nprint(file_collection_hash())\n```\n\nKnown issues and limitations\n----------------------------\n\n* TBD.\n\nGetting help\n------------\n\nPlease report any problems/issues [here](https://github.com/sammck/file-collection-hash/issues).\n\nContributing\n------------\n\nPull requests welcome.\n\nLicense\n-------\n\npulumi-crypto is distributed under the terms of the [MIT License](https://opensource.org/licenses/MIT).  The license applies to this file and other files in the [GitHub repository](http://github.com/sammck/file-collection-hash) hosting this file.\n\nAuthors and history\n---------------------------\n\nThe author of file-collection-hash is [Sam McKelvie](https://github.com/sammck).\n",
    'author': 'Sam McKelvie',
    'author_email': 'dev@mckelvie.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sammck/file-collection',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
