# Auto-generated by asn1ate v.0.6.0 from en_319_412_5.asn1 with manual fixups
# Taken from ETSI EN 319-412-5, Annex B


from pyasn1.type import univ, char, namedtype, constraint

MAX = float('inf')


def _OID(*components):
    output = []
    for x in tuple(components):
        if isinstance(x, univ.ObjectIdentifier):
            output.extend(list(x))
        else:
            output.append(int(x))

    return univ.ObjectIdentifier(output)


class CountryName(char.PrintableString):
    pass


CountryName.subtypeSpec = constraint.ValueSizeConstraint(2, 2)


class Iso4217CurrencyCode(univ.Choice):
    pass


Iso4217CurrencyCode.componentType = namedtype.NamedTypes(
    namedtype.NamedType('alphabetic', char.PrintableString().subtype(subtypeSpec=constraint.ValueSizeConstraint(3, 3))),
    namedtype.NamedType('numeric', univ.Integer().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 999)))
)


class MonetaryValue(univ.Sequence):
    pass


MonetaryValue.componentType = namedtype.NamedTypes(
    namedtype.NamedType('currency', Iso4217CurrencyCode()),
    namedtype.NamedType('amount', univ.Integer()),
    namedtype.NamedType('exponent', univ.Integer())
)


class PdsLocation(univ.Sequence):
    pass


PdsLocation.componentType = namedtype.NamedTypes(
    namedtype.NamedType('url', char.IA5String()),
    namedtype.NamedType('language', char.PrintableString().subtype(subtypeSpec=constraint.ValueSizeConstraint(2, 2)))
)


class PdsLocations(univ.SequenceOf):
    pass


PdsLocations.componentType = PdsLocation()
PdsLocations.subtypeSpec = constraint.ValueSizeConstraint(1, MAX)


class QcCClegislation(univ.SequenceOf):
    pass


QcCClegislation.componentType = CountryName()


class QcEuLimitValue(MonetaryValue):
    pass


class QcEuPDS(PdsLocations):
    pass


class QcEuRetentionPeriod(univ.Integer):
    pass


class QcType(univ.SequenceOf):
    pass


QcType.componentType = univ.ObjectIdentifier()

id_etsi_qcs = _OID(0, 4, 0, 1862, 1)

id_etsi_qcs_QcCClegislation = _OID(id_etsi_qcs, 7)

id_etsi_qcs_QcCompliance = _OID(id_etsi_qcs, 1)

id_etsi_qcs_QcLimitValue = _OID(id_etsi_qcs, 2)

id_etsi_qcs_QcPDS = _OID(id_etsi_qcs, 5)

id_etsi_qcs_QcRetentionPeriod = _OID(id_etsi_qcs, 3)

id_etsi_qcs_QcSSCD = _OID(id_etsi_qcs, 4)

id_etsi_qcs_QcType = _OID(id_etsi_qcs, 6)

id_etsi_qct_eseal = _OID(id_etsi_qcs_QcType, 2)

id_etsi_qct_esign = _OID(id_etsi_qcs_QcType, 1)

id_etsi_qct_web = _OID(id_etsi_qcs_QcType, 3)
