# coding: utf-8

"""
    Xero Payroll AU

    This is the Xero Payroll API for orgs in Australia region.  # noqa: E501

    OpenAPI spec version: 2.2.12
    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class PayslipSummary(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "employee_id": "str",
        "payslip_id": "str",
        "first_name": "str",
        "last_name": "str",
        "employee_group": "str",
        "wages": "float",
        "deductions": "float",
        "tax": "float",
        "super": "float",
        "reimbursements": "float",
        "net_pay": "float",
        "updated_date_utc": "datetime[ms-format]",
    }

    attribute_map = {
        "employee_id": "EmployeeID",
        "payslip_id": "PayslipID",
        "first_name": "FirstName",
        "last_name": "LastName",
        "employee_group": "EmployeeGroup",
        "wages": "Wages",
        "deductions": "Deductions",
        "tax": "Tax",
        "super": "Super",
        "reimbursements": "Reimbursements",
        "net_pay": "NetPay",
        "updated_date_utc": "UpdatedDateUTC",
    }

    def __init__(
        self,
        employee_id=None,
        payslip_id=None,
        first_name=None,
        last_name=None,
        employee_group=None,
        wages=None,
        deductions=None,
        tax=None,
        super=None,
        reimbursements=None,
        net_pay=None,
        updated_date_utc=None,
    ):  # noqa: E501
        """PayslipSummary - a model defined in OpenAPI"""  # noqa: E501

        self._employee_id = None
        self._payslip_id = None
        self._first_name = None
        self._last_name = None
        self._employee_group = None
        self._wages = None
        self._deductions = None
        self._tax = None
        self._super = None
        self._reimbursements = None
        self._net_pay = None
        self._updated_date_utc = None
        self.discriminator = None

        if employee_id is not None:
            self.employee_id = employee_id
        if payslip_id is not None:
            self.payslip_id = payslip_id
        if first_name is not None:
            self.first_name = first_name
        if last_name is not None:
            self.last_name = last_name
        if employee_group is not None:
            self.employee_group = employee_group
        if wages is not None:
            self.wages = wages
        if deductions is not None:
            self.deductions = deductions
        if tax is not None:
            self.tax = tax
        if super is not None:
            self.super = super
        if reimbursements is not None:
            self.reimbursements = reimbursements
        if net_pay is not None:
            self.net_pay = net_pay
        if updated_date_utc is not None:
            self.updated_date_utc = updated_date_utc

    @property
    def employee_id(self):
        """Gets the employee_id of this PayslipSummary.  # noqa: E501

        The Xero identifier for an employee  # noqa: E501

        :return: The employee_id of this PayslipSummary.  # noqa: E501
        :rtype: str
        """
        return self._employee_id

    @employee_id.setter
    def employee_id(self, employee_id):
        """Sets the employee_id of this PayslipSummary.

        The Xero identifier for an employee  # noqa: E501

        :param employee_id: The employee_id of this PayslipSummary.  # noqa: E501
        :type: str
        """

        self._employee_id = employee_id

    @property
    def payslip_id(self):
        """Gets the payslip_id of this PayslipSummary.  # noqa: E501

        Xero identifier for the payslip  # noqa: E501

        :return: The payslip_id of this PayslipSummary.  # noqa: E501
        :rtype: str
        """
        return self._payslip_id

    @payslip_id.setter
    def payslip_id(self, payslip_id):
        """Sets the payslip_id of this PayslipSummary.

        Xero identifier for the payslip  # noqa: E501

        :param payslip_id: The payslip_id of this PayslipSummary.  # noqa: E501
        :type: str
        """

        self._payslip_id = payslip_id

    @property
    def first_name(self):
        """Gets the first_name of this PayslipSummary.  # noqa: E501

        First name of employee  # noqa: E501

        :return: The first_name of this PayslipSummary.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this PayslipSummary.

        First name of employee  # noqa: E501

        :param first_name: The first_name of this PayslipSummary.  # noqa: E501
        :type: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this PayslipSummary.  # noqa: E501

        Last name of employee  # noqa: E501

        :return: The last_name of this PayslipSummary.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this PayslipSummary.

        Last name of employee  # noqa: E501

        :param last_name: The last_name of this PayslipSummary.  # noqa: E501
        :type: str
        """

        self._last_name = last_name

    @property
    def employee_group(self):
        """Gets the employee_group of this PayslipSummary.  # noqa: E501

        Employee group name  # noqa: E501

        :return: The employee_group of this PayslipSummary.  # noqa: E501
        :rtype: str
        """
        return self._employee_group

    @employee_group.setter
    def employee_group(self, employee_group):
        """Sets the employee_group of this PayslipSummary.

        Employee group name  # noqa: E501

        :param employee_group: The employee_group of this PayslipSummary.  # noqa: E501
        :type: str
        """

        self._employee_group = employee_group

    @property
    def wages(self):
        """Gets the wages of this PayslipSummary.  # noqa: E501

        The Wages for the Payslip  # noqa: E501

        :return: The wages of this PayslipSummary.  # noqa: E501
        :rtype: float
        """
        return self._wages

    @wages.setter
    def wages(self, wages):
        """Sets the wages of this PayslipSummary.

        The Wages for the Payslip  # noqa: E501

        :param wages: The wages of this PayslipSummary.  # noqa: E501
        :type: float
        """

        self._wages = wages

    @property
    def deductions(self):
        """Gets the deductions of this PayslipSummary.  # noqa: E501

        The Deductions for the Payslip  # noqa: E501

        :return: The deductions of this PayslipSummary.  # noqa: E501
        :rtype: float
        """
        return self._deductions

    @deductions.setter
    def deductions(self, deductions):
        """Sets the deductions of this PayslipSummary.

        The Deductions for the Payslip  # noqa: E501

        :param deductions: The deductions of this PayslipSummary.  # noqa: E501
        :type: float
        """

        self._deductions = deductions

    @property
    def tax(self):
        """Gets the tax of this PayslipSummary.  # noqa: E501

        The Tax for the Payslip  # noqa: E501

        :return: The tax of this PayslipSummary.  # noqa: E501
        :rtype: float
        """
        return self._tax

    @tax.setter
    def tax(self, tax):
        """Sets the tax of this PayslipSummary.

        The Tax for the Payslip  # noqa: E501

        :param tax: The tax of this PayslipSummary.  # noqa: E501
        :type: float
        """

        self._tax = tax

    @property
    def super(self):
        """Gets the super of this PayslipSummary.  # noqa: E501

        The Super for the Payslip  # noqa: E501

        :return: The super of this PayslipSummary.  # noqa: E501
        :rtype: float
        """
        return self._super

    @super.setter
    def super(self, super):
        """Sets the super of this PayslipSummary.

        The Super for the Payslip  # noqa: E501

        :param super: The super of this PayslipSummary.  # noqa: E501
        :type: float
        """

        self._super = super

    @property
    def reimbursements(self):
        """Gets the reimbursements of this PayslipSummary.  # noqa: E501

        The Reimbursements for the Payslip  # noqa: E501

        :return: The reimbursements of this PayslipSummary.  # noqa: E501
        :rtype: float
        """
        return self._reimbursements

    @reimbursements.setter
    def reimbursements(self, reimbursements):
        """Sets the reimbursements of this PayslipSummary.

        The Reimbursements for the Payslip  # noqa: E501

        :param reimbursements: The reimbursements of this PayslipSummary.  # noqa: E501
        :type: float
        """

        self._reimbursements = reimbursements

    @property
    def net_pay(self):
        """Gets the net_pay of this PayslipSummary.  # noqa: E501

        The NetPay for the Payslip  # noqa: E501

        :return: The net_pay of this PayslipSummary.  # noqa: E501
        :rtype: float
        """
        return self._net_pay

    @net_pay.setter
    def net_pay(self, net_pay):
        """Sets the net_pay of this PayslipSummary.

        The NetPay for the Payslip  # noqa: E501

        :param net_pay: The net_pay of this PayslipSummary.  # noqa: E501
        :type: float
        """

        self._net_pay = net_pay

    @property
    def updated_date_utc(self):
        """Gets the updated_date_utc of this PayslipSummary.  # noqa: E501

        Last modified timestamp  # noqa: E501

        :return: The updated_date_utc of this PayslipSummary.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_date_utc

    @updated_date_utc.setter
    def updated_date_utc(self, updated_date_utc):
        """Sets the updated_date_utc of this PayslipSummary.

        Last modified timestamp  # noqa: E501

        :param updated_date_utc: The updated_date_utc of this PayslipSummary.  # noqa: E501
        :type: datetime
        """

        self._updated_date_utc = updated_date_utc
