#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['scanpydoc', 'scanpydoc.elegant_typehints', 'scanpydoc.theme']

package_data = \
{'': ['*'],
 'scanpydoc.elegant_typehints': ['static/*'],
 'scanpydoc.theme': ['static/*', 'static/css/*']}

install_requires = \
['sphinx>=3.0', 'get_version']

extras_require = \
{'doc': ['sphinx-autodoc-typehints>=1.12', 'sphinx-rtd-theme'],
 'test': ['pytest', 'pytest-cov', 'pytest-black'],
 'test:python_version<"3.8"': ['typing_extensions']}

entry_points = \
{'sphinx.html_themes': ['scanpydoc = scanpydoc.theme']}

setup(name='scanpydoc',
      version='0.7',
      description='A series of Sphinx extensions to get easy to maintain, numpydoc style documentation.',
      author='Philipp Angerer',
      author_email='phil.angerer@gmail.com',
      url='https://github.com/theislab/scanpydoc/',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
